/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import java.util.Arrays;
import org.openmolecules.chem.conf.gen.RigidFragment;
import org.openmolecules.chem.conf.gen.RotatableBond;
import org.openmolecules.chem.conf.gen.TorsionSet;
import org.openmolecules.chem.conf.gen.TorsionSetStrategyRandom;

public class TorsionSetStrategyAdaptiveRandom
extends TorsionSetStrategyRandom {
    private static final int MAX_TRIES_FOR_NEW = 64;
    private boolean mStartWithMostProbable;

    public TorsionSetStrategyAdaptiveRandom(RotatableBond[] rotatableBondArray, RigidFragment[] rigidFragmentArray, boolean bl, boolean bl2, long l) {
        super(rotatableBondArray, rigidFragmentArray, bl, l);
        this.mStartWithMostProbable = bl2;
    }

    @Override
    public TorsionSet createTorsionSet(TorsionSet torsionSet) {
        if (torsionSet == null) {
            if (this.mStartWithMostProbable) {
                return this.createTorsionSet(new int[this.mRotatableBond.length], new int[this.mRigidFragment.length]);
            }
            return super.createTorsionSet(null);
        }
        if (torsionSet.getCollisionIntensitySum() == 0.0) {
            return super.createTorsionSet(torsionSet);
        }
        double[] dArray = this.getBondAndFragmentCollisionIntensities(torsionSet);
        int[] nArray = torsionSet.getTorsionIndexes();
        int[] nArray2 = torsionSet.getConformerIndexes();
        boolean[] blArray = new boolean[dArray.length];
        block0: for (int i = 0; i < 64; ++i) {
            Object object;
            int n;
            if (blArray[0] || this.mRotatableBond[0].getTorsionCount() == 1) {
                dArray[0] = 0.0;
            }
            int n2 = 1;
            for (int j = 1; j < this.mRotatableBond.length; ++j) {
                if (blArray[n2] || this.mRotatableBond[j].getTorsionCount() == 1) {
                    dArray[n2] = dArray[n2 - 1];
                } else {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + dArray[n2 - 1];
                }
                ++n2;
            }
            RigidFragment[] rigidFragmentArray = this.mRigidFragment;
            int n4 = rigidFragmentArray.length;
            for (n = 0; n < n4; ++n) {
                object = rigidFragmentArray[n];
                if (blArray[n2] || ((RigidFragment)object).getConformerCount() == 1) {
                    dArray[n2] = dArray[n2 - 1];
                } else {
                    int n5 = n2;
                    dArray[n5] = dArray[n5] + dArray[n2 - 1];
                }
                ++n2;
            }
            if (dArray[dArray.length - 1] == 0.0) {
                return super.createTorsionSet(torsionSet);
            }
            double d = this.getRandom().nextDouble() * dArray[dArray.length - 1];
            for (n = 0; n < dArray.length; ++n) {
                TorsionSet torsionSet2;
                int n6;
                if (!(d < dArray[n])) continue;
                object = Arrays.copyOf(nArray, nArray.length);
                int[] nArray3 = Arrays.copyOf(nArray2, nArray2.length);
                if (n < this.mRotatableBond.length) {
                    for (n6 = 1; n6 < this.mRotatableBond[n].getTorsionCount(); ++n6) {
                        Object object2 = object;
                        int n7 = n;
                        object2[n7] = object2[n7] + true;
                        if (object[n] == this.mRotatableBond[n].getTorsionCount()) {
                            object[n] = false;
                        }
                        if (!this.isNewTorsionSet(torsionSet2 = this.createTorsionSet((int[])object, nArray3))) continue;
                        return torsionSet2;
                    }
                } else {
                    n -= this.mRotatableBond.length;
                    for (n6 = 1; n6 < this.mRigidFragment[n].getConformerCount(); ++n6) {
                        int n8 = n;
                        nArray3[n8] = nArray3[n8] + 1;
                        if (nArray3[n] == this.mRigidFragment[n].getConformerCount()) {
                            nArray3[n] = 0;
                        }
                        if (!this.isNewTorsionSet(torsionSet2 = this.createTorsionSet((int[])object, nArray3))) continue;
                        return torsionSet2;
                    }
                }
                blArray[n] = true;
                continue block0;
            }
        }
        return super.createTorsionSet(torsionSet);
    }
}

