/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.BS;
import javajs.util.M4d;
import javajs.util.P4d;
import javajs.util.T3d;
import javajs.util.T4d;
import javajs.util.V3d;
import org.jmol.viewer.TransformManager;

public class TransformManager4D
extends TransformManager {
    private static final int MODE_3D = 0;
    private static final int MODE_4D_WX = 1;
    private static final int MODE_4D_WY = 2;
    private static final int MODE_4D_WZ = 3;
    private boolean is4D = false;
    private int mouseMode = 3;
    private M4d m2_rotate;
    private final M4d m3_toScreen = new M4d();
    private double zOffset;
    private final T3d v1 = new V3d();
    private final M4d m4 = new M4d();
    private T4d p4 = new P4d();
    private final V3d zero = new V3d();

    @Override
    public void resetRotation() {
        if (this.m2_rotate != null) {
            this.m2_rotate.setIdentity();
        }
        this.matrixRotate.setScale(1.0);
    }

    @Override
    protected void rotateXYBy(double xDelta, double yDelta, BS bsAtoms) {
        this.rotate3DBall(xDelta, yDelta, bsAtoms);
        switch (this.is4D && bsAtoms == null ? this.mouseMode : 0) {
            case 0: {
                this.m2_rotate = null;
                break;
            }
            case 1: {
                this.checkM2();
                this.rotate4DBall(0.0, xDelta, yDelta);
                break;
            }
            case 2: {
                this.checkM2();
                this.rotate4DBall(xDelta, 0.0, yDelta);
                break;
            }
            case 3: {
                this.checkM2();
                this.rotate4DBall(xDelta, yDelta, 0.0);
            }
        }
    }

    protected void rotate4DBall(double xDelta, double yDelta, double zDelta) {
        double scale = 50.0;
        this.setAsBallRotation(this.m4, scale, xDelta, yDelta, zDelta);
        this.m2_rotate.mul2(this.m4, this.m2_rotate);
    }

    public void setAsBallRotation(M4d m, double scale, double dx, double dy, double dz) {
        double dxyz2 = dx * dx + dy * dy + dz * dz;
        double sxyz = Math.sqrt(dxyz2);
        double th = sxyz / scale;
        double c = Math.cos(th);
        double s = Math.sin(th);
        double nx = dx / sxyz;
        double ny = dy / sxyz;
        double nz = dz / sxyz;
        double c1 = c - 1.0;
        m.m00 = 1.0 + c1 * nx * nx;
        m.m11 = 1.0 + c1 * ny * ny;
        m.m22 = 1.0 + c1 * nz * nz;
        m.m33 = c;
        m.m01 = m.m10 = c1 * nx * ny;
        m.m02 = m.m20 = c1 * nx * nz;
        m.m12 = m.m21 = c1 * ny * nz;
        m.m03 = s * nx;
        m.m30 = -m.m03;
        m.m13 = s * ny;
        m.m31 = -m.m13;
        m.m23 = s * nz;
        m.m32 = -m.m23;
    }

    private void checkM2() {
        if (this.m2_rotate == null) {
            this.m2_rotate = M4d.newMV(this.matrixRotate, this.zero);
        }
    }

    @Override
    public synchronized void calcTransformMatrix() {
        super.calcTransformMatrix();
        boolean bl = this.doTransform4D = this.is4D && !this.stereoFrame && this.mode != 1;
        if (!this.doTransform4D) {
            return;
        }
        this.v1.sub2(this.frameOffset, this.fixedRotationCenter);
        this.checkM2();
        this.m3_toScreen.setIdentity();
        this.m3_toScreen.m11 = this.m3_toScreen.m22 = this.scalePixelsPerAngstrom;
        this.m3_toScreen.m00 = this.m3_toScreen.m22;
        this.m3_toScreen.m11 = this.m3_toScreen.m22 = -this.scalePixelsPerAngstrom;
        this.zOffset = this.modelCenterOffset;
    }

    @Override
    protected void getScreenTemp(T3d ptXYZ) {
        if (this.doTransform4D && ptXYZ instanceof T4d) {
            this.p4.add2(ptXYZ, this.v1);
            this.m2_rotate.rotate(this.p4);
            this.fScrPt.setT(this.p4);
            this.m3_toScreen.rotTrans(this.fScrPt);
            this.fScrPt.z += this.zOffset;
        } else {
            this.matrixTransform.rotTrans2(ptXYZ, this.fScrPt);
        }
    }
}

