/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.P4d;
import javajs.util.PT;
import javajs.util.T3d;
import javajs.util.T4d;
import javajs.util.V3d;
import org.jmol.util.Escape;
import org.jmol.viewer.Viewer;

public class SimpleUnitCell {
    public static final int PARAM_STD = 6;
    public static final int PARAM_VAX = 6;
    public static final int PARAM_VBX = 9;
    public static final int PARAM_VCX = 12;
    public static final int PARAM_VCZ = 14;
    public static final int PARAM_OXYZ = 15;
    public static final int PARAM_M4 = 6;
    public static final int PARAM_M33 = 21;
    public static final int PARAM_SUPERCELL = 22;
    public static final int PARAM_SCALE = 25;
    public static final int PARAM_SLOP = 26;
    public static final int PARAM_COUNT = 27;
    public static final int INFO_IS_RHOMBOHEDRAL = 9;
    public static final int INFO_IS_HEXAGONAL = 8;
    public static final int INFO_DIMENSION_TYPE = 7;
    public static final int INFO_DIMENSIONS = 6;
    public static final int INFO_GAMMA = 5;
    public static final int INFO_BETA = 4;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_C = 2;
    public static final int INFO_B = 1;
    public static final int INFO_A = 0;
    public static final int DIMENSION_TYPE_ALL = 7;
    public static final String HEX_TO_RHOMB = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c";
    public static final String RHOMB_TO_HEX = "a-b,b-c,a+b+c";
    protected static final double toRadians = Math.PI / 180;
    public static final double SLOPSP = 1.0E-4;
    public static final double SLOPDP = 1.0E-12;
    public static final double SLOP_PARAMS = 0.001;
    protected double[] unitCellParams;
    protected double slop = Viewer.isHighPrecision ? 1.0E-12 : 1.0E-4;
    public M4d matrixCartesianToFractional;
    public M4d matrixFractionalToCartesian;
    protected M4d matrixCtoFNoOffset;
    protected M4d matrixFtoCNoOffset;
    public double volume;
    protected int dimension = 3;
    public int dimensionType = 7;
    private P3d fractionalOrigin = new P3d();
    private int na;
    private int nb;
    private int nc;
    protected double a;
    protected double b;
    protected double c;
    protected double alpha;
    protected double beta;
    protected double gamma;
    protected double cosAlpha;
    protected double sinAlpha;
    protected double cosBeta;
    protected double sinBeta;
    protected double cosGamma;
    protected double sinGamma;
    protected double cA_;
    protected double cB_;
    protected double a_;
    protected double b_;
    protected double c_;

    public double getPrecision() {
        return this.slop;
    }

    public void setPrecision(double slop) {
        this.slop = !Double.isNaN(slop) ? slop : (!Double.isNaN(this.unitCellParams[26]) ? this.unitCellParams[26] : (Viewer.isHighPrecision ? 1.0E-12 : 1.0E-4));
        this.unitCellParams[26] = this.slop;
    }

    public boolean isSupercell() {
        return this.na > 1 || this.nb > 1 || this.nc > 1;
    }

    public static boolean isValid(double[] parameters) {
        return parameters != null && (parameters[0] > 0.0 || parameters.length > 14 && !Double.isNaN(parameters[14]));
    }

    protected SimpleUnitCell() {
    }

    public static SimpleUnitCell newA(double[] params) {
        SimpleUnitCell c = new SimpleUnitCell();
        c.init(params);
        return c;
    }

    public static int getDimensionFromParams(double[] params) {
        return params[0] <= 0.0 ? 3 : (params[1] < 0.0 ? 1 : (params[2] < 0.0 ? 2 : 3));
    }

    protected void init(double[] params) {
        if (params == null) {
            params = new double[]{1.0, 1.0, 1.0, 90.0, 90.0, 90.0};
        }
        if (!SimpleUnitCell.isValid(params)) {
            return;
        }
        this.unitCellParams = SimpleUnitCell.newParams(params, Double.NaN);
        boolean rotateHex = false;
        this.dimension = SimpleUnitCell.getDimensionFromParams(params);
        switch (this.dimension) {
            case 1: {
                this.dimensionType = 1;
                break;
            }
            case 2: {
                this.dimensionType = 3;
                break;
            }
            case 3: {
                this.dimensionType = 7;
            }
        }
        this.a = params[0];
        this.b = params[1];
        this.c = params[2];
        this.alpha = params[3];
        this.beta = params[4];
        this.gamma = params[5];
        if (this.gamma == -1.0 && this.c > 0.0) {
            rotateHex = true;
            this.gamma = 120.0;
        }
        if (params.length > 26) {
            if (Double.isNaN(params[26])) {
                params[26] = this.slop;
            } else {
                this.slop = params[26];
            }
        }
        this.na = Math.max(1, params.length > 24 && !Double.isNaN(params[22]) ? (int)params[22] : 1);
        double fa = this.na;
        this.nb = Math.max(1, params.length > 24 && !Double.isNaN(params[23]) ? (int)params[23] : 1);
        double fb = this.nb;
        this.nc = Math.max(1, params.length > 24 && !Double.isNaN(params[24]) ? (int)params[24] : 1);
        double fc = this.nc;
        if (params.length > 25 && !Double.isNaN(params[25])) {
            double fScale = params[25];
            if (fScale > 0.0) {
                fa *= fScale;
                fb *= fScale;
                fc *= fScale;
            }
        } else {
            fc = 1.0;
            fb = 1.0;
            fa = 1.0;
        }
        if (this.a <= 0.0 && this.c <= 0.0) {
            V3d va = SimpleUnitCell.newV(params, 6);
            V3d vb = SimpleUnitCell.newV(params, 9);
            V3d vc = SimpleUnitCell.newV(params, 12);
            this.setABC(va, vb, vc);
            if (this.c < 0.0) {
                double[] n = AU.arrayCopyD(params, -1);
                if (this.b < 0.0) {
                    vb.set(0.0, 0.0, 1.0);
                    vb.cross(vb, va);
                    if (vb.length() < (double)0.001f) {
                        vb.set(0.0, 1.0, 0.0);
                    }
                    vb.normalize();
                    n[9] = vb.x;
                    n[10] = vb.y;
                    n[11] = vb.z;
                }
                if (this.c < 0.0) {
                    vc.cross(va, vb);
                    vc.normalize();
                    n[12] = vc.x;
                    n[13] = vc.y;
                    n[14] = vc.z;
                }
                params = n;
            }
        }
        this.a *= fa;
        if (this.b <= 0.0) {
            this.c = 1.0;
            this.b = 1.0;
        } else if (this.c <= 0.0) {
            this.c = 1.0;
            this.b *= fb;
        } else {
            this.b *= fb;
            this.c *= fc;
        }
        this.setCellParams();
        if (params.length > 21 && !Double.isNaN(params[21])) {
            double[] scaleMatrix = new double[16];
            for (int i = 0; i < 16; ++i) {
                double f;
                switch (i % 4) {
                    case 0: {
                        f = fa;
                        break;
                    }
                    case 1: {
                        f = fb;
                        break;
                    }
                    case 2: {
                        f = fc;
                        break;
                    }
                    default: {
                        f = 1.0;
                    }
                }
                scaleMatrix[i] = params[6 + i] * f;
            }
            this.matrixCartesianToFractional = M4d.newA16(scaleMatrix);
            this.matrixCartesianToFractional.getTranslation(this.fractionalOrigin);
            this.matrixFractionalToCartesian = M4d.newM4(this.matrixCartesianToFractional).invert();
            if (params[0] == 1.0) {
                this.setParamsFromMatrix();
            }
        } else if (params.length > 14 && !Double.isNaN(params[14])) {
            M4d m = this.matrixFractionalToCartesian = new M4d();
            m.setColumn4(0, params[6] * fa, params[7] * fa, params[8] * fa, 0.0);
            m.setColumn4(1, params[9] * fb, params[10] * fb, params[11] * fb, 0.0);
            m.setColumn4(2, params[12] * fc, params[13] * fc, params[14] * fc, 0.0);
            if (params.length > 17 && !Double.isNaN(params[17])) {
                m.setColumn4(3, params[15], params[16], params[17], 1.0);
            } else {
                m.setColumn4(3, 0.0, 0.0, 0.0, 1.0);
            }
            this.matrixCartesianToFractional = M4d.newM4(this.matrixFractionalToCartesian).invert();
        } else {
            M4d m = this.matrixFractionalToCartesian = new M4d();
            if (rotateHex) {
                m.setColumn4(0, -this.b * this.cosGamma, -this.b * this.sinGamma, 0.0, 0.0);
                m.setColumn4(1, -this.b * this.cosGamma, this.b * this.sinGamma, 0.0, 0.0);
            } else {
                m.setColumn4(0, this.a, 0.0, 0.0, 0.0);
                m.setColumn4(1, this.b * this.cosGamma, this.b * this.sinGamma, 0.0, 0.0);
            }
            m.setColumn4(2, this.c * this.cosBeta, this.c * (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma, this.volume / (this.a * this.b * this.sinGamma), 0.0);
            m.setColumn4(3, 0.0, 0.0, 0.0, 1.0);
            this.matrixCartesianToFractional = M4d.newM4(this.matrixFractionalToCartesian).invert();
        }
        this.matrixCtoFNoOffset = this.matrixCartesianToFractional;
        this.matrixFtoCNoOffset = this.matrixFractionalToCartesian;
    }

    private static V3d newV(double[] p, int i) {
        return V3d.new3(p[i++], p[i++], p[i]);
    }

    public static double[] newParams(double[] params, double slop) {
        double[] p = new double[27];
        int n = params.length;
        for (int i = 0; i < 27; ++i) {
            p[i] = i < n ? params[i] : Double.NaN;
        }
        if (n < 27) {
            p[26] = slop;
        }
        return p;
    }

    public static void addVectors(double[] params) {
        SimpleUnitCell c = SimpleUnitCell.newA(params);
        M4d m = c.matrixFractionalToCartesian;
        for (int i = 0; i < 9; ++i) {
            params[6 + i] = m.getElement(i % 3, i / 3);
        }
    }

    private void setParamsFromMatrix() {
        V3d va = V3d.new3(1.0, 0.0, 0.0);
        V3d vb = V3d.new3(0.0, 1.0, 0.0);
        V3d vc = V3d.new3(0.0, 0.0, 1.0);
        this.matrixFractionalToCartesian.rotate(va);
        this.matrixFractionalToCartesian.rotate(vb);
        this.matrixFractionalToCartesian.rotate(vc);
        this.setABC(va, vb, vc);
        this.setCellParams();
    }

    private void setABC(V3d va, V3d vb, V3d vc) {
        SimpleUnitCell.fillParams(va, vb, vc, this.unitCellParams);
        double[] p = this.unitCellParams;
        this.a = p[0];
        this.b = p[1];
        this.c = p[2];
        this.alpha = p[3];
        this.beta = p[4];
        this.gamma = p[5];
    }

    public static void fillParams(V3d va, V3d vb, V3d vc, double[] p) {
        if (va == null) {
            va = SimpleUnitCell.newV(p, 6);
            vb = SimpleUnitCell.newV(p, 9);
            vc = SimpleUnitCell.newV(p, 12);
        }
        double a = va.length();
        double b = vb.length();
        double c = vc.length();
        if (a == 0.0) {
            return;
        }
        if (b == 0.0) {
            c = -1.0;
            b = -1.0;
        } else if (c == 0.0) {
            c = -1.0;
        }
        p[0] = a;
        p[1] = b;
        p[2] = c;
        p[3] = b < 0.0 || c < 0.0 ? 90.0 : vb.angle(vc) / (Math.PI / 180);
        p[4] = c < 0.0 ? 90.0 : va.angle(vc) / (Math.PI / 180);
        p[5] = b < 0.0 ? 90.0 : va.angle(vb) / (Math.PI / 180);
    }

    private void setCellParams() {
        this.cosAlpha = Math.cos(Math.PI / 180 * this.alpha);
        this.sinAlpha = Math.sin(Math.PI / 180 * this.alpha);
        this.cosBeta = Math.cos(Math.PI / 180 * this.beta);
        this.sinBeta = Math.sin(Math.PI / 180 * this.beta);
        this.cosGamma = Math.cos(Math.PI / 180 * this.gamma);
        this.sinGamma = Math.sin(Math.PI / 180 * this.gamma);
        double unitVolume = Math.sqrt(this.sinAlpha * this.sinAlpha + this.sinBeta * this.sinBeta + this.sinGamma * this.sinGamma + 2.0 * this.cosAlpha * this.cosBeta * this.cosGamma - 2.0);
        this.volume = this.a * this.b * this.c * unitVolume;
        this.cA_ = (this.cosAlpha - this.cosBeta * this.cosGamma) / this.sinGamma;
        this.cB_ = unitVolume / this.sinGamma;
        this.a_ = this.b * this.c * this.sinAlpha / this.volume;
        this.b_ = this.a * this.c * this.sinBeta / this.volume;
        this.c_ = this.a * this.b * this.sinGamma / this.volume;
    }

    public P3d getFractionalOrigin() {
        return this.fractionalOrigin;
    }

    public P3d toSupercell(P3d fpt) {
        fpt.x /= (double)this.na;
        fpt.y /= (double)this.nb;
        fpt.z /= (double)this.nc;
        return fpt;
    }

    public final void toCartesian(T3d pt, boolean ignoreOffset) {
        if (this.matrixFractionalToCartesian != null) {
            (ignoreOffset ? this.matrixFtoCNoOffset : this.matrixFractionalToCartesian).rotTrans(pt);
        }
    }

    public void toFractionalM(M4d m) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        m.mul(this.matrixFractionalToCartesian);
        m.mul2(this.matrixCartesianToFractional, m);
    }

    public final void toFractional(T3d pt, boolean ignoreOffset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        (ignoreOffset ? this.matrixCtoFNoOffset : this.matrixCartesianToFractional).rotTrans(pt);
    }

    public boolean isPolymer() {
        return this.dimension == 1;
    }

    public boolean isSlab() {
        return this.dimension == 2;
    }

    public final double[] getUnitCellParams() {
        return this.unitCellParams;
    }

    public final double[] getUnitCellAsArray(boolean vectorsOnly) {
        double[] dArray;
        M4d m = this.matrixFractionalToCartesian;
        if (vectorsOnly) {
            double[] dArray2 = new double[9];
            dArray2[0] = m.m00;
            dArray2[1] = m.m10;
            dArray2[2] = m.m20;
            dArray2[3] = m.m01;
            dArray2[4] = m.m11;
            dArray2[5] = m.m21;
            dArray2[6] = m.m02;
            dArray2[7] = m.m12;
            dArray = dArray2;
            dArray2[8] = m.m22;
        } else {
            double[] dArray3 = new double[18];
            dArray3[0] = this.a;
            dArray3[1] = this.b;
            dArray3[2] = this.c;
            dArray3[3] = this.alpha;
            dArray3[4] = this.beta;
            dArray3[5] = this.gamma;
            dArray3[6] = m.m00;
            dArray3[7] = m.m10;
            dArray3[8] = m.m20;
            dArray3[9] = m.m01;
            dArray3[10] = m.m11;
            dArray3[11] = m.m21;
            dArray3[12] = m.m02;
            dArray3[13] = m.m12;
            dArray3[14] = m.m22;
            dArray3[15] = this.dimension;
            dArray3[16] = this.volume;
            dArray = dArray3;
            dArray3[17] = this.dimensionType;
        }
        return dArray;
    }

    public final double getInfo(int infoType) {
        switch (infoType) {
            case 0: {
                return this.a;
            }
            case 1: {
                return this.b;
            }
            case 2: {
                return this.c;
            }
            case 3: {
                return this.alpha;
            }
            case 4: {
                return this.beta;
            }
            case 5: {
                return this.gamma;
            }
            case 6: {
                return this.dimension;
            }
            case 7: {
                return this.dimensionType;
            }
            case 8: {
                return SimpleUnitCell.isHexagonal(this.unitCellParams) ? 1 : 0;
            }
            case 9: {
                return SimpleUnitCell.isRhombohedral(this.unitCellParams) ? 1 : 0;
            }
        }
        return Double.NaN;
    }

    public static T3d[] getReciprocal(T3d[] abc, T3d[] ret, double scale) {
        int i;
        int off = abc.length == 4 ? 1 : 0;
        T3d[] rabc = new P3d[4];
        P3d p3d = rabc[0] = off == 1 ? P3d.newP(abc[0]) : new P3d();
        if (scale == 0.0) {
            scale = Math.PI * 2;
        }
        for (i = 0; i < 3; ++i) {
            P3d p3d2 = new P3d();
            rabc[i + 1] = p3d2;
            P3d v = p3d2;
            v.cross(abc[(i + 1) % 3 + off], abc[(i + 2) % 3 + off]);
            double vol = abc[i + off].dot(v);
            if (scale == -1.0) {
                scale = Math.sqrt(vol);
            }
            v.scale(scale / vol);
        }
        if (ret == null) {
            return rabc;
        }
        for (i = 0; i < 4; ++i) {
            ret[i] = rabc[i];
        }
        return ret;
    }

    public static T3d[] setAbc(String abcabg, double[] params, T3d[] ucnew) {
        if (abcabg != null) {
            String[] tokens;
            if (params == null) {
                params = new double[6];
            }
            if ((tokens = PT.split(abcabg.replace(',', '='), "=")).length >= 12) {
                for (int i = 0; i < 6; ++i) {
                    params[i] = PT.parseDouble(tokens[i * 2 + 1]);
                }
            }
        }
        if (ucnew == null) {
            return null;
        }
        return SimpleUnitCell.setAbcFromParams(params, ucnew);
    }

    public static T3d[] setAbcFromParams(double[] params, T3d[] ucnew) {
        double[] f = SimpleUnitCell.newA(params).getUnitCellAsArray(true);
        ucnew[1].set(f[0], f[1], f[2]);
        ucnew[2].set(f[3], f[4], f[5]);
        ucnew[3].set(f[6], f[7], f[8]);
        return ucnew;
    }

    public void unitizeDim(int dimension, T3d pt) {
        switch (dimension) {
            case 3: {
                pt.z = SimpleUnitCell.unitizeX(pt.z, this.slop);
            }
            case 2: {
                pt.y = SimpleUnitCell.unitizeX(pt.y, this.slop);
            }
            case 1: {
                pt.x = SimpleUnitCell.unitizeX(pt.x, this.slop);
            }
        }
    }

    public static void unitizeDimRnd(int dimension, T3d pt, double slop) {
        switch (dimension) {
            case 3: {
                pt.z = SimpleUnitCell.unitizeXRnd(pt.z, slop);
            }
            case 2: {
                pt.y = SimpleUnitCell.unitizeXRnd(pt.y, slop);
            }
            case 1: {
                pt.x = SimpleUnitCell.unitizeXRnd(pt.x, slop);
            }
        }
    }

    private static double unitizeX(double x, double slop) {
        if ((x -= Math.floor(x)) > 1.0 - slop || x < slop) {
            x = 0.0;
        }
        return x;
    }

    private static double unitizeXRnd(double x, double slop) {
        if ((x -= Math.floor(x)) > 1.0 - slop || x < slop) {
            x = 0.0;
        }
        return x;
    }

    public int twelfthsOf(double f) {
        if (f == 0.0) {
            return 0;
        }
        int i = (int)Math.round(f = Math.abs(f * 12.0));
        return i <= 12 && Math.abs(f - (double)i) < this.slop * 12.0 ? i : -1;
    }

    public void twelfthify(P3d pt) {
        switch (this.dimension) {
            case 3: {
                pt.z = this.setTwelfths(pt.z);
            }
            case 2: {
                pt.y = this.setTwelfths(pt.y);
            }
            case 1: {
                pt.x = this.setTwelfths(pt.x);
            }
        }
    }

    private double setTwelfths(double x) {
        int i = this.twelfthsOf(x);
        return i >= 0 ? (double)i / 12.0 * (double)(x < 0.0 ? -1 : 1) : x;
    }

    public static void ijkToPoint3f(int nnn, P3d cell, int offset, int kcode) {
        int f = nnn > 1000000000 ? 1000 : (nnn > 1000000 ? 100 : 10);
        int f2 = f * f;
        cell.x = nnn / f2 % f + (offset -= offset >= 0 ? 5 * f / 10 : offset);
        cell.y = nnn % f2 / f + offset;
        cell.z = (kcode == 0 ? nnn % f : (offset == -500 ? kcode / f : kcode) % f) + offset;
    }

    public static P4d ptToIJK(T3d pt, int scale) {
        if (pt.x <= 5.0 && pt.y <= 5.0 && pt.z <= 5.0) {
            return P4d.new4(555.0, (pt.x + 4.0) * 100.0 + (pt.y + 4.0) * 10.0 + pt.z + 4.0, scale, 0.0);
        }
        int i555 = 1500500500;
        return P4d.new4(i555, (double)i555 + pt.x * 1000000.0 + pt.y * 1000.0 + pt.z, scale, 1500500.0 + pt.z);
    }

    public static String escapeMultiplier(T3d pt) {
        if (pt instanceof P4d) {
            P4d pt4 = (P4d)pt;
            int x = (int)Math.floor(pt4.x / 1000.0) * 1000 + (int)Math.floor(pt4.w / 1000.0) - 1000;
            int y = (int)Math.floor(pt4.y / 1000.0) * 1000 + (int)Math.floor(pt4.w) % 1000;
            return "{" + x + " " + y + " " + pt.z + "}";
        }
        return Escape.eP(pt);
    }

    public static void setMinMaxLatticeParameters(int dimension, P3i minXYZ, P3i maxXYZ, int kcode) {
        if (maxXYZ.x <= maxXYZ.y && maxXYZ.y >= 555) {
            P3d pt = new P3d();
            SimpleUnitCell.ijkToPoint3f(maxXYZ.x, pt, 0, kcode);
            minXYZ.x = (int)pt.x;
            minXYZ.y = (int)pt.y;
            minXYZ.z = (int)pt.z;
            SimpleUnitCell.ijkToPoint3f(maxXYZ.y, pt, 1, kcode);
            maxXYZ.x = (int)pt.x;
            maxXYZ.y = (int)pt.y;
            maxXYZ.z = (int)pt.z;
        }
        switch (dimension) {
            case 1: {
                minXYZ.y = 0;
                maxXYZ.y = 1;
            }
            case 2: {
                minXYZ.z = 0;
                maxXYZ.z = 1;
            }
        }
    }

    public static boolean isHexagonal(double[] params) {
        return SimpleUnitCell.approx0(params[0] - params[1]) && SimpleUnitCell.approx0(params[3] - 90.0) && SimpleUnitCell.approx0(params[4] - 90.0) && (SimpleUnitCell.approx0(params[5] - 120.0) || params[5] == -1.0);
    }

    public static boolean isRhombohedral(double[] params) {
        return SimpleUnitCell.approx0(params[0] - params[1]) && SimpleUnitCell.approx0(params[1] - params[2]) && !SimpleUnitCell.approx0(params[3] - 90.0) && SimpleUnitCell.approx0(params[3] - params[4]) && SimpleUnitCell.approx0(params[4] - params[5]);
    }

    public static boolean approx0(double f) {
        return Math.abs(f) < 0.001;
    }

    public static int getCellRange(T3d fset, P3d[] cellRange) {
        int t3w = fset instanceof T4d ? (int)((T4d)fset).w : 0;
        SimpleUnitCell.ijkToPoint3f((int)fset.x, cellRange[0], 0, t3w);
        SimpleUnitCell.ijkToPoint3f((int)fset.y, cellRange[1], 1, t3w);
        if (fset.z < 0.0) {
            cellRange[0].scale(-1.0 / fset.z);
            cellRange[1].scale(-1.0 / fset.z);
        }
        return t3w;
    }

    public static double parseCalc(Viewer vwr, String[] functions, String s) {
        String p;
        int i;
        String[] parts;
        double d = PT.parseDoubleStrict(s);
        if (!Double.isNaN(d)) {
            return d;
        }
        s = s.toLowerCase();
        if (functions != null && s.indexOf(40) >= 0) {
            parts = PT.split(s, "(");
            i = parts.length - 1;
            while (--i >= 0) {
                p = parts[i];
                String f = null;
                int j = functions.length;
                while (--j >= 0) {
                    if (!p.endsWith(functions[j])) continue;
                    f = functions[j];
                    break;
                }
                if (f != null) continue;
                System.err.println("Unrecognized function " + s);
                int n = i;
                parts[n] = parts[n] + "?";
            }
            s = PT.join(parts, '(', 0);
        }
        if (s.indexOf(47) >= 0) {
            parts = PT.split(s, "/");
            i = parts.length - 1;
            while (--i >= 0) {
                p = parts[i];
                boolean haveDecimal = false;
                boolean haveDigit = false;
                int j = p.length();
                while (--j >= 0) {
                    char c = p.charAt(j);
                    if (c == '.') {
                        haveDecimal = true;
                        break;
                    }
                    if (c == ')') {
                        if (haveDigit) {
                            return Double.NaN;
                        }
                        int n = i;
                        parts[n] = parts[n] + "*1.0";
                        break;
                    }
                    if (!PT.isDigit(c)) break;
                    haveDigit = true;
                }
                if (!haveDigit || haveDecimal) continue;
                int n = i;
                parts[n] = parts[n] + ".";
            }
            s = PT.join(parts, '/', 0);
        }
        return vwr.evaluateExpressionAsVariable(s).asDouble();
    }

    public String toString() {
        return "[" + this.a + " " + this.b + " " + this.c + " " + this.alpha + " " + this.beta + " " + this.gamma + "]";
    }
}

