/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.Interface;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.Geodesic;
import org.jmol.util.MeshSlicer;
import org.jmol.viewer.Viewer;

public class MeshSurface {
    protected static final int SEED_COUNT = 25;
    public static final int P_CHECK = 3;
    public static final int P_CONTOUR = 4;
    public static final int P_EXPLICIT_COLOR = 4;
    public Viewer vwr;
    private MeshSlicer slicer;
    public V3d[] oabc;
    public String meshType;
    public int vc;
    public T3d[] vs;
    public double[] vvs;
    public int[] vertexSource;
    public BS surfaceAtoms;
    public int pc;
    public int[][] pis;
    public boolean colorsExplicit;
    public boolean isDrawPolygon;
    public boolean haveQuads;
    public short colix;
    public short colixBack;
    public boolean isColorSolid = true;
    public P3d offset;
    public T3d[] altVertices;
    public short[] pcs;
    public short[] vcs;
    public T3d[] normals;
    public V3d[] normalsTemp;
    public int normalCount;
    public int normixCount;
    public BS bsPolygons;
    public M4d mat4;
    public BS[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;
    public boolean dataOnly;
    private int lastColor;
    private short lastColix;
    protected int iA;
    protected int iB;
    protected int iC;
    public int polygonCount0;
    public int vertexCount0;
    public BS bsSlabDisplay;
    public BS bsSlabGhost;
    public int slabMeshType;
    public short slabColix;
    public BS bsDisplay;
    public SB slabOptions;
    public int mergeVertexCount0;
    public int mergePolygonCount0;
    public boolean isMerged;

    public MeshSlicer getMeshSlicer() {
        return this.slicer == null ? (this.slicer = ((MeshSlicer)Interface.getInterface("org.jmol.util.MeshSlicer", this.vwr, "script")).set(this)) : this.slicer;
    }

    public static MeshSurface newMesh(boolean isAlt, T3d[] vertices, int vertexCount, int[][] polygonIndexes, T3d[] normals, int nNormals) {
        MeshSurface ms = new MeshSurface();
        ms.pis = polygonIndexes;
        if (isAlt) {
            ms.altVertices = vertices;
        } else {
            ms.vs = vertices;
        }
        ms.vc = vertexCount == 0 ? vertices.length : vertexCount;
        ms.normals = normals;
        ms.normalCount = nNormals == 0 && normals != null ? normals.length : nNormals;
        return ms;
    }

    public T3d[] getVertices() {
        return this.altVertices == null ? this.vs : this.altVertices;
    }

    public int[][] getFaces() {
        return this.pis;
    }

    public void setColix(short colix) {
        this.colix = colix;
    }

    public void setColixBack(short colix) {
        this.colixBack = colix;
    }

    public int addV(T3d vertex, boolean asCopy) {
        if (this.vc == 0) {
            this.vs = new T3d[25];
        } else if (this.vc == this.vs.length) {
            this.vs = (T3d[])AU.doubleLength(this.vs);
        }
        this.vs[this.vc] = asCopy ? P3d.newP(vertex) : vertex;
        return this.vc++;
    }

    public void addTriangle(int vertexA, int vertexB, int vertexC) {
        this.addPolygon(new int[]{vertexA, vertexB, vertexC}, null);
    }

    public void addQuad(int vertexA, int vertexB, int vertexC, int vertexD) {
        this.haveQuads = true;
        this.addPolygon(new int[]{vertexA, vertexB, vertexC, vertexD}, null);
    }

    public void setPolygonCount(int polygonCount) {
        this.pc = polygonCount;
        if (polygonCount < 0) {
            return;
        }
        if (this.pis == null || polygonCount > this.pis.length) {
            this.pis = AU.newInt2(polygonCount);
        }
    }

    public int addVCVal(T3d vertex, double value, boolean asCopy) {
        if (this.vc == 0) {
            this.vvs = new double[25];
        } else if (this.vc >= this.vvs.length) {
            this.vvs = AU.doubleLengthD(this.vvs);
        }
        this.vvs[this.vc] = value;
        return this.addV(vertex, asCopy);
    }

    public int addTriangleCheck(int vertexA, int vertexB, int vertexC, int check, int iContour, int color) {
        return this.vs == null || this.vvs != null && (Double.isNaN(this.vvs[vertexA]) || Double.isNaN(this.vvs[vertexB]) || Double.isNaN(this.vvs[vertexC])) || Double.isNaN(this.vs[vertexA].x) || Double.isNaN(this.vs[vertexB].x) || Double.isNaN(this.vs[vertexC].x) ? -1 : this.addPolygonV3(vertexA, vertexB, vertexC, check, iContour, color, null);
    }

    int addPolygonV3(int vertexA, int vertexB, int vertexC, int check, int iContour, int color, BS bs) {
        return this.dataOnly ? this.addPolygon(new int[]{vertexA, vertexB, vertexC, check}, bs) : this.addPolygonC(new int[]{vertexA, vertexB, vertexC, check, iContour}, color, bs, iContour < 0);
    }

    protected int addPolygonC(int[] polygon, int color, BS bs, boolean isExplicit) {
        if (color != 0) {
            if (this.pcs == null || this.pc == 0) {
                this.lastColor = 0;
            }
            if (isExplicit) {
                this.colorsExplicit = true;
            } else {
                int n;
                if (this.pcs == null) {
                    this.pcs = new short[25];
                } else if (this.pc >= this.pcs.length) {
                    this.pcs = AU.doubleLengthShort(this.pcs);
                }
                if (isExplicit) {
                    n = 2047;
                } else if (color == this.lastColor) {
                    n = this.lastColix;
                } else {
                    this.lastColor = color;
                    short s = C.getColix(this.lastColor);
                    n = s;
                    this.lastColix = s;
                }
                this.pcs[this.pc] = n;
            }
        }
        return this.addPolygon(polygon, bs);
    }

    public int addPolygon(int[] polygon, BS bs) {
        int n = this.pc;
        if (n == 0) {
            this.pis = AU.newInt2(25);
        } else if (n == this.pis.length) {
            this.pis = (int[][])AU.doubleLength(this.pis);
        }
        if (bs != null) {
            bs.set(n);
        }
        this.pis[this.pc++] = polygon;
        return n;
    }

    public void invalidatePolygons() {
        int i = this.pc;
        while (--i >= this.mergePolygonCount0) {
            if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(i) || this.setABC(i) != null) continue;
            this.pis[i] = null;
        }
    }

    protected int[] setABC(int i) {
        if (!(this.bsSlabDisplay == null || this.bsSlabDisplay.get(i) || this.bsSlabGhost != null && this.bsSlabGhost.get(i))) {
            return null;
        }
        int[] polygon = this.pis[i];
        if (polygon == null || polygon.length < 3) {
            return null;
        }
        this.iA = polygon[0];
        this.iB = polygon[1];
        this.iC = polygon[2];
        return (int[])(this.vvs == null || !Double.isNaN(this.vvs[this.iA]) && !Double.isNaN(this.vvs[this.iB]) && !Double.isNaN(this.vvs[this.iC]) ? polygon : null);
    }

    public void setTranslucentVertices(BS bsVertices) {
    }

    public String getSlabColor() {
        return this.bsSlabGhost == null ? null : C.getHexCode(this.slabColix);
    }

    public String getSlabType() {
        return this.bsSlabGhost != null && this.slabMeshType == 1073742018 ? "mesh" : null;
    }

    public void resetSlab() {
        if (this.slicer != null) {
            this.slicer.slabPolygons(MeshSurface.getSlabObjectType(1073742333, null, false, null), false);
        }
    }

    public void slabPolygonsList(Lst<Object[]> slabInfo, boolean allowCap) {
        this.getMeshSlicer();
        for (int i = 0; i < slabInfo.size() && this.slicer.slabPolygons((Object[])slabInfo.get(i), allowCap); ++i) {
        }
    }

    protected void slabBrillouin(P3d[] unitCellVectors) {
    }

    public double getResolution() {
        return 0.0;
    }

    public static MeshSurface getSphereData(int lvl) {
        Geodesic.createGeodesic(lvl);
        int vertexCount = Geodesic.getVertexCount(lvl);
        short[] f = Geodesic.getFaceVertexes(lvl);
        int nFaces = f.length / 3;
        int[][] faces = AU.newInt2(nFaces);
        int fpt = 0;
        for (int i = 0; i < nFaces; ++i) {
            faces[i] = new int[]{f[fpt++], f[fpt++], f[fpt++]};
        }
        T3d[] vectors = new V3d[vertexCount];
        for (int i = 0; i < vertexCount; ++i) {
            vectors[i] = Geodesic.getVertexVector(i);
        }
        return MeshSurface.newMesh(true, vectors, 0, faces, vectors, 0);
    }

    public void setBox(P3d xyzMin, P3d xyzMax) {
        xyzMin.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        xyzMax.set(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (int i = 0; i < this.vc; ++i) {
            T3d p = this.vs[i];
            if (Double.isNaN(p.x)) continue;
            BoxInfo.addPoint(p, xyzMin, xyzMax, 0.0);
        }
    }

    public void setBoundingBox(P3d[] boundBoxPoints) {
    }

    public static Object[] getSlabObjectType(int tok, Object data, boolean isCap, Object colorData) {
        return new Object[]{tok, data, isCap, colorData};
    }

    public static Object[] getSlabWithinRange(double min, double max) {
        return new Object[]{1073742114, new Double[]{min, max}, Boolean.FALSE, null};
    }

    public static double getSphericalInterpolationFraction(double r, double valueA, double valueB, double d) {
        double ra = Math.abs(r + valueA) / d;
        double rb = Math.abs(r + valueB) / d;
        double ra2 = ra * ra;
        double q = ra2 - rb * rb + 1.0;
        double p = 4.0 * ((r /= d) * r - ra2);
        double factor = ra < rb ? 1 : -1;
        return (q + factor * Math.sqrt(q * q + p)) / 2.0;
    }
}

