/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.jmol.api.JmolAudioPlayer;
import org.jmol.api.js.JSmolAppletObject;
import org.jmol.api.js.JmolToJSmolInterface;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class JmolAudio
implements LineListener,
JmolAudioPlayer {
    private static final int MAX_LOOP = 10;
    private Map<String, Object> params;
    private Clip myClip;
    private String fileName;
    private Viewer vwr;
    private String id;
    private static int idCount;
    private boolean autoClose;

    public void playAudio(Viewer vwr, Map<String, Object> htParams) {
        try {
            this.id = (String)htParams.get("id");
            if (this.id == null || this.id.length() == 0) {
                this.autoClose = true;
                this.id = "audio" + ++idCount;
                htParams.put("id", this.id);
            }
            this.vwr = vwr;
            this.params = htParams;
            this.params.put("audioPlayer", this);
            this.fileName = (String)htParams.get("audioFile");
            vwr.sm.registerAudio(this.id, htParams);
            JSmolAppletObject applet = vwr.html5Applet;
            JmolToJSmolInterface jmol = Viewer.jmolObject;
            if (jmol == null) {
                this.getClip();
            } else {
                jmol.playAudio(applet, htParams);
            }
            if (this.myClip == null) {
                return;
            }
            if (htParams.containsKey("action")) {
                this.action((String)htParams.get("action"));
            } else if (htParams.containsKey("loop")) {
                this.action("loop");
            } else {
                this.autoClose = true;
                this.action("start");
            }
        }
        catch (Exception e) {
            Logger.info("File " + this.fileName + " could not be opened as an audio file");
        }
    }

    private void getClip() throws Exception {
        Object data = this.vwr.fm.getFileAsBytes(this.fileName, null);
        if (data == null || data instanceof String) {
            this.params.put("status", "error");
            this.params.put("error", "" + data);
            this.vwr.sm.notifyAudioStatus(this.params);
            Logger.info("File " + this.fileName + " " + data);
            return;
        }
        this.myClip = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
        this.myClip.addLineListener(this);
        this.myClip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream((byte[])data)));
    }

    @Override
    public void update(LineEvent le) {
        this.processUpdate(le.getType().toString());
    }

    @Override
    public void processUpdate(String type) {
        Logger.info("audio id " + this.id + " " + this.fileName + " " + type);
        String status = null;
        switch (type) {
            case "open": 
            case "Open": {
                status = "open";
                break;
            }
            case "play": 
            case "Start": {
                status = "play";
                break;
            }
            case "pause": 
            case "Stop": {
                status = "pause";
                break;
            }
            case "ended": 
            case "Close": {
                status = "ended";
                break;
            }
            default: {
                status = type;
            }
        }
        if (!status.equals(this.params.get("status"))) {
            this.params.put("statusType", type);
            this.params.put("status", status);
            this.vwr.sm.notifyAudioStatus(this.params);
            if (status == "ended" && this.autoClose) {
                this.myClip.close();
            }
        }
    }

    @Override
    public void action(String action) {
        if (this.myClip == null) {
            if (action == "kill") {
                return;
            }
            this.params.put("status", "ended");
            this.vwr.sm.notifyAudioStatus(this.params);
            return;
        }
        try {
            switch (action) {
                case "start": {
                    this.myClip.setMicrosecondPosition(0L);
                    this.myClip.loop(0);
                    this.myClip.start();
                    break;
                }
                case "loop": {
                    this.myClip.setMicrosecondPosition(0L);
                    this.myClip.loop(10);
                    this.myClip.start();
                    break;
                }
                case "pause": {
                    this.myClip.stop();
                    break;
                }
                case "stop": {
                    this.myClip.stop();
                    this.myClip.setMicrosecondPosition(0L);
                    break;
                }
                case "play": {
                    this.myClip.stop();
                    this.myClip.start();
                    break;
                }
                case "kill": 
                case "close": {
                    this.myClip.stop();
                    this.myClip.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

