/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.M3d;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.GenericPlatform;
import org.jmol.api.JmolGraphicsInterface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.c.STER;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.util.Normix;
import org.jmol.util.Shader;
import org.jmol.viewer.Viewer;

public class GData
implements JmolGraphicsInterface {
    public GenericPlatform apiPlatform;
    public boolean translucentCoverOnly;
    public boolean currentlyRendering;
    public boolean antialiasEnabled;
    protected int windowWidth;
    protected int windowHeight;
    protected int displayMinX;
    protected int displayMaxX;
    protected int displayMinY;
    protected int displayMaxY;
    protected int displayMinX2;
    protected int displayMaxX2;
    protected int displayMinY2;
    protected int displayMaxY2;
    protected boolean antialiasThisFrame;
    protected boolean inGreyscaleMode;
    protected short[] changeableColixMap = new short[16];
    protected Object backgroundImage;
    protected int newWindowWidth;
    protected int newWindowHeight;
    protected boolean newAntialiasing;
    public int bgcolor;
    public short contrastColix;
    public int xLast;
    public int yLast;
    public int slab;
    public int depth;
    public int width;
    public int height;
    public int ambientOcclusion;
    protected short colixCurrent;
    public int argbCurrent;
    protected int ht3;
    public boolean isPass2;
    protected int textY;
    public int bufferSize;
    public Shader shader;
    protected Viewer vwr;
    public static final byte ENDCAPS_NONE = 0;
    public static final byte ENDCAPS_HIDDEN = 1;
    public static final byte ENDCAPS_FLAT = 2;
    public static final byte ENDCAPS_SPHERICAL = 3;
    public static final byte ENDCAPS_OPEN_TO_SPHERICAL = 4;
    public static final byte ENDCAPS_FLAT_TO_SPHERICAL = 5;
    protected Object graphicsForMetrics;
    public static final int EXPORT_RAYTRACER = 2;
    public static final int EXPORT_CARTESIAN = 1;
    public static final int EXPORT_NOT = 0;
    public static final int yGT = 1;
    public static final int yLT = 2;
    public static final int xGT = 4;
    public static final int xLT = 8;
    public static final int zGT = 16;
    public static final int zLT = 32;
    public static final int HUGE = -1;
    protected Font currentFont;
    public int argbNoisyUp;
    public int argbNoisyDn;
    protected V3d[] transformedVectors = new V3d[normixCount];
    protected static short normixCount = Normix.getNormixCount();

    public GData() {
        this.shader = new Shader();
    }

    public void initialize(Viewer vwr, GenericPlatform apiPlatform) {
        this.vwr = vwr;
        this.apiPlatform = apiPlatform;
    }

    public void setDepth(int depthValue) {
        this.depth = depthValue < 0 ? 0 : depthValue;
    }

    @Override
    public void setSlab(int slabValue) {
        this.slab = Math.max(0, slabValue);
    }

    @Override
    public void setSlabAndZShade(int slab, int depth, int zSlab, int zDepth, int zPower) {
        this.setSlab(slab);
        this.setDepth(depth);
    }

    public void setAmbientOcclusion(int value) {
        this.ambientOcclusion = value;
    }

    @Override
    public boolean isAntialiased() {
        return this.antialiasThisFrame;
    }

    public short getChangeableColix(int id, int argb) {
        if (id >= this.changeableColixMap.length) {
            this.changeableColixMap = AU.arrayCopyShort(this.changeableColixMap, id + 16);
        }
        if (this.changeableColixMap[id] == 0) {
            this.changeableColixMap[id] = C.getColix(argb);
        }
        return (short)(id | Short.MIN_VALUE);
    }

    public void changeColixArgb(int id, int argb) {
        if (id < this.changeableColixMap.length && this.changeableColixMap[id] != 0) {
            this.changeableColixMap[id] = C.getColix(argb);
        }
    }

    public int getColorArgbOrGray(short colix) {
        if (colix == 3) {
            return C.getArgb(this.contrastColix);
        }
        if (colix < 0) {
            colix = this.changeableColixMap[colix & 0x7FF];
        }
        return this.inGreyscaleMode ? C.getArgbGreyscale(colix) : C.getArgb(colix);
    }

    public int[] getShades(short colix) {
        if (colix < 0) {
            colix = this.changeableColixMap[colix & 0x7FF];
        }
        return this.inGreyscaleMode ? this.shader.getShadesG(colix) : this.shader.getShades(colix);
    }

    public void setGreyscaleMode(boolean greyscaleMode) {
        this.inGreyscaleMode = greyscaleMode;
    }

    public int getSpecularPower() {
        return this.shader.specularPower;
    }

    public synchronized void setSpecularPower(int val) {
        if (val < 0) {
            this.setSpecularExponent(-val);
            return;
        }
        if (this.shader.specularPower == val) {
            return;
        }
        this.shader.specularPower = val;
        this.shader.intenseFraction = (double)val / 100.0;
        this.shader.flushCaches();
    }

    public int getSpecularPercent() {
        return this.shader.specularPercent;
    }

    public synchronized void setSpecularPercent(int val) {
        if (this.shader.specularPercent == val) {
            return;
        }
        this.shader.specularPercent = val;
        this.shader.specularFactor = (double)val / 100.0;
        this.shader.flushCaches();
    }

    public int getSpecularExponent() {
        return this.shader.specularExponent;
    }

    public synchronized void setSpecularExponent(int val) {
        if (this.shader.specularExponent == val) {
            return;
        }
        this.shader.specularExponent = val;
        this.shader.phongExponent = (int)Math.pow(2.0, val);
        this.shader.usePhongExponent = false;
        this.shader.flushCaches();
    }

    public int getPhongExponent() {
        return this.shader.phongExponent;
    }

    public synchronized void setPhongExponent(int val) {
        if (this.shader.phongExponent == val && this.shader.usePhongExponent) {
            return;
        }
        this.shader.phongExponent = val;
        double x = Math.log(val) / Math.log(2.0);
        boolean bl = this.shader.usePhongExponent = x != (double)((int)x);
        if (!this.shader.usePhongExponent) {
            this.shader.specularExponent = (int)x;
        }
        this.shader.flushCaches();
    }

    public int getDiffusePercent() {
        return this.shader.diffusePercent;
    }

    public synchronized void setDiffusePercent(int val) {
        if (this.shader.diffusePercent == val) {
            return;
        }
        this.shader.diffusePercent = val;
        this.shader.diffuseFactor = (double)val / 100.0;
        this.shader.flushCaches();
    }

    public int getAmbientPercent() {
        return this.shader.ambientPercent;
    }

    public synchronized void setAmbientPercent(int val) {
        if (this.shader.ambientPercent == val) {
            return;
        }
        this.shader.ambientPercent = val;
        this.shader.ambientFraction = (double)val / 100.0;
        this.shader.flushCaches();
    }

    public boolean getSpecular() {
        return this.shader.specularOn;
    }

    public synchronized void setSpecular(boolean val) {
        if (this.shader.specularOn == val) {
            return;
        }
        this.shader.specularOn = val;
        this.shader.flushCaches();
    }

    public void setCel(boolean val) {
        this.shader.setCel(val, this.shader.celPower, this.bgcolor);
    }

    public boolean getCel() {
        return this.shader.celOn;
    }

    public int getCelPower() {
        return this.shader.celPower;
    }

    public void setCelPower(int celPower) {
        this.shader.setCel(this.shader.celOn || this.shader.celPower == 0, celPower, this.bgcolor);
    }

    public V3d getLightSource() {
        return this.shader.lightSource;
    }

    public boolean isClipped3(int x, int y, int z) {
        return x < 0 || x >= this.width || y < 0 || y >= this.height || z < this.slab || z > this.depth;
    }

    public boolean isClipped(int x, int y) {
        return x < 0 || x >= this.width || y < 0 || y >= this.height;
    }

    @Override
    public boolean isInDisplayRange(int x, int y) {
        return x >= this.displayMinX && x < this.displayMaxX && y >= this.displayMinY && y < this.displayMaxY;
    }

    @Override
    public boolean isClippedXY(int diameter, int x, int y) {
        int r = diameter + 1 >> 1;
        return x < -r || x >= this.width + r || y < -r || y >= this.height + r;
    }

    public boolean isClippedZ(int z) {
        return z != Integer.MIN_VALUE && (z < this.slab || z > this.depth);
    }

    public int clipCode3(int x, int y, int z) {
        int code = 0;
        if (x < 0) {
            code |= x < this.displayMinX2 ? -1 : 8;
        } else if (x >= this.width) {
            code |= x > this.displayMaxX2 ? -1 : 4;
        }
        if (y < 0) {
            code |= y < this.displayMinY2 ? -1 : 2;
        } else if (y >= this.height) {
            code |= y > this.displayMaxY2 ? -1 : 1;
        }
        if (z < this.slab) {
            code |= 0x20;
        } else if (z > this.depth) {
            code |= 0x10;
        }
        return code;
    }

    public int clipCode(int z) {
        int code = 0;
        if (z < this.slab) {
            code |= 0x20;
        } else if (z > this.depth) {
            code |= 0x10;
        }
        return code;
    }

    public Font getFont3D(double fontSize) {
        return Font.createFont3D(0, 0, fontSize, fontSize, 0.0, this.apiPlatform, this.graphicsForMetrics);
    }

    public Font getFont3DFS(String fontFace, double fontSize) {
        return Font.createFont3D(Font.getFontFaceID(fontFace), 0, fontSize, fontSize, 0.0, this.apiPlatform, this.graphicsForMetrics);
    }

    public int getFontFidFS(String fontFace, double fontSize) {
        return this.getFont3DFSS((String)fontFace, (String)"Bold", (double)fontSize).fid;
    }

    public Font getFont3DFSS(String fontFace, String fontStyle, double fontSize) {
        int iStyle = Font.getFontStyleID(fontStyle);
        if (iStyle < 0) {
            iStyle = 0;
        }
        return Font.createFont3D(Font.getFontFaceID(fontFace), iStyle, fontSize, fontSize, 0.0, this.apiPlatform, this.graphicsForMetrics);
    }

    public Font getFont3DScaled(Font font, double scale) {
        double newScale = font.fontSizeNominal * scale;
        return newScale == font.fontSize ? font : Font.createFont3D(font.idFontFace, font.idFontStyle, newScale, font.fontSizeNominal, font.fontSizeAngstroms, this.apiPlatform, this.graphicsForMetrics);
    }

    public int getFontFidI(double fontSize) {
        return this.getFont3D((double)fontSize).fid;
    }

    public Font getFont3DCurrent() {
        return this.currentFont;
    }

    public void setFont(Font font3d) {
    }

    public void setFontBold(String fontFace, double fontSize) {
        this.setFont(this.getFont3DFSS(fontFace, "Bold", fontSize));
    }

    public void setBackgroundTransparent(boolean TF) {
    }

    public void setBackgroundArgb(int argb) {
        this.bgcolor = argb;
        this.setCel(this.shader.celOn);
    }

    public void setBackgroundImage(Object image) {
        this.backgroundImage = image;
    }

    public void setWindowParameters(int width, int height, boolean antialias) {
        this.setWinParams(width, height, antialias);
    }

    protected void setWinParams(int width, int height, boolean antialias) {
        this.newWindowWidth = width;
        this.newWindowHeight = height;
        this.newAntialiasing = antialias;
    }

    public void setNewWindowParametersForExport() {
        this.windowWidth = this.newWindowWidth;
        this.windowHeight = this.newWindowHeight;
        this.setWidthHeight(false);
    }

    protected void setWidthHeight(boolean isAntialiased) {
        this.width = this.windowWidth;
        this.height = this.windowHeight;
        if (isAntialiased) {
            this.width <<= 1;
            this.height <<= 1;
        }
        this.xLast = this.width - 1;
        this.yLast = this.height - 1;
        this.displayMinX = -(this.width >> 1);
        this.displayMaxX = this.width - this.displayMinX;
        this.displayMinY = -(this.height >> 1);
        this.displayMaxY = this.height - this.displayMinY;
        this.displayMinX2 = this.displayMinX << 2;
        this.displayMaxX2 = this.displayMaxX << 2;
        this.displayMinY2 = this.displayMinY << 2;
        this.displayMaxY2 = this.displayMaxY << 2;
        this.ht3 = this.height * 3;
        this.bufferSize = this.width * this.height;
    }

    public void beginRendering(M3d stereoRotationMatrix, boolean translucentMode, boolean isImageWrite, boolean renderLow) {
    }

    public void endRendering() {
    }

    public void snapshotAnaglyphChannelBytes() {
    }

    public Object getScreenImage(boolean isImageWrite) {
        return null;
    }

    public void releaseScreenImage() {
    }

    public void applyAnaglygh(STER stereoMode, int[] stereoColors) {
    }

    public boolean setPass2(boolean antialias) {
        return false;
    }

    public void destroy() {
    }

    public void clearFontCache() {
    }

    public void drawQuadrilateralBits(JmolRendererInterface jmolRenderer, short colix, P3d screenA, P3d screenB, P3d screenC, P3d screenD) {
        jmolRenderer.drawLineBits(colix, colix, screenA, screenB);
        jmolRenderer.drawLineBits(colix, colix, screenB, screenC);
        jmolRenderer.drawLineBits(colix, colix, screenC, screenD);
        jmolRenderer.drawLineBits(colix, colix, screenD, screenA);
    }

    public void drawTriangleBits(JmolRendererInterface renderer, P3d screenA, short colixA, P3d screenB, short colixB, P3d screenC, short colixC, int check) {
        if ((check & 1) == 1) {
            renderer.drawLineBits(colixA, colixB, screenA, screenB);
        }
        if ((check & 2) == 2) {
            renderer.drawLineBits(colixB, colixC, screenB, screenC);
        }
        if ((check & 4) == 4) {
            renderer.drawLineBits(colixC, colixA, screenC, screenA);
        }
    }

    public void plotImage(int x, int y, int z, Object image, JmolRendererInterface jmolRenderer, short bgcolix, int width, int height) {
    }

    public void plotText(int x, int y, int z, int colorArgbOrGray, int bgColor, String text, Font font3d, JmolRendererInterface jmolRenderer) {
    }

    public void renderBackground(JmolRendererInterface jmolRenderer) {
    }

    public void setColor(int argb) {
        this.argbNoisyUp = this.argbNoisyDn = argb;
        this.argbCurrent = this.argbNoisyDn;
    }

    public boolean setC(short colix) {
        return true;
    }

    public boolean isDirectedTowardsCamera(short normix) {
        return normix < 0 || this.transformedVectors[normix].z > 0.0;
    }

    public static int roundInt(int a) {
        return a;
    }

    public void clear() {
    }

    @Override
    public void renderAllStrings(Object jmolRenderer) {
    }

    public void addRenderer(int tok) {
    }

    public static void getHermiteList(int tension, T3d p0, T3d p1, T3d p2, T3d p3, T3d p4, T3d[] list, int index0, int n, boolean isPt) {
        int nPoints = n + 1;
        double fnPoints = n - 1;
        double x1 = p1.x;
        double y1 = p1.y;
        double z1 = p1.z;
        double x2 = p2.x;
        double y2 = p2.y;
        double z2 = p2.z;
        double xT1 = (x2 - p0.x) * (double)tension / 8.0;
        double yT1 = (y2 - p0.y) * (double)tension / 8.0;
        double zT1 = (z2 - p0.z) * (double)tension / 8.0;
        double xT2 = (p3.x - x1) * (double)tension / 8.0;
        double yT2 = (p3.y - y1) * (double)tension / 8.0;
        double zT2 = (p3.z - z1) * (double)tension / 8.0;
        double xT3 = (p4.x - x2) * (double)tension / 8.0;
        double yT3 = (p4.y - y2) * (double)tension / 8.0;
        double zT3 = (p4.z - z2) * (double)tension / 8.0;
        list[index0] = p1;
        for (int i = 0; i < nPoints; ++i) {
            double s = (double)i / fnPoints;
            if (i == nPoints - 1) {
                x1 = x2;
                y1 = y2;
                z1 = z2;
                x2 = p3.x;
                y2 = p3.y;
                z2 = p3.z;
                xT1 = xT2;
                yT1 = yT2;
                zT1 = zT2;
                xT2 = xT3;
                yT2 = yT3;
                zT2 = zT3;
                s -= 1.0;
            }
            double s2 = s * s;
            double s3 = s2 * s;
            double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
            double h2 = -2.0 * s3 + 3.0 * s2;
            double h3 = s3 - 2.0 * s2 + s;
            double h4 = s3 - s2;
            double x = h1 * x1 + h2 * x2 + h3 * xT1 + h4 * xT2;
            double y = h1 * y1 + h2 * y2 + h3 * yT1 + h4 * yT2;
            double z = h1 * z1 + h2 * z2 + h3 * zT1 + h4 * zT2;
            list[index0 + i] = isPt ? P3d.new3(x, y, z) : V3d.new3(x, y, z);
        }
    }

    public void setTextPosition(int y) {
        this.textY = y;
    }

    public int getTextPosition() {
        return this.textY;
    }

    public V3d[] getTransformedVertexVectors() {
        return this.transformedVectors;
    }

    @Override
    public void drawLinePixels(P3i sA, P3i sB, int z, int zslab) {
    }
}

