/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.modelset.Atom;
import org.jmol.script.T;

public class ContactPair {
    public double[] radii = new double[2];
    public double[] vdws = new double[2];
    public Atom[] myAtoms = new Atom[2];
    public P3d pt;
    public double volume = 0.0;
    public double vdwVolume = 0.0;
    public double score;
    public double d;
    public double chord;
    public int contactType;
    public double xVdwClash = Double.NaN;
    private int oldType = 0;

    public ContactPair(Atom[] atoms, int i1, int i2, double R, double r, double vdwA, double vdwB) {
        this.radii[0] = R;
        this.radii[1] = r;
        this.vdws[0] = vdwA;
        this.vdws[1] = vdwB;
        this.myAtoms[0] = atoms[i1];
        this.myAtoms[1] = atoms[i2];
        V3d v = V3d.newVsub(this.myAtoms[1], this.myAtoms[0]);
        this.d = v.length();
        double f = (R - r + this.d) / (2.0 * this.d);
        this.pt = new P3d();
        this.pt.scaleAdd2(f, v, this.myAtoms[0]);
        this.score = this.d - vdwA - vdwB;
        int n = this.contactType = this.score < 0.0 ? 1073741881 : 1648363544;
        if (this.score < 0.0) {
            this.radii[0] = R = vdwA;
            this.radii[1] = r = vdwB;
        }
        this.getVolume();
    }

    private void getVolume() {
        double R = this.radii[0];
        double r = this.radii[1];
        this.volume = R + r - this.d;
        this.volume *= Math.PI * this.volume * (this.d * this.d + 2.0 * this.d * r - 3.0 * r * r + 2.0 * this.d * R + 6.0 * r * R - 3.0 * R * R) / 12.0 / this.d;
        this.vdwVolume = this.score > 0.0 ? -this.volume : this.volume;
        double a = this.d * this.d - r * r + R * R;
        this.chord = Math.sqrt(4.0 * this.d * this.d * R * R - a * a) / this.d;
    }

    public boolean setForVdwClash(boolean isVdw) {
        if (Double.isNaN(this.xVdwClash)) {
            return false;
        }
        if (isVdw) {
            this.oldType = this.contactType;
            this.contactType = 1648363544;
            this.radii[0] = this.vdws[0] + this.xVdwClash;
            this.radii[1] = this.vdws[1] + this.xVdwClash;
        } else {
            this.contactType = this.oldType;
            this.radii[0] = this.vdws[0];
            this.radii[1] = this.vdws[1];
        }
        this.getVolume();
        return true;
    }

    public void switchAtoms() {
        Atom atom = this.myAtoms[0];
        this.myAtoms[0] = this.myAtoms[1];
        this.myAtoms[1] = atom;
        double r = this.radii[0];
        this.radii[0] = this.radii[1];
        this.radii[1] = r;
        r = this.vdws[0];
        this.vdws[0] = this.vdws[1];
        this.vdws[1] = r;
    }

    public String toString() {
        return "type=" + T.nameOf(this.contactType) + " " + this.myAtoms[0] + " " + this.myAtoms[1] + " dAB=" + this.d + " score=" + this.score + " chord=" + this.chord + " volume=" + this.volume;
    }
}

