/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class VibrationThread
extends JmolThread {
    private TransformManager transformManager;

    @Override
    public int setManager(Object manager, Viewer vwr, Object options) {
        this.transformManager = (TransformManager)manager;
        this.setViewer(vwr, "VibrationThread");
        return 0;
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    this.lastRepaintTime = this.startTime = System.currentTimeMillis();
                    this.vwr.startHoverWatcher(false);
                    this.haveReference = true;
                    mode = 0;
                    break;
                }
                case 0: {
                    int elapsed = (int)(System.currentTimeMillis() - this.lastRepaintTime);
                    this.sleepTime = 33 - elapsed;
                    if (!this.runSleep(this.sleepTime, 1)) {
                        return;
                    }
                    mode = 1;
                    break;
                }
                case 1: {
                    this.lastRepaintTime = System.currentTimeMillis();
                    int elapsed = (int)(this.lastRepaintTime - this.startTime);
                    if (this.transformManager.vibrationPeriodMs == 0) {
                        mode = -2;
                        break;
                    }
                    double t = (double)(elapsed % this.transformManager.vibrationPeriodMs) / (double)this.transformManager.vibrationPeriodMs;
                    this.transformManager.setVibrationT(t);
                    this.vwr.refresh(3, "VibrationThread");
                    mode = this.checkInterrupted(this.transformManager.vibrationThread) ? -2 : 0;
                    break;
                }
                case -2: {
                    this.vwr.startHoverWatcher(true);
                    return;
                }
            }
        }
    }
}

