/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.thread.JmolThread;
import org.jmol.util.Logger;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.Viewer;

public class AnimationThread
extends JmolThread {
    private AnimationManager am;
    private int framePointer1;
    private int framePointer2;
    private int intThread;
    private boolean isFirst;

    @Override
    public int setManager(Object manager, Viewer vwr, Object params) {
        int[] options = (int[])params;
        this.framePointer1 = options[0];
        this.framePointer2 = options[1];
        this.intThread = options[2];
        this.am = (AnimationManager)manager;
        this.setViewer(vwr, "AnimationThread");
        vwr.startHoverWatcher(false);
        return 0;
    }

    @Override
    public void interrupt() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (Logger.debugging) {
            Logger.debug("animation thread interrupted!");
        }
        try {
            this.am.setAnimationOn(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.interrupt();
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    if (Logger.debugging) {
                        Logger.debug("animation thread " + this.intThread + " running");
                    }
                    this.vwr.requestRepaintAndWait("animationThread");
                    this.vwr.startHoverWatcher(false);
                    this.haveReference = true;
                    this.isFirst = true;
                    mode = 0;
                    break;
                }
                case 0: {
                    if (!this.am.animationOn || this.checkInterrupted(this.am.animationThread)) {
                        mode = -2;
                        break;
                    }
                    if (this.am.currentFrameIs(this.framePointer1)) {
                        this.targetTime += (long)this.am.firstFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 1)) {
                            return;
                        }
                    }
                    mode = 1;
                    break;
                }
                case 1: {
                    if (this.am.currentFrameIs(this.framePointer2)) {
                        this.targetTime += (long)this.am.lastFrameDelayMs;
                        this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                        if (!this.runSleep(this.sleepTime, 2)) {
                            return;
                        }
                    }
                    mode = 2;
                    break;
                }
                case 2: {
                    if (!this.isFirst && this.am.currentIsLast() && !this.am.setAnimationNext()) {
                        mode = -2;
                        break;
                    }
                    this.isFirst = false;
                    this.targetTime += (long)((int)(1000.0 / (double)this.am.animationFps + (double)this.vwr.ms.getFrameDelayMs(this.am.cmi)));
                    mode = 3;
                    break;
                }
                case 3: {
                    while (this.am.animationOn && !this.checkInterrupted(this.am.animationThread) && !this.vwr.getRefreshing()) {
                        if (this.runSleep(10, 3)) continue;
                        return;
                    }
                    if (!this.vwr.tm.spinOn) {
                        this.vwr.refresh(1, "animationThread");
                    }
                    this.sleepTime = (int)(this.targetTime - (System.currentTimeMillis() - this.startTime));
                    if (!this.runSleep(this.sleepTime, 0)) {
                        return;
                    }
                    mode = 0;
                    break;
                }
                case -2: {
                    if (Logger.debugging) {
                        Logger.debug("animation thread " + this.intThread + " exiting");
                    }
                    if (this.am.animationThread == this) {
                        this.am.stopThread(false);
                    } else {
                        this.interrupt();
                    }
                    return;
                }
            }
        }
    }
}

