/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.T3d;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;

public class UnitCellIterator
implements AtomIndexIterator {
    private Atom[] atoms;
    private T3d center;
    private T3d translation;
    private int nFound;
    private double maxDistance2;
    private double distance2;
    private SymmetryInterface unitCell;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3i t;
    private P3d p;
    private int ipt = Integer.MIN_VALUE;
    private Lst<P3d[]> unitList;
    private boolean done;
    private int nAtoms;
    private int listPt;

    public UnitCellIterator set(SymmetryInterface unitCell, Atom atom, Atom[] atoms, BS bsAtoms, double distance) {
        this.unitCell = unitCell;
        this.atoms = atoms;
        this.addAtoms(bsAtoms);
        this.p = new P3d();
        if (distance > 0.0) {
            this.setCenter(atom, distance);
        }
        return this;
    }

    @Override
    public void setModel(ModelSet modelSet, int modelIndex, int zeroBase, int atomIndex, T3d center, double distance, RadiusData rd) {
    }

    @Override
    public void setCenter(T3d center, double distance) {
        if (distance == 0.0) {
            return;
        }
        this.maxDistance2 = distance * distance;
        this.center = center;
        this.translation = new P3d();
        P3d[] pts = BoxInfo.unitCubePoints;
        P3d min = P3d.new3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        P3d max = P3d.new3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        this.p = new P3d();
        P3d ptC = new P3d();
        ptC.setT(center);
        this.unitCell.toFractional(ptC, true);
        for (int i = 0; i < 8; ++i) {
            this.p.scaleAdd2(-2.0, pts[i], pts[7]);
            this.p.scaleAdd2(distance, this.p, center);
            this.unitCell.toFractional(this.p, true);
            if (min.x > this.p.x) {
                min.x = this.p.x;
            }
            if (max.x < this.p.x) {
                max.x = this.p.x;
            }
            if (min.y > this.p.y) {
                min.y = this.p.y;
            }
            if (max.y < this.p.y) {
                max.y = this.p.y;
            }
            if (min.z > this.p.z) {
                min.z = this.p.z;
            }
            if (!(max.z < this.p.z)) continue;
            max.z = this.p.z;
        }
        this.minXYZ = P3i.new3((int)Math.floor(min.x), (int)Math.floor(min.y), (int)Math.floor(min.z));
        this.maxXYZ = P3i.new3((int)Math.ceil(max.x), (int)Math.ceil(max.y), (int)Math.ceil(max.z));
        if (Logger.debugging) {
            Logger.info("UnitCellIterator minxyz/maxxyz " + this.minXYZ + " " + this.maxXYZ);
        }
        this.t = P3i.new3(this.minXYZ.x - 1, this.minXYZ.y, this.minXYZ.z);
        this.nextCell();
    }

    @Override
    public void addAtoms(BS bsAtoms) {
        boolean bl = this.done = bsAtoms == null;
        if (this.done) {
            return;
        }
        this.unitList = new Lst();
        String cat = "";
        M4d[] ops = this.unitCell.getSymmetryOperations();
        int nOps = ops.length;
        P3d pt = new P3d();
        P3d pa = new P3d();
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = this.atoms[i];
            for (int j = 0; j < nOps; ++j) {
                if (j > 0) {
                    pt.setT(a);
                    this.unitCell.toFractional(pt, false);
                    ops[j].rotTrans(pt);
                    this.unitCell.unitize(pt);
                    this.unitCell.toCartesian(pt, false);
                    pt.putP(pa);
                } else {
                    pa.setT(a);
                    this.unitCell.toUnitCell(pa, null);
                }
                String key = "_" + (int)(pa.x * 100.0) + "_" + (int)(pa.y * 100.0) + "_" + (int)(pa.z * 100.0) + "_";
                if (cat.indexOf(key) >= 0) continue;
                cat = cat + key;
                this.unitList.addLast(new P3d[]{a, pa});
                pa = new P3d();
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        this.nAtoms = this.unitList.size();
        boolean bl2 = this.done = this.nAtoms == 0;
        if (Logger.debugging) {
            Logger.info("UnitCellIterator " + this.nAtoms + " unique points found");
        }
    }

    @Override
    public boolean hasNext() {
        while (this.ipt < this.nAtoms || this.nextCell()) {
            double d;
            ++this.ipt;
            this.listPt = this.listPt;
            this.p.add2(((P3d[])this.unitList.get(this.listPt))[1], this.translation);
            this.distance2 = this.p.distanceSquared(this.center);
            if (!(d < this.maxDistance2) || !(this.distance2 > 0.1)) continue;
            ++this.nFound;
            return true;
        }
        return false;
    }

    private boolean nextCell() {
        if (this.done) {
            return false;
        }
        if (++this.t.x >= this.maxXYZ.x) {
            this.t.x = this.minXYZ.x;
            if (++this.t.y >= this.maxXYZ.y) {
                this.t.y = this.minXYZ.y;
                if (++this.t.z >= this.maxXYZ.z) {
                    this.done = true;
                    this.ipt = this.nAtoms;
                    return false;
                }
            }
        }
        this.translation.set(this.t.x, this.t.y, this.t.z);
        this.unitCell.toCartesian(this.translation, false);
        this.ipt = 0;
        return true;
    }

    @Override
    public int next() {
        return this.done || this.ipt < 0 ? -1 : this.getAtom().i;
    }

    private Atom getAtom() {
        return (Atom)((P3d[])this.unitList.get(this.listPt))[0];
    }

    @Override
    public double foundDistance2() {
        return this.nFound > 0 ? this.distance2 : Double.MAX_VALUE;
    }

    @Override
    public P3d getPosition() {
        Atom a = this.getAtom();
        if (Logger.debugging) {
            Logger.info("draw ID p_" + this.nFound + " " + this.p + " //" + a + " " + this.t);
        }
        if (this.p.distanceSquared(a) < (double)1.0E-4f) {
            return a;
        }
        Point3fi p = new Point3fi();
        p.setT(this.p);
        p.i = a.i;
        p.sD = (short)a.getElementNumber();
        return p;
    }

    @Override
    public void release() {
        this.atoms = null;
        this.center = null;
        this.translation = null;
    }
}

