/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.Edge;
import org.jmol.util.SimpleNode;

public class SmilesBond
extends Edge {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_AROMATIC = 17;
    public static final int TYPE_RING = 65;
    public static final int TYPE_ANY = 81;
    public static final int TYPE_BIO_SEQUENCE = 96;
    public static final int TYPE_BIO_CROSSLINK = 112;
    private static final String ALL_BONDS = "-=#$:/\\.~^`+!,&;@";
    private static final String SMILES_BONDS = "-=#$:/\\.~^`";
    SmilesAtom atom1;
    SmilesAtom atom2;
    boolean isNot;
    Edge matchingBond;
    private SmilesBond[] primitives;
    int nPrimitives;
    SmilesBond[] bondsOr;
    int nBondsOr;
    boolean isConnection;
    int[] atropType;
    public boolean isChain;

    static String getBondOrderString(int order) {
        switch (order) {
            case 2: {
                return "=";
            }
            case 3: {
                return "#";
            }
            case 4: {
                return "$";
            }
        }
        return "";
    }

    static int getBondTypeFromCode(char code) {
        switch (code) {
            case '.': {
                return 0;
            }
            case '-': {
                return 1;
            }
            case '=': {
                return 2;
            }
            case '#': {
                return 3;
            }
            case '$': {
                return 4;
            }
            case ':': {
                return 17;
            }
            case '/': {
                return 1025;
            }
            case '\\': {
                return 1041;
            }
            case '^': {
                return 65537;
            }
            case '`': {
                return 65538;
            }
            case '@': {
                return 65;
            }
            case '~': {
                return 81;
            }
            case '+': {
                return 96;
            }
        }
        return -1;
    }

    public SmilesAtom getAtom1() {
        return this.atom1;
    }

    void set(SmilesBond bond) {
        this.order = bond.order;
        this.isNot = bond.isNot;
        this.primitives = bond.primitives;
        this.nPrimitives = bond.nPrimitives;
        this.bondsOr = bond.bondsOr;
        this.nBondsOr = bond.nBondsOr;
        this.atropType = bond.atropType;
    }

    void setAtropType(int nn) {
        this.atropType = new int[]{nn / 10 - 1, nn % 10 - 1};
    }

    public SmilesBond setPrimitive(int i) {
        SmilesBond p = this.primitives[i];
        this.order = p.order;
        this.isNot = p.isNot;
        this.atropType = p.atropType;
        return p;
    }

    SmilesBond addBondOr() {
        SmilesBond sBond;
        if (this.bondsOr == null) {
            this.bondsOr = new SmilesBond[2];
        }
        if (this.nBondsOr >= this.bondsOr.length) {
            SmilesBond[] tmp = new SmilesBond[this.bondsOr.length * 2];
            System.arraycopy(this.bondsOr, 0, tmp, 0, this.bondsOr.length);
            this.bondsOr = tmp;
        }
        this.bondsOr[this.nBondsOr] = sBond = new SmilesBond(null, null, -1, false);
        ++this.nBondsOr;
        return sBond;
    }

    SmilesBond addPrimitive() {
        SmilesBond sBond;
        if (this.primitives == null) {
            this.primitives = new SmilesBond[2];
        }
        if (this.nPrimitives >= this.primitives.length) {
            SmilesBond[] tmp = new SmilesBond[this.primitives.length * 2];
            System.arraycopy(this.primitives, 0, tmp, 0, this.primitives.length);
            this.primitives = tmp;
        }
        this.primitives[this.nPrimitives] = sBond = new SmilesBond(null, null, -1, false);
        ++this.nPrimitives;
        return sBond;
    }

    public String toString() {
        return this.atom1 + " -" + (this.isNot ? "!" : "") + this.order + "- " + this.atom2;
    }

    public SmilesBond(SmilesAtom atom1, SmilesAtom atom2, int bondType, boolean isNot) {
        this.set2(bondType, isNot);
        this.set2a(atom1, atom2);
    }

    public void set2(int bondType, boolean isNot) {
        this.order = bondType;
        this.isNot = isNot;
    }

    void set2a(SmilesAtom a1, SmilesAtom a2) {
        if (a1 != null) {
            this.atom1 = a1;
            a1.addBond(this);
        }
        if (a2 != null) {
            this.atom2 = a2;
            if (a2.isBioAtomWild && this.atom1.isBioAtomWild) {
                this.order = 96;
            }
            a2.isFirst = false;
            a2.addBond(this);
        }
    }

    void setAtom2(SmilesAtom atom, SmilesSearch molecule) {
        this.atom2 = atom;
        if (this.atom2 != null) {
            atom.addBond(this);
            this.isConnection = true;
        }
    }

    boolean isFromPreviousTo(SmilesAtom atom) {
        return !this.isConnection && this.atom2 == atom;
    }

    static int isBondType(char ch, boolean isSearch, boolean isBioSequence) throws InvalidSmilesException {
        if (ch == '>') {
            return 1;
        }
        if (ALL_BONDS.indexOf(ch) < 0) {
            return 0;
        }
        if (!isSearch && SMILES_BONDS.indexOf(ch) < 0) {
            throw new InvalidSmilesException("SMARTS bond type " + ch + " not allowed in SMILES");
        }
        switch (ch) {
            case '~': {
                return isBioSequence ? 0 : 1;
            }
            case '^': 
            case '`': {
                return -1;
            }
        }
        return 1;
    }

    public int getValence() {
        return this.order & 7;
    }

    public SmilesAtom getOtherAtom(SmilesAtom a) {
        return this.atom1 == a ? this.atom2 : this.atom1;
    }

    @Override
    public int getAtomIndex1() {
        return this.atom1.index;
    }

    @Override
    public int getAtomIndex2() {
        return this.atom2.index;
    }

    @Override
    public int getCovalentOrder() {
        return this.order & 0x1FFFF;
    }

    @Override
    public SimpleNode getOtherNode(SimpleNode atom) {
        return atom == this.atom1 ? this.atom2 : (atom == this.atom2 || atom == null ? this.atom1 : null);
    }

    @Override
    public boolean isPartial() {
        return false;
    }

    @Override
    public boolean isCovalent() {
        return this.order != 112;
    }

    @Override
    public boolean isHydrogen() {
        return this.order == 112;
    }

    void switchAtoms() {
        SmilesAtom a = this.atom1;
        this.atom1 = this.atom2;
        this.atom2 = a;
        switch (this.order & 0x1FFFF) {
            case 65537: {
                this.order = 65538;
                break;
            }
            case 65538: {
                this.order = 65537;
                break;
            }
            case 1025: {
                this.order = 1041;
                break;
            }
            case 1041: {
                this.order = 1025;
            }
        }
    }

    public int getRealCovalentOrder() {
        switch (this.order & 0x1FFFF) {
            case 1025: 
            case 1041: 
            case 65537: 
            case 65538: {
                return 1;
            }
        }
        return this.order & 0x1FFFF;
    }

    public Edge getMatchingBond() {
        return this.matchingBond == null ? this : this.matchingBond;
    }

    @Override
    public SimpleNode getAtom(int i) {
        return i == 1 ? this.atom2 : this.atom1;
    }
}

