/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Map;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.modelset.Atom;
import org.jmol.util.Tensor;

public class Ellipsoid {
    private static int ID = 0;
    public short colix = (short)23;
    public boolean visible;
    public boolean isValid;
    public P3d center = P3d.new3(0.0, 0.0, 0.0);
    public Tensor tensor;
    public String options;
    boolean isOn = true;
    String id;
    int myID = ++ID;
    int modelIndex;
    byte pid;
    double[] lengths;
    double scale = 1.0;
    int percent;
    private double[] scaleXYZ;
    public Map<String, Object> info;
    public String label;
    private static final double[] crtval = new double[]{0.3389, 0.4299, 0.4951, 0.5479, 0.5932, 0.6334, 0.6699, 0.7035, 0.7349, 0.7644, 0.7924, 0.8192, 0.8447, 0.8694, 0.8932, 0.9162, 0.9386, 0.9605, 0.9818, 1.0026, 1.023, 1.043, 1.0627, 1.0821, 1.1012, 1.12, 1.1386, 1.157, 1.1751, 1.1932, 1.211, 1.2288, 1.2464, 1.2638, 1.2812, 1.2985, 1.3158, 1.333, 1.3501, 1.3672, 1.3842, 1.4013, 1.4183, 1.4354, 1.4524, 1.4695, 1.4866, 1.5037, 1.5209, 1.5382, 1.5555, 1.5729, 1.5904, 1.608, 1.6257, 1.6436, 1.6616, 1.6797, 1.698, 1.7164, 1.7351, 1.754, 1.773, 1.7924, 1.8119, 1.8318, 1.8519, 1.8724, 1.8932, 1.9144, 1.936, 1.958, 1.9804, 2.0034, 2.0269, 2.051, 2.0757, 2.1012, 2.1274, 2.1544, 2.1824, 2.2114, 2.2416, 2.273, 2.3059, 2.3404, 2.3767, 2.4153, 2.4563, 2.5003, 2.5478, 2.5997, 2.6571, 2.7216, 2.7955, 2.8829, 2.9912, 3.1365, 3.3682};

    private Ellipsoid() {
    }

    public static Ellipsoid getEmptyEllipsoid(String id, int modelIndex) {
        Ellipsoid e = new Ellipsoid();
        e.id = id;
        e.modelIndex = modelIndex;
        return e;
    }

    public static Ellipsoid getEllipsoidForAtomTensor(Tensor t, Atom center) {
        Ellipsoid e = new Ellipsoid();
        e.tensor = t;
        e.modelIndex = t.modelIndex;
        e.colix = 0;
        e.center = center;
        return e;
    }

    public void setCenter(P3d center) {
        this.center = center;
        this.validate(false);
    }

    public double getLength(int i) {
        if (this.lengths == null) {
            this.setLengths();
        }
        return this.lengths == null ? Double.NaN : this.lengths[i];
    }

    public void scaleAxes(double[] value) {
        this.scaleXYZ = value;
        this.setLengths();
    }

    public void setLengths() {
        if (this.tensor == null) {
            return;
        }
        if (this.lengths == null) {
            this.lengths = new double[3];
        }
        for (int i = 0; i < this.lengths.length; ++i) {
            this.lengths[i] = this.tensor.getFactoredValue(i) * this.scale * (this.scaleXYZ == null ? 1.0 : Math.abs(this.scaleXYZ[i]));
        }
    }

    public void setScale(double scale, boolean isPercent) {
        if (scale <= 0.0) {
            this.isValid = false;
            return;
        }
        if (isPercent) {
            if (scale == 2.147483647E9) {
                scale = this.tensor.forThermalEllipsoid ? 50 : 100;
            }
            this.percent = (int)scale;
            scale = this.tensor.forThermalEllipsoid ? Ellipsoid.getThermalRadius(this.percent) : (this.percent < 1 ? 0.0 : (double)this.percent / 100.0);
        }
        this.scale = scale;
        this.validate(true);
    }

    public static final double getThermalRadius(int prob) {
        return crtval[prob < 1 ? 0 : (prob > 99 ? 98 : prob - 1)];
    }

    protected void setTensor(Tensor tensor) {
        this.isValid = false;
        this.tensor = tensor;
        this.validate(tensor != null);
    }

    private void validate(boolean andSetLengths) {
        if (this.tensor == null) {
            return;
        }
        if (andSetLengths) {
            this.setLengths();
        }
        this.isValid = true;
    }

    public static void getEquationForQuadricWithCenter(double x, double y, double z, M3d mToElliptical, V3d vTemp, M3d mTemp, double[] coef, M4d mDeriv) {
        vTemp.set(x, y, z);
        mToElliptical.rotate(vTemp);
        double f = 1.0 - vTemp.dot(vTemp);
        mTemp.transposeM(mToElliptical);
        mTemp.rotate(vTemp);
        mTemp.mul(mToElliptical);
        coef[0] = mTemp.m00 / f;
        coef[1] = mTemp.m11 / f;
        coef[2] = mTemp.m22 / f;
        coef[3] = mTemp.m01 * 2.0 / f;
        coef[4] = mTemp.m02 * 2.0 / f;
        coef[5] = mTemp.m12 * 2.0 / f;
        coef[6] = -2.0 * vTemp.x / f;
        coef[7] = -2.0 * vTemp.y / f;
        coef[8] = -2.0 * vTemp.z / f;
        coef[9] = -1.0;
        if (mDeriv == null) {
            return;
        }
        mDeriv.setIdentity();
        mDeriv.m00 = 2.0 * coef[0];
        mDeriv.m11 = 2.0 * coef[1];
        mDeriv.m22 = 2.0 * coef[2];
        mDeriv.m01 = mDeriv.m10 = coef[3];
        mDeriv.m02 = mDeriv.m20 = coef[4];
        mDeriv.m12 = mDeriv.m21 = coef[5];
        mDeriv.m03 = coef[6];
        mDeriv.m13 = coef[7];
        mDeriv.m23 = coef[8];
    }
}

