/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.SB;
import org.jmol.atomdata.RadiusData;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;

public class Dots
extends AtomShape {
    public EnvelopeCalculation ec;
    public boolean isSurface = false;
    static final double SURFACE_DISTANCE_FOR_CALCULATION = 10.0;
    BS bsOn = new BS();
    private BS bsSelected;
    private BS bsIgnore;
    public static int MAX_LEVEL = 3;
    int thisAtom;
    double thisRadius;
    int thisArgb;
    RadiusData rdLast = new RadiusData(null, 0.0, null, null);

    @Override
    public void initShape() {
        super.initShape();
        this.translucentAllowed = false;
        this.ec = new EnvelopeCalculation().set(this.vwr, this.ms.ac, this.mads);
    }

    @Override
    public int getSize(int atomIndex) {
        return this.mads != null ? this.mads[atomIndex] * 2 : (this.bsOn.get(atomIndex) ? (int)Math.floor(this.ec.getRadius(atomIndex) * 2000.0) : 0);
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("init" == propertyName) {
            this.initialize();
            return;
        }
        if ("translucency" == propertyName && !this.translucentAllowed) {
            return;
        }
        if ("ignore" == propertyName) {
            this.bsIgnore = (BS)value;
            return;
        }
        if ("select" == propertyName) {
            this.bsSelected = (BS)value;
            return;
        }
        if ("radius" == propertyName) {
            this.thisRadius = ((Number)value).doubleValue();
            if (this.thisRadius > 16.0) {
                this.thisRadius = 16.1;
            }
            return;
        }
        if ("colorRGB" == propertyName) {
            this.thisArgb = (Integer)value;
            return;
        }
        if ("atom" == propertyName) {
            this.thisAtom = (Integer)value;
            if (this.thisAtom >= this.ms.at.length) {
                return;
            }
            this.ms.at[this.thisAtom].setShapeVisibility(this.vf, true);
            this.ec.allocDotsConvexMaps(this.ms.ac);
            return;
        }
        if ("dots" == propertyName) {
            Atom[] atoms = this.ms.at;
            if (this.thisAtom >= atoms.length) {
                return;
            }
            this.isActive = true;
            this.ec.setFromBits(this.thisAtom, (BS)value);
            atoms[this.thisAtom].setShapeVisibility(this.vf, true);
            int ac = this.ms.ac;
            if (this.mads == null) {
                this.ec.setMads(null);
                this.mads = new short[ac];
                for (int i = 0; i < ac; ++i) {
                    if (atoms[i] == null || !atoms[i].isVisible(1 | this.vf)) continue;
                    try {
                        this.mads[i] = (short)(this.ec.getAppropriateRadius(i) * 1000.0);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.ec.setMads(this.mads);
            }
            this.mads[this.thisAtom] = (short)(this.thisRadius * 1000.0);
            if (this.colixes == null) {
                this.checkColixLength((short)4, ac);
            }
            this.colixes[this.thisAtom] = C.getColix(this.thisArgb);
            this.bsOn.set(this.thisAtom);
            return;
        }
        if ("refreshTrajectories" == propertyName) {
            bs = (BS)((Object[])value)[1];
            M4d m4 = (M4d)((Object[])value)[2];
            if (m4 == null) {
                return;
            }
            M3d m = new M3d();
            m4.getRotationScale(m);
            this.ec.reCalculate(bs, m);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int firstAtomDeleted = ((int[])((Object[])value)[2])[1];
            int nAtomsDeleted = ((int[])((Object[])value)[2])[2];
            BSUtil.deleteBits(this.bsOn, bs);
            this.ec.deleteAtoms(firstAtomDeleted, nAtomsDeleted);
        }
        this.setPropAS(propertyName, value, bs);
    }

    void initialize() {
        this.bsSelected = null;
        this.bsIgnore = null;
        this.isActive = false;
        if (this.ec == null) {
            this.ec = new EnvelopeCalculation().set(this.vwr, this.ms.ac, this.mads);
        }
    }

    @Override
    protected void setSizeRD(RadiusData rd, BS bsSelected) {
        BS[] dotsConvexMaps;
        int i;
        boolean newSet;
        double maxRadius;
        if (rd == null) {
            rd = new RadiusData(null, 0.0, RadiusData.EnumType.ABSOLUTE, null);
        }
        if (this.bsSelected != null) {
            bsSelected = this.bsSelected;
        }
        boolean isVisible = true;
        double setRadius = Double.MAX_VALUE;
        this.isActive = true;
        switch (rd.factorType) {
            case OFFSET: {
                break;
            }
            case ABSOLUTE: {
                if (rd.value == 0.0) {
                    isVisible = false;
                }
                setRadius = rd.value;
            }
            default: {
                rd.valueExtended = this.vwr.getBoolean(603979948) ? this.vwr.getDouble(0x22000032) : 0.0;
            }
        }
        switch (rd.vdwType) {
            case ADPMIN: 
            case ADPMAX: 
            case HYDRO: 
            case TEMP: {
                maxRadius = setRadius;
                break;
            }
            case BONDING: {
                maxRadius = this.ms.getMaxVanderwaalsRadius() * 2.0;
                break;
            }
            default: {
                maxRadius = this.ms.getMaxVanderwaalsRadius();
            }
        }
        boolean bl = newSet = this.rdLast.value != rd.value || this.rdLast.valueExtended != rd.valueExtended || this.rdLast.factorType != rd.factorType || this.rdLast.vdwType != rd.vdwType || this.ec.getDotsConvexMax() == 0;
        if (isVisible) {
            int i2 = bsSelected.nextSetBit(0);
            while (i2 >= 0) {
                if (!this.bsOn.get(i2)) {
                    this.bsOn.set(i2);
                    newSet = true;
                }
                i2 = bsSelected.nextSetBit(i2 + 1);
            }
        } else {
            int i0;
            boolean isAll = bsSelected == null;
            i = i0 = isAll ? this.ms.ac - 1 : bsSelected.nextSetBit(0);
            while (i >= 0) {
                this.bsOn.setBitTo(i, false);
                i = isAll ? i - 1 : bsSelected.nextSetBit(i + 1);
            }
        }
        Atom[] atoms = this.ms.at;
        int i3 = this.ms.ac;
        while (--i3 >= 0) {
            if (atoms[i3] == null) continue;
            atoms[i3].setShapeVisibility(this.vf, this.bsOn.get(i3));
        }
        if (!isVisible) {
            return;
        }
        if (newSet) {
            this.mads = null;
            this.ec.newSet();
        }
        if ((dotsConvexMaps = this.ec.getDotsConvexMaps()) != null) {
            i = this.ms.ac;
            while (--i >= 0) {
                if (atoms[i] == null || !this.bsOn.get(i)) continue;
                dotsConvexMaps[i] = null;
            }
        }
        if (dotsConvexMaps == null && (this.colixes == null || this.colixes.length != this.ms.ac)) {
            this.checkColixLength((short)4, this.ms.ac);
        }
        this.ec.calculate(rd, maxRadius, this.bsOn, this.bsIgnore, !this.vwr.getBoolean(603979830), this.vwr.getBoolean(603979829), this.isSurface, true);
        this.rdLast = rd;
    }

    @Override
    public void setAtomClickability() {
        int i = this.ms.ac;
        while (--i >= 0) {
            Atom atom = this.ms.at[i];
            if (atom != null && ((atom.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(i))) continue;
            atom.setClickable(this.vf);
        }
    }

    @Override
    public String getShapeState() {
        BS[] dotsConvexMaps = this.ec.getDotsConvexMaps();
        if (dotsConvexMaps == null || this.ec.getDotsConvexMax() == 0) {
            return "";
        }
        SB s = new SB();
        Hashtable<String, BS> temp = new Hashtable<String, BS>();
        int ac = this.ms.ac;
        String type = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < ac; ++i) {
            BS bs;
            if (!this.bsOn.get(i) || dotsConvexMaps[i] == null) continue;
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                BSUtil.setMapBitSet(temp, i, i, Dots.getColorCommand(type, this.paletteIDs[i], this.colixes[i], this.translucentAllowed));
            }
            if ((bs = dotsConvexMaps[i]).isEmpty()) continue;
            double r = this.ec.getAppropriateRadius(i);
            Dots.appendCmd(s, type + i + " radius " + r + " " + Escape.eBS(bs));
        }
        return s.append(this.vwr.getCommands(temp, null, "select")).toString();
    }
}

