/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.SB;
import javajs.util.V3d;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.C;
import org.jmol.util.Escape;

public class Dipole {
    String thisID = "";
    public short mad;
    public short colix = 0;
    short type;
    public P3d origin;
    public P3d center;
    public V3d vector;
    String dipoleInfo = "";
    public double dipoleValue;
    boolean isUserValue;
    public double offsetSide;
    public double offsetAngstroms;
    public P3d offsetPt;
    int offsetPercent;
    public int visibilityFlags;
    int modelIndex;
    boolean visible;
    public boolean noCross;
    boolean haveAtoms;
    boolean isValid;
    public Atom[] atoms = new Atom[2];
    P3d[] coords = new P3d[2];
    public Bond bond;
    public BS bsMolecule;
    public Lst<Object> lstDipoles;
    static final short DIPOLE_TYPE_UNKNOWN = 0;
    static final short DIPOLE_TYPE_POINTS = 1;
    static final short DIPOLE_TYPE_ATOMS = 2;
    static final short DIPOLE_TYPE_BOND = 3;
    static final short DIPOLE_TYPE_MOLECULAR = 4;
    static final short DIPOLE_TYPE_POINTVECTOR = 5;

    Dipole init(int modelIndex, String thisID, String dipoleInfo, short colix, short mad, boolean visible) {
        this.modelIndex = modelIndex;
        this.thisID = thisID;
        this.dipoleInfo = dipoleInfo;
        this.colix = colix;
        this.mad = mad;
        this.visible = visible;
        this.type = 0;
        return this;
    }

    void setTranslucent(boolean isTranslucent, double translucentLevel) {
        this.colix = C.getColixTranslucent3(this.colix, isTranslucent, translucentLevel);
    }

    void set(Dipole d) {
        this.thisID = d.thisID;
        this.dipoleInfo = d.dipoleInfo;
        this.dipoleValue = d.dipoleValue;
        this.mad = d.mad;
        this.lstDipoles = d.lstDipoles;
        if (this.lstDipoles != null) {
            this.isValid = true;
        }
        this.offsetAngstroms = d.offsetAngstroms;
        this.offsetPercent = d.offsetPercent;
        this.offsetSide = d.offsetSide;
        this.vector = V3d.newV(d.vector);
        this.origin = P3d.newP(d.origin);
        if (d.offsetPt != null) {
            this.origin.add(d.offsetPt);
            this.offsetPt = P3d.newP(d.offsetPt);
        }
        this.bsMolecule = d.bsMolecule;
        boolean bl = this.haveAtoms = d.atoms[0] != null;
        if (this.haveAtoms) {
            this.atoms[0] = d.atoms[0];
            this.atoms[1] = d.atoms[1];
            this.centerDipole();
        } else {
            this.center = null;
        }
    }

    private void set2(P3d pt1, P3d pt2) {
        this.coords[0] = P3d.newP(pt1);
        this.coords[1] = P3d.newP(pt2);
        boolean bl = this.isValid = this.coords[0].distance(this.coords[1]) > 0.1;
        if (this.dipoleValue < 0.0) {
            this.origin = P3d.newP(pt2);
            this.vector = V3d.newV(pt1);
            this.dipoleValue = -this.dipoleValue;
        } else {
            this.origin = P3d.newP(pt1);
            this.vector = V3d.newV(pt2);
        }
        this.dipoleInfo = "" + this.origin + this.vector;
        this.vector.sub(this.origin);
        if (this.dipoleValue == 0.0) {
            this.dipoleValue = this.vector.length();
        } else {
            this.vector.scale(this.dipoleValue / this.vector.length());
        }
        this.type = 1;
    }

    void setValue(double value) {
        double d = this.dipoleValue;
        this.dipoleValue = value;
        if (value == 0.0) {
            this.isValid = false;
        }
        if (this.vector == null) {
            return;
        }
        this.vector.scale(this.dipoleValue / this.vector.length());
        if (d * this.dipoleValue < 0.0) {
            this.origin.sub(this.vector);
        }
    }

    void set2Value(P3d pt1, P3d pt2, double value) {
        this.dipoleValue = value;
        this.atoms[0] = null;
        this.set2(pt1, pt2);
    }

    void setPtVector(P3d pt1, V3d dipole) {
        this.setValue(dipole.length());
        P3d pt2 = P3d.newP(pt1);
        pt2.add(dipole);
        this.set2(pt1, pt2);
        this.type = (short)5;
    }

    void set2AtomValue(Atom atom1, Atom atom2, double value) {
        this.setValue(value);
        this.set2(atom1, atom2);
        this.offsetSide = 0.4;
        this.mad = (short)10;
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.haveAtoms = true;
        this.centerDipole();
    }

    void centerDipole() {
        boolean bl = this.isValid = this.atoms[0] != this.atoms[1] && this.dipoleValue != 0.0;
        if (!this.isValid) {
            return;
        }
        double f = this.atoms[0].distance(this.atoms[1]) / (2.0 * this.dipoleValue) - 0.5;
        this.origin.scaleAdd2(f, this.vector, this.atoms[0]);
        this.center = new P3d();
        this.center.scaleAdd2(0.5, this.vector, this.origin);
        this.bond = this.atoms[0].getBond(this.atoms[1]);
        this.type = (short)(this.bond == null ? 2 : 3);
    }

    boolean isBondType() {
        return this.type == 2 || this.type == 3;
    }

    public String getShapeState() {
        if (!this.isValid) {
            return "";
        }
        SB s = new SB();
        s.append("dipole ID ").append(this.thisID);
        if (this.lstDipoles != null) {
            s.append(" all ").append(Escape.eBS(this.bsMolecule));
        } else if (this.haveAtoms) {
            s.append(" ({").appendI(this.atoms[0].i).append("}) ({").appendI(this.atoms[1].i).append("})");
        } else {
            if (this.coords[0] == null) {
                return "";
            }
            s.append(" ").append(Escape.eP(this.coords[0])).append(" ").append(Escape.eP(this.coords[1]));
        }
        if (this.isUserValue) {
            s.append(" value ").appendD(this.dipoleValue);
        }
        if (this.mad != 10) {
            s.append(" width ").appendD((double)this.mad / 1000.0);
        }
        if (this.offsetAngstroms != 0.0) {
            s.append(" offset ").appendD(this.offsetAngstroms);
        } else if (this.offsetPercent != 0) {
            s.append(" offset ").appendI(this.offsetPercent);
        }
        if (this.offsetSide != 0.4) {
            s.append(" offsetSide ").appendD(this.offsetSide);
        }
        if (this.offsetPt != null) {
            s.append(" offset ").append(Escape.eP(this.offsetPt));
        }
        if (this.noCross) {
            s.append(" nocross");
        }
        if (!this.visible) {
            s.append(" off");
        }
        s.append(";\n");
        return s.toString();
    }

    public void setOffsetPt(P3d pt) {
        if (this.offsetPt != null) {
            this.origin.sub(this.offsetPt);
        }
        this.offsetPt = pt;
        this.origin.add(pt);
    }
}

