/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.P3d;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.Strands;

public class StrandsRenderer
extends BioShapeRenderer {
    protected int strandCount = 1;
    protected double strandSeparation;
    protected double baseStrandOffset;

    @Override
    protected void renderBioShape(BioShape bioShape) {
        this.renderStrandShape();
    }

    protected void renderStrandShape() {
        if (!this.setStrandCount()) {
            return;
        }
        this.renderStrands();
    }

    protected boolean setStrandCount() {
        if (this.wingVectors == null) {
            return false;
        }
        this.strandCount = this.shape instanceof Strands ? this.vwr.getStrandCount(((Strands)this.shape).shapeID) : 10;
        this.strandSeparation = this.strandCount <= 1 ? 0.0 : 1.0 / (double)(this.strandCount - 1);
        this.baseStrandOffset = (this.strandCount & 1) == 0 ? this.strandSeparation / 2.0 : this.strandSeparation;
        return true;
    }

    protected void renderStrands() {
        P3d[] screens;
        int i = this.strandCount >> 1;
        while (--i >= 0) {
            double f = (double)i * this.strandSeparation + this.baseStrandOffset;
            screens = this.calcScreens(f, this.mads);
            this.renderStrand(screens);
            this.vwr.freeTempPoints(screens);
            screens = this.calcScreens(-f, this.mads);
            this.renderStrand(screens);
            this.vwr.freeTempPoints(screens);
        }
        if (this.strandCount % 2 == 1) {
            screens = this.calcScreens(0.0, this.mads);
            this.renderStrand(screens);
            this.vwr.freeTempPoints(screens);
        }
    }

    private void renderStrand(P3d[] screens) {
        int i = this.bsVisible.nextSetBit(0);
        while (i >= 0) {
            this.renderHermiteCylinder(screens, i);
            i = this.bsVisible.nextSetBit(i + 1);
        }
    }
}

