/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.api.JmolRendererInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.renderbio.BioShapeRenderer;
import org.jmol.util.C;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class NucleicRenderer {
    private boolean cartoonBaseEdges;
    private boolean cartoonBlocks;
    private double blockHeight;
    private boolean cartoonLadders;
    private boolean cartoonRibose;
    private P3d[] rPt;
    private P3d[] rPt5;
    private P3d[] rScr;
    private P3d[] rScr5;
    private P3d basePt;
    private P3d backbonePt;
    private P3d baseScreen;
    private P3d backboneScreen;
    private P3d ptTemp;
    private Viewer vwr;
    private TransformManager tm;
    private JmolRendererInterface g3d;
    private BioShapeRenderer bsr;
    private short colix;
    private boolean cartoonSteps;
    private P3d[] scrBox;
    private final int[] triangles = new int[]{1, 0, 3, 1, 3, 2, 0, 4, 7, 0, 7, 3, 4, 5, 6, 4, 6, 7, 5, 1, 2, 5, 2, 6, 2, 3, 7, 2, 7, 6, 0, 1, 5, 0, 5, 4};

    void renderNucleic(BioShapeRenderer renderer) {
        if (this.vwr == null) {
            this.rPt = new P3d[10];
            this.rScr = new P3d[10];
            this.rPt5 = new P3d[5];
            this.rScr5 = new P3d[5];
            this.backboneScreen = new P3d();
            this.backbonePt = new P3d();
            this.bsr = renderer;
            this.tm = renderer.vwr.tm;
            this.vwr = renderer.vwr;
        }
        this.g3d = renderer.g3d;
        P3d[] screens = renderer.controlPointScreens;
        P3d[] pts = renderer.controlPoints;
        this.cartoonBlocks = this.vwr.getBoolean(0x24000022);
        this.cartoonBaseEdges = this.vwr.getBoolean(603979815);
        this.cartoonSteps = this.vwr.getBoolean(603979811);
        this.cartoonLadders = this.vwr.getBoolean(603979817);
        this.cartoonRibose = this.vwr.getBoolean(603979818);
        this.blockHeight = this.vwr.getDouble(0x22000003);
        boolean isTraceAlpha = this.vwr.getBoolean(603979966);
        BS bsVisible = this.bsr.bsVisible;
        int i = bsVisible.nextSetBit(0);
        while (i >= 0) {
            P3d scr = screens[i + 1];
            if (isTraceAlpha) {
                this.backboneScreen.ave(screens[i], scr);
                this.backbonePt.ave(pts[i], pts[i + 1]);
            } else {
                this.backboneScreen.setT(scr);
                this.backbonePt.setT(pts[i + 1]);
            }
            this.bsr.renderHermiteConic(i, false, 4);
            this.colix = this.bsr.getLeadColix(i);
            if (this.bsr.setBioColix(this.colix)) {
                if (this.cartoonRibose && bsVisible.get(i + 1)) {
                    this.renderNucleicBaseStep(i, pts[i + 1], screens[i + 1]);
                } else {
                    this.renderNucleicBaseStep(i, null, null);
                }
            }
            i = bsVisible.nextSetBit(i + 1);
        }
    }

    private void renderNucleicBaseStep(int im, T3d ptPnext, T3d scrPnext) {
        P3d stepPt;
        P3d stepScreen;
        boolean hasRing5;
        if (this.bsr.isPhosphorusOnly) {
            return;
        }
        NucleicMonomer nucleotide = (NucleicMonomer)this.bsr.monomers[im];
        int thisMad = this.bsr.mad = this.bsr.mads[im];
        if (this.rScr[0] == null) {
            int i = 10;
            while (--i >= 0) {
                this.rScr[i] = new P3d();
            }
            i = 5;
            while (--i >= 0) {
                this.rScr5[i] = new P3d();
            }
            this.baseScreen = new P3d();
            this.basePt = new P3d();
            this.rPt[9] = new P3d();
        }
        if (this.cartoonBlocks) {
            this.renderBlock(nucleotide);
            return;
        }
        if (this.cartoonBaseEdges) {
            this.renderLeontisWesthofEdges(nucleotide);
            return;
        }
        if (this.cartoonSteps) {
            this.renderSteps(nucleotide, im);
            return;
        }
        nucleotide.getBaseRing6Points(this.rPt);
        this.transformPoints(6, this.rPt, this.rScr);
        if (!this.cartoonLadders) {
            this.renderRing6();
        }
        if (hasRing5 = nucleotide.maybeGetBaseRing5Points(this.rPt5)) {
            if (this.cartoonLadders) {
                stepScreen = this.rScr[2];
                stepPt = this.rPt[2];
            } else {
                this.transformPoints(5, this.rPt5, this.rScr5);
                this.renderRing5();
                stepScreen = this.rScr5[3];
                stepPt = this.rPt5[3];
            }
        } else {
            int pt = this.cartoonLadders ? 4 : 2;
            stepScreen = this.rScr[pt];
            stepPt = this.rPt[pt];
        }
        short mad = (short)(thisMad > 1 ? thisMad / 2 : thisMad);
        double r = (double)mad / 2000.0;
        int w = (int)this.vwr.tm.scaleToScreen((int)this.backboneScreen.z, mad);
        if (this.cartoonLadders || !this.cartoonRibose) {
            this.g3d.fillCylinderScreen3I((byte)3, w, this.backboneScreen, stepScreen, this.backbonePt, stepPt, r);
        }
        if (this.cartoonLadders) {
            return;
        }
        this.drawEdges(this.rScr, this.rPt, 6);
        if (hasRing5) {
            this.drawEdges(this.rScr5, this.rPt5, 5);
        } else {
            this.renderEdge(this.rScr, this.rPt, 0, 5);
        }
        if (this.cartoonRibose) {
            this.baseScreen.setT(stepScreen);
            this.basePt.setT(stepPt);
            nucleotide.getRiboseRing5Points(this.rPt);
            P3d c = this.rPt[9];
            c.set(0.0, 0.0, 0.0);
            for (int i = 0; i < 5; ++i) {
                c.add(this.rPt[i]);
            }
            c.scale(0.2);
            this.transformPoints(10, this.rPt, this.rScr);
            this.renderRibose();
            this.renderEdge(this.rScr, this.rPt, 2, 5);
            this.renderEdge(this.rScr, this.rPt, 3, 6);
            this.renderEdge(this.rScr, this.rPt, 6, 7);
            this.renderEdge(this.rScr, this.rPt, 7, 8);
            this.renderEdge(this.rScr, this.rPt, 0, 4);
            this.renderCyl(this.rScr[0], this.baseScreen, this.rPt[0], this.basePt);
            if (ptPnext != null) {
                this.renderCyl(this.rScr[5], (P3d)scrPnext, this.rPt[5], (P3d)ptPnext);
            }
            this.drawEdges(this.rScr, this.rPt, 5);
        }
    }

    private void renderSteps(NucleicMonomer g, int i) {
        Lst<BasePair> bps = g.getBasePairs();
        Atom atomA = g.getLeadAtom();
        short cA = C.getColixInherited(this.colix, atomA.colixAtom);
        if (bps != null) {
            boolean checkPass2 = !this.bsr.isExport && !this.vwr.gdata.isPass2;
            Atom[] atoms = this.vwr.ms.at;
            int j = bps.size();
            while (--j >= 0) {
                int iAtom = ((BasePair)bps.get(j)).getPartnerAtom(g);
                if (iAtom <= i) continue;
                Atom atomB = atoms[iAtom];
                short cB = C.getColixInherited(this.colix, atomB.colixAtom);
                if (checkPass2 && !this.bsr.setBioColix(cA) && !this.bsr.setBioColix(cB)) continue;
                this.bsr.drawSegmentAB(atomA, atomB, cA, cB, 1000.0);
            }
        }
    }

    private void transformPoints(int count, T3d[] angstroms, P3d[] screens) {
        int i = count;
        while (--i >= 0) {
            this.tm.transformPtScrT3(angstroms[i], screens[i]);
        }
    }

    private void drawEdges(P3d[] scr, P3d[] pt, int n) {
        int i = n;
        while (--i >= 0) {
            scr[i].z -= 1.0;
        }
        i = n;
        while (--i > 0) {
            this.renderEdge(scr, pt, i, i - 1);
        }
    }

    private void renderBlock(NucleicMonomer g) {
        int j;
        Atom atomA = g.getLeadAtom();
        short cA = this.colix;
        if (this.scrBox == null) {
            this.scrBox = new P3d[8];
            for (int j2 = 0; j2 < 8; ++j2) {
                this.scrBox[j2] = new P3d();
            }
        }
        T3d[] oxyz = g.getDSSRFrame(this.vwr);
        P3d[] box = g.dssrBox;
        double lastHeight = g.dssrBoxHeight;
        boolean isPurine = g.isPurine();
        if (box == null || lastHeight != this.blockHeight) {
            g.dssrBoxHeight = this.blockHeight;
            if (box == null) {
                box = new P3d[8];
                int j3 = 8;
                while (--j3 >= 0) {
                    box[j3] = new P3d();
                }
                g.dssrBox = box;
            }
            SymmetryInterface uc = this.vwr.getSymTemp().getUnitCell(oxyz, false, null);
            if (this.ptTemp == null) {
                this.ptTemp = new P3d();
            }
            this.ptTemp.setT(oxyz[0]);
            uc.toFractional(this.ptTemp, true);
            uc.setOffsetPt(P3d.new3(this.ptTemp.x - 2.25, this.ptTemp.y + 5.0, this.ptTemp.z - this.blockHeight / 2.0));
            double x = 4.5;
            double y = isPurine ? -4.5 : -3.0;
            double z = this.blockHeight;
            box[0] = P3d.new3(0.0, 0.0, 0.0);
            uc.toCartesian(box[0], false);
            box[1] = P3d.new3(x, 0.0, 0.0);
            uc.toCartesian(box[1], false);
            box[2] = P3d.new3(x, y, 0.0);
            uc.toCartesian(box[2], false);
            box[3] = P3d.new3(0.0, y, 0.0);
            uc.toCartesian(box[3], false);
            box[4] = P3d.new3(0.0, 0.0, z);
            uc.toCartesian(box[4], false);
            box[5] = P3d.new3(x, 0.0, z);
            uc.toCartesian(box[5], false);
            box[6] = P3d.new3(x, y, z);
            uc.toCartesian(box[6], false);
            box[7] = P3d.new3(0.0, y, z);
            uc.toCartesian(box[7], false);
        }
        for (j = 0; j < 8; ++j) {
            this.vwr.tm.transformPt3f(box[j], this.scrBox[j]);
        }
        j = 0;
        while (j < 36) {
            this.g3d.fillTriangle3f(this.scrBox[this.triangles[j++]], this.scrBox[this.triangles[j++]], this.scrBox[this.triangles[j++]], false);
        }
        Atom atomB = g.getC1P();
        Atom atomC = g.getN0();
        if (atomB != null && atomC != null) {
            this.bsr.drawSegmentAB(atomA, atomB, cA, cA, 1000.0);
            this.bsr.drawSegmentAB(atomB, atomC, cA, cA, 1000.0);
        }
    }

    private void renderLeontisWesthofEdges(NucleicMonomer nucleotide) {
        if (!nucleotide.getEdgePoints(this.rPt)) {
            return;
        }
        this.transformPoints(6, this.rPt, this.rScr);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, true);
        this.renderEdge(this.rScr, this.rPt, 0, 1);
        this.renderEdge(this.rScr, this.rPt, 1, 2);
        boolean isTranslucent = C.isColixTranslucent(this.colix);
        double tl = C.getColixTranslucencyLevel(this.colix);
        short colixSugarEdge = C.getColixTranslucent3((short)10, isTranslucent, tl);
        short colixWatsonCrickEdge = C.getColixTranslucent3((short)11, isTranslucent, tl);
        short colixHoogsteenEdge = C.getColixTranslucent3((short)7, isTranslucent, tl);
        this.g3d.setC(colixSugarEdge);
        this.renderEdge(this.rScr, this.rPt, 2, 3);
        this.g3d.setC(colixWatsonCrickEdge);
        this.renderEdge(this.rScr, this.rPt, 3, 4);
        this.g3d.setC(colixHoogsteenEdge);
        this.renderEdge(this.rScr, this.rPt, 4, 5);
    }

    private void renderEdge(P3d[] scr, P3d[] pt, int i, int j) {
        this.renderCyl(scr[i], scr[j], pt[i], pt[j]);
    }

    private void renderCyl(P3d s1, P3d s2, P3d p1, P3d p2) {
        this.g3d.fillCylinderScreen3I((byte)3, 3, s1, s2, p1, p2, 0.005);
    }

    private void renderTriangle(P3d[] scr, P3d[] pt, int i, int j, int k, boolean doShade) {
        this.g3d.fillTriangle3i(scr[i], scr[j], scr[k], pt[i], pt[j], pt[k], doShade);
    }

    private void renderRing6() {
        this.renderTriangle(this.rScr, this.rPt, 0, 2, 4, true);
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 2, false);
        this.renderTriangle(this.rScr, this.rPt, 0, 4, 5, false);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 4, false);
    }

    private void renderRing5() {
        this.renderTriangle(this.rScr5, this.rPt5, 0, 1, 2, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 2, 3, false);
        this.renderTriangle(this.rScr5, this.rPt5, 0, 3, 4, false);
    }

    private void renderRibose() {
        this.renderTriangle(this.rScr, this.rPt, 0, 1, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 1, 2, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 2, 3, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 3, 4, 9, true);
        this.renderTriangle(this.rScr, this.rPt, 4, 0, 9, true);
    }
}

