/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Sheet
extends ProteinStructure {
    V3d widthUnitVector;
    V3d heightUnitVector;

    Sheet(AlphaPolymer apolymer, int monomerIndex, int monomerCount, STR subtype) {
        this.setupPS(apolymer, STR.SHEET, monomerIndex, monomerCount);
        this.subtype = subtype;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.nRes == 2) {
            this.axisA = this.apolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.apolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new P3d();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new P3d();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes - 1, this.axisB);
        }
        this.axisUnitVector = new V3d();
        this.axisUnitVector.sub2(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        P3d tempA = new P3d();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst, tempA);
        if (this.notHelixOrSheet(this.monomerIndexFirst - 1)) {
            MeasureD.projectOntoAxis(tempA, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        P3d tempB = new P3d();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes, tempB);
        if (this.notHelixOrSheet(this.monomerIndexFirst + this.nRes)) {
            MeasureD.projectOntoAxis(tempB, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        this.axisA = tempA;
        this.axisB = tempB;
    }

    private boolean notHelixOrSheet(int i) {
        return i < 0 || i >= this.apolymer.monomerCount || !this.apolymer.monomers[i].isHelix() && !this.apolymer.monomers[i].isSheet();
    }

    void calcSheetUnitVectors() {
        if (!(this.apolymer instanceof AminoPolymer)) {
            return;
        }
        if (this.widthUnitVector == null) {
            V3d vectorCO = new V3d();
            V3d vectorCOSum = new V3d();
            AminoMonomer amino = (AminoMonomer)this.apolymer.monomers[this.monomerIndexFirst];
            vectorCOSum.sub2(amino.getCarbonylOxygenAtom(), amino.getCarbonylCarbonAtom());
            int i = this.nRes;
            while (--i > this.monomerIndexFirst) {
                amino = (AminoMonomer)this.apolymer.monomers[i];
                vectorCO.sub2(amino.getCarbonylOxygenAtom(), amino.getCarbonylCarbonAtom());
                if (vectorCOSum.angle(vectorCO) < 1.5707963267948966) {
                    vectorCOSum.add(vectorCO);
                    continue;
                }
                vectorCOSum.sub(vectorCO);
            }
            this.heightUnitVector = vectorCO;
            this.heightUnitVector.cross(this.axisUnitVector, vectorCOSum);
            this.heightUnitVector.normalize();
            this.widthUnitVector = vectorCOSum;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    public void setBox(double w, double h, P3d pt, V3d vW, V3d vH, P3d ptC, double scale) {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        vW.setT(this.widthUnitVector);
        vW.scale(scale * w);
        vH.setT(this.heightUnitVector);
        vH.scale(scale * h);
        ptC.ave(vW, vH);
        ptC.sub2(pt, ptC);
    }
}

