/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Helix
extends ProteinStructure {
    Helix(AlphaPolymer apolymer, int monomerIndex, int monomerCount, STR subtype) {
        this.setupPS(apolymer, STR.HELIX, monomerIndex, monomerCount);
        this.subtype = subtype;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        P3d[] points = new P3d[this.nRes + 1];
        for (int i = 0; i <= this.nRes; ++i) {
            points[i] = new P3d();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + i, points[i]);
        }
        this.axisA = new P3d();
        this.axisUnitVector = new V3d();
        MeasureD.calcBestAxisThroughPoints(points, points.length, this.axisA, this.axisUnitVector, this.vectorProjection, 4);
        this.axisB = P3d.newP(points[this.nRes]);
        MeasureD.projectOntoAxis(this.axisB, this.axisA, this.axisUnitVector, this.vectorProjection);
    }
}

