/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;

public class AminoPolymer
extends AlphaPolymer {
    private static final double maxHbondAlphaDistance = 9.0;
    private static final double maxHbondAlphaDistance2 = 81.0;
    private static final double minimumHbondDistance2 = 0.25;
    private Map<STR, double[]> structureList;

    AminoPolymer(Monomer[] monomers, int pt0) {
        super(monomers, pt0);
        this.type = 1;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)monomers[i]).hasOAtom()) continue;
            return;
        }
        this.hasWingPoints = true;
    }

    @Override
    protected void resetHydrogenPoints() {
        ProteinStructure psLast = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure ps = this.getProteinStructure(i);
            if (ps != null && ps != psLast) {
                psLast = ps;
                psLast.resetAxes();
            }
            ((AminoMonomer)this.monomers[i]).resetHydrogenPoint();
        }
    }

    @Override
    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles2((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles2(AminoMonomer residue1, AminoMonomer residue2) {
        Atom nitrogen1 = residue1.getNitrogenAtom();
        Atom alphacarbon1 = residue1.getLeadAtom();
        Atom carbon1 = residue1.getCarbonylCarbonAtom();
        Atom nitrogen2 = residue2.getNitrogenAtom();
        Atom alphacarbon2 = residue2.getLeadAtom();
        Atom carbon2 = residue2.getCarbonylCarbonAtom();
        residue2.setGroupParameter(1111490569, MeasureD.computeTorsion(carbon1, nitrogen2, alphacarbon2, carbon2, true));
        residue1.setGroupParameter(1111490570, MeasureD.computeTorsion(nitrogen1, alphacarbon1, carbon1, nitrogen2, true));
        residue1.setGroupParameter(1111490568, MeasureD.computeTorsion(alphacarbon1, carbon1, nitrogen2, alphacarbon2, true));
    }

    @Override
    protected double calculateRamachandranHelixAngle(int m, char qtype) {
        double psiLast = m == 0 ? Double.NaN : this.monomers[m - 1].getGroupParameter(1111490570);
        double psi = this.monomers[m].getGroupParameter(1111490570);
        double phi = this.monomers[m].getGroupParameter(1111490569);
        double phiNext = m == this.monomerCount - 1 ? Double.NaN : this.monomers[m + 1].getGroupParameter(1111490569);
        double psiNext = m == this.monomerCount - 1 ? Double.NaN : this.monomers[m + 1].getGroupParameter(1111490570);
        switch (qtype) {
            default: {
                double dPhi = (phiNext - phi) / 2.0 * Math.PI / 180.0;
                double dPsi = (psiNext - psi) / 2.0 * Math.PI / 180.0;
                return 114.59155902616465 * Math.acos(Math.cos(dPsi) * Math.cos(dPhi) - Math.sin(dPsi) * Math.sin(dPhi) / 3.0);
            }
            case 'C': 
            case 'c': 
        }
        return psi - psiLast + phiNext - phi;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer polymer, BS bsA, BS bsB, Lst<Bond> vHBonds, int nMaxPerResidue, int[][][] min, boolean checkDistances, boolean dsspIgnoreHydrogens) {
        if (polymer == null) {
            polymer = this;
        }
        if (!(polymer instanceof AminoPolymer)) {
            return;
        }
        P3d pt = new P3d();
        V3d vNH = new V3d();
        int[][] min1 = min == null ? new int[2][3] : (int[][])null;
        for (int i = 1; i < this.monomerCount; ++i) {
            boolean isInA;
            if (min == null) {
                int n = this.bioPolymerIndexInModel;
                min1[1][0] = n;
                min1[0][0] = n;
                min1[1][1] = Integer.MIN_VALUE;
                min1[0][1] = Integer.MIN_VALUE;
                min1[1][2] = 0;
                min1[0][2] = 0;
            } else {
                min1 = min[i];
            }
            AminoMonomer source = (AminoMonomer)this.monomers[i];
            if (!source.getNHPoint(pt, vNH, checkDistances, dsspIgnoreHydrogens)) continue;
            boolean bl = isInA = bsA == null || bsA.get(source.getNitrogenAtom().i);
            if (!isInA || !checkDistances && source.getCarbonylOxygenAtom() == null) continue;
            this.checkRasmolHydrogenBond(source, polymer, i, pt, isInA ? bsB : bsA, vHBonds, min1, checkDistances);
        }
    }

    private void checkRasmolHydrogenBond(AminoMonomer source, BioPolymer polymer, int indexDonor, P3d hydrogenPoint, BS bsB, Lst<Bond> vHBonds, int[][] min, boolean checkDistances) {
        Atom sourceAlphaPoint = source.getLeadAtom();
        Atom sourceNitrogenPoint = source.getNitrogenAtom();
        Atom nitrogen = source.getNitrogenAtom();
        int i = polymer.monomerCount;
        while (--i >= 0) {
            int[] m;
            Atom targetAlphaPoint;
            double dist2;
            AminoMonomer target;
            Atom oxygen;
            if (polymer == this && (i == indexDonor || i + 1 == indexDonor) || (oxygen = (target = (AminoMonomer)polymer.monomers[i]).getCarbonylOxygenAtom()) == null || bsB != null && !bsB.get(oxygen.i) || (dist2 = sourceAlphaPoint.distanceSquared(targetAlphaPoint = target.getLeadAtom())) >= 81.0) continue;
            int energy = this.calcHbondEnergy(sourceNitrogenPoint, hydrogenPoint, target, checkDistances);
            if (energy < min[0][2]) {
                m = min[1];
                min[1] = min[0];
                min[0] = m;
            } else {
                if (energy >= min[1][2]) continue;
                m = min[1];
            }
            m[0] = polymer.bioPolymerIndexInModel;
            m[1] = energy < -500 ? i : -1 - i;
            m[2] = energy;
        }
        if (vHBonds != null) {
            for (i = 0; i < 2; ++i) {
                if (min[i][1] < 0) continue;
                this.addResidueHydrogenBond(nitrogen, ((AminoMonomer)((AminoPolymer)polymer).monomers[min[i][1]]).getCarbonylOxygenAtom(), polymer == this ? indexDonor : -99, min[i][1], (double)min[i][2] / 1000.0, vHBonds);
            }
        }
    }

    private int calcHbondEnergy(P3d nitrogenPoint, P3d hydrogenPoint, AminoMonomer target, boolean checkDistances) {
        double distON;
        double distCN;
        double distCH;
        Atom targetOxygenPoint = target.getCarbonylOxygenAtom();
        if (targetOxygenPoint == null) {
            return 0;
        }
        double distON2 = targetOxygenPoint.distanceSquared(nitrogenPoint);
        if (distON2 < 0.25) {
            return 0;
        }
        double distOH2 = targetOxygenPoint.distanceSquared(hydrogenPoint);
        if (distOH2 < 0.25) {
            return 0;
        }
        Atom targetCarbonPoint = target.getCarbonylCarbonAtom();
        double distCH2 = targetCarbonPoint.distanceSquared(hydrogenPoint);
        if (distCH2 < 0.25) {
            return 0;
        }
        double distCN2 = targetCarbonPoint.distanceSquared(nitrogenPoint);
        if (distCN2 < 0.25) {
            return 0;
        }
        double distOH = Math.sqrt(distOH2);
        int energy = HBond.calcEnergy(distOH, distCH = Math.sqrt(distCH2), distCN = Math.sqrt(distCN2), distON = Math.sqrt(distON2));
        boolean isHbond = energy < -500 && (!checkDistances || distCN > distCH && distOH <= 3.0);
        return !isHbond && checkDistances || energy < -9900 ? 0 : energy;
    }

    private void addResidueHydrogenBond(Atom nitrogen, Atom oxygen, int indexAminoGroup, int indexCarbonylGroup, double energy, Lst<Bond> vHBonds) {
        int order;
        switch (indexAminoGroup - indexCarbonylGroup) {
            case 2: {
                order = 6144;
                break;
            }
            case 3: {
                order = 8192;
                break;
            }
            case 4: {
                order = 10240;
                break;
            }
            case 5: {
                order = 12288;
                break;
            }
            case -3: {
                order = 14336;
                break;
            }
            case -4: {
                order = 16384;
                break;
            }
            default: {
                order = 4096;
            }
        }
        vHBonds.addLast(new HBond(nitrogen, oxygen, order, 1, 0, energy));
    }

    @Override
    public void calculateStructures(boolean alphaOnly) {
        int start;
        if (alphaOnly) {
            return;
        }
        if (this.structureList == null) {
            this.structureList = this.model.ms.getStructureList();
        }
        char[] structureTags = new char[this.monomerCount];
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            AminoMonomer leadingResidue = (AminoMonomer)this.monomers[i];
            AminoMonomer trailingResidue = (AminoMonomer)this.monomers[i + 1];
            double phi = trailingResidue.getGroupParameter(1111490569);
            double psi = leadingResidue.getGroupParameter(1111490570);
            structureTags[i] = this.isHelix(psi, phi) ? (phi < 0.0 && psi < 25.0 ? 52 : 51) : (this.isSheet(psi, phi) ? 115 : (this.isTurn(psi, phi) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug(0 + this.monomers[0].chain.chainID + " aminopolymer:" + i + " " + trailingResidue.getGroupParameter(1111490569) + "," + leadingResidue.getGroupParameter(1111490570) + " " + structureTags[i]);
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '4') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '4'; ++end) {
            }
            if (--end >= start + 3) {
                this.addStructureProtected(STR.HELIX, null, null, 0, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != '3') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == '3'; ++end) {
            }
            if (--end >= start + 3) {
                this.addStructureProtected(STR.HELIX, null, null, 0, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 's') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 's'; ++end) {
            }
            if (--end >= start + 2) {
                this.addStructureProtected(STR.SHEET, null, null, 0, start, end);
            }
            start = end;
        }
        for (start = 0; start < this.monomerCount; ++start) {
            int end;
            if (structureTags[start] != 't') continue;
            for (end = start + 1; end < this.monomerCount && structureTags[end] == 't'; ++end) {
            }
            if (--end >= start + 2) {
                this.addStructureProtected(STR.TURN, null, null, 0, start, end);
            }
            start = end;
        }
    }

    private boolean isTurn(double psi, double phi) {
        return AminoPolymer.checkPhiPsi(this.structureList.get((Object)STR.TURN), psi, phi);
    }

    private boolean isSheet(double psi, double phi) {
        return AminoPolymer.checkPhiPsi(this.structureList.get((Object)STR.SHEET), psi, phi);
    }

    private boolean isHelix(double psi, double phi) {
        return AminoPolymer.checkPhiPsi(this.structureList.get((Object)STR.HELIX), psi, phi);
    }

    private static boolean checkPhiPsi(double[] list, double psi, double phi) {
        for (int i = 0; i < list.length; i += 4) {
            if (!(phi >= list[i]) || !(phi <= list[i + 1]) || !(psi >= list[i + 2]) || !(psi <= list[i + 3])) continue;
            return true;
        }
        return false;
    }

    public void setStructureList(Map<STR, double[]> structureList) {
        this.structureList = structureList;
    }
}

