/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Map;
import javajs.util.A4d;
import javajs.util.Lst;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Measurement {
    public ModelSet ms;
    public String thisID;
    public int index;
    public boolean isVisible = true;
    public boolean isHidden = false;
    public boolean isTrajectory = false;
    public boolean isValid = true;
    public short colix;
    public short labelColix = (short)-1;
    public int mad;
    public TickInfo tickInfo;
    public int traceX = Integer.MIN_VALUE;
    public int traceY;
    public int count;
    public int[] countPlusIndices = new int[5];
    public Point3fi[] pts;
    public double value;
    public String property;
    public String strFormat;
    public String units;
    public Text text;
    private Viewer vwr;
    private String strMeasurement;
    private String type;
    private boolean tainted;
    public A4d renderAxis;
    public P3d renderArc;
    private String newUnits;
    public double fixedValue = Double.NaN;
    private boolean isPending;
    public boolean inFront;
    private boolean useDefaultLabel;
    public static final int NMR_NOT = 0;
    public static final int NMR_DC = 1;
    public static final int NMR_JC = 2;
    public static final int NMR_NOE_OR_J = 3;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTainted() {
        if (!this.tainted) return false;
        this.tainted = false;
        if (false) return false;
        return true;
    }

    public Measurement setM(ModelSet modelSet, Measurement m, double value, short colix, String strFormat, int index) {
        this.ms = modelSet;
        this.index = index;
        this.vwr = modelSet.vwr;
        this.colix = colix;
        this.strFormat = strFormat;
        if (m != null) {
            this.tickInfo = m.tickInfo;
            this.pts = m.pts;
            this.mad = m.mad;
            this.thisID = m.thisID;
            this.text = m.text;
            this.property = m.property;
            this.units = m.units;
            if (this.property == null && "+hz".equals(this.units)) {
                this.property = "property_J";
            }
            if (this.thisID != null && this.text != null) {
                this.labelColix = this.text.colix;
            }
        }
        if (this.pts == null) {
            this.pts = new Point3fi[4];
        }
        int[] indices = m == null ? null : m.countPlusIndices;
        int n = this.count = indices == null ? 0 : indices[0];
        if (this.count > 0) {
            System.arraycopy(indices, 0, this.countPlusIndices, 0, this.count + 1);
            this.isTrajectory = modelSet.isTrajectoryMeasurement(this.countPlusIndices);
        }
        this.isPending = Double.isNaN(value);
        this.value = this.isPending || this.isTrajectory ? this.getMeasurement(null) : value;
        this.formatMeasurement(null);
        return this;
    }

    public Measurement setPoints(ModelSet modelSet, int[] indices, Point3fi[] points, TickInfo tickInfo) {
        this.ms = modelSet;
        this.countPlusIndices = indices;
        this.count = indices[0];
        this.pts = points == null ? new Point3fi[4] : points;
        this.vwr = modelSet.vwr;
        this.tickInfo = tickInfo;
        return this;
    }

    public void setCount(int count) {
        this.setCountM(count);
    }

    protected void setCountM(int count) {
        this.count = this.countPlusIndices[0] = count;
    }

    public int getAtomIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public Point3fi getAtom(int n) {
        int pt = this.countPlusIndices[n];
        return pt < -1 ? this.pts[-2 - pt] : this.ms.at[pt];
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String toString() {
        return this.getString();
    }

    String getStringUsing(Viewer vwr, String strFormat, String units) {
        this.vwr = vwr;
        this.value = this.getMeasurement(null);
        this.formatMeasurementAs(strFormat, units, true);
        if (strFormat == null) {
            return this.getInfoAsString(units);
        }
        return this.strMeasurement;
    }

    public String getStringDetail() {
        return (this.count == 2 ? "Distance" : (this.count == 3 ? "Angle" : "Torsion")) + this.getMeasurementScript(" - ", false) + " : " + this.value;
    }

    public void refresh(Point3fi[] pts) {
        this.value = this.getMeasurement(pts);
        this.isTrajectory = this.ms.isTrajectoryMeasurement(this.countPlusIndices);
        this.formatMeasurement(null);
    }

    public String getMeasurementScript(String sep, boolean withModelIndex) {
        SB sb = new SB();
        boolean asBitSet = sep.equals(" ");
        for (int i = 1; i <= this.count; ++i) {
            sb.append(i > 1 ? sep : " ").append(this.getLabel(i, asBitSet, withModelIndex));
        }
        return sb.toString();
    }

    public void formatMeasurementAs(String strFormat, String units, boolean useDefault) {
        if (strFormat != null && strFormat.length() == 0) {
            strFormat = null;
        }
        if (!useDefault && strFormat != null && strFormat.indexOf(this.countPlusIndices[0] + ":") != 0) {
            return;
        }
        this.strFormat = strFormat;
        this.formatMeasurement(units);
    }

    public void formatMeasurement(String units) {
        this.tainted = true;
        switch (Double.isNaN(this.value) ? 0 : this.count) {
            default: {
                this.strMeasurement = null;
                return;
            }
            case 2: {
                this.strMeasurement = this.formatDistance(units);
                return;
            }
            case 3: 
            case 4: 
        }
        this.strMeasurement = this.formatAngle(this.value);
    }

    public void reformatDistanceIfSelected(boolean isDefault) {
        if (this.count == 2 && this.vwr.slm.isSelected(this.countPlusIndices[1]) && this.vwr.slm.isSelected(this.countPlusIndices[2])) {
            int pt;
            if (this.useDefaultLabel && this.strFormat != null && (pt = this.strFormat.indexOf("//")) >= 0) {
                this.strFormat = this.strFormat.substring(0, pt);
            }
            if (isDefault) {
                this.units = null;
            }
            this.formatMeasurement(null);
        }
    }

    private String formatDistance(String units) {
        String label = this.getLabelString();
        if (label == null) {
            return "";
        }
        int pt = this.strFormat.indexOf("//");
        if (units == null && (units = this.units) == null) {
            String string = pt >= 0 ? this.strFormat.substring(pt + 2) : (units = this.property == null ? this.vwr.g.measureDistanceUnits : "");
        }
        if (pt >= 0) {
            this.strFormat = this.strFormat.substring(0, pt);
        }
        this.strFormat = this.strFormat + "//" + units;
        units = Measurement.fixUnits(units);
        pt = label.indexOf("//");
        if (pt >= 0 && (label = label.substring(0, pt)).length() == 0) {
            label = "%VALUE";
        }
        double f = this.fixValue(units, label.indexOf("%V") >= 0);
        return this.formatString(f, this.newUnits, label);
    }

    public double fixValue(String units, boolean andRound) {
        this.checkJ(units);
        if (units != null && units.startsWith("+")) {
            if (!this.isPending) {
                this.value = Math.abs(this.value);
            }
            units = units.substring(1);
        }
        this.newUnits = units;
        if (this.count != 2) {
            return this.value;
        }
        double dist = this.value;
        if (units == null && this.property != null) {
            units = "";
        }
        if (units != null) {
            boolean isPercent = units.equals("%");
            if (this.property == null && (isPercent || units.endsWith("hz"))) {
                int i1 = this.getAtomIndex(1);
                int i2 = this.getAtomIndex(2);
                if (i1 >= 0 && i2 >= 0) {
                    boolean isDC;
                    Atom a1 = (Atom)this.getAtom(1);
                    Atom a2 = (Atom)this.getAtom(2);
                    int itype = Measurement.nmrType(units);
                    boolean bl = isDC = !isPercent && itype == 1;
                    String string = isPercent ? "percent" : (isDC ? "dipoleCouplingConstant" : (this.type = itype == 3 ? "NOE or 3JHH" : "J-CouplingConstant"));
                    if (itype == 3) {
                        double[] result = this.vwr.getNMRCalculation().getNOEorJHH(new Atom[]{a1, null, null, a2}, 11);
                        if (result == null) {
                            dist = Double.NaN;
                            units = "";
                            this.newUnits = "";
                        } else {
                            dist = result[1];
                            this.newUnits = result.length == 2 ? "noe" : "hz";
                            units = this.newUnits;
                        }
                    } else {
                        dist = isPercent ? dist / (a1.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO) + a2.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO)) : (isDC ? this.vwr.getNMRCalculation().getDipolarConstantHz(a1, a2) : this.vwr.getNMRCalculation().getIsoOrAnisoHz(true, a1, a2, units, null));
                    }
                    boolean bl2 = this.isValid = !Double.isNaN(dist);
                    if (isPercent) {
                        units = "pm";
                    }
                }
            }
            return Measurement.toUnits(dist, units, andRound);
        }
        return andRound ? (double)Math.round(dist * 100.0) / 100.0 : dist;
    }

    private void checkJ(String units) {
        if (this.property != null || units != null || this.units != null) {
            return;
        }
        units = this.vwr.g.measureDistanceUnits;
        if ("+hz".equals(units)) {
            this.property = "property_J";
            this.units = units;
        }
    }

    public static int nmrType(String units) {
        return units.indexOf("hz") < 0 ? 0 : (units.equals("noe_hz") ? 3 : (units.startsWith("dc_") || units.equals("khz") ? 1 : 2));
    }

    private String formatAngle(double angle) {
        String label = this.getLabelString();
        if (label.indexOf("%V") >= 0) {
            angle = (double)((int)Math.round(angle * 10.0)) / 10.0;
        }
        return this.formatString(angle, "\u00b0", label);
    }

    private String getLabelString() {
        int atomCount = this.countPlusIndices[0];
        String s = atomCount + ":";
        String label = null;
        if (this.strFormat != null) {
            if (this.strFormat.length() == 0) {
                return null;
            }
            label = this.strFormat.length() > 2 && this.strFormat.indexOf(s) == 0 ? this.strFormat : null;
        }
        this.useDefaultLabel = false;
        if (label == null) {
            this.strFormat = null;
            label = this.vwr.getDefaultMeasurementLabel(this.countPlusIndices[0]);
            boolean bl = this.useDefaultLabel = this.units == null;
        }
        if (label.indexOf(s) == 0) {
            label = label.substring(2);
        }
        if (this.strFormat == null) {
            this.strFormat = s + label;
        }
        return label;
    }

    private String formatString(double value, String units, String label) {
        return LabelToken.formatLabelMeasure(this.vwr, this, label, value, units);
    }

    public boolean sameAsPoints(int[] indices, Point3fi[] points) {
        int i;
        if (this.count != indices[0]) {
            return false;
        }
        boolean isSame = true;
        for (i = 1; i <= this.count && isSame; ++i) {
            isSame = this.countPlusIndices[i] == indices[i];
        }
        if (isSame) {
            for (i = 0; i < this.count && isSame; ++i) {
                if (points[i] == null) continue;
                isSame = this.pts[i].distance(points[i]) < 0.01;
            }
        }
        if (isSame) {
            return true;
        }
        switch (this.count) {
            default: {
                return true;
            }
            case 2: {
                return this.sameAsIJ(indices, points, 1, 2) && this.sameAsIJ(indices, points, 2, 1);
            }
            case 3: {
                return this.sameAsIJ(indices, points, 1, 3) && this.sameAsIJ(indices, points, 2, 2) && this.sameAsIJ(indices, points, 3, 1);
            }
            case 4: 
        }
        return this.sameAsIJ(indices, points, 1, 4) && this.sameAsIJ(indices, points, 2, 3) && this.sameAsIJ(indices, points, 3, 2) && this.sameAsIJ(indices, points, 4, 1);
    }

    private boolean sameAsIJ(int[] atoms, Point3fi[] points, int i, int j) {
        int ipt = this.countPlusIndices[i];
        int jpt = atoms[j];
        return ipt >= 0 || jpt >= 0 ? ipt == jpt : this.pts[-2 - ipt].distance(points[-2 - jpt]) < 0.01;
    }

    public boolean sameAs(int i, int j) {
        return this.sameAsIJ(this.countPlusIndices, this.pts, i, j);
    }

    public double getPropMeasurement(Point3fi[] pts) {
        if (this.countPlusIndices == null || this.count != 2) {
            return Double.NaN;
        }
        int i = this.count;
        while (--i >= 0) {
            if (this.countPlusIndices[i + 1] >= 0) continue;
            return Double.NaN;
        }
        try {
            Atom ptA = (Atom)(pts == null ? this.getAtom(1) : pts[0]);
            Atom ptB = (Atom)(pts == null ? this.getAtom(2) : pts[1]);
            double[][] props = (double[][])this.vwr.getDataObj(this.property, null, 2);
            int ia = ptA.i;
            int ib = ptB.i;
            return props == null || ib >= props.length || ia >= props.length ? Double.NaN : props[ia][ib];
        }
        catch (Throwable t) {
            return Double.NaN;
        }
    }

    public double getMeasurement(Point3fi[] pts) {
        this.checkJ(null);
        if (!Double.isNaN(this.fixedValue)) {
            return this.fixedValue;
        }
        if (this.property != null) {
            return this.getPropMeasurement(pts);
        }
        if (this.countPlusIndices == null) {
            return Double.NaN;
        }
        if (this.count < 2) {
            return Double.NaN;
        }
        int i = this.count;
        while (--i >= 0) {
            if (this.countPlusIndices[i + 1] != -1) continue;
            return Double.NaN;
        }
        Point3fi ptA = pts == null ? this.getAtom(1) : pts[0];
        Point3fi ptB = pts == null ? this.getAtom(2) : pts[1];
        switch (this.count) {
            case 2: {
                return ptA.distance(ptB);
            }
            case 3: {
                Point3fi ptC = pts == null ? this.getAtom(3) : pts[2];
                return MeasureD.computeAngleABC(ptA, ptB, ptC, true);
            }
            case 4: {
                Point3fi ptC = pts == null ? this.getAtom(3) : pts[2];
                Point3fi ptD = pts == null ? this.getAtom(4) : pts[3];
                return MeasureD.computeTorsion(ptA, ptB, ptC, ptD, true);
            }
        }
        return Double.NaN;
    }

    public String getLabel(int i, boolean asBitSet, boolean withModelIndex) {
        int atomIndex = this.countPlusIndices[i];
        return atomIndex < 0 ? (withModelIndex ? "modelIndex " + this.getAtom((int)i).mi + " " : "") + Escape.eP(this.getAtom(i)) : (asBitSet ? "({" + atomIndex + "})" : this.vwr.getAtomInfo(atomIndex));
    }

    public void setModelIndex(short modelIndex) {
        if (this.pts == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.pts[i] == null) continue;
            this.pts[i].mi = modelIndex;
        }
    }

    public boolean isValid() {
        return !(this.sameAs(1, 2) || this.count > 2 && this.sameAs(1, 3) || this.count == 4 && this.sameAs(2, 4));
    }

    public static int find(Lst<Measurement> measurements, Measurement m) {
        int[] indices = m.countPlusIndices;
        Point3fi[] points = m.pts;
        int i = measurements.size();
        while (--i >= 0) {
            if (!((Measurement)measurements.get(i)).sameAsPoints(indices, points)) continue;
            return i;
        }
        return -1;
    }

    public boolean isConnected(Atom[] atoms, int count) {
        int atomIndexLast = -1;
        for (int i = 1; i <= count; ++i) {
            int atomIndex = this.getAtomIndex(i);
            if (atomIndex < 0) continue;
            if (atomIndexLast >= 0 && !atoms[atomIndex].isBonded(atoms[atomIndexLast])) {
                return false;
            }
            atomIndexLast = atomIndex;
        }
        return true;
    }

    public String getInfoAsString(String units) {
        double f = this.fixValue(units, true);
        SB sb = new SB();
        sb.append(this.count == 2 ? (this.property != null ? this.property : (this.type == null ? "distance" : this.type)) : (this.count == 3 ? "angle" : "dihedral"));
        sb.append(" \t").appendD(f);
        sb.append(" \t").append(PT.esc(this.strMeasurement));
        for (int i = 1; i <= this.count; ++i) {
            sb.append(" \t").append(this.getLabel(i, false, false));
        }
        if (this.thisID != null) {
            sb.append(" \t").append(this.thisID);
        }
        return sb.toString();
    }

    public boolean isInRange(RadiusData radiusData, double value) {
        if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
            Atom atom1 = (Atom)this.getAtom(1);
            Atom atom2 = (Atom)this.getAtom(2);
            double d = (atom1.getVanderwaalsRadiusFloat(this.vwr, radiusData.vdwType) + atom2.getVanderwaalsRadiusFloat(this.vwr, radiusData.vdwType)) * radiusData.value;
            return value <= d;
        }
        return radiusData.values[0] == Double.MAX_VALUE || value >= radiusData.values[0] && value <= radiusData.values[1];
    }

    public boolean isIntramolecular(Atom[] atoms, int count) {
        int molecule = -1;
        for (int i = 1; i <= count; ++i) {
            int atomIndex = this.getAtomIndex(i);
            if (atomIndex < 0) continue;
            int m = atoms[atomIndex].getMoleculeNumber(false);
            if (molecule < 0) {
                molecule = m;
                continue;
            }
            if (m == molecule) continue;
            return false;
        }
        return true;
    }

    public boolean isMin(Map<String, Integer> htMin) {
        String n2;
        Atom a1 = (Atom)this.getAtom(1);
        Atom a2 = (Atom)this.getAtom(2);
        int d = (int)(a2.distanceSquared(a1) * 100.0);
        String n1 = a1.getAtomName();
        String key = n1.compareTo(n2 = a2.getAtomName()) < 0 ? n1 + n2 : n2 + n1;
        Integer min = htMin.get(key);
        return min != null && d == min;
    }

    public static boolean isUnits(String s) {
        return PT.isOneOf((s.startsWith("+") ? s.substring(1) : s).toLowerCase(), ";nm;nanometers;pm;picometers;angstroms;angstroms;ang;\u00c5;au;vanderwaals;vdw;%;noe;") || s.indexOf(" ") < 0 && s.endsWith("hz");
    }

    public static double toUnits(double dist, String units, boolean andRound) {
        if (Double.isNaN(dist)) {
            return Double.NaN;
        }
        if (units.equals("hz")) {
            return andRound ? (double)Math.round(dist * 10.0) / 10.0 : dist;
        }
        if (units.equals("nm")) {
            return andRound ? (double)Math.round(dist * 100.0) / 1000.0 : dist / 10.0;
        }
        if (units.equals("pm")) {
            return andRound ? (double)Math.round(dist * 1000.0) / 10.0 : dist * 100.0;
        }
        if (units.equals("au")) {
            return andRound ? (double)Math.round(dist / 0.5291772 * 1000.0) / 1000.0 : dist / 0.5291772;
        }
        if (units.endsWith("khz")) {
            return andRound ? (double)Math.round(dist / 10.0) / 100.0 : dist / 1000.0;
        }
        return andRound ? (double)Math.round(dist * 100.0) / 100.0 : dist;
    }

    public static double fromUnits(double dist, String units) {
        if (units.equals("nm")) {
            return dist * 10.0;
        }
        if (units.equals("pm")) {
            return dist / 100.0;
        }
        if (units.equals("au")) {
            return dist * 0.5291772;
        }
        if (units.equals("\u00c5")) {
            return dist;
        }
        return 0.0;
    }

    public static String fixUnits(String u) {
        String units;
        String string = units = u.endsWith("s") ? u.substring(0, u.length() - 1) : u;
        if (units.equals("nanometer")) {
            return "nm";
        }
        if (units.equals("bohr") || units.equals("atomicunits") || units.equals("atomic")) {
            return "au";
        }
        if (units.equals("picometer")) {
            return "pm";
        }
        if (units.equals("\u00e5") || units.equals("angstrom") || units.equals("a") || units.equals("ang")) {
            return "\u00c5";
        }
        if (units.equals("vanderwaal") || units.equals("vdw")) {
            return "%";
        }
        return u;
    }

    public String getDistanceFormatForState() {
        return this.useDefaultLabel ? null : this.strFormat;
    }

    public void setFromMD(MeasurementData md, boolean andText) {
        if (md.thisID != null) {
            this.thisID = md.thisID;
            if (md.text != null && md.text.text != null) {
                this.text = md.text;
            }
        }
        this.units = "default".equals(md.units) ? null : md.units;
        this.property = md.property;
        this.fixedValue = md.fixedValue;
        if (md.colix != 0) {
            this.colix = md.colix;
        }
        if (md.mad != 0) {
            this.mad = md.mad;
        }
        if (md.strFormat != null) {
            this.strFormat = (this.strFormat == null ? md.strFormat : this.strFormat.substring(0, 2)) + md.strFormat.substring(2);
        }
        if (md.text != null) {
            if (this.text == null) {
                this.text = md.text;
            } else {
                if (md.text.font != null) {
                    this.text.setFont(md.text.font, false);
                    this.text.fontScale = md.text.font.fontSize / md.text.font.fontSizeNominal;
                }
                this.text.text = null;
                if (md.text.align != 0) {
                    this.text.align = md.text.align;
                }
                if (md.colix != 0) {
                    this.labelColix = this.text.colix = md.text.colix;
                }
            }
        }
        this.formatMeasurement(null);
    }
}

