/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.OC;
import javajs.util.P3d;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.calc.MarchingCubes;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.quantum.QuantumPlaneCalculation;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class SurfaceReader
implements VertexDataServer {
    protected SurfaceGenerator sg;
    protected MeshDataServer meshDataServer;
    protected Parameters params;
    protected MeshData meshData;
    protected JvxlData jvxlData;
    VolumeData volumeData;
    private String edgeData;
    protected boolean haveSurfaceAtoms = false;
    protected boolean allowSigma = false;
    protected boolean isProgressive = false;
    protected boolean isXLowToHigh = false;
    private double assocCutoff = 0.3;
    protected boolean isQuiet;
    protected boolean isPeriodic;
    boolean vertexDataOnly;
    boolean hasColorData;
    protected double dataMin = Double.MAX_VALUE;
    protected double dataMax = -1.7976931348623157E308;
    protected double dataMean;
    protected P3d xyzMin;
    protected P3d xyzMax;
    protected P3d center;
    protected double[] anisotropy;
    protected boolean isAnisotropic;
    protected M3d eccentricityMatrix;
    protected M3d eccentricityMatrixInverse;
    protected boolean isEccentric;
    protected double eccentricityScale;
    protected double eccentricityRatio;
    static final double ANGSTROMS_PER_BOHR = 0.529177188873291;
    static final double defaultMappedDataMin = 0.0;
    static final double defaultMappedDataMax = 1.0;
    static final double defaultCutoff = (double)0.02f;
    private int edgeCount;
    protected P3d volumetricOrigin;
    protected V3d[] volumetricVectors;
    protected int[] voxelCounts;
    protected double[][][] voxelData;
    protected long nBytes;
    protected int nDataPoints;
    protected int nPointsX;
    protected int nPointsY;
    protected int nPointsZ;
    protected boolean isJvxl;
    protected int edgeFractionBase;
    protected int edgeFractionRange;
    protected int colorFractionBase;
    protected int colorFractionRange;
    protected SB jvxlFileHeaderBuffer;
    protected SB fractionData;
    protected String jvxlEdgeDataRead = "";
    protected String jvxlColorDataRead = "";
    protected BS jvxlVoxelBitSet;
    protected boolean jvxlDataIsColorMapped;
    protected boolean jvxlDataIsPrecisionColor;
    protected boolean jvxlDataIs2dContour;
    protected boolean jvxlDataIsColorDensity;
    protected double jvxlCutoff;
    protected double[] jvxlCutoffRange;
    protected int jvxlNSurfaceInts;
    protected char cJvxlEdgeNaN = '\u0000';
    protected int contourVertexCount;
    protected MarchingSquares marchingSquares;
    protected MarchingCubes marchingCubes;
    protected double[][] yzPlanes;
    protected int yzCount;
    protected QuantumPlaneCalculation qpc;
    protected final P3d ptTemp = new P3d();
    private static final String[] colorPhases = new String[]{"_orb", "x", "y", "z", "xy", "yz", "xz", "x2-y2", "z2"};
    protected double[] minMax;
    private boolean haveSetAnisotropy;

    SurfaceReader() {
    }

    abstract void init(SurfaceGenerator var1);

    void initSR(SurfaceGenerator sg) {
        this.sg = sg;
        this.params = sg.params;
        this.assocCutoff = this.params.assocCutoff;
        this.isXLowToHigh = this.params.isXLowToHigh;
        this.center = this.params.center;
        this.anisotropy = this.params.anisotropy;
        this.isAnisotropic = this.params.isAnisotropic;
        this.eccentricityMatrix = this.params.eccentricityMatrix;
        this.eccentricityMatrixInverse = this.params.eccentricityMatrixInverse;
        this.isEccentric = this.params.isEccentric;
        this.eccentricityScale = this.params.eccentricityScale;
        this.eccentricityRatio = this.params.eccentricityRatio;
        this.marchingSquares = sg.marchingSquares;
        this.meshData = sg.meshData;
        this.jvxlData = sg.jvxlData;
        this.setVolumeDataV(sg.volumeDataTemp);
        this.meshDataServer = sg.meshDataServer;
        this.cJvxlEdgeNaN = (char)125;
    }

    protected abstract void closeReader();

    protected void setOutputChannel(OC out) {
    }

    protected void newVoxelDataCube() {
        this.voxelData = new double[this.nPointsX][this.nPointsY][this.nPointsZ];
        this.volumeData.setVoxelDataAsArray(this.voxelData);
    }

    protected void setVolumeDataV(VolumeData v) {
        this.nBytes = 0L;
        this.volumetricOrigin = v.volumetricOrigin;
        this.volumetricVectors = v.volumetricVectors;
        this.voxelCounts = v.voxelCounts;
        this.voxelData = v.getVoxelData();
        this.volumeData = v;
    }

    protected abstract boolean readVolumeParameters(boolean var1);

    protected abstract boolean readVolumeData(boolean var1);

    void jvxlUpdateInfo() {
        this.jvxlData.jvxlUpdateInfo(this.params.title, this.nBytes);
    }

    boolean readAndSetVolumeParameters(boolean isMapData) {
        if (!this.readVolumeParameters(isMapData)) {
            return false;
        }
        if (this.vertexDataOnly) {
            return true;
        }
        return this.volumeData.setUnitVectors();
    }

    boolean createIsosurface(boolean justForPlane) {
        this.resetIsosurface();
        if (this.params.showTiming) {
            Logger.startTimer("isosurface creation");
        }
        this.jvxlData.cutoff = Double.NaN;
        this.jvxlData.cutoffRange = null;
        if (!this.readAndSetVolumeParameters(justForPlane)) {
            return false;
        }
        if (!(justForPlane || Double.isNaN(this.params.sigma) || this.allowSigma)) {
            if (this.params.sigma > 0.0) {
                Logger.error("Reader does not support SIGMA option -- using cutoff 1.6");
            }
            this.params.cutoff = 1.6;
        }
        if (this.params.sigma < 0.0) {
            this.params.sigma = -this.params.sigma;
        }
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.jvxlData.isSlabbable = (this.params.dataType & 0x400) != 0;
        this.jvxlData.insideOut = this.params.isInsideOut();
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.nPointsX = this.nPointsX;
        this.jvxlData.nPointsY = this.nPointsY;
        this.jvxlData.nPointsZ = this.nPointsZ;
        this.jvxlData.jvxlVolumeDataXml = this.volumeData.xmlData;
        this.jvxlData.voxelVolume = this.volumeData.voxelVolume;
        if (justForPlane) {
            this.volumeData.setMappingPlane(this.params.thePlane);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
            }
            this.params.setMapRanges(this, false);
            this.generateSurfaceData();
            this.volumeData.setMappingPlane(null);
        } else {
            if (!this.readVolumeData(false)) {
                return false;
            }
            this.generateSurfaceData();
        }
        if (this.jvxlFileHeaderBuffer == null) {
            this.jvxlData.jvxlFileTitle = "";
            this.jvxlData.jvxlFileSource = null;
            this.jvxlData.jvxlFileMessage = null;
        } else {
            String s = this.jvxlFileHeaderBuffer.toString();
            int i = s.indexOf(10, s.indexOf(10, s.indexOf(10) + 1) + 1) + 1;
            this.jvxlData.jvxlFileTitle = s.substring(0, i);
            this.jvxlData.jvxlFileSource = this.params.fileName;
        }
        if (this.params.contactPair == null) {
            this.setBBoxAll();
        }
        boolean bl = this.jvxlData.isValid = this.xyzMin.x != Double.MAX_VALUE;
        if (!this.params.isSilent) {
            if (!this.jvxlData.isValid) {
                Logger.error("no isosurface points were found!");
            } else {
                Logger.info("boundbox corners " + Escape.eP(this.xyzMin) + " " + Escape.eP(this.xyzMax));
            }
        }
        this.jvxlData.boundingBox = new P3d[]{this.xyzMin, this.xyzMax};
        this.jvxlData.dataMin = this.dataMin;
        this.jvxlData.dataMax = this.dataMax;
        double[] dArray = this.jvxlData.cutoffRange = this.isJvxl ? this.jvxlCutoffRange : this.params.cutoffRange;
        this.jvxlData.cutoff = this.jvxlCutoffRange != null ? this.jvxlData.cutoffRange[0] : (this.isJvxl ? this.jvxlCutoff : this.params.cutoff);
        this.jvxlData.isCutoffAbsolute = this.params.isCutoffAbsolute;
        this.jvxlData.isModelConnected = this.params.isModelConnected;
        this.jvxlData.pointsPerAngstrom = 1.0 / this.volumeData.volumetricVectorLengths[0];
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.jvxlPlane = this.params.thePlane;
        this.jvxlData.jvxlEdgeData = this.edgeData;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.isContoured = this.params.isContoured;
        this.jvxlData.colorDensity = this.params.colorDensity;
        this.jvxlData.pointSize = this.params.pointSize;
        if (this.jvxlData.vContours != null) {
            this.params.nContours = this.jvxlData.vContours.length;
        }
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.thisContour = this.params.thisContour;
        this.jvxlData.nEdges = this.edgeCount;
        this.jvxlData.edgeFractionBase = this.edgeFractionBase;
        this.jvxlData.edgeFractionRange = this.edgeFractionRange;
        this.jvxlData.colorFractionBase = this.colorFractionBase;
        this.jvxlData.colorFractionRange = this.colorFractionRange;
        this.jvxlData.jvxlDataIs2dContour = this.jvxlDataIs2dContour;
        this.jvxlData.jvxlDataIsColorMapped = this.jvxlDataIsColorMapped;
        this.jvxlData.jvxlDataIsColorDensity = this.jvxlDataIsColorDensity;
        this.jvxlData.isXLowToHigh = this.isXLowToHigh;
        this.jvxlData.vertexDataOnly = this.vertexDataOnly;
        this.jvxlData.saveVertexCount = 0;
        if (this.jvxlDataIsColorMapped || this.jvxlData.nVertexColors > 0) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
                this.meshDataServer.fillMeshData(this.meshData, 2, null);
            }
            this.jvxlData.jvxlColorData = this.readColorData();
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceMappingCompleted();
            }
        }
        if (this.params.showTiming) {
            Logger.checkTimer("isosurface creation", false);
        }
        return true;
    }

    void resetIsosurface() {
        this.meshData = new MeshData();
        this.xyzMax = null;
        this.xyzMin = null;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(null, 0, null);
        }
        this.contourVertexCount = 0;
        if (this.params.cutoff == Double.MAX_VALUE) {
            this.params.cutoff = 0.02f;
        }
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.edgeCount = 0;
        this.edgeFractionBase = 35;
        this.edgeFractionRange = 90;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.params.mappedDataMin = Double.MAX_VALUE;
    }

    void discardTempData(boolean discardAll) {
        this.discardTempDataSR(discardAll);
    }

    protected void discardTempDataSR(boolean discardAll) {
        if (!discardAll) {
            return;
        }
        this.voxelData = null;
        this.marchingSquares = null;
        this.sg.marchingSquares = null;
        this.marchingCubes = null;
    }

    void initializeVolumetricData() {
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.setVolumeDataV(this.volumeData);
    }

    protected abstract void readSurfaceData(boolean var1) throws Exception;

    protected boolean gotoAndReadVoxelData(boolean isMapData) {
        this.initializeVolumetricData();
        if (this.nPointsX > 0 && this.nPointsY > 0 && this.nPointsZ > 0) {
            try {
                this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
                this.readSurfaceData(isMapData);
            }
            catch (Exception e) {
                Logger.error(e.toString());
                return false;
            }
        }
        return true;
    }

    protected void gotoData(int n, int nPoints) throws Exception {
    }

    protected String readColorData() {
        if (this.jvxlData.vertexColors == null) {
            return "";
        }
        int vertexCount = this.jvxlData.vertexCount;
        short[] colixes = this.meshData.vcs;
        double[] vertexValues = this.meshData.vvs;
        if (colixes == null || colixes.length < vertexCount) {
            this.meshData.vcs = colixes = new short[vertexCount];
        }
        if (vertexValues == null || vertexValues.length < vertexCount) {
            this.meshData.vvs = vertexValues = new double[vertexCount];
        }
        for (int i = 0; i < vertexCount; ++i) {
            colixes[i] = C.getColix(this.jvxlData.vertexColors[i]);
        }
        return "-";
    }

    @Override
    public double[] getPlane(int x) {
        return this.getPlaneSR(x);
    }

    protected double[] getPlaneSR(int x) {
        if (this.yzCount == 0) {
            this.initPlanes();
        }
        if (this.qpc != null) {
            this.qpc.getPlane(x, this.yzPlanes[x % 2]);
        }
        return this.yzPlanes[x % 2];
    }

    void initPlanes() {
        this.yzCount = this.nPointsY * this.nPointsZ;
        if (!this.isQuiet) {
            Logger.info("reading data progressively -- yzCount = " + this.yzCount);
        }
        this.yzPlanes = AU.newDouble2(2);
        this.yzPlanes[0] = new double[this.yzCount];
        this.yzPlanes[1] = new double[this.yzCount];
    }

    @Override
    public double getValue(int x, int y, int z, int ptyz) {
        return this.getValue2(x, y, z, ptyz);
    }

    protected double getValue2(int x, int y, int z, int ptyz) {
        return this.yzPlanes == null ? this.voxelData[x][y][z] : this.yzPlanes[x % 2][ptyz];
    }

    private void generateSurfaceData() {
        this.edgeData = "";
        if (this.vertexDataOnly) {
            try {
                this.readSurfaceData(false);
            }
            catch (Exception e) {
                System.out.println(e.toString());
                Logger.error("Exception in SurfaceReader::readSurfaceData: " + e.toString());
            }
            return;
        }
        this.contourVertexCount = 0;
        int contourType = -1;
        this.marchingSquares = null;
        if (this.params.thePlane != null || this.params.isContoured) {
            this.marchingSquares = new MarchingSquares(this, this.volumeData, this.params.thePlane, this.params.contoursDiscrete, this.params.nContours, this.params.thisContour, this.params.contourFromZero);
            contourType = this.marchingSquares.contourType;
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
        }
        this.params.contourType = contourType;
        this.params.isXLowToHigh = this.isXLowToHigh;
        this.marchingCubes = new MarchingCubes(this, this.volumeData, this.params, this.jvxlVoxelBitSet);
        String data = this.marchingCubes.getEdgeData();
        if (this.params.thePlane == null) {
            this.edgeData = data;
        }
        this.jvxlData.setSurfaceInfoFromBitSetPts(this.marchingCubes.bsVoxels, this.params.thePlane, this.params.mapLattice);
        this.jvxlData.jvxlExcluded = this.params.bsExcluded;
        if (this.isJvxl) {
            this.edgeData = this.jvxlEdgeDataRead;
        }
        this.postProcessVertices();
    }

    protected void postProcessVertices() {
    }

    @Override
    public int getSurfacePointIndexAndFraction(double cutoff, boolean isCutoffAbsolute, int x, int y, int z, P3i offset, int vA, int vB, double valueA, double valueB, T3d pointA, V3d edgeVector, boolean isContourType, double[] fReturn) {
        int n;
        int assocVertex;
        double thisValue = this.getSurfacePointAndFraction(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, this.ptTemp);
        if (this.marchingSquares != null && this.params.isContoured) {
            return this.marchingSquares.addContourVertex(this.ptTemp, cutoff);
        }
        int n2 = this.assocCutoff > 0.0 ? (fReturn[0] < this.assocCutoff ? vA : (fReturn[0] > 1.0 - this.assocCutoff ? vB : -1)) : (assocVertex = -1);
        if (assocVertex >= 0) {
            assocVertex = this.marchingCubes.getLinearOffset(x, y, z, assocVertex);
        }
        if ((n = this.addVertexCopy(this.ptTemp, thisValue, assocVertex, true)) >= 0 && this.params.iAddGridPoints) {
            this.marchingCubes.calcVertexPoint(x, y, z, vB, this.ptTemp);
            this.addVertexCopy(valueA < valueB ? pointA : this.ptTemp, Math.min(valueA, valueB), -3, true);
            this.addVertexCopy(valueA < valueB ? this.ptTemp : pointA, Math.max(valueA, valueB), -3, true);
        }
        return n;
    }

    protected double getSurfacePointAndFraction(double cutoff, boolean isCutoffAbsolute, double valueA, double valueB, T3d pointA, V3d edgeVector, int x, int y, int z, int vA, int vB, double[] fReturn, T3d ptReturn) {
        return this.getSPF(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
    }

    protected double getSPF(double cutoff, boolean isCutoffAbsolute, double valueA, double valueB, T3d pointA, V3d edgeVector, int x, int y, int z, int vA, int vB, double[] fReturn, T3d ptReturn) {
        double diff = valueB - valueA;
        double fraction = (cutoff - valueA) / diff;
        if (isCutoffAbsolute && (fraction < 0.0 || fraction > 1.0)) {
            fraction = (-cutoff - valueA) / diff;
        }
        if (fraction < 0.0 || fraction > 1.0) {
            fraction = Double.NaN;
        }
        fReturn[0] = fraction;
        ptReturn.scaleAdd2(fraction, edgeVector, pointA);
        return valueA + fraction * diff;
    }

    @Override
    public int addVertexCopy(T3d vertexXYZ, double value, int assocVertex, boolean asCopy) {
        return this.addVC(vertexXYZ, value, assocVertex, asCopy);
    }

    protected int addVC(T3d vertexXYZ, double value, int assocVertex, boolean asCopy) {
        return Double.isNaN(value) && assocVertex != -3 ? -1 : (this.meshDataServer == null ? this.meshData.addVertexCopy(vertexXYZ, value, assocVertex, asCopy) : this.meshDataServer.addVertexCopy(vertexXYZ, value, assocVertex, asCopy));
    }

    @Override
    public int addTriangleCheck(int iA, int iB, int iC, int check, int iContour, boolean isAbsolute, int color) {
        if (this.marchingSquares != null && this.params.isContoured) {
            if (color == 0) {
                return this.marchingSquares.addTriangle(iA, iB, iC, check, iContour);
            }
            color = 0;
        }
        return this.meshDataServer != null ? this.meshDataServer.addTriangleCheck(iA, iB, iC, check, iContour, isAbsolute, color) : (isAbsolute && !MeshData.checkCutoff(iA, iB, iC, this.meshData.vvs) ? -1 : this.meshData.addTriangleCheck(iA, iB, iC, check, iContour, color));
    }

    void colorIsosurface() {
        if (this.params.isSquared && this.volumeData != null) {
            this.volumeData.filterData(true, Double.NaN);
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.jvxlData.saveVertexCount = 0;
        if (this.params.isContoured && this.marchingSquares != null) {
            this.initializeMapping();
            this.params.setMapRanges(this, false);
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
            this.jvxlData.saveVertexCount = this.marchingSquares.contourVertexCount;
            this.contourVertexCount = this.marchingSquares.generateContourData(this.jvxlDataIs2dContour, this.params.isSquared ? 1.0E-8 : 1.0E-4);
            this.jvxlData.contourValuesUsed = this.marchingSquares.contourValuesUsed;
            this.minMax = this.marchingSquares.getMinMax();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            this.finalizeMapping();
        }
        this.applyColorScale();
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.thisContour = this.params.thisContour;
        this.jvxlData.jvxlFileMessage = "mapped: min = " + this.params.valueMappedToRed + "; max = " + this.params.valueMappedToBlue;
    }

    void applyColorScale() {
        boolean useMeshDataValues;
        boolean saveColorData;
        this.jvxlData.colorFractionBase = 35;
        this.colorFractionBase = 35;
        this.jvxlData.colorFractionRange = 90;
        this.colorFractionRange = 90;
        if (this.params.colorPhase == 0) {
            this.params.colorPhase = 1;
        }
        if (this.meshDataServer == null) {
            this.meshData.vcs = new short[this.meshData.vc];
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
            if (this.params.contactPair == null) {
                this.meshDataServer.fillMeshData(this.meshData, 2, null);
            }
        }
        boolean bl = saveColorData = this.params.colorDensity || this.params.isBicolorMap || this.params.colorBySign || !this.params.colorByPhase;
        if (this.params.contactPair != null) {
            saveColorData = false;
        }
        this.jvxlData.isJvxlPrecisionColor = true;
        this.jvxlData.vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vc;
        this.jvxlData.minColorIndex = (short)-1;
        this.jvxlData.maxColorIndex = 0;
        this.jvxlData.contourValues = this.params.contoursDiscrete;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (!this.params.colorDensity && (this.params.isBicolorMap && !this.params.isContoured || this.params.colorBySign)) {
            this.jvxlData.minColorIndex = C.getColixTranslucent3(C.getColix(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg), this.jvxlData.translucency != 0.0, this.jvxlData.translucency);
            this.jvxlData.maxColorIndex = C.getColixTranslucent3(C.getColix(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos), this.jvxlData.translucency != 0.0, this.jvxlData.translucency);
        }
        this.jvxlData.isTruncated = this.jvxlData.minColorIndex >= 0 && !this.params.isContoured;
        boolean bl2 = useMeshDataValues = this.jvxlDataIs2dContour || this.hasColorData || this.vertexDataOnly || this.params.colorDensity || this.params.isBicolorMap && !this.params.isContoured;
        if (!useMeshDataValues) {
            if (this.haveSurfaceAtoms && this.meshData.vertexSource == null) {
                this.meshData.vertexSource = new int[this.meshData.vc];
            }
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            this.initializeMapping();
            int i = this.meshData.vc;
            while (--i >= this.meshData.mergeVertexCount0) {
                double value;
                if (this.params.colorBySets) {
                    value = this.meshData.vertexSets[i];
                } else if (this.params.colorByPhase) {
                    value = this.getPhase(this.meshData.vs[i]);
                } else {
                    boolean needSource = this.haveSurfaceAtoms;
                    value = this.volumeData.lookupInterpolatedVoxelValue(this.meshData.vs[i], needSource);
                    if (needSource) {
                        this.meshData.vertexSource[i] = this.getSurfaceAtomIndex();
                    }
                }
                if (value < min) {
                    min = value;
                }
                if (value > max && value != Double.MAX_VALUE) {
                    max = value;
                }
                this.meshData.vvs[i] = value;
            }
            if (this.params.rangeSelected && this.minMax == null) {
                this.minMax = new double[]{min, max};
            }
            this.finalizeMapping();
        }
        this.params.setMapRanges(this, true);
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        if (this.params.contactPair == null && this.jvxlData.vertexColors == null) {
            this.colorData();
        }
        JvxlCoder.jvxlCreateColorData(this.jvxlData, saveColorData ? this.meshData.vvs : null);
        if (this.haveSurfaceAtoms && this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 4, null);
        }
        if (this.meshDataServer != null && this.params.colorBySets) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    private void colorData() {
        double[] vertexValues = this.meshData.vvs;
        short[] vertexColixes = this.meshData.vcs;
        this.meshData.pcs = null;
        double valueBlue = this.jvxlData.valueMappedToBlue;
        double valueRed = this.jvxlData.valueMappedToRed;
        short minColorIndex = this.jvxlData.minColorIndex;
        short maxColorIndex = this.jvxlData.maxColorIndex;
        if (this.params.colorEncoder == null) {
            this.params.colorEncoder = new ColorEncoder(null, null);
        }
        this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
        int i = this.meshData.vc;
        while (--i >= 0) {
            double value = vertexValues[i];
            if (minColorIndex >= 0) {
                if (value <= 0.0) {
                    vertexColixes[i] = minColorIndex;
                    continue;
                }
                if (!(value > 0.0)) continue;
                vertexColixes[i] = maxColorIndex;
                continue;
            }
            if (value <= valueRed) {
                value = valueRed;
            }
            if (value >= valueBlue) {
                value = valueBlue;
            }
            vertexColixes[i] = this.params.colorEncoder.getColorIndex(value);
        }
        if ((this.params.nContours > 0 || this.jvxlData.contourValues != null) && this.jvxlData.contourColixes == null) {
            int n = this.jvxlData.contourValues == null ? this.params.nContours : this.jvxlData.contourValues.length;
            this.jvxlData.contourColixes = new short[n];
            short[] colors = this.jvxlData.contourColixes;
            double[] values = this.jvxlData.contourValues;
            if (values == null) {
                values = this.jvxlData.contourValuesUsed;
            }
            if (this.jvxlData.contourValuesUsed == null) {
                this.jvxlData.contourValuesUsed = values == null ? new double[n] : values;
            }
            double dv = (valueBlue - valueRed) / (double)(n + 1);
            this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
            for (int i2 = 0; i2 < n; ++i2) {
                double v;
                this.jvxlData.contourValuesUsed[i2] = v = values == null ? valueRed + (double)(i2 + 1) * dv : values[i2];
                colors[i2] = C.getColixTranslucent(this.params.colorEncoder.getArgb(v));
            }
            this.jvxlData.contourColors = C.getHexCodes(colors);
        }
    }

    static int getColorPhaseIndex(String color) {
        int colorPhase = -1;
        for (int i = 0; i < colorPhases.length; ++i) {
            if (!color.equalsIgnoreCase(colorPhases[i])) continue;
            colorPhase = i;
            break;
        }
        return colorPhase;
    }

    private double getPhase(T3d pt) {
        switch (this.params.colorPhase) {
            case -1: 
            case 0: 
            case 1: {
                return pt.x > 0.0 ? 1 : -1;
            }
            case 2: {
                return pt.y > 0.0 ? 1 : -1;
            }
            case 3: {
                return pt.z > 0.0 ? 1 : -1;
            }
            case 4: {
                return pt.x * pt.y > 0.0 ? 1 : -1;
            }
            case 5: {
                return pt.y * pt.z > 0.0 ? 1 : -1;
            }
            case 6: {
                return pt.x * pt.z > 0.0 ? 1 : -1;
            }
            case 7: {
                return pt.x * pt.x - pt.y * pt.y > 0.0 ? 1 : -1;
            }
            case 8: {
                return pt.z * pt.z * 2.0 - pt.x * pt.x - pt.y * pt.y > 0.0 ? 1 : -1;
            }
        }
        return 1.0;
    }

    public double[] getMinMaxMappedValues(boolean haveData) {
        if (this.minMax != null && this.minMax[0] != Double.MAX_VALUE) {
            return this.minMax;
        }
        if (this.params.colorBySets) {
            this.minMax = new double[]{0.0, Math.max(this.meshData.nSets - 1, 0)};
            return this.minMax;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (this.params.usePropertyForColorRange && this.params.theProperty != null) {
            int i = this.params.theProperty.length;
            while (--i >= 0) {
                double p;
                if (this.params.rangeSelected && !this.params.bsSelected.get(i) || Double.isNaN(p = this.params.theProperty[i])) continue;
                if (p < min) {
                    min = p;
                }
                if (!(p > max)) continue;
                max = p;
            }
            this.minMax = new double[]{min, max};
            return this.minMax;
        }
        int vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vc;
        T3d[] vertexes = this.meshData.vs;
        boolean useVertexValue = haveData || this.jvxlDataIs2dContour || this.vertexDataOnly || this.params.colorDensity;
        for (int i = this.meshData.mergeVertexCount0; i < vertexCount; ++i) {
            double v = useVertexValue ? this.meshData.vvs[i] : this.volumeData.lookupInterpolatedVoxelValue(vertexes[i], false);
            if (v < min) {
                min = v;
            }
            if (!(v > max) || v == Double.MAX_VALUE) continue;
            max = v;
        }
        this.minMax = new double[]{min, max};
        return this.minMax;
    }

    void updateTriangles() {
        if (this.meshDataServer == null) {
            this.meshData.invalidatePolygons();
        } else {
            this.meshDataServer.invalidateTriangles();
        }
    }

    void updateSurfaceData() {
        this.meshData.setVertexSets(true);
        this.updateTriangles();
        if (this.params.bsExcluded[1] == null) {
            this.params.bsExcluded[1] = new BS();
        }
        this.meshData.updateInvalidatedVertices(this.params.bsExcluded[1]);
    }

    public void selectPocket(boolean doExclude) {
    }

    void excludeMinimumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int i = this.meshData.nSets;
        while (--i >= 0) {
            BS bs = this.meshData.surfaceSet[i];
            if (bs == null || bs.cardinality() >= this.params.minSet) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    void excludeMaximumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int i = this.meshData.nSets;
        while (--i >= 0) {
            BS bs = this.meshData.surfaceSet[i];
            if (bs == null || bs.cardinality() <= this.params.maxSet) continue;
            this.meshData.invalidateSurfaceSet(i);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    public void slabIsosurface(Lst<Object[]> slabInfo) {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.slabPolygonsList(slabInfo, true);
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 4, null);
        }
    }

    protected void setVertexAnisotropy(T3d pt) {
        pt.x *= this.anisotropy[0];
        pt.y *= this.anisotropy[1];
        pt.z *= this.anisotropy[2];
        pt.add(this.center);
    }

    protected void setVectorAnisotropy(T3d v) {
        this.haveSetAnisotropy = true;
        v.x *= this.anisotropy[0];
        v.y *= this.anisotropy[1];
        v.z *= this.anisotropy[2];
    }

    protected void setVolumetricAnisotropy() {
        if (this.haveSetAnisotropy) {
            return;
        }
        this.setVolumetricOriginAnisotropy();
        this.setVectorAnisotropy(this.volumetricVectors[0]);
        this.setVectorAnisotropy(this.volumetricVectors[1]);
        this.setVectorAnisotropy(this.volumetricVectors[2]);
    }

    protected void setVolumetricOriginAnisotropy() {
        this.volumetricOrigin.setT(this.center);
    }

    private void setBBoxAll() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.xyzMin = new P3d();
        this.xyzMax = new P3d();
        this.meshData.setBox(this.xyzMin, this.xyzMax);
    }

    protected void setBBox(T3d pt, double margin) {
        if (this.xyzMin == null) {
            this.xyzMin = P3d.new3(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
            this.xyzMax = P3d.new3(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        }
        BoxInfo.addPoint(pt, this.xyzMin, this.xyzMax, margin);
    }

    public double getValueAtPoint(T3d pt, boolean getSource) {
        return 0.0;
    }

    void initializeMapping() {
    }

    protected void finalizeMapping() {
    }

    public int getSurfaceAtomIndex() {
        return -1;
    }
}

