/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import javajs.api.GenericBinaryDocument;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.api.Interface;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.viewer.Viewer;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected GenericBinaryDocument binarydoc;
    protected OC out;
    protected String line;
    protected int[] next = new int[1];

    SurfaceFileReader() {
    }

    protected void setStream(String fileName, boolean isBigEndian) {
        if (fileName == null) {
            this.binarydoc.setStream(null, isBigEndian);
        } else {
            try {
                if (this.br instanceof Rdr.StreamReader) {
                    BufferedInputStream stream = ((Rdr.StreamReader)this.br).getStream();
                    stream.reset();
                    this.binarydoc.setStream(stream, true);
                }
            }
            catch (Exception e) {
                System.out.println("BCifDensityReader " + e);
                this.binarydoc.setStream(this.sg.atomDataServer.getBufferedInputStream(fileName), isBigEndian);
            }
        }
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initSR(sg);
    }

    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2SFR(sg, br);
    }

    void init2SFR(SurfaceGenerator sg, BufferedReader br) {
        this.br = br;
        this.init(sg);
    }

    GenericBinaryDocument newBinaryDocument() {
        return (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", (Viewer)this.sg.atomDataServer, "file");
    }

    @Override
    protected void setOutputChannel(OC out) {
        if (this.binarydoc == null) {
            this.out = out;
        } else {
            this.sg.setOutputChannel(this.binarydoc, out);
        }
    }

    @Override
    protected void closeReader() {
        this.closeReaderSFR();
    }

    protected void closeReaderSFR() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
        if (this.binarydoc != null) {
            this.binarydoc.close();
        }
    }

    @Override
    void discardTempData(boolean discardAll) {
        this.closeReader();
        this.discardTempDataSR(discardAll);
    }

    protected String[] getTokens() {
        return PT.getTokensAt(this.line, 0);
    }

    protected double parseDouble() {
        return PT.parseDoubleNext(this.line, this.next);
    }

    protected double parseDoubleStr(String s) {
        this.next[0] = 0;
        return PT.parseDoubleNext(s, this.next);
    }

    protected double parseDoubleRange(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return PT.parseDoubleRange(s, iEnd, this.next);
    }

    protected int parseInt() {
        return PT.parseIntNext(this.line, this.next);
    }

    protected int parseIntStr(String s) {
        this.next[0] = 0;
        return PT.parseIntNext(s, this.next);
    }

    protected int parseIntNext(String s) {
        return PT.parseIntNext(s, this.next);
    }

    protected double[] parseDoubleArrayStr(String s) {
        this.next[0] = 0;
        return PT.parseDoubleArrayNext(s, this.next, null, null, null);
    }

    protected double[] parseDoubleArray(double[] a, String strStart, String strEnd) {
        return PT.parseDoubleArrayNext(this.line, this.next, a, strStart, strEnd);
    }

    protected String getQuotedStringNext() {
        return PT.getQuotedStringNext(this.line, this.next);
    }

    protected void skipTo(String info, String what) throws Exception {
        if (info != null) {
            while (this.rd().indexOf(info) < 0) {
            }
        }
        if (what != null) {
            this.next[0] = this.line.indexOf(what) + what.length() + 2;
        }
    }

    protected String rd() throws Exception {
        this.line = this.br.readLine();
        if (this.line != null) {
            this.nBytes += (long)this.line.length();
            if (this.out != null) {
                byte[] b = this.line.getBytes();
                this.out.write(b, 0, b.length);
                this.out.writeByteAsInt(10);
            }
        }
        return this.line;
    }
}

