/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Random;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;

final class IsoShapeReader
extends VolumeDataReader {
    private int psi_n = 2;
    private int psi_l = 1;
    private int psi_m = 1;
    private double psi_Znuc = 1.0;
    private double sphere_radiusAngstroms;
    private int monteCarloCount;
    private Random random;
    private boolean allowNegative = true;
    private double[] rfactor = new double[10];
    private double[] pfactor = new double[10];
    private static final double A0 = 0.52918;
    private static final double ROOT2 = 1.414214;
    private static final double ATOMIC_ORBITAL_ZERO_CUT_OFF = 1.0E-7;
    private double radius;
    private final P3d ptPsi = new P3d();
    private static final double[] fact = new double[20];
    private double psi_normalization = 1.0 / (2.0 * Math.sqrt(Math.PI));
    private double aoMax;
    private double aoMax2;
    private double angMax2;
    private V3d planeU;
    private V3d planeV;
    private P3d planeCenter;
    private double planeRadius;
    private double rnl;
    private boolean surfaceDone;
    private int nTries;

    IsoShapeReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initVDR(sg);
        Object o = sg.getReaderData();
        if (o instanceof Double) {
            this.sphere_radiusAngstroms = (Double)o;
        } else {
            this.sphere_radiusAngstroms = 0.0;
            double[] data = (double[])o;
            this.psi_n = (int)data[0];
            this.psi_l = (int)data[1];
            this.psi_m = (int)data[2];
            this.psi_Znuc = data[3];
            this.monteCarloCount = (int)data[4];
        }
    }

    @Override
    protected void setup(boolean isMapData) {
        this.volumeData.sr = this;
        this.precalculateVoxelData = false;
        this.isQuiet = true;
        if (Double.isNaN(this.center.x)) {
            this.center.set(0.0, 0.0, 0.0);
        }
        String type = "sphere";
        switch (this.dataType) {
            case 1294: {
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.autoScaleOrbital();
                this.ptsPerAngstrom = 5.0;
                this.maxGrid = 40;
                type = "hydrogen-like orbital";
                if (this.monteCarloCount > 0) {
                    this.vertexDataOnly = true;
                    this.random = new Random(this.params.randomSeed);
                    break;
                }
                this.isQuiet = false;
                break;
            }
            case 70: 
            case 71: {
                type = "lp";
                this.vertexDataOnly = true;
                this.radius = 0.0;
                this.ptsPerAngstrom = 1.0;
                this.maxGrid = 1;
                break;
            }
            case 68: {
                this.allowNegative = false;
                this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
                this.psi_normalization = 1.0;
                this.radius = 1.1 * this.eccentricityRatio * this.eccentricityScale;
                if (this.eccentricityScale > 0.0 && this.eccentricityScale < 1.0) {
                    this.radius /= this.eccentricityScale;
                }
                this.ptsPerAngstrom = 10.0;
                this.maxGrid = 21;
                type = "lobe";
                break;
            }
            case 67: {
                type = "ellipsoid(thermal)";
                this.radius = 3.0 * this.sphere_radiusAngstroms;
                this.ptsPerAngstrom = 10.0;
                this.maxGrid = 22;
                break;
            }
            case 74: {
                if (!isMapData && this.monteCarloCount == 0) break;
                type = "geodesic";
            }
            case 66: {
                if (type.equals("sphere")) {
                    type = "ellipsoid";
                }
            }
            default: {
                this.radius = 1.2 * this.sphere_radiusAngstroms * this.eccentricityScale;
                this.ptsPerAngstrom = 10.0;
                this.maxGrid = 22;
            }
        }
        if (this.monteCarloCount == 0) {
            this.setVolumeData();
        }
        this.setHeader(type + "\n");
    }

    @Override
    protected void setVolumeData() {
        this.setVoxelRange(0, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid, 0.0);
        this.setVoxelRange(1, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid, 0.0);
        if (this.allowNegative) {
            this.setVoxelRange(2, -this.radius, this.radius, this.ptsPerAngstrom, this.maxGrid, 0.0);
        } else {
            this.setVoxelRange(2, 0.0, this.radius / this.eccentricityRatio, this.ptsPerAngstrom, this.maxGrid, 0.0);
        }
    }

    @Override
    public double getValue(int x, int y, int z, int ptyz) {
        this.volumeData.voxelPtToXYZ(x, y, z, this.ptPsi);
        return this.getValueAtPoint(this.ptPsi, false);
    }

    @Override
    public double getValueAtPoint(T3d pt, boolean getSource) {
        this.ptTemp.sub2(pt, this.center);
        if (this.isEccentric) {
            this.eccentricityMatrixInverse.rotate(this.ptTemp);
        }
        if (this.isAnisotropic) {
            this.ptTemp.x /= this.anisotropy[0];
            this.ptTemp.y /= this.anisotropy[1];
            this.ptTemp.z /= this.anisotropy[2];
        }
        if (this.sphere_radiusAngstroms > 0.0) {
            if (this.params.anisoB != null) {
                return this.sphere_radiusAngstroms - Math.sqrt(this.ptTemp.x * this.ptTemp.x + this.ptTemp.y * this.ptTemp.y + this.ptTemp.z * this.ptTemp.z) / Math.sqrt(this.params.anisoB[0] * this.ptTemp.x * this.ptTemp.x + this.params.anisoB[1] * this.ptTemp.y * this.ptTemp.y + this.params.anisoB[2] * this.ptTemp.z * this.ptTemp.z + this.params.anisoB[3] * this.ptTemp.x * this.ptTemp.y + this.params.anisoB[4] * this.ptTemp.x * this.ptTemp.z + this.params.anisoB[5] * this.ptTemp.y * this.ptTemp.z);
            }
            return this.sphere_radiusAngstroms - Math.sqrt(this.ptTemp.x * this.ptTemp.x + this.ptTemp.y * this.ptTemp.y + this.ptTemp.z * this.ptTemp.z);
        }
        double value = this.hydrogenAtomPsi(this.ptTemp);
        if (Math.abs(value) < 1.0E-7) {
            value = 0.0;
        }
        return this.allowNegative || value >= 0.0 ? value : 0.0;
    }

    private void setHeader(String line1) {
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append(line1);
        if (this.sphere_radiusAngstroms > 0.0) {
            this.jvxlFileHeaderBuffer.append(" rad=").appendD(this.sphere_radiusAngstroms);
        } else {
            this.jvxlFileHeaderBuffer.append(" n=").appendI(this.psi_n).append(", l=").appendI(this.psi_l).append(", m=").appendI(this.psi_m).append(" Znuc=").appendD(this.psi_Znuc).append(" res=").appendD(this.ptsPerAngstrom).append(" rad=").appendD(this.radius);
        }
        this.jvxlFileHeaderBuffer.append(this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")\n" : "\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    private void calcFactors(int n, int el, int m) {
        int p;
        int abm = Math.abs(m);
        double NnlLnl = Math.pow(2.0 * this.psi_Znuc / (double)n / 0.52918, 1.5) * Math.sqrt(fact[n - el - 1] * fact[n + el] / 2.0 / (double)n);
        double Plm = Math.pow(2.0, -el) * fact[el] * fact[el + abm] * Math.sqrt((double)(2 * el + 1) * fact[el - abm] / 2.0 / fact[el + abm]);
        for (p = 0; p <= n - el - 1; ++p) {
            this.rfactor[p] = NnlLnl / fact[p] / fact[n - el - p - 1] / fact[2 * el + p + 1];
        }
        for (p = abm; p <= el; ++p) {
            this.pfactor[p] = Math.pow(-1.0, el - p) * Plm / fact[p] / fact[el + abm - p] / fact[el - p] / fact[p - abm];
        }
    }

    private void autoScaleOrbital() {
        double min;
        double d;
        this.aoMax = 0.0;
        double rmax = 0.0;
        this.aoMax2 = 0.0;
        double rmax2 = 0.0;
        if (this.params.distance == 0.0) {
            for (int ir = 0; ir < 1000; ++ir) {
                double r = (double)ir / 10.0;
                d = Math.abs(this.radialPart(r));
                if (Logger.debugging) {
                    Logger.debug("R\t" + r + "\t" + d);
                }
                if (d >= this.aoMax) {
                    rmax = r;
                    this.aoMax = d;
                }
                if (!((d *= d * r * r) >= this.aoMax2)) continue;
                rmax2 = r;
                this.aoMax2 = d;
            }
        } else {
            this.aoMax = Math.abs(this.radialPart(this.params.distance));
            this.aoMax2 = this.aoMax * this.aoMax * this.params.distance * this.params.distance;
            rmax = rmax2 = this.params.distance;
        }
        Logger.info("Atomic Orbital radial max = " + this.aoMax + " at " + rmax);
        Logger.info("Atomic Orbital r2R2 max = " + this.aoMax2 + " at " + rmax2);
        if (this.monteCarloCount >= 0) {
            this.angMax2 = 0.0;
            for (double ang = 0.0; ang < 180.0; ang += 1.0) {
                double th = ang / (Math.PI * 2);
                d = Math.abs(this.angularPart(th, 0.0, 0));
                if (Logger.debugging) {
                    Logger.debug("A\t" + ang + "\t" + d);
                }
                if (!(d > this.angMax2)) continue;
                this.angMax2 = d;
            }
            this.angMax2 *= this.angMax2;
            if (this.psi_m != 0) {
                this.angMax2 *= 2.0;
            }
            Logger.info("Atomic Orbital phi^2theta^2 max = " + this.angMax2);
        }
        if (this.params.cutoff == 0.0) {
            min = this.monteCarloCount > 0 ? this.aoMax * (double)0.01f : (double)0.01f;
        } else if (this.monteCarloCount > 0) {
            this.aoMax = Math.abs(this.params.cutoff);
            min = this.aoMax * (double)0.01f;
        } else {
            min = Math.abs(this.params.cutoff / 2.0);
            if (this.params.isSquared) {
                min = Math.sqrt(min / 2.0);
            }
        }
        double r0 = 0.0;
        int ir = 1000;
        while (--ir >= 0) {
            double r = (double)ir / 10.0;
            d = Math.abs(this.radialPart(r));
            if (d >= min) {
                r0 = r;
                break;
            }
            --ir;
        }
        this.radius = r0 + (double)(this.monteCarloCount == 0 ? 1 : 0);
        if (this.isAnisotropic) {
            double aMax = 0.0;
            int i = 3;
            while (--i >= 0) {
                if (!(this.anisotropy[i] > aMax)) continue;
                aMax = this.anisotropy[i];
            }
            this.radius *= aMax;
        }
        Logger.info("Atomic Orbital radial extent set to " + this.radius + " for cutoff " + this.params.cutoff);
        if (this.params.thePlane != null && this.monteCarloCount > 0) {
            this.planeCenter = new P3d();
            this.planeU = new V3d();
            MeasureD.getPlaneProjection(this.center, this.params.thePlane, this.planeCenter, this.planeU);
            this.planeU.set(this.params.thePlane.x, this.params.thePlane.y, this.params.thePlane.z);
            this.planeU.normalize();
            this.planeV = V3d.new3(1.0, 0.0, 0.0);
            if (Math.abs(this.planeU.dot(this.planeV)) > 0.5) {
                this.planeV.set(0.0, 1.0, 0.0);
            }
            this.planeV.cross(this.planeU, this.planeV);
            this.planeU.cross(this.planeU, this.planeV);
            this.aoMax2 = 0.0;
            d = this.center.distance(this.planeCenter);
            if (d < this.radius) {
                this.planeRadius = Math.sqrt(this.radius * this.radius - d * d);
                ir = (int)(this.planeRadius * 10.0);
                for (int ix = -ir; ix <= ir; ++ix) {
                    for (int iy = -ir; iy <= ir; ++iy) {
                        this.ptPsi.setT(this.planeU);
                        this.ptPsi.scale((double)ix / 10.0);
                        this.ptPsi.scaleAdd2((double)iy / 10.0, this.planeV, this.ptPsi);
                        d = this.hydrogenAtomPsi(this.ptPsi);
                        d = Math.abs(this.hydrogenAtomPsi(this.ptPsi));
                        if (!(d > this.aoMax2)) continue;
                        this.aoMax2 = d;
                    }
                }
                this.aoMax2 = this.aoMax2 < (double)0.001f ? 0.0 : (this.aoMax2 *= this.aoMax2);
            }
        }
    }

    private double radialPart(double r) {
        double rho = 2.0 * this.psi_Znuc * r / (double)this.psi_n / 0.52918;
        double sum = 0.0;
        for (int p = 0; p <= this.psi_n - this.psi_l - 1; ++p) {
            sum += Math.pow(-rho, p) * this.rfactor[p];
        }
        return Math.exp(-rho / 2.0) * Math.pow(rho, this.psi_l) * sum;
    }

    private double hydrogenAtomPsi(P3d pt) {
        double x2y2 = pt.x * pt.x + pt.y * pt.y;
        this.rnl = this.radialPart(Math.sqrt(x2y2 + pt.z * pt.z));
        double ph = Math.atan2(pt.y, pt.x);
        double th = Math.atan2(Math.sqrt(x2y2), pt.z);
        double theta_lm_phi_m = this.angularPart(th, ph, this.psi_m);
        return this.rnl * theta_lm_phi_m;
    }

    private double angularPart(double th, double ph, int m) {
        double theta_lm;
        double cth = Math.cos(th);
        double sth = Math.sin(th);
        boolean isS = m == 0 && this.psi_l == 0;
        int abm = Math.abs(m);
        double sum = 0.0;
        if (isS) {
            sum = this.pfactor[0];
        } else {
            for (int p = abm; p <= this.psi_l; ++p) {
                sum += (p == abm ? 1.0 : Math.pow(1.0 + cth, p - abm)) * (p == this.psi_l ? 1.0 : Math.pow(1.0 - cth, this.psi_l - p)) * this.pfactor[p];
            }
        }
        double d = theta_lm = abm == 0 ? sum : Math.abs(Math.pow(sth, abm)) * sum;
        double phi_m = m == 0 ? 1.0 : (m > 0 ? Math.cos((double)m * ph) * 1.414214 : Math.sin((double)m * ph) * 1.414214);
        return Math.abs(phi_m) < 1.0E-10 ? 0.0 : theta_lm * phi_m * this.psi_normalization;
    }

    private void createMonteCarloOrbital() {
        if (this.surfaceDone || this.aoMax2 == 0.0 || this.params.distance > this.radius) {
            return;
        }
        boolean isS = this.psi_m == 0 && this.psi_l == 0;
        this.surfaceDone = true;
        double rave = 0.0;
        this.nTries = 0;
        int i = 0;
        while (i < this.monteCarloCount) {
            block9: {
                double value;
                block10: {
                    block6: {
                        double phi;
                        double ap;
                        double r;
                        block8: {
                            block7: {
                                if (this.params.thePlane != null) break block6;
                                if (this.params.distance != 0.0) break block7;
                                r = this.random.nextDouble() * this.radius;
                                double rp = r * this.radialPart(r);
                                if (!(rp * rp <= this.aoMax2 * this.random.nextDouble())) break block8;
                                break block9;
                            }
                            r = this.params.distance;
                        }
                        double u = this.random.nextDouble();
                        double v = this.random.nextDouble();
                        double theta = Math.PI * 2 * u;
                        double cosPhi = 2.0 * v - 1.0;
                        if (!isS && (ap = this.angularPart(phi = Math.acos(cosPhi), theta, this.psi_m)) * ap <= this.angMax2 * this.random.nextDouble()) break block9;
                        double sinPhi = Math.sin(Math.acos(cosPhi));
                        double x = r * Math.cos(theta) * sinPhi;
                        double y = r * Math.sin(theta) * sinPhi;
                        double z = r * cosPhi;
                        this.ptPsi.set(x, y, z);
                        this.ptPsi.add(this.center);
                        value = this.getValueAtPoint(this.ptPsi, false);
                        break block10;
                    }
                    this.ptPsi.setT(this.planeU);
                    this.ptPsi.scale((double)this.random.nextFloat() * this.planeRadius * 2.0 - this.planeRadius);
                    this.ptPsi.scaleAdd2((double)this.random.nextFloat() * this.planeRadius * 2.0 - this.planeRadius, this.planeV, this.ptPsi);
                    this.ptPsi.add(this.planeCenter);
                    value = this.getValueAtPoint(this.ptPsi, false);
                    if (value * value <= this.aoMax2 * (double)this.random.nextFloat()) break block9;
                }
                rave += this.ptPsi.distance(this.center);
                this.addVC(this.ptPsi, value, 0, true);
                ++i;
            }
            ++this.nTries;
        }
        if (this.params.distance == 0.0) {
            Logger.info("Atomic Orbital mean radius = " + rave / (double)this.monteCarloCount + " for " + this.monteCarloCount + " points (" + this.nTries + " tries)");
        }
    }

    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        switch (this.params.dataType) {
            case 1294: {
                if (this.monteCarloCount <= 0) break;
                this.createMonteCarloOrbital();
                return;
            }
            case 70: 
            case 71: {
                this.ptPsi.set(0.0, 0.0, this.eccentricityScale / 2.0);
                this.eccentricityMatrixInverse.rotate(this.ptPsi);
                this.ptPsi.add(this.center);
                this.addVC(this.center, 0.0, 0, true);
                this.addVC(this.ptPsi, 0.0, 0, true);
                this.addTriangleCheck(0, 0, 0, 0, 0, false, 0);
                return;
            }
            case 74: {
                if (isMapData) break;
                this.createGeodesic();
                return;
            }
        }
        this.readSurfaceDataVDR(isMapData);
    }

    private void createGeodesic() {
        MeshSurface ms = MeshSurface.getSphereData(4);
        T3d[] pts = ms.altVertices;
        for (int i = 0; i < pts.length; ++i) {
            P3d pt = P3d.newP(pts[i]);
            pt.scale(this.params.distance);
            pt.add(this.center);
            this.addVC(pt, 0.0, i, false);
        }
        int[][] faces = ms.pis;
        for (int i = 0; i < faces.length; ++i) {
            int[] face = faces[i];
            this.addTriangleCheck(face[0], face[1], face[2], 7, 7, false, 0);
        }
    }

    static {
        IsoShapeReader.fact[0] = 1.0;
        for (int i = 1; i < 20; ++i) {
            IsoShapeReader.fact[i] = fact[i - 1] * (double)i;
        }
    }
}

