/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.P4d;
import javajs.util.SB;
import javajs.util.T3d;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class IsoFxyReader
extends AtomDataReader {
    private double[][] data;
    private boolean isPlanarMapping;
    private Object[] func;
    private final double[] values = new double[3];

    IsoFxyReader() {
    }

    @Override
    void init(SurfaceGenerator sg) {
        this.initIFR(sg);
    }

    protected void initIFR(SurfaceGenerator sg) {
        this.initADR(sg);
        this.isXLowToHigh = true;
        this.precalculateVoxelData = false;
        this.params.fullyLit = true;
        this.isPlanarMapping = this.params.thePlane != null || this.params.state == 3;
        this.volumeData.sr = this.params.func == null ? null : this;
    }

    @Override
    protected void setup(boolean isMapData) {
        if (this.params.functionInfo.size() > 5) {
            this.data = (double[][])this.params.functionInfo.get(5);
        }
        this.setupType("functionXY");
    }

    protected void setupType(String type) {
        this.func = (Object[])this.params.func;
        String functionName = (String)this.params.functionInfo.get(0);
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append(type).append("\n").append(functionName).append("\n");
        if (this.params.thePlane != null || this.data == null && !this.useOriginStepsPoints) {
            this.setVolumeForPlane();
        } else if (this.data == null) {
            this.setVolumeDataParams();
        } else {
            this.setVolumeData();
        }
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    protected void setVolumeData() {
        if (this.data == null) {
            this.setVolumeDataADR();
            return;
        }
        this.volumetricOrigin.setT((T3d)this.params.functionInfo.get(1));
        for (int i = 0; i < 3; ++i) {
            P4d info = (P4d)this.params.functionInfo.get(i + 2);
            this.voxelCounts[i] = Math.abs((int)info.x);
            this.volumetricVectors[i].set(info.y, info.z, info.w);
        }
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
    }

    @Override
    protected void readSurfaceData(boolean isMapData) throws Exception {
        if (this.volumeData.sr != null) {
            return;
        }
        this.readSurfaceDataVDR(isMapData);
    }

    @Override
    public double[] getPlane(int x) {
        double[] plane = this.getPlaneSR(x);
        this.setPlane(x, plane);
        return plane;
    }

    private void setPlane(int x, double[] plane) {
        int ptyz = 0;
        for (int y = 0; y < this.nPointsY; ++y) {
            for (int z = 0; z < this.nPointsZ; ++z) {
                plane[ptyz++] = this.getValue(x, y, z, 0);
            }
        }
    }

    @Override
    public double getValue(int x, int y, int z, int pxyz) {
        double value;
        if (this.data == null) {
            value = this.evaluateValue(x, y, z);
        } else {
            this.volumeData.voxelPtToXYZ(x, y, z, this.ptTemp);
            value = this.data[x][y];
        }
        return this.isPlanarMapping ? value : value - this.ptTemp.z;
    }

    @Override
    public double getValueAtPoint(T3d pt, boolean getSource) {
        if (this.params.func == null) {
            return 0.0;
        }
        this.values[0] = pt.x;
        this.values[1] = pt.y;
        this.values[2] = pt.z;
        return this.sg.atomDataServer.evalFunctionFloat(this.func[0], this.func[1], this.values);
    }

    protected double evaluateValue(int x, int y, int z) {
        this.volumeData.voxelPtToXYZ(x, y, z, this.ptTemp);
        return this.getValueAtPoint(this.ptTemp, false);
    }
}

