/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.SB;
import org.jmol.jvxl.data.JvxlCoder;

public class JvxlData {
    public String msg = "";
    public boolean wasJvxl;
    public boolean wasCubic;
    public String jvxlFileSource;
    public String jvxlFileTitle;
    public String jvxlFileMessage;
    public String jvxlSurfaceData;
    public String jvxlEdgeData;
    public String jvxlColorData;
    public String jvxlVolumeDataXml;
    public BS[] jvxlExcluded = new BS[4];
    public P4d jvxlPlane;
    public boolean isJvxlPrecisionColor;
    public boolean jvxlDataIsColorMapped;
    public boolean jvxlDataIs2dContour;
    public boolean jvxlDataIsColorDensity;
    public boolean isColorReversed;
    public BS thisSet = null;
    public int edgeFractionBase = 35;
    public int edgeFractionRange = 90;
    public int colorFractionBase = 35;
    public int colorFractionRange = 90;
    public boolean isValid = true;
    public boolean insideOut;
    public boolean isXLowToHigh;
    public boolean isContoured;
    public boolean isBicolorMap;
    public boolean isTruncated;
    public boolean isCutoffAbsolute;
    public boolean isModelConnected;
    public boolean vertexDataOnly;
    public double mappedDataMin;
    public double mappedDataMax;
    public double valueMappedToRed;
    public double valueMappedToBlue;
    public double cutoff;
    public double[] cutoffRange;
    public double pointsPerAngstrom;
    public int nPointsX;
    public int nPointsY;
    public int nPointsZ;
    public long nBytes;
    public int nContours;
    public int nEdges;
    public int nSurfaceInts;
    public int vertexCount;
    public Lst<Object>[] vContours;
    public short[] contourColixes;
    public String contourColors;
    public double[] contourValues;
    public double[] contourValuesUsed;
    public int thisContour = -1;
    public double scale3d;
    public short minColorIndex = (short)-1;
    public short maxColorIndex = 0;
    public String[] title;
    public String version;
    public P3d[] boundingBox;
    public int excludedTriangleCount;
    public int excludedVertexCount;
    public boolean colorDensity;
    public double pointSize;
    public String moleculeXml;
    public double dataMin;
    public double dataMax;
    public int saveVertexCount;
    public Map<String, BS> vertexColorMap;
    public int nVertexColors;
    public int[] vertexColors;
    public String color;
    public String meshColor;
    public double translucency;
    public String colorScheme;
    public String rendering;
    public int slabValue = Integer.MIN_VALUE;
    public boolean isSlabbable;
    public int diameter;
    public String slabInfo;
    public boolean allowVolumeRender;
    public double voxelVolume;
    public P3d mapLattice;
    public P3d fixedLattice;
    public String baseColor;
    public double integration = Double.NaN;
    public SB sbOut;

    public void clear() {
        this.allowVolumeRender = true;
        this.jvxlSurfaceData = "";
        this.jvxlEdgeData = "";
        this.jvxlColorData = "";
        this.jvxlVolumeDataXml = "";
        this.color = null;
        this.colorScheme = null;
        this.colorDensity = false;
        this.pointSize = Double.NaN;
        this.contourValues = null;
        this.contourValuesUsed = null;
        this.contourColixes = null;
        this.contourColors = null;
        this.integration = Double.NaN;
        this.isSlabbable = false;
        this.isValid = true;
        this.mapLattice = null;
        this.meshColor = null;
        this.msg = "";
        this.nPointsX = 0;
        this.nVertexColors = 0;
        this.fixedLattice = null;
        this.slabInfo = null;
        this.slabValue = Integer.MIN_VALUE;
        this.thisSet = null;
        this.rendering = null;
        this.thisContour = -1;
        this.translucency = 0.0;
        this.vContours = null;
        this.vertexColorMap = null;
        this.vertexColors = null;
        this.voxelVolume = 0.0;
    }

    public void setSurfaceInfo(P4d thePlane, P3d mapLattice, int nSurfaceInts, String surfaceData) {
        this.jvxlSurfaceData = surfaceData;
        this.jvxlPlane = thePlane;
        this.mapLattice = mapLattice;
        this.nSurfaceInts = nSurfaceInts;
    }

    public void setSurfaceInfoFromBitSet(BS bs, P4d thePlane) {
        this.setSurfaceInfoFromBitSetPts(bs, thePlane, null);
    }

    public void setSurfaceInfoFromBitSetPts(BS bs, P4d thePlane, P3d mapLattice) {
        SB sb = new SB();
        int nSurfaceInts = thePlane != null ? 0 : JvxlCoder.jvxlEncodeBitSetBuffer(bs, this.nPointsX * this.nPointsY * this.nPointsZ, sb);
        this.setSurfaceInfo(thePlane, mapLattice, nSurfaceInts, sb.toString());
    }

    public void jvxlUpdateInfo(String[] title, long nBytes) {
        this.title = title;
        this.nBytes = nBytes;
    }

    public static String updateSurfaceData(String edgeData, double[] vertexValues, int vertexCount, int vertexIncrement, char isNaN) {
        if (edgeData.length() == 0) {
            return "";
        }
        char[] chars = edgeData.toCharArray();
        int i = 0;
        int ipt = 0;
        while (i < vertexCount) {
            if (Double.isNaN(vertexValues[i])) {
                chars[ipt] = isNaN;
            }
            i += vertexIncrement;
            ++ipt;
        }
        return String.copyValueOf(chars);
    }
}

