/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

public class PrecisionRenderer {
    protected double a;
    protected double b;
    boolean isOrthographic;

    protected int getZCurrent(double a, double b, int x) {
        return (int)Math.round(a == Double.MIN_VALUE ? b : (this.isOrthographic ? a * (double)x + b : a / (b - (double)x)));
    }

    protected void setRastABFloat(double xa, double za, double xb, double zb) {
        double zdif = zb - za;
        double xdif = xb - xa;
        if (zdif == 0.0 || xdif == 0.0) {
            this.a = Double.MIN_VALUE;
            this.b = za;
            return;
        }
        if (this.isOrthographic) {
            this.a = zdif / xdif;
            this.b = za - this.a * xa;
        } else {
            this.a = xdif * za * (zb / zdif);
            this.b = (xb * zb - xa * za) / zdif;
        }
    }

    protected void setRastAB(int xa, int za, int xb, int zb) {
        double zdif = zb - za;
        double xdif = xb - xa;
        if ((double)xa == Double.MIN_VALUE || zdif == 0.0 || xdif == 0.0) {
            this.a = Double.MIN_VALUE;
            this.b = zb;
            return;
        }
        if (this.isOrthographic) {
            this.a = zdif / xdif;
            this.b = (double)za - this.a * (double)xa;
        } else {
            this.a = xdif * (double)za * ((double)zb / zdif);
            this.b = (double)(xb * zb - xa * za) / zdif;
        }
    }
}

