/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.net.URL;
import java.util.Map;
import javajs.img.BMPDecoder;
import javajs.util.AU;
import javax.swing.JPanel;
import org.jmol.api.GenericImageDialog;
import org.jmol.api.Interface;
import org.jmol.api.PlatformViewer;
import org.jmol.console.ImageDialog;
import org.jmol.viewer.Viewer;

class Image {
    private static final DirectColorModel rgbColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255};

    Image() {
    }

    static Object allocateRgbImage(int windowWidth, int windowHeight, int[] pBuffer, int windowSize, boolean backgroundTransparent) {
        return new BufferedImage(rgbColorModel, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, windowWidth, windowHeight, sampleModelBitMasks), new DataBufferInt(pBuffer, windowSize), null), false, null);
    }

    static Object createImage(Object data, PlatformViewer vwr) {
        if (data instanceof URL) {
            return Toolkit.getDefaultToolkit().createImage((URL)data);
        }
        if (data instanceof String) {
            return Toolkit.getDefaultToolkit().createImage((String)data);
        }
        if (AU.isAB(data)) {
            byte[] b = (byte[])data;
            if (b.length < 3) {
                return null;
            }
            if (b[0] == 66 && b[1] == 77) {
                Component c = (Component)((Viewer)vwr).display;
                if (c == null) {
                    return null;
                }
                BMPDecoder ie = (BMPDecoder)Interface.getInterface("javajs.img.BMPDecoder", (Viewer)vwr, "createImage");
                Object[] o = ie.decodeWindowsBMP(b);
                if (o == null || o[0] == null) {
                    return null;
                }
                int w = (Integer)o[1];
                int h = (Integer)o[2];
                return c.createImage(new MemoryImageSource(w, h, (int[])o[0], 0, w));
            }
            if (b.length > 53 && b[51] == 32 && b[52] == 78 && b[53] == 71) {
                b = AU.arrayCopyByte(b, -1);
                b[51] = 80;
            }
            return Toolkit.getDefaultToolkit().createImage(b);
        }
        return null;
    }

    static void waitForDisplay(PlatformViewer vwr, Object image) throws InterruptedException {
        Object display = ((Viewer)vwr).display;
        if (display == null) {
            display = new JPanel();
        }
        MediaTracker mediaTracker = new MediaTracker((Component)display);
        int rnd = (int)(Math.random() * 100000.0);
        mediaTracker.addImage((java.awt.Image)image, rnd);
        mediaTracker.waitForID(rnd);
    }

    static int getWidth(Object image) {
        return ((java.awt.Image)image).getWidth(null);
    }

    static int getHeight(Object image) {
        return ((java.awt.Image)image).getHeight(null);
    }

    static int[] grabPixels(Object imageobj, int width, int height, int[] pixels) {
        if (!(imageobj instanceof BufferedImage)) {
            java.awt.Image img = (java.awt.Image)imageobj;
            BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics2D bGr = bimage.createGraphics();
            bGr.drawImage(img, 0, 0, null);
            bGr.dispose();
            imageobj = bimage;
        }
        BufferedImage image = (BufferedImage)imageobj;
        int iw = image.getWidth();
        int[] data = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        if (iw == width && image.getHeight() == height) {
            return data;
        }
        if (pixels == null) {
            pixels = new int[width * height];
        }
        int i = 0;
        int p = 0;
        int d = 0;
        int n = iw - width;
        while (i < height) {
            for (int j = 0; j < width; ++j) {
                pixels[p++] = data[d++];
            }
            ++i;
            d += n;
        }
        return pixels;
    }

    static int[] drawImageToBuffer(Object gOffscreen, Object imageOffscreen, Object imageobj, int width, int height, int bgcolor) {
        Graphics g = (Graphics)gOffscreen;
        java.awt.Image image = (java.awt.Image)imageobj;
        int width0 = image.getWidth(null);
        int height0 = image.getHeight(null);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(5, 1.0f));
            g.setColor(bgcolor == 0 ? new Color(0, 0, 0, 0) : new Color(bgcolor));
            g.fillRect(0, 0, width, height);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
            g.drawImage(image, 0, 0, width, height, 0, 0, width0, height0, null);
        } else {
            g.clearRect(0, 0, width, height);
            g.drawImage(image, 0, 0, width, height, 0, 0, width0, height0, null);
        }
        return Image.grabPixels(imageOffscreen, width, height, null);
    }

    public static int[] getTextPixels(String text, org.jmol.util.Font font3d, Object gObj, Object image, int width, int height, int ascent) {
        Graphics g = (Graphics)gObj;
        g.setColor(Color.black);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.white);
        g.setFont((Font)font3d.font);
        g.drawString(text, 0, ascent);
        return Image.grabPixels(image, width, height, null);
    }

    static Object newBufferedImage(Object image, int w, int h) {
        return new BufferedImage(w, h, ((BufferedImage)image).getType());
    }

    static Object newBufferedImage(int w, int h) {
        return new BufferedImage(w, h, 2);
    }

    static Object getStaticGraphics(Object image, boolean backgroundTransparent) {
        Graphics2D g2d = ((BufferedImage)image).createGraphics();
        if (!Viewer.isJS) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
        return g2d;
    }

    static Object getGraphics(Object image) {
        return ((java.awt.Image)image).getGraphics();
    }

    static void flush(Object image) {
        ((java.awt.Image)image).flush();
    }

    static void disposeGraphics(Object graphicForText) {
        ((Graphics)graphicForText).dispose();
    }

    public static GenericImageDialog getImageDialog(PlatformViewer vwr, String title, Map<String, GenericImageDialog> imageMap) {
        return new ImageDialog((Viewer)vwr, title, imageMap);
    }

    static void drawImage(Object g, Object img, int x, int y, int width, int height) {
        ((Graphics)g).drawImage((java.awt.Image)img, x, y, null);
    }

    static void drawImageDTI(Object g, Object img, int x, int y, int width, int height) {
        ((Graphics)g).drawImage((java.awt.Image)img, x, y, x == 0 ? width >> 1 : width, height, 0, y, width, height, null);
    }
}

