/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;

public class Atom
extends P3d
implements Cloneable {
    public int atomSetIndex;
    public int index;
    public BS bsSymmetry;
    public int atomSite;
    public String elementSymbol;
    public short elementNumber = (short)-1;
    public String atomName;
    public int formalCharge = Integer.MIN_VALUE;
    public double partialCharge = Double.NaN;
    public V3d vib;
    public double bfactor = Double.NaN;
    public double foccupancy = 1.0;
    public double radius = Double.NaN;
    public boolean isHetero;
    public int atomSerial = Integer.MIN_VALUE;
    public int chainID;
    public double bondingRadius = Double.NaN;
    public char altLoc = '\u0000';
    public String group3;
    public int sequenceNumber = Integer.MIN_VALUE;
    public char insertionCode = '\u0000';
    public double[] anisoBorU;
    public Lst<Object> tensors;
    public String typeSymbol;
    public double dx;
    public double dy;
    public double dz;
    public int part;
    private static final int[] elementCharMasks = new int[]{1972292, -2147351151, -2146019271, -2130706430, 0x160000, -2147348464, 25, -2147205008, -2147344384, 0, -2147352576, 0x120101, 548936, -2147434213, -2147221504, -2145759221, 0, 1056947, -2147339946, -2147477097, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x800010, -2147483646, 139264};

    public Tensor addTensor(Tensor tensor, String type, boolean reset) {
        if (tensor == null) {
            return null;
        }
        if (reset || this.tensors == null) {
            this.tensors = new Lst();
        }
        this.tensors.addLast(tensor);
        if (type != null) {
            tensor.setType(type);
        }
        return tensor;
    }

    public Atom() {
        this.set(Double.NaN, Double.NaN, Double.NaN);
    }

    public Atom getClone() {
        Atom a;
        try {
            a = (Atom)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        if (this.vib != null) {
            a.vib = this.vib instanceof Vibration ? (Vibration)((Vibration)this.vib).clone() : V3d.newV(a.vib);
        }
        if (this.anisoBorU != null) {
            a.anisoBorU = AU.arrayCopyD(this.anisoBorU, -1);
        }
        if (this.tensors != null) {
            a.tensors = new Lst();
            int i = this.tensors.size();
            while (--i >= 0) {
                a.tensors.addLast(((Tensor)this.tensors.get(i)).copyTensor());
            }
        }
        return a;
    }

    public String getElementSymbol() {
        if (this.elementSymbol == null && this.atomName != null) {
            int ichFirst;
            int len = this.atomName.length();
            char chFirst = '\u0000';
            for (ichFirst = 0; ichFirst < len && !Atom.isValidSymChar1(chFirst = this.atomName.charAt(ichFirst)); ++ichFirst) {
            }
            switch (len - ichFirst) {
                case 0: {
                    break;
                }
                default: {
                    char chSecond = this.atomName.charAt(ichFirst + 1);
                    if (Atom.isValidSymNoCase(chFirst, chSecond)) {
                        this.elementSymbol = "" + chFirst + chSecond;
                        break;
                    }
                }
                case 1: {
                    if (!Atom.isValidSym1(chFirst)) break;
                    this.elementSymbol = "" + chFirst;
                }
            }
        }
        return this.elementSymbol;
    }

    public static boolean isValidSym1(char ch) {
        return ch >= 'A' && ch <= 'Z' && elementCharMasks[ch - 65] < 0;
    }

    public static boolean isValidSym2(char ch1, char ch2) {
        return ch1 >= 'A' && ch1 <= 'Z' && ch2 >= 'a' && ch2 <= 'z' && (elementCharMasks[ch1 - 65] >> ch2 - 97 & 1) != 0;
    }

    public static boolean isValidSymNoCase(char ch1, char ch2) {
        return Atom.isValidSym2(ch1, ch2 < 'a' ? (char)(ch2 + 32) : ch2);
    }

    private static boolean isValidSymChar1(char ch) {
        return ch >= 'A' && ch <= 'Z' && elementCharMasks[ch - 65] != 0;
    }

    public Atom copyTo(P3d pt, AtomSetCollection asc) {
        Atom a = asc.newCloneAtom(this);
        a.setT(pt);
        return a;
    }
}

