/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.V3d;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class CastepReader
extends AtomSetCollectionReader {
    private static final double RAD_TO_DEG = 57.29577951308232;
    private String[] tokens;
    private boolean isPhonon;
    private boolean isTS;
    private boolean isOutput;
    private boolean isCell;
    private double a;
    private double b;
    private double c;
    private double alpha;
    private double beta;
    private double gamma;
    private V3d[] abc = new V3d[3];
    private int ac;
    private P3d[] atomPts;
    private boolean havePhonons = false;
    private String lastQPt;
    private int qpt2;
    private V3d desiredQpt;
    private String desiredQ;
    private String chargeType = "MULL";
    private boolean isAllQ;
    private boolean haveCharges;
    private String tsType;
    private boolean allowSymmetryGeneration = true;
    private M3d lattTr;
    private static String[] functions = new String[]{"sqrt", "sin", "cos", "tan", "+", "-", "*", "/"};
    private static final String[] lengthUnitIds = new String[]{"bohr", "m", "cm", "nm", "ang", "a0"};
    private static final double[] lengthUnitFactors = new double[]{0.5291772, 1.0E10, 1.0E8, 10.0, 1.0, 0.5291772};
    private M4d matSupercell;
    private static final double TWOPI = Math.PI * 2;

    @Override
    public void initializeReader() throws Exception {
        if (this.filter != null) {
            this.allowSymmetryGeneration = !this.checkFilterKey("NOSYM");
            this.chargeType = this.getFilter("CHARGE=");
            if (this.chargeType != null && this.chargeType.length() > 4) {
                this.chargeType = this.chargeType.substring(0, 4);
            }
            this.filter = this.filter.replace('(', '{').replace(')', '}');
            this.filter = PT.rep(this.filter, "  ", " ");
            this.isAllQ = this.checkFilterKey("Q=ALL");
            this.tsType = this.getFilter("TSTYPE=");
            if (!this.isAllQ && this.filter.indexOf("{") >= 0) {
                this.setDesiredQpt(this.filter.substring(this.filter.indexOf("{")));
            }
            this.filter = PT.rep(this.filter, "-PT", "");
        }
        this.continuing = this.readFileData();
    }

    private void setDesiredQpt(String s) {
        this.desiredQpt = new V3d();
        this.desiredQ = "";
        double num = 1.0;
        double denom = 1.0;
        int ipt = 0;
        int xyz = 0;
        boolean useSpace = s.indexOf(44) < 0;
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '{': {
                    ipt = i + 1;
                    num = 1.0;
                    denom = 1.0;
                    continue block10;
                }
                case '/': {
                    num = this.parseDoubleStr(s.substring(ipt, i));
                    ipt = i + 1;
                    denom = 0.0;
                    continue block10;
                }
                case ' ': 
                case ',': 
                case '}': {
                    if (c == '}') {
                        this.desiredQ = s.substring(0, i + 1);
                    } else if (c == ' ' != useSpace) continue block10;
                    if (denom == 0.0) {
                        denom = this.parseDoubleStr(s.substring(ipt, i));
                    } else {
                        num = this.parseDoubleStr(s.substring(ipt, i));
                    }
                    num /= denom;
                    switch (xyz++) {
                        case 0: {
                            this.desiredQpt.x = num;
                            break;
                        }
                        case 1: {
                            this.desiredQpt.y = num;
                            break;
                        }
                        case 2: {
                            this.desiredQpt.z = num;
                        }
                    }
                    denom = 1.0;
                    if (c == '}') {
                        i = s.length();
                    }
                    ipt = i + 1;
                }
            }
        }
        Logger.info("Looking for q-pt=" + this.desiredQpt);
    }

    private boolean readFileData() throws Exception {
        while (this.tokenizeCastepCell() > 0) {
            if (this.tokens.length >= 2 && this.tokens[0].equalsIgnoreCase("%BLOCK")) {
                Logger.info(this.line);
                if (this.tokens[1].equalsIgnoreCase("LATTICE_ABC")) {
                    this.readLatticeAbc();
                    continue;
                }
                if (this.tokens[1].equalsIgnoreCase("LATTICE_CART")) {
                    this.readLatticeCart();
                    continue;
                }
                if (this.tokens[1].equalsIgnoreCase("POSITIONS_FRAC")) {
                    this.setFractionalCoordinates(true);
                    this.readPositionsFrac();
                    continue;
                }
                if (this.tokens[1].equalsIgnoreCase("POSITIONS_ABS")) {
                    this.setFractionalCoordinates(false);
                    this.readPositionsAbs();
                    continue;
                }
                if (!this.tokens[1].equalsIgnoreCase("SYMMETRY_OPS")) continue;
                this.readSymmetryOps();
                continue;
            }
            if (!this.allowSymmetryGeneration || !this.tokens[0].equalsIgnoreCase("SYMMETRY_GENERATE")) continue;
            this.addJmolScript("print 'CastepReader SYMMETRY_GENERATE';modelkit spacegroup");
        }
        if (this.isPhonon || this.isOutput || this.isTS) {
            if (this.isPhonon) {
                this.isTrajectory = this.desiredVibrationNumber <= 0;
                this.asc.allowMultiple = false;
            }
            return true;
        }
        return false;
    }

    private void readSymmetryOps() throws Exception {
        if (this.lattTr == null) {
            this.setLatticeVectors();
            SymmetryInterface uc = this.getSymmetry().setUnitCellFromParams(this.unitCellParams, false, 1.0E-4);
            P3d[] vecs = uc.getUnitCellVectors();
            this.lattTr = new M3d();
            this.lattTr.setColumnV(0, vecs[1]);
            this.lattTr.setColumnV(1, vecs[2]);
            this.lattTr.setColumnV(2, vecs[3]);
        }
        M3d lattTrInv = M3d.newM3(this.lattTr);
        lattTrInv.invert();
        M4d op = new M4d();
        int nop = 0;
        this.tokenizeCastepCell();
        while (this.tokens.length > 0 && !this.tokens[0].equalsIgnoreCase("%ENDBLOCK")) {
            M3d op3 = new M3d();
            P3d t = new P3d();
            for (int i = 0; i < 4; ++i) {
                if (this.tokens.length >= 3) {
                    double x = this.parseCalcStr(this.tokens[0]);
                    double y = this.parseCalcStr(this.tokens[1]);
                    double z = this.parseCalcStr(this.tokens[2]);
                    if (i < 3) {
                        op3.setColumn3(i, x, y, z);
                    } else {
                        t.set(x, y, z);
                    }
                } else {
                    Logger.warn("cannot read line with CASTEP symmetr_ops: " + this.line);
                }
                this.tokenizeCastepCell();
            }
            op3.mul2(op3, this.lattTr);
            op3.mul2(lattTrInv, op3);
            op.setMV(op3, t);
            String xyz = SymmetryOperation.getXYZFromMatrix(op, false, true, false);
            System.out.println("CASTEP reader op[" + ++nop + "] = " + xyz);
            this.setSymmetryOperator(xyz);
        }
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.isOutput) {
            if (this.line.contains("Real Lattice(A)")) {
                this.readOutputUnitCell();
            } else if (this.line.contains("Fractional coordinates of atoms")) {
                if (this.doGetModel(++this.modelNumber, null)) {
                    this.readOutputAtoms();
                }
            } else if (this.doProcessLines && (this.line.contains("Atomic Populations (Mulliken)") || this.line.contains("Hirshfield Charge (e)"))) {
                this.readOutputCharges();
            } else if (this.doProcessLines && this.line.contains("Born Effective Charges")) {
                this.readOutputBornChargeTensors();
            } else if (this.line.contains("Final energy ")) {
                this.readEnergy(3, null);
            } else if (this.line.contains("Dispersion corrected final energy*")) {
                this.readEnergy(5, null);
            } else if (this.line.contains("Total energy corrected")) {
                this.readEnergy(8, null);
            }
            return true;
        }
        if (this.line.contains("<-- E")) {
            this.readPhononTrajectories();
            return true;
        }
        if (this.line.indexOf("Unit cell vectors") == 1) {
            this.readPhononUnitCell();
            return true;
        }
        if (this.line.indexOf("Fractional Co-ordinates") >= 0) {
            this.readPhononFractionalCoord();
            return true;
        }
        if (this.line.indexOf("q-pt") >= 0) {
            this.readPhononFrequencies();
            return true;
        }
        return true;
    }

    private void readOutputUnitCell() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSetClear(false);
        this.setFractionalCoordinates(true);
        this.abc = this.read3Vectors(false);
        this.setLatticeVectors();
    }

    private void readOutputAtoms() throws Exception {
        this.readLines(2);
        while (this.rd().indexOf("xxx") < 0) {
            Atom atom = new Atom();
            this.tokens = this.getTokens();
            atom.elementSymbol = this.tokens[1];
            atom.atomName = this.tokens[1] + this.tokens[2];
            this.asc.addAtomWithMappedName(atom);
            this.setAtomCoordTokens(atom, this.tokens, 3);
        }
    }

    private void readEnergy(int pt, String prefix) throws Exception {
        if (this.isTrajectory) {
            this.applySymmetryAndSetTrajectory();
        }
        this.tokens = this.getTokens();
        try {
            Double energy = Double.parseDouble(this.tokens[pt]);
            this.asc.setAtomSetName(prefix + "Energy = " + energy + " eV");
            this.asc.setAtomSetEnergy("" + energy, energy);
            this.asc.setCurrentModelInfo("Energy", energy);
        }
        catch (Exception e) {
            this.appendLoadNote("CASTEP Energy could not be read: " + this.line);
        }
    }

    private void readPhononTrajectories() throws Exception {
        if (!this.isTS) {
            boolean bl = this.isTrajectory = this.desiredVibrationNumber <= 0;
        }
        if (this.isTrajectory) {
            this.asc.setTrajectory();
        }
        this.doApplySymmetry = true;
        while (this.line != null && this.line.contains("<-- E")) {
            boolean skip;
            boolean bl = skip = this.isTS && this.tsType != null && this.prevline.indexOf(this.tsType) < 0;
            if (!skip) {
                this.asc.newAtomSetClear(false);
                if (this.isTS) {
                    this.readEnergy(0, PT.getTokens(this.prevline + " -")[0] + " ");
                }
                this.discardLinesUntilContains("<-- h");
                this.setSpaceGroupName("P1");
                this.abc = this.read3Vectors(true);
                this.setLatticeVectors();
                this.setFractionalCoordinates(false);
                this.discardLinesUntilContains("<-- R");
                while (this.line != null && this.line.contains("<-- R")) {
                    this.tokens = this.getTokens();
                    this.setAtomCoordScaled(null, (String[])this.tokens, (int)2, (double)0.5291772).elementSymbol = this.tokens[0];
                    this.rd();
                }
                this.applySymmetryAndSetTrajectory();
            }
            this.discardLinesUntilContains("<-- E");
        }
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        if (this.isPhonon || this.isOutput || this.isTS) {
            this.isTrajectory = false;
        } else {
            this.doApplySymmetry = true;
            this.setLatticeVectors();
            int nAtoms = this.asc.ac;
            for (int i = 0; i < nAtoms; ++i) {
                this.setAtomCoord(this.asc.atoms[i]);
            }
        }
        this.finalizeReaderASCR();
    }

    private void setLatticeVectors() {
        if (this.abc[0] == null) {
            this.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
            return;
        }
        double[] lv = new double[3];
        for (int i = 0; i < 3; ++i) {
            lv[0] = this.abc[i].x;
            lv[1] = this.abc[i].y;
            lv[2] = this.abc[i].z;
            this.addExplicitLatticeVector(i, lv, 0);
        }
    }

    private void readLatticeAbc() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        double factor = this.readLengthUnit(this.tokens[0]);
        if (this.tokens.length < 3) {
            Logger.warn("error reading a,b,c in %BLOCK LATTICE_ABC in CASTEP .cell file");
            return;
        }
        this.a = this.parseCalcStr(this.tokens[0]) * factor;
        this.b = this.parseCalcStr(this.tokens[1]) * factor;
        this.c = this.parseCalcStr(this.tokens[2]) * factor;
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        if (this.tokens.length >= 3) {
            this.alpha = this.parseCalcStr(this.tokens[0]);
            this.beta = this.parseCalcStr(this.tokens[1]);
            this.gamma = this.parseCalcStr(this.tokens[2]);
        } else {
            Logger.warn("error reading alpha,beta,gamma in %BLOCK LATTICE_ABC in CASTEP .cell file");
        }
    }

    private void readLatticeCart() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        double factor = this.readLengthUnit(this.tokens[0]);
        this.lattTr = new M3d();
        for (int i = 0; i < 3; ++i) {
            if (this.tokens.length < 3) {
                Logger.warn("error reading coordinates of lattice vector " + Integer.toString(i + 1) + " in %BLOCK LATTICE_CART in CASTEP .cell file");
                return;
            }
            double x = this.parseCalcStr(this.tokens[0]) * factor;
            double y = this.parseCalcStr(this.tokens[1]) * factor;
            double z = this.parseCalcStr(this.tokens[2]) * factor;
            this.abc[i] = V3d.new3(x, y, z);
            this.lattTr.setColumnV(i, this.abc[i]);
            if (this.tokenizeCastepCell() != 0) continue;
            return;
        }
        this.a = this.abc[0].length();
        this.b = this.abc[1].length();
        this.c = this.abc[2].length();
        this.alpha = this.abc[1].angle(this.abc[2]) * 57.29577951308232;
        this.beta = this.abc[2].angle(this.abc[0]) * 57.29577951308232;
        this.gamma = this.abc[0].angle(this.abc[1]) * 57.29577951308232;
    }

    private double parseCalcStr(String s) {
        String p;
        int i;
        String[] parts;
        double d = PT.parseDoubleStrict(s);
        if (!Double.isNaN(d)) {
            return d;
        }
        if ((s = s.toLowerCase()).indexOf(40) >= 0) {
            parts = PT.split(s, "(");
            i = parts.length - 1;
            while (--i >= 0) {
                p = parts[i];
                String f = null;
                int j = functions.length;
                while (--j >= 0) {
                    if (!p.endsWith(functions[j])) continue;
                    f = functions[j];
                    break;
                }
                if (f != null) continue;
                System.err.println("Unrecognized function " + s);
                int n = i;
                parts[n] = parts[n] + "?";
            }
            s = PT.join(parts, '(', 0);
        }
        if (s.indexOf(47) >= 0) {
            parts = PT.split(s, "/");
            i = parts.length - 1;
            while (--i >= 0) {
                p = parts[i];
                boolean haveDecimal = false;
                boolean haveDigit = false;
                int j = p.length();
                while (--j >= 0) {
                    char c = p.charAt(j);
                    if (c == '.') {
                        haveDecimal = true;
                        break;
                    }
                    if (!PT.isDigit(c)) break;
                    haveDigit = true;
                }
                if (!haveDigit || haveDecimal) continue;
                int n = i;
                parts[n] = parts[n] + ".";
            }
            s = PT.join(parts, '/', 0);
        }
        return this.vwr.evaluateExpressionAsVariable(s).asDouble();
    }

    private void readPositionsFrac() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        this.readAtomData(1.0);
    }

    private void readPositionsAbs() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        double factor = this.readLengthUnit(this.tokens[0]);
        this.readAtomData(factor);
    }

    private double readLengthUnit(String units) throws Exception {
        double factor = 1.0;
        for (int i = 0; i < lengthUnitIds.length; ++i) {
            if (!units.equalsIgnoreCase(lengthUnitIds[i])) continue;
            factor = lengthUnitFactors[i];
            this.tokenizeCastepCell();
            break;
        }
        return factor;
    }

    private void readAtomData(double factor) throws Exception {
        do {
            if (this.tokens.length >= 4) {
                Atom atom = this.asc.addNewAtom();
                int pt = this.tokens[0].indexOf(":");
                if (pt >= 0) {
                    atom.elementSymbol = this.tokens[0].substring(0, pt);
                    atom.atomName = this.tokens[0];
                } else {
                    atom.elementSymbol = this.tokens[0];
                }
                atom.set(this.parseCalcStr(this.tokens[1]), this.parseCalcStr(this.tokens[2]), this.parseCalcStr(this.tokens[3]));
                atom.scale(factor);
                continue;
            }
            Logger.warn("cannot read line with CASTEP atom data: " + this.line);
        } while (this.tokenizeCastepCell() > 0 && !this.tokens[0].equalsIgnoreCase("%ENDBLOCK"));
    }

    private int tokenizeCastepCell() throws Exception {
        int n;
        while (this.rd() != null) {
            this.line = this.line.trim();
            if (this.line.length() == 0 || this.line.startsWith("#") || this.line.startsWith("!")) continue;
            if (this.isCell) break;
            if (this.line.startsWith("%")) {
                this.isCell = true;
                break;
            }
            if (this.line.startsWith("LST")) {
                this.isTS = true;
                Logger.info("reading CASTEP .ts file");
                return -1;
            }
            if (this.line.startsWith("BEGIN header")) {
                this.isPhonon = true;
                Logger.info("reading CASTEP .phonon file");
                return -1;
            }
            if (!this.line.contains("CASTEP")) break;
            this.isOutput = true;
            Logger.info("reading CASTEP .castep file");
            return -1;
        }
        if (this.line == null) {
            n = 0;
        } else {
            this.tokens = this.getTokens();
            n = this.tokens.length;
        }
        return n;
    }

    private void readOutputBornChargeTensors() throws Exception {
        if (this.rd().indexOf("--------") < 0) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        this.appendLoadNote("Ellipsoids: Born Charge Tensors");
        while (this.rd().indexOf(61) < 0) {
            this.getTensor(atoms[this.readOutputAtomIndex()], this.line.substring(12));
        }
    }

    private int readOutputAtomIndex() {
        this.tokens = this.getTokens();
        return this.asc.getAtomIndex(this.tokens[0] + this.tokens[1]);
    }

    private void getTensor(Atom atom, String line0) throws Exception {
        line0 = line0 + this.rd() + this.rd();
        Logger.info("tensor " + atom.atomName + " " + line0);
        double[][] a = this.fill3x3(PT.getTokens(line0), 0);
        atom.addTensor(new Tensor().setFromAsymmetricTensor(a, "charge", atom.atomName + " " + line0), null, false);
        if (!this.haveCharges) {
            this.appendLoadNote("Ellipsoids set \"charge\": Born Effective Charges");
        }
        this.haveCharges = true;
    }

    private void readOutputCharges() throws Exception {
        double[] spins;
        if (this.line.toUpperCase().indexOf(this.chargeType) < 0) {
            return;
        }
        Logger.info("reading charges: " + this.line);
        this.readLines(2);
        boolean haveSpin = this.line.indexOf("Spin") >= 0;
        this.rd();
        Atom[] atoms = this.asc.atoms;
        double[] dArray = spins = haveSpin ? new double[atoms.length] : null;
        if (spins != null) {
            for (int i = 0; i < spins.length; ++i) {
                spins[i] = 0.0;
            }
        }
        while (this.rd() != null && this.line.indexOf(61) < 0) {
            double charge;
            int index = this.readOutputAtomIndex();
            atoms[index].partialCharge = charge = this.parseDoubleStr(this.tokens[haveSpin ? this.tokens.length - 2 : this.tokens.length - 1]);
            if (!haveSpin) continue;
            spins[index] = this.parseDoubleStr(this.tokens[this.tokens.length - 1]);
        }
        if (haveSpin) {
            this.asc.setAtomProperties("spin", spins, -1, false);
        }
    }

    private void readPhononUnitCell() throws Exception {
        this.abc = this.read3Vectors(this.line.indexOf("bohr") >= 0);
        this.setSpaceGroupName("P1");
        this.setLatticeVectors();
    }

    private void readPhononFractionalCoord() throws Exception {
        this.setFractionalCoordinates(true);
        while (this.rd() != null && this.line.indexOf("END") < 0) {
            this.tokens = this.getTokens();
            this.addAtomXYZSymName((String[])this.tokens, (int)1, (String)this.tokens[4], null).bfactor = this.parseDoubleStr(this.tokens[5]);
        }
        this.ac = this.asc.ac;
        this.atomPts = new P3d[this.ac];
        Atom[] atoms = this.asc.atoms;
        for (int i = 0; i < this.ac; ++i) {
            this.atomPts[i] = P3d.newP(atoms[i]);
        }
    }

    private void readPhononFrequencies() throws Exception {
        this.tokens = this.getTokens();
        V3d v = new V3d();
        V3d qvec = V3d.new3(this.parseDoubleStr(this.tokens[2]), this.parseDoubleStr(this.tokens[3]), this.parseDoubleStr(this.tokens[4]));
        String fcoord = this.getFractionalCoord(qvec);
        String qtoks = "{" + this.tokens[2] + " " + this.tokens[3] + " " + this.tokens[4] + "}";
        fcoord = fcoord == null ? qtoks : "{" + fcoord + "}";
        boolean isOK = this.isAllQ;
        boolean isSecond = this.tokens[1].equals(this.lastQPt);
        this.qpt2 = isSecond ? this.qpt2 + 1 : 1;
        this.lastQPt = this.tokens[1];
        if (!isOK && this.checkFilterKey("Q=")) {
            if (this.desiredQpt != null) {
                v.sub2(this.desiredQpt, qvec);
                if (v.length() < (double)0.001f) {
                    fcoord = this.desiredQ;
                }
            }
            boolean bl = isOK = this.checkFilterKey("Q=" + fcoord + "." + this.qpt2 + ";") || this.checkFilterKey("Q=" + this.lastQPt + "." + this.qpt2 + ";") || !isSecond && this.checkFilterKey("Q=" + fcoord + ";") || !isSecond && this.checkFilterKey("Q=" + this.lastQPt + ";");
            if (!isOK) {
                return;
            }
        }
        boolean isGammaPoint = qvec.length() == 0.0;
        double nx = 1.0;
        double ny = 1.0;
        double nz = 1.0;
        if (this.ptSupercell != null && !isOK && !isSecond) {
            this.matSupercell = new M4d();
            this.matSupercell.m00 = this.ptSupercell.x;
            this.matSupercell.m11 = this.ptSupercell.y;
            this.matSupercell.m22 = this.ptSupercell.z;
            this.matSupercell.m33 = 1.0;
            Logger.info("Using supercell \n" + this.matSupercell);
            nx = this.ptSupercell.x;
            ny = this.ptSupercell.y;
            nz = this.ptSupercell.z;
            double dx = (qvec.x == 0.0 ? 1.0 : qvec.x) * nx;
            double dy = (qvec.y == 0.0 ? 1.0 : qvec.y) * ny;
            double dz = (qvec.z == 0.0 ? 1.0 : qvec.z) * nz;
            if ((nx != 1.0 || ny != 1.0 || nz != 1.0) && isGammaPoint || !CastepReader.isInt(dx) || !CastepReader.isInt(dy) || !CastepReader.isInt(dz)) {
                return;
            }
            isOK = true;
        }
        if (this.ptSupercell == null || !this.havePhonons) {
            this.appendLoadNote(this.line);
        }
        if (!isOK && isSecond) {
            return;
        }
        if (!isOK && this.ptSupercell == null == !isGammaPoint) {
            return;
        }
        if (this.havePhonons && !this.isAllQ) {
            return;
        }
        this.havePhonons = true;
        String qname = "q=" + this.lastQPt + " " + fcoord;
        this.applySymmetryAndSetTrajectory();
        if (isGammaPoint) {
            qvec = null;
        }
        Lst<Double> freqs = new Lst<Double>();
        while (this.rd() != null && this.line.indexOf("Phonon") < 0) {
            this.tokens = this.getTokens();
            freqs.addLast(this.parseDoubleStr(this.tokens[1]));
        }
        this.rd();
        int frequencyCount = freqs.size();
        double[] data = new double[8];
        V3d td = new V3d();
        this.asc.setCollectionName(qname);
        for (int i = 0; i < frequencyCount; ++i) {
            if (!this.doGetVibration(++this.vibrationNumber)) {
                for (int j = 0; j < this.ac; ++j) {
                    this.rd();
                }
                continue;
            }
            if (this.desiredVibrationNumber <= 0 && !this.isTrajectory) {
                this.cloneLastAtomSet(this.ac, this.atomPts);
                this.applySymmetryAndSetTrajectory();
            }
            this.symmetry = this.asc.getSymmetry();
            int iatom = this.asc.getLastAtomSetAtomIndex();
            double freq = (Double)freqs.get(i);
            Atom[] atoms = this.asc.atoms;
            int aCount = this.asc.ac;
            for (int j = 0; j < this.ac; ++j) {
                this.fillDoubleArray(null, 0, data);
                for (int k = iatom++; k < aCount; ++k) {
                    if (atoms[k].atomSite != j) continue;
                    td.sub2(atoms[k], atoms[atoms[k].atomSite]);
                    if (this.matSupercell != null) {
                        this.matSupercell.rotTrans(td);
                    }
                    this.setPhononVector(data, atoms[k], td, qvec, v);
                    this.asc.addVibrationVectorWithSymmetry(k, v.x, v.y, v.z, true);
                }
            }
            if (this.isTrajectory) {
                this.asc.setTrajectory();
            }
            this.asc.setAtomSetFrequency(this.vibrationNumber, null, null, "" + freq, null);
            this.asc.setAtomSetName(DF.formatDecimal(freq, 2) + " cm-1 " + qname);
        }
    }

    private String getFractionalCoord(V3d qvec) {
        return this.symmetry != null && CastepReader.isInt(qvec.x * 12.0) && CastepReader.isInt(qvec.y * 12.0) && CastepReader.isInt(qvec.z * 12.0) ? this.symmetry.fcoord(qvec) : null;
    }

    private static boolean isInt(double f) {
        return Math.abs(f - (double)Math.round(f)) < (double)0.001f;
    }

    private void setPhononVector(double[] data, Atom atom, V3d rTrans, V3d qvec, V3d v) {
        if (qvec == null) {
            v.set(data[2], data[4], data[6]);
        } else {
            double phase = qvec.x * rTrans.x + qvec.y * rTrans.y + qvec.z * rTrans.z;
            double cosph = Math.cos(Math.PI * 2 * phase);
            double sinph = Math.sin(Math.PI * 2 * phase);
            v.x = cosph * data[2] - sinph * data[3];
            v.y = cosph * data[4] - sinph * data[5];
            v.z = cosph * data[6] - sinph * data[7];
        }
        v.scale(Math.sqrt(1.0 / atom.bfactor));
    }
}

