/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;

public class JmeReader
extends AtomSetCollectionReader {
    @Override
    public void initializeReader() throws Exception {
        this.asc.setCollectionName("JME");
        this.asc.newAtomSet();
        this.line = this.rd().replace('\t', ' ');
        this.checkCurrentLineForScript();
        this.addJmolScript("jmeString='" + this.line + "'");
        int ac = this.parseInt();
        int bondCount = this.parseInt();
        this.readAtoms(ac);
        this.readBonds(bondCount);
        if (this.asc.ac == 0 && this.line.equals("0") && !this.merging) {
            Atom atom = this.asc.addNewAtom();
            this.setAtomCoordXYZ(atom, Double.NaN, Double.NaN, 0.0);
            this.addJmolScript("delete thisModel");
        } else {
            this.set2D();
        }
        this.continuing = false;
    }

    private void readAtoms(int ac) throws Exception {
        for (int i = 0; i < ac; ++i) {
            String elementSymbol;
            String strAtom = this.parseToken();
            Atom atom = this.asc.addNewAtom();
            this.setAtomCoordXYZ(atom, this.parseDouble(), this.parseDouble(), 0.0);
            int indexColon = strAtom.indexOf(58);
            String string = elementSymbol = indexColon > 0 ? strAtom.substring(0, indexColon) : strAtom;
            if (elementSymbol.indexOf("+") >= 0) {
                elementSymbol = PT.trim(elementSymbol, "+");
                atom.formalCharge = 1;
            } else if (elementSymbol.indexOf("-") >= 0) {
                elementSymbol = PT.trim(elementSymbol, "-");
                atom.formalCharge = -1;
            }
            atom.elementSymbol = elementSymbol;
        }
        if (ac > 0) {
            this.asc.setModelInfoForSet("dimension", "2D", this.asc.iSet);
        }
    }

    private void readBonds(int bondCount) throws Exception {
        block5: for (int i = 0; i < bondCount; ++i) {
            int atomIndex1 = this.parseInt() - 1;
            int atomIndex2 = this.parseInt() - 1;
            int order = this.parseInt();
            switch (order) {
                default: {
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case -1: {
                    order = 1025;
                    break;
                }
                case -2: {
                    order = 1041;
                }
            }
            this.asc.addBond(new Bond(atomIndex1, atomIndex2, order));
        }
    }
}

