/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import java.io.BufferedReader;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class FAHReader
extends AtomSetCollectionReader {
    double factor = 1.0;
    int[] pt = new int[1];
    private BufferedReader readerSave;
    private String units;
    static final String note = " -- FAH:: is required for Frame files but not the Top file.\n -- automatic calculation of structure using DSSP\n -- Both files are required; three load options:\n    \n    LOAD FILES \"ViewerTop.json\" + \"ViewerFrame22.json\" // explicit joining to two files\n    \n    LOAD ViewerTop.json; \n    LOAD XYZ FAH::ViewerFrame22.json   // first the atoms, then the coordinates\n    \n    LOAD FAH::ViewerFrame22.json        // just the coordinates with associated ViewerTop.json assumed present\n    \n -- Subsequent calls to LOAD XYZ will replace coordinates and recalculate DSSP only.\n\n    LOAD ViewerTop.json; \n    LOAD XYZ FAH::ViewerFrame0.json \n    delay 1.0\n    LOAD XYZ FAH::ViewerFrame22.json \n \n";

    @Override
    protected void initializeReader() {
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.asc.setNoAutoBond();
        this.setModelPDB(true);
        this.finalizeReaderASCR();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith("{")) {
            return this.readTopAtomsAndBonds();
        }
        if (this.line.startsWith("[")) {
            return this.readVnnCoords();
        }
        return true;
    }

    boolean readTopAtomsAndBonds() throws Exception {
        if (this.readerSave == null) {
            this.appendLoadNote(note);
        }
        this.discardLinesUntilContains("\"");
        if (this.line.indexOf("units") >= 0) {
            this.pt[0] = this.line.indexOf(":");
            this.units = PT.getQuotedStringNext(this.line, this.pt);
            if (this.units != null && (this.units.equalsIgnoreCase("NM") || this.units.toUpperCase().indexOf("NANOMETER") >= 0)) {
                this.factor = 0.1;
            }
            Logger.info("FAHReader units are " + this.units + " factor = " + this.factor);
        }
        this.discardLinesUntilContains("atoms");
        int index = 0;
        while (this.rd() != null) {
            String[] tokens = this.getTokens();
            this.pt[0] = 0;
            String name = PT.getQuotedStringNext(tokens[0], this.pt);
            this.pt[0] = 0;
            String group = PT.getQuotedStringNext(tokens[5], this.pt);
            int elemNo = this.parseIntStr(tokens[4]);
            Atom atom = new Atom();
            atom.elementNumber = (short)elemNo;
            atom.atomName = name;
            atom.group3 = group;
            atom.set(0.0, 0.0, index++);
            this.asc.addAtom(atom);
            if (!this.line.trim().endsWith("]")) continue;
            break;
        }
        this.discardLinesUntilContains("bonds");
        while (this.rd() != null) {
            this.pt[0] = this.line.indexOf("[") + 1;
            int a = PT.parseIntNext(this.line, this.pt);
            this.pt[0] = this.line.indexOf(",") + 1;
            int b = PT.parseIntNext(this.line, this.pt);
            this.asc.addBond(new Bond(a, b, 1));
            if (!this.line.trim().endsWith("]")) continue;
            break;
        }
        Logger.info("FAHReader " + this.asc.ac + " top atoms read");
        this.rd();
        this.rd();
        return true;
    }

    private boolean readVnnCoords() throws Exception {
        int iatom = 0;
        if (this.asc.ac == 0 && this.readerSave == null && !"xyz".equals(this.htParams.get("dataType"))) {
            this.getTopData();
        }
        Atom[] atoms = this.asc.atoms;
        int atomCount = this.asc.ac;
        while (this.rd() != null) {
            this.pt[0] = 0;
            this.line = this.line.trim();
            String[] tokens = this.line.substring(1, this.line.length() - 1).split(",");
            double x = this.parseDoubleStr(tokens[0]) * this.factor;
            double y = this.parseDoubleStr(tokens[1]) * this.factor;
            double z = this.parseDoubleStr(tokens[2]) * this.factor;
            Atom atom = iatom >= atomCount ? this.asc.addAtom(new Atom()) : atoms[iatom];
            atom.set(x, y, z);
            ++iatom;
            if (!this.line.trim().endsWith("]")) continue;
            break;
        }
        Logger.info("FAHReader " + iatom + " atom coordinates read");
        if (!this.checkBondlengths()) {
            this.checkBondlengths();
        }
        this.rd();
        return true;
    }

    private boolean checkBondlengths() {
        double d = 1.0;
        if (this.asc.bondCount > 0) {
            Bond b = this.asc.bonds[0];
            d = this.asc.atoms[b.atomIndex1].distance(this.asc.atoms[b.atomIndex2]);
        } else {
            int i = Math.min(this.asc.ac, 10);
            while (--i >= 0) {
                int j = i;
                while (--j >= 0) {
                    d = Math.min(d, this.asc.atoms[i].distance(this.asc.atoms[j]));
                }
            }
        }
        if (d < 0.5) {
            int i = this.asc.ac;
            while (--i >= 0) {
                this.asc.atoms[i].scale(10.0);
            }
            String msg = "FAHReader CORRECTION: Top.json file units=" + this.units + "\n but we found NANOMETERS based on\n " + (this.asc.bondCount > 0 ? "bonds[0].length" : "shortest distance among first 10 atoms") + "=" + d;
            this.appendLoadNote(msg);
            return false;
        }
        return true;
    }

    private void getTopData() {
        boolean isError;
        String fileName = this.filePath;
        int pt = fileName.lastIndexOf(".");
        if (pt < 0) {
            pt = fileName.length();
        }
        int ptv = fileName.lastIndexOf("Frame", pt);
        fileName = fileName.substring(0, ptv) + "Top" + fileName.substring(pt);
        String data = this.vwr.getFileAsString3(fileName, false, null);
        Logger.info("FAHReader " + data.length() + " bytes read from " + fileName);
        boolean bl = isError = data.indexOf("\"atoms\"") < 0;
        if (isError) {
            Logger.error("FAHReader " + fileName + "was not found");
        } else {
            this.readerSave = this.reader;
            this.reader = Rdr.getBR(data);
            try {
                this.rd();
                this.checkLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.reader = this.readerSave;
        }
    }
}

