/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.derived;

import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.core.IFDAssociation;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.dataobject.IFDDataObject;
import org.iupac.fairdata.dataobject.IFDDataObjectCollection;
import org.iupac.fairdata.structure.IFDStructure;
import org.iupac.fairdata.structure.IFDStructureCollection;

public class IFDStructureDataAssociation
extends IFDAssociation {
    private static final int ITEM_STRUC = 0;
    private static final int ITEM_DATA = 1;
    private static final String sdaPrefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_STRUCTUREDATA_ASSOCIATION_FLAG);

    @Override
    protected String getIFDPropertyPrefix() {
        return sdaPrefix;
    }

    protected IFDStructureDataAssociation(IFDCollection[] collection) throws IFDException {
        super(null, collection);
    }

    public IFDStructureDataAssociation() throws IFDException {
        this(new IFDCollection[]{new IFDStructureCollection(), new IFDDataObjectCollection()});
    }

    public IFDStructureDataAssociation(IFDStructure structure, IFDDataObject data) throws IFDException {
        this(new IFDStructureCollection(structure), new IFDDataObjectCollection(data));
    }

    public IFDStructureDataAssociation(IFDStructureCollection structureCollection, IFDDataObjectCollection dataCollection) throws IFDException {
        super(null, structureCollection, dataCollection);
    }

    public IFDStructureCollection getStructureCollection() {
        return (IFDStructureCollection)this.get(0);
    }

    public IFDDataObjectCollection getDataObjectCollection() {
        return (IFDDataObjectCollection)this.get(1);
    }

    public IFDStructure getStructure(int i) {
        return (IFDStructure)this.getStructureCollection().get(i);
    }

    public IFDDataObject getDataObject(int i) {
        return (IFDDataObject)this.getDataObjectCollection().get(i);
    }

    public boolean addStructure(IFDStructure struc) {
        return this.getStructureCollection().add(struc);
    }

    public boolean addDataObject(IFDDataObject data) {
        return this.getDataObjectCollection().add(data);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IFDStructureDataAssociation)) {
            return false;
        }
        IFDStructureDataAssociation ss = (IFDStructureDataAssociation)o;
        return ((IFDCollection)ss.get(0)).equals(this.get(0)) && ((IFDCollection)ss.get(1)).equals(this.get(1));
    }
}

