/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import org.iupac.fairdata.api.IFDSerializableI;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDReference;

public abstract class IFDRepresentation
implements IFDSerializableI {
    private String representationType;
    private IFDReference ref;
    private Object data;
    private long len;
    private String mediaType;
    private String note;

    public IFDRepresentation(IFDReference ref, Object data, long len, String type, String subtype) {
        this.ref = ref;
        this.data = data;
        this.len = data instanceof String ? (long)((String)data).length() : (data instanceof byte[] ? (long)((byte[])data).length : (ref != null || len != 0L ? len : 0L));
        this.representationType = type;
        this.mediaType = subtype;
    }

    public IFDRepresentation(IFDRepresentation rep) {
        this(rep.getRef(), rep.getData(), rep.getLength(), rep.getType(), rep.getMediaType());
    }

    public String getType() {
        return this.representationType;
    }

    public void setType(String type) {
        this.representationType = type;
    }

    public void setRef(IFDReference ref) {
        this.ref = ref;
    }

    public IFDReference getRef() {
        return this.ref;
    }

    public Object getData() {
        return this.data;
    }

    public void setLength(long len) {
        this.len = len;
    }

    public long getLength() {
        return this.len;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String toString() {
        return "[IFDRepresentation type=" + this.representationType + " ref=" + this.ref + "]";
    }

    @Override
    public String getSerializedType() {
        return this.representationType;
    }

    @Override
    public void serialize(IFDSerializerI serializer) {
        IFDObject.serializeClass(serializer, this.getClass(), null);
        serializer.addAttr("representationType", this.representationType == null ? "unknown" : this.representationType);
        if (this.mediaType != null && !this.mediaType.equals(this.representationType)) {
            serializer.addAttr("mediaType", this.mediaType);
        }
        serializer.addAttrInt("len", (int)this.len);
        if (this.ref != null) {
            serializer.addObject("ref", this.ref);
        }
        if (this.data != null) {
            serializer.addObject("data", this.data);
        }
        if (this.note != null) {
            serializer.addObject("note", this.note);
        }
    }

    public void setNote(String note) {
        this.note = this.note == null ? note : this.note + ";\n" + note;
    }

    public void setInSitu() {
        if (this.data != null && this.ref == null) {
            return;
        }
        if (this.ref.checkInSitu()) {
            this.data = null;
        }
    }
}

