/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDCollectionSet;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDProperty;
import org.iupac.fairdata.core.IFDResource;

public class IFDFindingAid
extends IFDObject<IFDObject<?>> {
    private static String propertyPrefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_FINDINGAID_FLAG);
    protected IFDCollectionSet collectionSet;
    protected List<Map<String, Object>> relatedItems;
    protected List<IFDResource> resources = new ArrayList<IFDResource>();
    protected Date date = new Date();
    protected String creator;
    protected boolean serializing;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");

    @Override
    protected String getIFDPropertyPrefix() {
        return propertyPrefix;
    }

    public IFDFindingAid(String label, String type, String creator, IFDCollectionSet collection) throws IFDException {
        super(label, type, 1, collection == null ? new IFDCollectionSet(null) : collection);
        this.creator = creator;
        this.collectionSet = (IFDCollectionSet)this.get(0);
    }

    public void setCollectionSet(IFDCollectionSet set) {
        this.collectionSet = set;
        this.set(0, this.collectionSet);
    }

    public IFDCollectionSet getCollectionSet() {
        return this.collectionSet;
    }

    public void addCollection(IFDCollection c) {
        this.collectionSet.add(c);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public List<IFDResource> getSources() {
        return this.resources;
    }

    public IFDResource addOrSetResource(String ref, String rootPath) {
        IFDResource r;
        int i = this.resources.size();
        while (--i >= 0) {
            r = this.resources.get(i);
            if (!r.getRef().equals(ref)) continue;
            return r;
        }
        r = new IFDResource(ref, rootPath, "" + (this.resources.size() + 1), 0L);
        this.resources.add(r);
        return r;
    }

    public List<IFDResource> getResources() {
        return this.resources;
    }

    public Date getDate() {
        return this.date;
    }

    public void finalizeCollectionSet(Map<String, Map<String, Object>> htURLReferences) {
        this.collectionSet.finalizeCollections(htURLReferences);
    }

    @Override
    public IFDProperty setPropertyValue(String label, Object value) {
        if (label.startsWith(IFDConst.IFD_FINDINGAID_FLAG)) {
            return super.setPropertyValue(label, value);
        }
        return this.collectionSet.setPropertyValue(label, value);
    }

    @Override
    public Object getPropertyValue(String label) {
        if (label.startsWith(IFDConst.IFD_FINDINGAID_FLAG)) {
            return super.getPropertyValue(label);
        }
        return this.collectionSet.getPropertyValue(label);
    }

    public String getVersion() {
        return IFDConst.getVersion();
    }

    protected Map<String, Object> getContentsMap(Map<String, Object> map) {
        if (this.relatedItems != null && this.relatedItems.size() > 0) {
            map.put("relatedCount", this.relatedItems.size());
        }
        map.put("resourceCount", this.resources.size());
        this.collectionSet.getContents(map);
        return map;
    }

    public void setRelatedTo(List<Map<String, Object>> citationMap) {
        this.relatedItems = citationMap;
    }

    @Override
    protected void serializeList(IFDSerializerI serializer) {
        serializer.serialize(this.collectionSet);
        this.collectionSet.serialize(serializer);
    }

    @Override
    public void serialize(IFDSerializerI serializer) {
        if (this.serializing) {
            this.serializeTop(serializer);
            serializer.addObject("version", this.getVersion());
            serializer.addObject("created", df.format(this.date));
            if (this.getCreator() != null) {
                serializer.addObject("createdBy", this.getCreator());
            }
            serializer.addObject("contents", this.getContentsMap(new TreeMap<String, Object>()));
            if (this.relatedItems != null) {
                serializer.addObject("relatedItems", this.relatedItems);
            }
            Object o = this.resources;
            if (serializer.isByID()) {
                LinkedHashMap<String, IFDResource> map = new LinkedHashMap<String, IFDResource>();
                for (int i = 0; i < this.resources.size(); ++i) {
                    IFDResource r = this.resources.get(i);
                    map.put(r.getID(), r);
                }
                o = map;
            }
            serializer.addObject("resources", o);
            this.serializeProps(serializer);
            if (this.collectionSet != null) {
                serializer.addObject("collectionSet", this.collectionSet);
            }
        } else {
            this.serializing = true;
            serializer.addObject(IFDConst.IFD_FINDINGAID, this);
            this.serializing = false;
        }
    }

    static {
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

