/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.util.ArrayList;
import java.util.List;
import org.iupac.fairdata.api.IFDSerializableI;
import org.iupac.fairdata.api.IFDSerializerI;

public class IFDAttribute
implements IFDSerializableI,
Comparable<IFDAttribute> {
    private final String name;
    private Object value;
    private List<Object> values;

    public IFDAttribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.values == null ? this.value : this.values;
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public String getSerializedType() {
        return "IFDAttribute";
    }

    public static void add(List<IFDAttribute> params, String name, Object value) {
        if (value == null || name == null) {
            return;
        }
        IFDAttribute p = null;
        int i = params.size();
        while (--i >= 0) {
            p = params.get(i);
            if (!p.name.equals(name) || (p.values == null ? p.value.equals(value) : p.values.contains(value))) continue;
            if (p.values == null) {
                p.values = new ArrayList<Object>();
                p.values.add(p.value);
                p.value = null;
            }
            p.values.add(value);
            return;
        }
        params.add(new IFDAttribute(name, value));
    }

    public static void remove(List<IFDAttribute> params, String name) {
        if (name == null) {
            return;
        }
        int i = params.size();
        while (--i >= 0) {
            if (!params.get((int)i).name.equals(name)) continue;
            params.remove(i);
            return;
        }
    }

    public static boolean remove(List<IFDAttribute> params, String name, Object value) {
        if (name == null) {
            return false;
        }
        int i = params.size();
        while (--i >= 0) {
            if (!params.get((int)i).name.equals(name)) continue;
            IFDAttribute p = params.get(i);
            if (value == null || value.equals(p.value)) {
                params.remove(i);
                return true;
            }
            if (p.values == null || !p.values.contains(value)) break;
            p.values.remove(value);
            switch (p.values.size()) {
                case 1: {
                    p.value = p.values.get(0);
                    p.values = null;
                    break;
                }
                case 0: {
                    params.remove(i);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(IFDAttribute o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public void serialize(IFDSerializerI serializer) {
    }

    public String toString() {
        return this.getValue() == null ? "" : "[IFDParam " + this.name + "=" + this.value + "]";
    }
}

