/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.contrib.fairspec;

import com.integratedgraphics.extractor.DOIInfoExtractor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundAssociation;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundCollection;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAid;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAidHelperI;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.contrib.fairspec.dataobject.FAIRSpecDataObject;
import org.iupac.fairdata.core.IFDAssociation;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDCollectionSet;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDReference;
import org.iupac.fairdata.core.IFDRepresentableObject;
import org.iupac.fairdata.core.IFDRepresentation;
import org.iupac.fairdata.core.IFDResource;
import org.iupac.fairdata.dataobject.IFDDataObject;
import org.iupac.fairdata.dataobject.IFDDataObjectCollection;
import org.iupac.fairdata.dataobject.IFDDataObjectRepresentation;
import org.iupac.fairdata.derived.IFDSampleDataAssociation;
import org.iupac.fairdata.derived.IFDSampleDataAssociationCollection;
import org.iupac.fairdata.derived.IFDSampleStructureAssociation;
import org.iupac.fairdata.derived.IFDSampleStructureAssociationCollection;
import org.iupac.fairdata.derived.IFDStructureDataAnalysisCollection;
import org.iupac.fairdata.derived.IFDStructureDataAssociation;
import org.iupac.fairdata.sample.IFDSample;
import org.iupac.fairdata.sample.IFDSampleCollection;
import org.iupac.fairdata.structure.IFDStructure;
import org.iupac.fairdata.structure.IFDStructureCollection;
import org.iupac.fairdata.structure.IFDStructureRepresentation;
import org.iupac.fairdata.util.IFDDefaultJSONSerializer;

public class FAIRSpecFindingAidHelper
implements FAIRSpecFindingAidHelperI {
    public static final int SAMPLE_COLLECTION = 0;
    public static final int STRUCTURE_COLLECTION = 1;
    public static final int DATA_COLLECTION = 2;
    public static final int SAMPLE_STRUCTURE_COLLECTION = 0;
    public static final int SAMPLE_DATA_COLLECTION = 1;
    public static final int STRUCTURE_DATA_COLLECTION = 2;
    public static final int SAMPLE_DATA_ANALYSIS_COLLECTION = 3;
    public static final int STRUCTURE_DATA_ANALYSIS_COLLECTION = 4;
    protected FAIRSpecFindingAid findingAid;
    protected IFDStructureCollection structureCollection;
    protected IFDDataObjectCollection dataObjectCollection;
    protected FAIRSpecCompoundCollection compoundCollection;
    protected IFDStructureDataAnalysisCollection structureDataAnalysisCollection;
    protected IFDSampleCollection sampleCollection;
    protected IFDSampleDataAssociationCollection sampleDataCollection;
    protected IFDSampleStructureAssociationCollection sampleStructureCollection;
    protected IFDStructure currentStructure;
    protected IFDDataObject currentDataObject;
    protected IFDAssociation currentAssociation;
    protected IFDSample currentSample;
    protected IFDResource currentResource;
    protected IFDCollection[] objects = new IFDCollection[3];
    protected IFDCollection[] associations = new IFDCollection[5];
    private FAIRSpecCompoundAssociation thisCompound;
    protected boolean byId;

    public FAIRSpecFindingAidHelper(String creator) {
        try {
            this.findingAid = new FAIRSpecFindingAid(null, null, creator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setById(boolean tf) {
        this.byId = tf;
    }

    public IFDStructure getCurrentStructure() {
        return this.currentStructure;
    }

    public void setCurrentStructure(IFDStructure struc) {
        this.currentStructure = struc;
    }

    public IFDDataObject getCurrentSpecData() {
        return this.currentDataObject;
    }

    public void setCurrentSpecData(IFDDataObject spec) {
        this.currentDataObject = spec;
    }

    public static String getObjectTypeForPropertyOrRepresentationKey(String key, boolean allowError) throws IFDException {
        if (IFDConst.isIFDProperty(key)) {
            key = FAIRSpecUtilities.rep(key, IFDConst.IFD_PROPERTY_FLAG, "\u0000");
        } else if (IFDConst.isRepresentation(key)) {
            key = FAIRSpecUtilities.rep(key, IFDConst.IFD_REPRESENTATION_FLAG, "\u0000");
        } else if (IFDConst.isObject(key)) {
            key = FAIRSpecUtilities.rep(key, IFDConst.IFD_OBJECT_FLAG, "\u0000");
        } else {
            if (allowError) {
                return "Unknown";
            }
            throw new IFDException("bad IFD identifier: " + key);
        }
        if (key.startsWith("\u0000structure.")) {
            return "org.iupac.fairdata.structure.IFDStructure";
        }
        if (key.startsWith("\u0000sample.")) {
            return "org.iupac.fairdata.sample.IFDSample";
        }
        if (key.startsWith("\u0000fairspec.compound.")) {
            return "org.iupac.fairdata.contrib.fairspec.FAIRSpecCompound";
        }
        if (key.startsWith("\u0000association.sampledata")) {
            return "org.iupac.fairdata.derived.IFDSampleDataAssociation";
        }
        if (key.startsWith("\u0000analysis.structuredata")) {
            return "org.iupac.fairdata.derived.IFDStructureDataAnalysis";
        }
        if (key.startsWith("\u0000analysis.sampledata")) {
            return "org.iupac.fairdata.derived.IFDSampleDataAnalysis";
        }
        if (key.startsWith("\u0000dataobject.fairspec.")) {
            return key.replace('\u0000', '.').substring(0, key.indexOf(".", 21));
        }
        if (key.startsWith("\u0000dataobject.")) {
            return "org.iupac.fairdata.dataobject.IFDDataObject";
        }
        return "Unknown";
    }

    @Override
    public FAIRSpecFindingAid getFindingAid() {
        return this.findingAid;
    }

    @Override
    public String addRelatedInfo(String doi, boolean addPublicationMetadata, List<Map<String, Object>> list, String type) throws IOException {
        Map<String, Object> info = DOIInfoExtractor.getPubInfo(doi, addPublicationMetadata, type);
        if (info == null || info.get("metadataSource") == null) {
            return "Could not access " + DOIInfoExtractor.getMetadataUrl(doi, type);
        }
        list.add(info);
        this.findingAid.setRelatedTo(list);
        return null;
    }

    @Override
    public IFDDataObject cloneData(IFDDataObject localSpec, String idExtension, boolean andReplace) {
        IFDAssociation assoc;
        IFDDataObject data = this.getSpecCollection().cloneData(localSpec, idExtension, andReplace);
        if (this.compoundCollection != null) {
            for (IFDAssociation a : this.compoundCollection) {
                assoc = (IFDStructureDataAssociation)a;
                if (!((IFDStructureDataAssociation)assoc).getDataObjectCollection().contains(localSpec)) continue;
                ((IFDStructureDataAssociation)assoc).getDataObjectCollection().add(data);
            }
        }
        if (this.sampleDataCollection != null) {
            for (IFDAssociation a : this.sampleDataCollection) {
                assoc = (IFDSampleDataAssociation)a;
                if (!((IFDSampleDataAssociation)assoc).getDataObjectCollection().contains(localSpec)) continue;
                ((IFDSampleDataAssociation)assoc).getDataObjectCollection().add(data);
            }
        }
        return data;
    }

    @Override
    public IFDStructure getFirstStructureForSpec(IFDDataObject spec, boolean andRemove) {
        return (IFDStructure)this.getCompoundCollection().getFirstObj1ForObj2(spec, andRemove);
    }

    @Override
    public IFDSample getFirstSampleForSpec(IFDDataObject spec, boolean andRemove) {
        return (IFDSample)this.getSampleDataCollection().getFirstObj1ForObj2(spec, andRemove);
    }

    @Override
    public FAIRSpecCompoundAssociation createCompound(IFDStructure struc, IFDDataObject spec) throws IFDException {
        return this.getCompoundCollection().addAssociation(struc, spec);
    }

    @Override
    public FAIRSpecCompoundAssociation createCompound(String id) throws IFDException {
        FAIRSpecCompoundAssociation c = this.createCompound(null, null);
        if (id != null) {
            c.setPropertyValue(IFDConst.IFD_PROPERTY_ID, id);
        }
        this.thisCompound = c;
        this.currentAssociation = this.thisCompound;
        this.getCompoundCollection().add(c);
        this.currentStructure = null;
        this.currentDataObject = null;
        return c;
    }

    public IFDSampleCollection getSampleCollection() {
        if (this.sampleCollection == null) {
            this.sampleCollection = new IFDSampleCollection();
            this.objects[0] = this.sampleCollection;
            this.sampleCollection.setID("samples");
        }
        return this.sampleCollection;
    }

    @Override
    public IFDStructureCollection getStructureCollection() {
        if (this.structureCollection == null) {
            this.structureCollection = new IFDStructureCollection();
            this.objects[1] = this.structureCollection;
            this.structureCollection.setID("structures");
        }
        return this.structureCollection;
    }

    @Override
    public IFDDataObjectCollection getSpecCollection() {
        if (this.dataObjectCollection == null) {
            this.dataObjectCollection = new IFDDataObjectCollection();
            this.objects[2] = this.dataObjectCollection;
            this.dataObjectCollection.setID("spectra");
        }
        return this.dataObjectCollection;
    }

    public IFDSampleStructureAssociationCollection getSampleStructureCollection() {
        if (this.sampleStructureCollection == null) {
            this.sampleStructureCollection = new IFDSampleStructureAssociationCollection(this.byId);
            this.associations[0] = this.sampleStructureCollection;
            this.sampleStructureCollection.setID("sample-structure associations");
        }
        return this.sampleStructureCollection;
    }

    public IFDSampleDataAssociationCollection getSampleDataCollection() {
        if (this.sampleDataCollection == null) {
            this.sampleDataCollection = new IFDSampleDataAssociationCollection(this.byId);
            this.associations[1] = this.sampleDataCollection;
            this.sampleDataCollection.setID("sample-spectra associations");
        }
        return this.sampleDataCollection;
    }

    @Override
    public FAIRSpecCompoundCollection getCompoundCollection() {
        if (this.compoundCollection == null) {
            this.compoundCollection = new FAIRSpecCompoundCollection(this.byId);
            this.associations[2] = this.compoundCollection;
            this.compoundCollection.setID("compounds");
        }
        return this.compoundCollection;
    }

    public IFDStructureDataAnalysisCollection getStructureDataAnalysisCollection() {
        if (this.structureDataAnalysisCollection == null) {
            this.structureDataAnalysisCollection = new IFDStructureDataAnalysisCollection(this.byId);
            this.associations[4] = this.structureDataAnalysisCollection;
        }
        this.structureDataAnalysisCollection.setID("structure-spectra-analyses");
        return this.structureDataAnalysisCollection;
    }

    @Override
    public IFDStructure createStructure(String id) {
        this.currentStructure = new IFDStructure();
        if (id != null) {
            this.currentStructure.setID(id);
        }
        if (this.thisCompound != null) {
            this.thisCompound.addStructure(this.currentStructure);
        }
        this.getStructureCollection().add(this.currentStructure);
        return this.currentStructure;
    }

    @Override
    public IFDStructureRepresentation createStructureRepresentation(IFDReference ref, Object data, long len, String ifdStructureType, String mediatype) {
        if (this.currentStructure == null) {
            this.currentStructure = this.createStructure(null);
        }
        IFDStructureRepresentation r = (IFDStructureRepresentation)this.findOrAddRepresentation(this.currentStructure, null, null, null, ref == null ? null : ref.getLocalName(), data, null);
        if (data == null) {
            r.getRef().setDOI(ref.getDOI());
            r.getRef().setURL(ref.getURL());
        }
        r.setMediaType(mediatype);
        r.setType(ifdStructureType);
        r.setLength(len);
        return r;
    }

    @Override
    public IFDDataObject createDataObject(String id, String type) {
        FAIRSpecDataObject o = FAIRSpecDataObject.createFAIRSpecObject(type);
        if (this.thisCompound != null) {
            this.thisCompound.addDataObject(o);
        }
        this.getSpecCollection().add(o);
        this.currentDataObject = o;
        return this.currentDataObject;
    }

    @Override
    public IFDDataObjectRepresentation createDataObjectRepresentation(IFDReference ref, Object data, long len, String ifdDataType, String mediatype) {
        if (this.currentDataObject == null) {
            System.out.println("no data object for " + ref);
            return null;
        }
        IFDDataObjectRepresentation r = (IFDDataObjectRepresentation)this.findOrAddRepresentation(this.currentDataObject, null, null, null, ref == null ? null : ref.getLocalName(), data, null);
        r.setRef(ref);
        r.setMediaType(mediatype);
        r.setType(ifdDataType);
        r.setLength(len);
        return r;
    }

    @Override
    public FAIRSpecCompoundAssociation findCompound(IFDStructure struc, IFDDataObject spec) {
        return (FAIRSpecCompoundAssociation)this.getCompoundCollection().findAssociation(struc, spec);
    }

    @Override
    public IFDSampleDataAssociation associateSampleSpec(IFDSample sample, IFDDataObject spec) throws IFDException {
        return this.getSampleDataCollection().addAssociation(sample, spec);
    }

    public IFDSampleDataAssociation getSampleAssociation(IFDSample struc, IFDDataObject spec) {
        return (IFDSampleDataAssociation)this.getSampleDataCollection().findAssociation(struc, spec);
    }

    @Override
    public IFDRepresentation getSpecDataRepresentation(String localizeName) {
        return this.dataObjectCollection == null ? null : this.dataObjectCollection.getRepresentation(this.currentResource.getID(), localizeName);
    }

    @Override
    public IFDSample getSampleByName(String label) {
        return (IFDSample)this.getSampleCollection().getObjectByLabel(label);
    }

    @Override
    public IFDSampleStructureAssociation associateSampleStructure(IFDSample sample, IFDStructure struc) throws IFDException {
        return this.getSampleStructureCollection().addAssociation(sample, struc);
    }

    @Override
    public String createSerialization(File targetDir, ArrayList<Object> products, IFDSerializerI serializer, long[] t) throws IOException {
        if (serializer == null) {
            serializer = new IFDDefaultJSONSerializer(this.byId);
        }
        if (t == null) {
            t = new long[3];
        }
        t[0] = System.currentTimeMillis();
        String serializedFindingAid = serializer.serialize(this.findingAid).toString();
        t[0] = System.currentTimeMillis() - t[0];
        if (targetDir == null) {
            return serializedFindingAid;
        }
        String aidName = "IFD" + IFDConst.IFD_FINDINGAID_FLAG + serializer.getFileExt();
        String faPath = targetDir.toString().replace('\\', '/') + "/" + aidName;
        FAIRSpecUtilities.writeBytesToFile(serializedFindingAid.getBytes(), new File(faPath));
        System.out.println("created " + faPath);
        if (products != null) {
            products = (ArrayList)products.clone();
            this.findingAid.setPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_REF, null);
            this.findingAid.setPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_LEN, null);
            String zipName = "IFD" + IFDConst.IFD_COLLECTION_FLAG + "zip";
            String path = targetDir + "/" + zipName;
            FAIRSpecUtilities.refreshLog();
            System.out.println("FAIRSpecFindingAidHelper creating " + path);
            t[1] = System.currentTimeMillis();
            products.add(0, serializedFindingAid.getBytes());
            products.add(1, aidName);
            long len = FAIRSpecUtilities.zip(path, targetDir.toString().length() + 1, products);
            t[1] = System.currentTimeMillis() - t[1];
            t[2] = System.currentTimeMillis();
            this.findingAid.setPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_REF, zipName);
            this.findingAid.setPropertyValue(IFDConst.IFD_PROPERTY_COLLECTIONSET_LEN, len);
            serializedFindingAid = serializer.serialize(this.findingAid).toString();
            t[2] = System.currentTimeMillis() - t[2];
            FAIRSpecUtilities.writeBytesToFile(serializedFindingAid.getBytes(), new File(faPath));
        }
        return serializedFindingAid;
    }

    public void finalizeObjects() {
        int i;
        if (this.objects == null) {
            return;
        }
        for (i = 0; i < this.objects.length; ++i) {
            if (this.objects[i] == null) continue;
            this.findingAid.addCollection(this.objects[i]);
        }
        for (i = 0; i < this.associations.length; ++i) {
            if (this.associations[i] == null) continue;
            this.findingAid.addCollection(this.associations[i]);
        }
        this.objects = null;
        this.associations = null;
    }

    public String dumpSummary() {
        IFDCollectionSet cs = this.findingAid.getCollectionSet();
        int n = 0;
        String s = "";
        for (int i = 0; i < cs.size(); ++i) {
            IFDCollection c = (IFDCollection)cs.get(i);
            for (Object sd : c) {
                s = s + "\t" + sd + "\n";
                ++n;
            }
            s = s + "## " + c.size() + " " + c.getID() + "\n";
        }
        s = "!FAIRSpecExtractionHelper.dumpSummary extraction complete:\n! " + this.getFindingAid().getResources() + "\n!\n" + (n == 0 ? "!FAIRSpecExtractionHelper.dumpSummary no objects?\n" : s) + "\n!FAIRSpecExtractionHelper.dumpSummary version " + IFDConst.getProp("IFD_VERSION") + "\n";
        return s;
    }

    public void finalizeCollectionSet(Map<String, Map<String, Object>> htURLReferences) {
        this.findingAid.finalizeCollectionSet(htURLReferences);
    }

    @Override
    public String generateFindingAid(File fileDir) throws IOException {
        this.finalizeObjects();
        this.finalizeCollectionSet(null);
        return this.createSerialization(fileDir, null, null, null);
    }

    public IFDRepresentation findOrAddRepresentation(IFDRepresentableObject<? extends IFDRepresentation> collection, String resourceID, String currentOriginPath, String rootPath, String localName, Object data, String param) {
        return collection.findOrAddRepresentation(resourceID, currentOriginPath, rootPath, localName, data, param, FAIRSpecUtilities.mediaTypeFromFileName(localName));
    }

    public static String updateKey(String key) {
        int pt = key.indexOf(".xray.");
        if (pt >= 0) {
            key = key.substring(0, pt + 1) + "xrd" + key.substring(pt + 5);
        }
        return key;
    }

    @Override
    public IFDResource getCurrentSource() {
        return this.currentResource;
    }

    @Override
    public IFDResource addOrSetSource(String dataSource, String rootPath) {
        this.currentResource = this.getFindingAid().addOrSetResource(dataSource, rootPath);
        return this.currentResource;
    }

    @Override
    public void setCurrentResourceByteLength(long len) {
        this.currentResource.setLength(len);
    }

    public static void addProperties(IFDObject<?> o, List<Object[]> props) {
        for (Object[] s : props) {
            String key;
            Object val = s[1];
            if (val == null || (key = (String)s[0]).startsWith(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_METADATA_IGNORE_PREFIX)) continue;
            o.setPropertyValue(key, val);
        }
    }

    @Override
    public Object setPropertyValueNotAlreadySet(IFDObject<?> obj, String key, Object value, String originPath) {
        if (IFDConst.isIFDProperty(key)) {
            Object v = obj.getPropertyValue(key);
            if (value.equals(v)) {
                return null;
            }
            if (v != null && value != "\u0001") {
                String objSource = obj.getPropertySource(key);
                if (originPath != null && !originPath.equals(objSource)) {
                    return v;
                }
            }
        }
        obj.setPropertyValue(key, value, originPath);
        return null;
    }

    static {
        FAIRSpecFindingAid.loadProperties();
    }

    public static interface ClassTypes {
        public static final String Sample = "org.iupac.fairdata.sample.IFDSample";
        public static final String SampleCollection = "org.iupac.fairdata.sample.IFDSampleCollection";
        public static final String Structure = "org.iupac.fairdata.structure.IFDStructure";
        public static final String StructureCollection = "org.iupac.fairdata.structure.IFDStructureCollection";
        public static final String DataObject = "org.iupac.fairdata.dataobject.IFDDataObject";
        public static final String DataObjectCollection = "org.iupac.fairdata.dataobject.IFDDataObjectCollection";
        public static final String SampleDataAssociation = "org.iupac.fairdata.derived.IFDSampleDataAssociation";
        public static final String SampleDataAssociationCollection = "org.iupac.fairdata.derived.IFDSampleDataAssociationCollection";
        public static final String SampleDataAnalysis = "org.iupac.fairdata.derived.IFDSampleDataAnalysis";
        public static final String SampleDataAnalysisCollection = "org.iupac.fairdata.derived.IFDSampleDataAnalysisCollection";
        public static final String StructureDataAnalysis = "org.iupac.fairdata.derived.IFDStructureDataAnalysis";
        public static final String StructureDataAnalysisCollection = "org.iupac.fairdata.derived.IFDStructureDataAnalysisCollection";
        public static final String Compound = "org.iupac.fairdata.contrib.fairspec.FAIRSpecCompound";
        public static final String CompoundCollection = "org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundCollection";
    }
}

