/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.contrib.fairspec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundAssociation;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundCollection;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelperI;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAid;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecFindingAidHelper;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecUtilities;
import org.iupac.fairdata.contrib.fairspec.dataobject.FAIRSpecDataObject;
import org.iupac.fairdata.core.IFDAssociation;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDRepresentableObject;
import org.iupac.fairdata.core.IFDRepresentation;
import org.iupac.fairdata.dataobject.IFDDataObject;
import org.iupac.fairdata.dataobject.IFDDataObjectCollection;
import org.iupac.fairdata.derived.IFDSampleDataAssociation;
import org.iupac.fairdata.derived.IFDStructureDataAssociation;
import org.iupac.fairdata.extract.MetadataReceiverI;
import org.iupac.fairdata.sample.IFDSample;
import org.iupac.fairdata.sample.IFDSampleCollection;
import org.iupac.fairdata.structure.IFDStructure;
import org.iupac.fairdata.structure.IFDStructureCollection;

public class FAIRSpecExtractorHelper
extends FAIRSpecFindingAidHelper
implements FAIRSpecExtractorHelperI {
    public static final String FAIRSPEC_EXTRACTOR_FLAG;
    public static final String FAIRSPEC_EXTRACTOR_OBJECT;
    public static final String FAIRSPEC_EXTRACTOR_REPLACEMENTS;
    public static final String FAIRSPEC_EXTRACTOR_ACCEPT;
    public static final String FAIRSPEC_EXTRACTOR_REJECT;
    public static final String FAIRSPEC_EXTRACTOR_IGNORE;
    public static final String FAIRSPEC_EXTRACTOR_OPTION_FLAG;
    public static final String FAIRSPEC_EXTRACTOR_OPTIONS;
    public static final String FAIRSPEC_EXTRACTOR_METADATA;
    public static final String FAIRSPEC_EXTRACTOR_METADATA_FILE;
    public static final String FAIRSPEC_EXTRACTOR_METADATA_KEY;
    public static final String FAIRSPEC_EXTRACTOR_METADATA_IGNORE_PREFIX;
    public static final String FAIRSPEC_EXTRACTOR_RELATED_METADATA;
    public static final String FAIRSPEC_EXTRACTOR_LOCAL_SOURCE_FILE;
    public static final String EXIT = "EXIT";
    public static final String junkFilePattern;
    public static final String defaultCachePattern = "(?<img>\\.pdf$|\\.png$)";
    public static final String FAIRSPEC_EXTRACT_VERSION;
    public static final String DATAOBJECT_FAIRSPEC_FLAG;
    public static final String DATAOBJECT_ORIGINATING_SAMPLE_ID;
    private static final String IFD_PROPERTY_SAMPLE_ID;
    public static final String IFD_PROPERTY_STRUCTURE_ID;
    public static final String IFD_PROPERTY_DATAOBJECT_ID;
    public static final String IFD_PROPERTY_FAIRSPEC_COMPOUND_ID;
    protected String currentOriginPath;
    protected List<Object[]> currentDataProps;
    private MetadataReceiverI extractor;
    private int lastStructureName;
    private int lastSampleName;

    public FAIRSpecExtractorHelper(MetadataReceiverI extractor, String creator) {
        super(creator);
        if (extractor == null) {
            throw new RuntimeException("FAIRSpecExtractorHelper: extractor cannot be null");
        }
        this.extractor = extractor;
    }

    @Override
    public void beginAddingObjects(String originPath) {
        if (this.isAddingObjects()) {
            this.endAddingObjects();
        }
        this.currentOriginPath = originPath;
    }

    public boolean isAddingObjects() {
        return this.currentOriginPath != null;
    }

    @Override
    public IFDObject<?> addObject(String rootPath, String param, String value, String localizedName, long len) throws IFDException {
        if (!this.isAddingObjects()) {
            throw new IFDException("addObject " + param + " " + value + " called with no current object file name");
        }
        String type = FAIRSpecExtractorHelper.getObjectTypeForPropertyOrRepresentationKey(param, false);
        if (type.startsWith(DATAOBJECT_FAIRSPEC_FLAG)) {
            boolean isNew;
            if (this.currentDataObject == null && this.currentDataProps != null) {
                for (Object[] s : this.currentDataProps) {
                    if (!IFDConst.isID((String)s[0])) continue;
                    this.currentDataObject = (IFDDataObject)this.getSpecCollection().getObjectByID((String)s[1]);
                    break;
                }
            }
            boolean bl = isNew = this.currentDataObject == null;
            if (isNew) {
                this.currentDataObject = (IFDDataObject)this.checkAddNewObject(this.getSpecCollection(), type, rootPath, param, value, localizedName, this.currentOriginPath, len, true);
            } else {
                this.checkAddRepOrSetParam(this.currentDataObject, param, value, localizedName, len);
            }
            if (this.currentDataProps != null) {
                FAIRSpecExtractorHelper.addProperties(this.currentDataObject, this.currentDataProps);
            }
            if (isNew) {
                this.extractor.setNewObjectMetadata(this.currentDataObject, IFD_PROPERTY_DATAOBJECT_ID);
            }
            if (this.currentAssociation != null && this.currentAssociation instanceof FAIRSpecCompoundAssociation) {
                ((IFDStructureDataAssociation)this.currentAssociation).getDataObjectCollection().add(this.currentDataObject);
            }
            return this.currentDataObject;
        }
        switch (type) {
            case "org.iupac.fairdata.sample.IFDSample": {
                this.currentSample = (IFDSample)this.checkAddNewObject(this.getSampleCollection(), type, rootPath, param, value, localizedName, null, len, true);
                if (this.currentAssociation != null && this.currentAssociation instanceof IFDSampleDataAssociation) {
                    ((IFDSampleDataAssociation)this.currentAssociation).getSampleCollection().add(this.currentSample);
                }
                return this.currentSample;
            }
            case "org.iupac.fairdata.structure.IFDStructure": {
                if (this.currentStructure == null) {
                    this.currentStructure = (IFDStructure)this.checkAddNewObject(this.getStructureCollection(), type, rootPath, param, value, localizedName, null, len, true);
                } else {
                    this.checkAddRepOrSetParam(this.currentStructure, param, value, localizedName, len);
                }
                if (this.currentAssociation != null && this.currentAssociation instanceof IFDStructureDataAssociation) {
                    ((IFDStructureDataAssociation)this.currentAssociation).getStructureCollection().add(this.currentStructure);
                }
                return this.currentStructure;
            }
            case "org.iupac.fairdata.dataobject.IFDDataObject": {
                if (this.currentDataObject == null) {
                    if (IFDConst.isID(param) && this.byId) {
                        this.currentDataObject = (IFDDataObject)this.checkAddNewObject(this.getSpecCollection(), type, rootPath, param, value, localizedName, this.currentOriginPath, len, false);
                        if (this.currentDataObject != null) {
                            return this.currentDataObject;
                        }
                    }
                    if (this.currentDataProps == null) {
                        this.currentDataProps = new ArrayList<Object[]>();
                    }
                    this.currentDataProps.add(new String[]{param, value});
                } else {
                    this.checkAddRepOrSetParam(this.currentDataObject, param, value, localizedName, len);
                }
                if (this.currentAssociation != null) {
                    if (this.currentAssociation instanceof FAIRSpecCompoundAssociation) {
                        ((FAIRSpecCompoundAssociation)this.currentAssociation).getDataObjectCollection().add(this.currentDataObject);
                    } else if (this.currentAssociation instanceof IFDSampleDataAssociation) {
                        ((IFDSampleDataAssociation)this.currentAssociation).getDataObjectCollection().add(this.currentDataObject);
                    }
                }
                return this.currentDataObject;
            }
            case "org.iupac.fairdata.contrib.fairspec.FAIRSpecCompound": {
                this.currentAssociation = (IFDAssociation)this.getCompoundCollection().getObjectByID(value);
                if (this.currentAssociation == null) {
                    this.currentAssociation = new FAIRSpecCompoundAssociation();
                }
                this.currentAssociation.setPropertyValue(param, value);
                if (IFDConst.isID(param)) {
                    this.extractor.setNewObjectMetadata(this.currentAssociation, param);
                }
                this.getCompoundCollection().add(this.currentAssociation);
                return this.currentAssociation;
            }
            case "org.iupac.fairdata.derived.IFDSampleDataAssociation": {
                this.currentAssociation = (IFDAssociation)this.getSampleDataCollection().getObjectByID(value);
                if (this.currentAssociation == null) {
                    this.currentAssociation = new FAIRSpecCompoundAssociation();
                    this.getSampleDataCollection().add(this.currentAssociation);
                    this.currentAssociation.setPropertyValue(param, value);
                }
                return null;
            }
            case "org.iupac.fairdata.derived.IFDSampleDataAssociationCollection": 
            case "org.iupac.fairdata.contrib.fairspec.FAIRSpecCompoundCollection": 
            case "org.iupac.fairdata.derived.IFDStructureDataAnalysisCollection": 
            case "org.iupac.fairdata.derived.IFDStructureDataAnalysis": {
                System.out.println("FAIRSpecExtractionHelper.addObject " + type + " not implemented");
                return null;
            }
        }
        throw new IFDException("addObject raw collection -- could not add " + param + " " + value + " for " + this.currentOriginPath + " type " + type);
    }

    private IFDRepresentableObject<? extends IFDRepresentation> checkAddNewObject(IFDCollection<?> c, String type, String rootPath, String param, String value, String localName, String originPath, long len, boolean forceNew) throws IFDException {
        boolean isNew;
        String key;
        boolean isID = IFDConst.isID(param);
        if (isID) {
            key = value;
        } else {
            switch (type) {
                case "org.iupac.fairdata.derived.IFDSampleDataAssociation": 
                case "org.iupac.fairdata.contrib.fairspec.FAIRSpecCompound": {
                    this.currentAssociation.setPropertyValue(param, value);
                    return null;
                }
                case "org.iupac.fairdata.sample.IFDSample": {
                    key = rootPath + "::" + (originPath == null ? localName : value);
                    break;
                }
                case "org.iupac.fairdata.structure.IFDStructure": {
                    key = rootPath + "::" + (originPath == null ? localName : value);
                    break;
                }
                default: {
                    key = rootPath + "::" + originPath;
                }
            }
        }
        IFDRepresentableObject o = (IFDRepresentableObject)(isID ? c.getObjectByID(key) : c.getPath(key));
        boolean bl = isNew = o == null;
        if (isNew) {
            if (!forceNew) {
                return null;
            }
            switch (type) {
                case "org.iupac.fairdata.sample.IFDSample": {
                    o = new IFDSample();
                    o = ((IFDSampleCollection)c).addWithPath(key, (IFDSample)o);
                    break;
                }
                case "org.iupac.fairdata.structure.IFDStructure": {
                    o = new IFDStructure();
                    o = ((IFDStructureCollection)c).addWithPath(key, (IFDStructure)o);
                    break;
                }
                default: {
                    o = FAIRSpecDataObject.createFAIRSpecObject(type);
                    o = ((IFDDataObjectCollection)c).addWithPath(key, (IFDDataObject)o);
                }
            }
            if (o == null) {
                throw new IFDException("FAIRSpecExtractorHelper.addNewObject object not found for path=" + rootPath + " and originPath=" + this.currentOriginPath);
            }
        }
        this.checkAddRepOrSetParam(o, param, value, localName, len);
        if (isNew && isID) {
            this.extractor.setNewObjectMetadata(o, param);
        }
        return o;
    }

    private void checkAddRepOrSetParam(IFDRepresentableObject<? extends IFDRepresentation> o, String param, String value, String localName, long len) {
        if (IFDConst.isRepresentation(param)) {
            this.findOrAddRepresentation(o, this.currentResource.getID(), this.currentOriginPath, this.currentResource.getRootPath(), localName, null, param).setLength(len);
        } else {
            o.setPropertyValue(param, value);
        }
    }

    @Override
    public IFDObject<?> endAddingObjects() {
        if (!this.isAddingObjects()) {
            return null;
        }
        try {
            if (this.currentAssociation instanceof IFDStructureDataAssociation) {
                if (this.currentDataObject != null) {
                    ((IFDStructureDataAssociation)this.currentAssociation).addDataObject(this.currentDataObject);
                }
                if (this.currentStructure != null) {
                    ((IFDStructureDataAssociation)this.currentAssociation).addStructure(this.currentStructure);
                }
                IFDAssociation iFDAssociation = this.currentAssociation;
                return iFDAssociation;
            }
            if (this.currentAssociation instanceof IFDSampleDataAssociation) {
                if (this.currentDataObject != null) {
                    ((IFDSampleDataAssociation)this.currentAssociation).addDataObject(this.currentDataObject);
                }
                if (this.currentStructure != null) {
                    ((IFDSampleDataAssociation)this.currentAssociation).addSample(this.currentSample);
                }
                IFDAssociation iFDAssociation = this.currentAssociation;
                return iFDAssociation;
            }
            if (this.currentStructure != null && this.currentDataObject != null) {
                FAIRSpecCompoundAssociation fAIRSpecCompoundAssociation = this.getCompoundCollection().addAssociation(this.currentStructure, this.currentDataObject);
                return fAIRSpecCompoundAssociation;
            }
            if (this.currentSample != null && this.currentDataObject != null) {
                IFDSampleDataAssociation iFDSampleDataAssociation = this.getSampleDataCollection().addAssociation(this.currentSample, this.currentDataObject);
                return iFDSampleDataAssociation;
            }
            IFDStructure iFDStructure = this.currentStructure != null ? this.currentStructure : (this.currentSample != null ? this.currentSample : this.currentDataObject);
            return iFDStructure;
        }
        catch (IFDException e) {
            IFDObject<?> iFDObject = null;
            return iFDObject;
        }
        finally {
            this.currentOriginPath = null;
            this.currentStructure = null;
            this.currentSample = null;
            this.currentDataObject = null;
            this.currentAssociation = null;
            this.currentDataProps = null;
        }
    }

    @Override
    public int removeStructuresWithNoAssociations() {
        ArrayList<IFDAssociation> lstRemove = new ArrayList<IFDAssociation>();
        FAIRSpecCompoundCollection strucData = this.getCompoundCollection();
        int n = 0;
        for (IFDAssociation assoc : strucData) {
            ArrayList<IFDDataObject> empty = new ArrayList<IFDDataObject>();
            IFDCollection dataCollection = (IFDCollection)assoc.getObject(1);
            for (IFDRepresentableObject d : dataCollection) {
                if (d.size() != 0) continue;
                if (d.isValid()) {
                    this.extractor.log("! FAIRSpecExtractionHelper.removed " + d);
                }
                empty.add((IFDDataObject)d);
            }
            n += empty.size();
            dataCollection.removeAll(empty);
            if (dataCollection.size() != 0) continue;
            lstRemove.add(assoc);
            IFDStructure st = (IFDStructure)assoc.getFirstObj1();
            if (st != null) {
                this.extractor.log("! FAIRSpecExtractionHelper.removeStructuresWithNoAssociation removing structure " + st.getID());
                this.getStructureCollection().remove(st);
            }
            ++n;
        }
        strucData.removeAll(lstRemove);
        return n += lstRemove.size();
    }

    @Override
    public IFDStructure addStructureForCompound(String rootPath, FAIRSpecCompoundAssociation assoc, String ifdRepType, String oPath, String localName, String name) throws IFDException {
        IFDStructure struc = this.getStructureCollection().getStructureFromLocalName(this.currentResource.getID(), localName);
        if (struc == null) {
            struc = this.newStructure(rootPath, ifdRepType, oPath, localName, name);
            if (name == null) {
                name = "Structure_" + ++this.lastStructureName;
            }
        }
        if (assoc != null) {
            assoc.addStructure(struc);
        }
        return struc;
    }

    private IFDStructure newStructure(String rootPath, String ifdRepType, String originPath, String localName, String name) throws IFDException {
        if (name == null) {
            name = "Structure_" + ++this.lastStructureName;
        }
        IFDStructure struc = (IFDStructure)this.checkAddNewObject(this.getStructureCollection(), "org.iupac.fairdata.structure.IFDStructure", rootPath, IFD_PROPERTY_STRUCTURE_ID, name, localName, null, 0L, true);
        struc.findOrAddRepresentation(this.currentResource.getID(), originPath, rootPath, localName, null, ifdRepType, FAIRSpecUtilities.mediaTypeFromFileName(localName));
        this.getStructureCollection().add(struc);
        return struc;
    }

    @Override
    public IFDStructure addStructureForSpec(String rootPath, IFDDataObject spec, String ifdRepType, String originPath, String localName, String name) throws IFDException {
        IFDStructure struc = this.getStructureCollection().getStructureFromLocalName(this.currentResource.getID(), localName);
        if (struc == null) {
            struc = this.newStructure(rootPath, ifdRepType, originPath, localName, name);
        }
        if (spec != null) {
            IFDStructureDataAssociation ss;
            if (this.getSpecCollection().indexOf(spec) < 0) {
                this.getSpecCollection().add(spec);
            }
            if ((ss = (IFDStructureDataAssociation)this.getCompoundCollection().getAssociationForSingleObj2(spec)) == null) {
                ss = this.getCompoundCollection().addAssociation(struc, spec);
            } else {
                ss.getStructureCollection().add(struc);
            }
        }
        return struc;
    }

    @Override
    public IFDSample addSpecOriginatingSampleRef(String rootPath, IFDDataObject spec, String id) throws IFDException {
        if (this.getSpecCollection().indexOf(spec) < 0) {
            this.getSpecCollection().add(spec);
        }
        IFDSample sample = (IFDSample)this.checkAddNewObject(this.getSampleCollection(), "org.iupac.fairdata.sample.IFDSample", rootPath, IFD_PROPERTY_SAMPLE_ID, id, null, null, 0L, true);
        this.getSampleCollection().add(sample);
        IFDSampleDataAssociation ss = (IFDSampleDataAssociation)this.getSampleDataCollection().getAssociationForSingleObj1(sample);
        if (ss == null) {
            ss = this.getSampleDataCollection().addAssociation(sample, spec);
        } else {
            ss.getDataObjectCollection().add(spec);
        }
        return sample;
    }

    @Override
    public String finalizeExtraction(Map<String, Map<String, Object>> htURLReferences) {
        this.finalizeObjects();
        this.finalizeCompoundURLRefs(htURLReferences);
        this.finalizeCollectionSet(htURLReferences);
        return this.dumpSummary();
    }

    private void finalizeCompoundURLRefs(Map<String, Map<String, Object>> htURLReferences) {
        if (htURLReferences == null) {
            return;
        }
        FAIRSpecCompoundCollection cc = this.getCompoundCollection();
        int i = cc.size();
        while (--i >= 0) {
            IFDAssociation c = (IFDAssociation)cc.get(i);
            c.setDOIorURLFromMapByID(htURLReferences);
        }
    }

    @Override
    public IFDDataObject cloneData(IFDDataObject localSpec, String idExtension, boolean andReplace) {
        IFDAssociation assoc;
        IFDDataObject data = this.getSpecCollection().cloneData(localSpec, idExtension, andReplace);
        if (this.compoundCollection != null) {
            for (IFDAssociation a : this.compoundCollection) {
                assoc = (IFDStructureDataAssociation)a;
                if (!((IFDStructureDataAssociation)assoc).getDataObjectCollection().contains(localSpec)) continue;
                ((IFDStructureDataAssociation)assoc).getDataObjectCollection().add(data);
            }
        }
        if (this.sampleDataCollection != null) {
            for (IFDAssociation a : this.sampleDataCollection) {
                assoc = (IFDSampleDataAssociation)a;
                if (!((IFDSampleDataAssociation)assoc).getDataObjectCollection().contains(localSpec)) continue;
                ((IFDSampleDataAssociation)assoc).getDataObjectCollection().add(data);
            }
        }
        return data;
    }

    @Override
    public void removeInvalidData() {
        IFDAssociation assoc;
        if (this.dataObjectCollection == null) {
            return;
        }
        this.dataObjectCollection.removeInvalidData();
        if (this.compoundCollection != null) {
            for (IFDAssociation a : this.compoundCollection) {
                assoc = (IFDStructureDataAssociation)a;
                int i = assoc.size();
                while (--i >= 0) {
                    ((IFDStructureDataAssociation)assoc).getDataObjectCollection().removeInvalidData();
                }
                IFDStructure struc = (IFDStructure)assoc.getFirstObj1();
                IFDObject<?> spec = assoc.getFirstObj2();
                if (((IFDCollection)assoc.get(1)).size() > 0 && (struc == null || struc.size() == 0)) {
                    this.extractor.log("! FAIRSpecExtractorHelper association id=" + assoc.getID() + " spec=" + (spec == null ? "" : spec.getID()) + " has no associated structure representation ");
                }
                if (((IFDCollection)assoc.get(0)).size() <= 0 || spec != null && spec.size() != 0) continue;
                this.extractor.log("! FAIRSpecExtractorHelper association id=" + assoc.getID() + " struc=" + (struc == null ? "" : struc.getID()) + " has no associated spectrum representation ");
                assoc.setValid(false);
            }
            this.compoundCollection.removeInvalidData();
        }
        if (this.sampleDataCollection != null) {
            for (IFDAssociation a : this.sampleDataCollection) {
                assoc = (IFDSampleDataAssociation)a;
                int i = assoc.size();
                while (--i >= 0) {
                    ((IFDSampleDataAssociation)assoc).getDataObjectCollection().removeInvalidData();
                }
                if (assoc.getFirstObj1() != null) continue;
                this.extractor.log("! FAIRSpecExtractorHelper association " + assoc.getID() + " has no associated sample representation");
            }
        }
    }

    @Override
    public String getFileListJSON(String name, List<FileList> rootLists, String resourceList, String scriptFileName, int[] ret) throws IOException {
        int n = ret[0] = FileList.getListCount(rootLists, name);
        StringBuffer sb = new StringBuffer();
        sb.append("{\"" + IFDConst.IFD_FLAG + "version\":\"" + IFDConst.IFD_VERSION + "\",\n");
        sb.append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "version\":\"" + this.extractor.getVersion() + "\",\n").append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "code\":\"" + this.extractor.getCodeSource() + "\",\n").append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "creation_date\":\"" + this.getFindingAid().getDate().toGMTString() + "\",\n");
        sb.append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "script\":\"" + scriptFileName + "\",\n");
        sb.append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "sources\":\n");
        FAIRSpecUtilities.toJSON(sb, resourceList.split(";"), null, true);
        sb.append(",\n");
        sb.append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "list_type\":\"" + name + "\",\n").append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "list_fileCount\":" + n + ",\n").append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "list_byteCount\":" + FileList.getByteCount(rootLists, name) + ",\n").append("\"" + FAIRSPEC_EXTRACTOR_FLAG + "list\":\n");
        sb.append("[\n");
        String sep = "";
        for (int i = 0; i < rootLists.size(); ++i) {
            FileList list = rootLists.get(i);
            if (list == null || !list.getName().equals(name) || list.size() <= 0) continue;
            sb.append(sep);
            list.serialize(sb);
            sep = ",";
        }
        sb.append("]\n");
        sb.append("}\n");
        return sb.toString();
    }

    static {
        FAIRSpecFindingAid.loadProperties();
        FAIRSPEC_EXTRACTOR_FLAG = IFDConst.getProp("FAIRSPEC_EXTRACTOR_FLAG");
        FAIRSPEC_EXTRACTOR_OBJECT = IFDConst.getProp("FAIRSPEC_EXTRACTOR_OBJECT");
        FAIRSPEC_EXTRACTOR_REPLACEMENTS = IFDConst.getProp("FAIRSPEC_EXTRACTOR_REPLACEMENTS");
        FAIRSPEC_EXTRACTOR_ACCEPT = IFDConst.getProp("FAIRSPEC_EXTRACTOR_ACCEPT");
        FAIRSPEC_EXTRACTOR_REJECT = IFDConst.getProp("FAIRSPEC_EXTRACTOR_REJECT");
        FAIRSPEC_EXTRACTOR_IGNORE = IFDConst.getProp("FAIRSPEC_EXTRACTOR_IGNORE");
        FAIRSPEC_EXTRACTOR_OPTION_FLAG = IFDConst.getProp("FAIRSPEC_EXTRACTOR_OPTION_FLAG");
        FAIRSPEC_EXTRACTOR_OPTIONS = IFDConst.getProp("FAIRSPEC_EXTRACTOR_OPTIONS");
        FAIRSPEC_EXTRACTOR_METADATA = IFDConst.getProp("FAIRSPEC_EXTRACTOR_METADATA");
        FAIRSPEC_EXTRACTOR_METADATA_FILE = IFDConst.getProp("FAIRSPEC_EXTRACTOR_METADATA_FILE");
        FAIRSPEC_EXTRACTOR_METADATA_KEY = IFDConst.getProp("FAIRSPEC_EXTRACTOR_METADATA_KEY");
        FAIRSPEC_EXTRACTOR_METADATA_IGNORE_PREFIX = IFDConst.getProp("FAIRSPEC_EXTRACTOR_METADATA_IGNORE_PREFIX");
        FAIRSPEC_EXTRACTOR_RELATED_METADATA = IFDConst.getProp("FAIRSPEC_EXTRACTOR_RELATED_METADATA");
        FAIRSPEC_EXTRACTOR_LOCAL_SOURCE_FILE = IFDConst.getProp("FAIRSPEC_EXTRACTOR_LOCAL_SOURCE_FILE");
        junkFilePattern = IFDConst.getProp("FAIRSPEC_EXTRACTOR_REJECT_PATTERN");
        FAIRSPEC_EXTRACT_VERSION = IFDConst.getProp("FAIRSPEC_EXTRACT_VERSION");
        DATAOBJECT_FAIRSPEC_FLAG = IFDConst.getProp("DATAOBJECT_FAIRSPEC_FLAG");
        DATAOBJECT_ORIGINATING_SAMPLE_ID = IFDConst.getProp("IFD_PROPERTY_DATAOBJECT.ORIGINATING_SAMPLE_ID");
        IFD_PROPERTY_SAMPLE_ID = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_SAMPLE_FLAG, IFDConst.IFD_ID_FLAG);
        IFD_PROPERTY_STRUCTURE_ID = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_STRUCTURE_FLAG, IFDConst.IFD_ID_FLAG);
        IFD_PROPERTY_DATAOBJECT_ID = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_DATAOBJECT_FLAG, IFDConst.IFD_ID_FLAG);
        IFD_PROPERTY_FAIRSPEC_COMPOUND_ID = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, "fairspec.compound.id");
    }

    public static class FileList {
        private String rootPath;
        private final String name;
        private final List<String> files = new ArrayList<String>();
        private List<Long> lengths = new ArrayList<Long>();
        private Pattern acceptPattern;
        private long byteCount;
        private String start;

        public FileList(String rootPath, String name, String start) {
            this.name = name;
            this.rootPath = rootPath;
            this.start = start;
        }

        public int size() {
            return this.files.size();
        }

        public String serialize(StringBuffer sb) {
            this.lengths = null;
            return this.getJSON(sb);
        }

        private String getJSON(StringBuffer sb) {
            Object[] list = this.files.toArray(new String[this.files.size()]);
            Arrays.sort(list);
            return FAIRSpecUtilities.toJSON(sb, (String[])list, this.rootPath, false);
        }

        public boolean contains(String fileName) {
            return this.files.contains(fileName);
        }

        public void add(String fileName, long len) {
            this.files.add(fileName);
            if (len < 0L) {
                len = 0L;
            }
            this.lengths.add(len);
            this.byteCount += len;
        }

        public void remove(String localizedName, long len) {
            this.files.remove(localizedName);
            this.byteCount -= len;
        }

        public long getByteCount() {
            return this.byteCount;
        }

        public boolean accept(String fileName) {
            return this.start != null && fileName.startsWith(this.start) || this.acceptPattern != null && this.acceptPattern.matcher(fileName).find();
        }

        public void setAcceptPattern(String pattern) {
            this.acceptPattern = Pattern.compile(pattern);
        }

        public String getName() {
            return this.name;
        }

        public static int getListCount(List<FileList> lists, String name) {
            int n = 0;
            int i = lists.size();
            while (--i >= 0) {
                FileList list = lists.get(i);
                if (list == null || !list.getName().equals(name)) continue;
                n += list.size();
            }
            return n;
        }

        public static long getByteCount(List<FileList> lists, String name) {
            long n = 0L;
            int i = lists.size();
            while (--i >= 0) {
                FileList list = lists.get(i);
                if (list == null || !list.getName().equals(name)) continue;
                n += list.getByteCount();
            }
            return n;
        }

        public String toString() {
            return this.getJSON(null);
        }

        public long getLength(String fileName) {
            int i = this.files.indexOf(fileName);
            return i < 0 || this.lengths == null ? 0L : this.lengths.get(i);
        }
    }
}

