/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.common;

public class IFDUtil {
    public static String getNumericalSortKey(String id) {
        int[] ret = new int[2];
        int val = IFDUtil.getBestNumber(id = id.toUpperCase(), ret);
        if (val == 0) {
            return id + "__________";
        }
        String sval = "" + val;
        sval = ("0000000000" + sval).substring(sval.length());
        return id.substring(0, ret[0]) + sval + id.substring(ret[1]);
    }

    private static int getBestNumber(String id, int[] ret) {
        int pt1 = -1;
        int n = id.length();
        int val = 0;
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (c >= '0' && c <= '9') {
                if (pt1 < 0) {
                    pt1 = i;
                }
                val = val * 10 + (c - 48);
                continue;
            }
            if (pt1 < 0) continue;
            n = i;
            break;
        }
        ret[0] = pt1;
        ret[1] = n;
        return val;
    }

    public static int parsePositiveInt(String s) {
        char c;
        int n = Math.min(s.length(), 9);
        int i = -1;
        int val = 0;
        while (++i < n && (c = s.charAt(i)) >= '0' && c <= '9') {
            val = val * 10 + (c - 48);
        }
        return i == 0 ? Integer.MIN_VALUE : val;
    }

    public static boolean isDigit(char ch) {
        char c = ch;
        return '0' <= c && c <= '9';
    }

    public static String getShortFileName(String fileName) {
        int pt = fileName.lastIndexOf("/");
        return pt >= 0 ? fileName.substring(pt + 1) : fileName;
    }
}

