/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.util.Hashtable;
import javajs.util.SB;

public class XMLParser {
    private XmlEvent thisEvent = new XmlEvent(0);
    private DataBuffer buffer;
    public static final int TAG_NONE = 0;
    public static final int START_ELEMENT = 1;
    public static final int END_ELEMENT = 2;
    public static final int START_END_ELEMENT = 3;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 6;
    public static final int EOF = 8;

    public XMLParser(BufferedReader br) {
        this.buffer = new DataBuffer(br);
    }

    public String getBufferData() {
        return this.buffer == null ? null : this.buffer.data.toString().substring(0, this.buffer.ptr);
    }

    public String thisValue() throws Exception {
        return this.buffer.nextEvent().toString().trim();
    }

    public String qualifiedValue() throws Exception {
        this.buffer.nextTag();
        String value = this.buffer.nextEvent().toString().trim();
        this.buffer.nextTag();
        return value;
    }

    public int peek() throws Exception {
        this.thisEvent = this.buffer.peek();
        return this.thisEvent.getEventType();
    }

    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    public void nextTag() throws Exception {
        do {
            this.thisEvent = this.buffer.nextTag();
        } while (this.thisEvent.eventType == 6);
    }

    public int nextEvent() throws Exception {
        this.thisEvent = this.buffer.nextEvent();
        return this.thisEvent.getEventType();
    }

    public void nextStartTag() throws Exception {
        this.thisEvent = this.buffer.nextTag();
        while (!this.thisEvent.isStartElement()) {
            this.thisEvent = this.buffer.nextTag();
        }
    }

    public String getTagName() {
        return this.thisEvent.getTagName();
    }

    public int getTagType() {
        return this.thisEvent.getTagType();
    }

    public String getEndTag() {
        return this.thisEvent.getTagName();
    }

    public String nextValue() throws Exception {
        this.buffer.nextTag();
        return this.buffer.nextEvent().toString().trim();
    }

    public String getAttributeList() {
        return this.thisEvent.toString().toLowerCase();
    }

    public String getAttrValueLC(String key) {
        return this.getAttrValue(key).toLowerCase();
    }

    public String getAttrValue(String name) {
        String a = this.thisEvent.getAttributeByName(name);
        return a == null ? "" : a;
    }

    public String getCharacters() throws Exception {
        SB sb = new SB();
        this.thisEvent = this.buffer.peek();
        int eventType = this.thisEvent.getEventType();
        while (eventType != 4) {
            this.thisEvent = this.buffer.nextEvent();
        }
        while (eventType == 4) {
            this.thisEvent = this.buffer.nextEvent();
            eventType = this.thisEvent.getEventType();
            if (eventType != 4) continue;
            sb.append(this.thisEvent.toString());
        }
        return sb.toString();
    }

    public String getOuterXML() throws Exception {
        int pt = this.buffer.pt0;
        String myName = this.thisEvent.getTagName();
        this.thisEvent = this.buffer.peek();
        while (this.thisEvent.getEventType() != 2 || !this.thisEvent.getTagName().equals(myName)) {
            this.thisEvent = this.buffer.newXmlEvent();
        }
        return this.buffer.data.substring2(pt, this.buffer.ptEnd);
    }

    public String getInnerXML() throws Exception {
        int pt;
        int pt1 = pt = this.buffer.data.length();
        int pt2 = pt;
        String myName = this.thisEvent.getTagName();
        this.thisEvent = this.buffer.peek();
        while (this.thisEvent.getEventType() != 2 || !this.thisEvent.getTagName().equals(myName)) {
            pt2 = pt1;
            pt1 = this.buffer.data.length();
            this.thisEvent = this.buffer.newXmlEvent();
        }
        return this.buffer.data.substring2(pt, pt2);
    }

    public boolean requiresEndTag() {
        int tagType = this.thisEvent.getTagType();
        return tagType != 3 && tagType != 6;
    }

    class Tag {
        int tagType;
        String name;
        String text;
        private Hashtable<String, String> attributes;

        Tag() {
        }

        Tag(String fulltag) {
            this.text = fulltag;
            this.tagType = fulltag.startsWith("<!--") ? 6 : (fulltag.charAt(1) == '/' ? 2 : (fulltag.charAt(fulltag.length() - 2) == '/' ? 3 : 1));
        }

        String getName() {
            int ptTemp;
            if (this.name != null) {
                return this.name;
            }
            int n = this.text.length() - (this.tagType == 3 ? 2 : 1);
            for (ptTemp = this.tagType == 2 ? 2 : 1; ptTemp < n && Character.isWhitespace(this.text.charAt(ptTemp)); ++ptTemp) {
            }
            int pt0 = ptTemp;
            while (ptTemp < n && !Character.isWhitespace(this.text.charAt(ptTemp))) {
                ++ptTemp;
            }
            this.name = this.text.substring(pt0, ptTemp).toLowerCase().trim();
            return this.name;
        }

        String getAttributeByName(String attrName) {
            if (this.attributes == null) {
                this.getAttributes();
            }
            return this.attributes.get(attrName.toLowerCase());
        }

        private void getAttributes() {
            this.attributes = new Hashtable();
            DataString d = new DataString(new SB().append(this.text));
            try {
                if (d.skipTo(' ', false) < 0) {
                    return;
                }
                while (true) {
                    int pt0 = ++d.ptr;
                    if (d.ptr >= 0) {
                        if (d.skipTo('=', false) < 0) {
                            return;
                        }
                        String name = d.substring(pt0, d.ptr).trim().toLowerCase();
                        d.skipTo('\"', false);
                        pt0 = ++d.ptr;
                        d.skipTo('\"', true);
                        String attr = d.substring(pt0, d.ptr);
                        this.attributes.put(name, attr);
                        int pt1 = name.indexOf(":");
                        if (pt1 < 0) continue;
                        name = name.substring(pt1).trim();
                        this.attributes.put(name, attr);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class XmlEvent {
        int eventType = 0;
        private int ptr = 0;
        private Tag tag;
        private String data;

        public String toString() {
            return this.data != null ? this.data : (this.tag != null ? this.tag.text : null);
        }

        XmlEvent(int eventType) {
            this.eventType = eventType;
        }

        XmlEvent(DataBuffer b) throws Exception {
            this.ptr = b.ptr;
            int n = b.getNCharactersRemaining();
            int n2 = n == 0 ? 8 : (n == 1 || b.data.charAt(b.ptr) != '<' ? 4 : (this.eventType = b.data.charAt(b.ptr + 1) != '/' ? 1 : 2));
            if (this.eventType == 8) {
                return;
            }
            if (this.eventType == 4) {
                b.skipTo('<', false);
                this.data = b.data.toString().substring(this.ptr, b.ptr);
            } else {
                b.skipOver('>', false);
                String s = b.data.toString().substring(this.ptr, b.ptr);
                if (s.startsWith("<!--")) {
                    this.eventType = 6;
                }
                this.tag = new Tag(s);
            }
        }

        public int getEventType() {
            return this.eventType;
        }

        boolean isStartElement() {
            return (this.eventType & 1) != 0;
        }

        public String getTagName() {
            return this.tag == null ? null : this.tag.getName();
        }

        public int getTagType() {
            return this.tag == null ? 0 : this.tag.tagType;
        }

        public String getAttributeByName(String name) {
            return this.tag == null ? null : this.tag.getAttributeByName(name);
        }
    }

    private class DataString {
        SB data;
        protected BufferedReader reader;
        int ptr;
        int ptEnd;

        DataString() {
            this.data = new SB();
        }

        DataString(SB data) {
            this.data = data;
            this.ptEnd = data.length();
        }

        int getNCharactersRemaining() {
            return this.ptEnd - this.ptr;
        }

        protected void flush() {
            if (this.data.length() < 1000 || this.ptEnd - this.ptr > 100) {
                return;
            }
            this.data = new SB().append(this.data.substring(this.ptr));
            this.ptr = 0;
            this.ptEnd = this.data.length();
        }

        String substring(int i, int j) {
            return this.data.toString().substring(i, j);
        }

        int skipOver(char c, boolean inQuotes) throws Exception {
            if (this.skipTo(c, inQuotes) > 0 && this.ptr != this.ptEnd) {
                ++this.ptr;
            }
            return this.ptr;
        }

        int skipTo(char toWhat, boolean inQuotes) throws Exception {
            char ch;
            boolean ignoreQuotes;
            boolean bl = ignoreQuotes = toWhat == '<';
            if (this.data == null) {
                return -1;
            }
            if (this.ptr == this.ptEnd) {
                if (this.reader == null) {
                    return -1;
                }
                this.readLine();
            }
            int ptEnd1 = this.ptEnd - 1;
            while (this.ptr < this.ptEnd && (ch = this.data.charAt(this.ptr)) != toWhat) {
                if (inQuotes && ch == '\\' && this.ptr < ptEnd1) {
                    ch = this.data.charAt(this.ptr + 1);
                    if (ch == '\"' || ch == '\\') {
                        ++this.ptr;
                    }
                } else if (!ignoreQuotes && ch == '\"') {
                    ++this.ptr;
                    if (this.skipTo('\"', true) < 0) {
                        return -1;
                    }
                }
                if (++this.ptr != this.ptEnd) continue;
                if (this.reader == null) {
                    return -1;
                }
                this.readLine();
            }
            return this.ptr;
        }

        public boolean readLine() throws Exception {
            return false;
        }
    }

    private class DataBuffer
    extends DataString {
        int pt0;

        DataBuffer(BufferedReader br) {
            this.reader = br;
        }

        boolean hasNext() {
            if (this.ptr == this.ptEnd) {
                try {
                    this.readLine();
                }
                catch (Exception e) {
                    return false;
                }
            }
            return this.ptr < this.ptEnd;
        }

        @Override
        public boolean readLine() throws Exception {
            String s = this.reader.readLine();
            if (s == null) {
                return false;
            }
            this.data.append(s + "\n");
            this.ptEnd = this.data.length();
            return true;
        }

        XmlEvent peek() throws Exception {
            if (this.ptEnd - this.ptr < 2) {
                try {
                    this.readLine();
                }
                catch (Exception e) {
                    return new XmlEvent(8);
                }
            }
            int pt0 = this.ptr;
            XmlEvent e = new XmlEvent(this);
            this.ptr = pt0;
            return e;
        }

        XmlEvent nextTag() throws Exception {
            this.flush();
            this.skipTo('<', false);
            XmlEvent e = new XmlEvent(this);
            return e;
        }

        XmlEvent nextEvent() throws Exception {
            this.flush();
            return this.newXmlEvent();
        }

        protected XmlEvent newXmlEvent() throws Exception {
            this.pt0 = this.ptr;
            return new XmlEvent(this);
        }
    }
}

