/*
 * Decompiled with CFR 0.152.
 */
package jme.util;

import java.util.Arrays;
import jme.util.DPoint;
import jme.util.Eigen4;

public class StructureComparator {
    private StructureComparator() {
    }

    public static double[][] getCenterAndPoints(double[][] vPts) {
        int n = vPts.length;
        double[][] pts = new double[n + 1][3];
        pts[0] = new double[3];
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                double[] dArray = vPts[i];
                pts[i + 1] = dArray;
                DPoint.add(pts[0], dArray);
            }
            DPoint.scale(pts[0], 1.0 / (double)n);
        }
        return pts;
    }

    public static double[][] calculateQuaternionRotation(double[][][] centerAndPoints, double[] retStddev, double[][] receiver) {
        retStddev[1] = Double.NaN;
        double[][] ptsA = centerAndPoints[0];
        double[][] ptsB = centerAndPoints[1];
        int nPts = ptsA.length - 1;
        if (nPts < 2 || ptsA.length != ptsB.length) {
            return null;
        }
        double Sxx = 0.0;
        double Sxy = 0.0;
        double Sxz = 0.0;
        double Syx = 0.0;
        double Syy = 0.0;
        double Syz = 0.0;
        double Szx = 0.0;
        double Szy = 0.0;
        double Szz = 0.0;
        double[] ptA = new double[3];
        double[] ptB = new double[3];
        double[] ptA0 = ptsA[0];
        double[] ptB0 = ptsB[0];
        int i = nPts + 1;
        while (--i >= 1) {
            DPoint.sub2(ptsA[i], ptA0, ptA);
            DPoint.sub2(ptsB[i], ptB0, ptB);
            Sxx += ptA[0] * ptB[0];
            Sxy += ptA[0] * ptB[1];
            Sxz += ptA[0] * ptB[2];
            Syx += ptA[1] * ptB[0];
            Syy += ptA[1] * ptB[1];
            Syz += ptA[1] * ptB[2];
            Szx += ptA[2] * ptB[0];
            Szy += ptA[2] * ptB[1];
            Szz += ptA[2] * ptB[2];
        }
        retStddev[0] = StructureComparator.getRmsd(centerAndPoints, null, centerAndPoints.length == 2 ? (double[][])null : centerAndPoints[2]);
        double[][] N = new double[4][4];
        N[0][0] = Sxx + Syy + Szz;
        double d = Syz - Szy;
        N[1][0] = d;
        N[0][1] = d;
        double d2 = Szx - Sxz;
        N[2][0] = d2;
        N[0][2] = d2;
        double d3 = Sxy - Syx;
        N[3][0] = d3;
        N[0][3] = d3;
        N[1][1] = Sxx - Syy - Szz;
        double d4 = Sxy + Syx;
        N[2][1] = d4;
        N[1][2] = d4;
        double d5 = Szx + Sxz;
        N[3][1] = d5;
        N[1][3] = d5;
        N[2][2] = -Sxx + Syy - Szz;
        double d6 = Syz + Szy;
        N[3][2] = d6;
        N[2][3] = d6;
        N[3][3] = -Sxx - Syy + Szz;
        double[] v = new Eigen4().setM(N).getLargestEigenvector();
        double[] q = DPoint.setQ(v[1], v[2], v[3], v[0]);
        double[][] mat4 = DPoint.qToM4(q);
        retStddev[1] = StructureComparator.getRmsd(centerAndPoints, mat4, receiver);
        return mat4;
    }

    public static double getRmsd(double[][][] centerAndPoints, double[][] mat4, double[][] receiver) {
        double sum2 = 0.0;
        double[][] ptsA = centerAndPoints[0];
        double[][] ptsB = centerAndPoints[1];
        double[] cA = ptsA[0];
        double[] cB = ptsB[0];
        if (receiver != null) {
            receiver[0] = cB;
        }
        int n = ptsA.length - 1;
        double[] ptAnew = new double[3];
        int i = n + 1;
        while (--i >= 1) {
            DPoint.sub2(ptsA[i], cA, ptAnew);
            DPoint.add(DPoint.transform2(mat4, ptAnew), cB);
            sum2 += DPoint.distanceSquared(ptAnew, ptsB[i]);
            if (receiver == null) continue;
            receiver[i] = ptAnew;
            ptAnew = new double[3];
        }
        return Math.sqrt(sum2 / (double)n);
    }

    public static void main(String[] args) {
        StructureComparator.test();
    }

    public static void test() {
        double[][] a = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 2.0, 0.0}};
        double[][] b = new double[][]{{0.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {-2.0, 0.0, 0.0}};
        double[][] ca = StructureComparator.getCenterAndPoints(a);
        double[][] cb = StructureComparator.getCenterAndPoints(b);
        double[][] receiver = new double[ca.length][];
        double[] rmsd = new double[2];
        double[][] m = StructureComparator.calculateQuaternionRotation(new double[][][]{ca, cb}, rmsd, receiver);
        System.out.println(Arrays.toString(rmsd));
        System.out.println(DPoint.toString(m));
    }
}

