/*
 * Decompiled with CFR 0.152.
 */
package jme.util;

import java.util.StringTokenizer;

public interface JMEUtil {
    public static final boolean isSwingJS = true;

    public static boolean isHighDPI() {
        return false;
    }

    public static String nextData(StringTokenizer st, String separator) {
        if (st.hasMoreTokens()) {
            char c;
            String s = st.nextToken();
            if (s.equals(separator)) {
                return " ";
            }
            if (!st.nextToken().equals(separator)) {
                System.err.println("mol file line separator problem!");
            }
            while ((c = s.charAt(s.length() - 1)) == '|' || c == '\n' || c == '\r') {
                if ((s = s.substring(0, s.length() - 1)).length() != 0) continue;
                return " ";
            }
            return s;
        }
        return null;
    }

    public static String findLineSeparator(String molFile) {
        StringTokenizer st = new StringTokenizer(molFile, "\n", true);
        if (st.countTokens() > 4) {
            return "\n";
        }
        st = new StringTokenizer(molFile, "|", true);
        if (st.countTokens() > 4) {
            return "|";
        }
        System.err.println("Cannot process mol file, use | as line separator !");
        return null;
    }

    public static String iformat(int number, int len) {
        return JMEUtil.rightJustify("        ".substring(0, len), "" + number);
    }

    public static String rightJustify(String s1, String s2) {
        int n = s1.length() - s2.length();
        return n == 0 ? s2 : (n > 0 ? s1.substring(0, n) + s2 : s1.substring(0, s1.length() - 1) + "?");
    }

    public static String fformat(double number, int len, int dec) {
        double m;
        String s;
        int dotpos;
        if (dec == 0) {
            return JMEUtil.iformat((int)number, len);
        }
        if (Math.abs(number) < 9.0E-4) {
            number = 0.0;
        }
        if ((dotpos = (s = new Double(number = (double)((int)Math.round(number * (m = Math.pow(10.0, dec)))) / m).toString()).indexOf(46)) < 0) {
            s = s + ".";
            dotpos = s.indexOf(46);
        }
        int slen = s.length();
        for (int i = 1; i <= dec - slen + dotpos + 1; ++i) {
            s = s + "0";
        }
        return len == 0 ? s : JMEUtil.rightJustify("          ".substring(0, len), s);
    }

    public static void log(String s) {
    }

    public static boolean isMacintosh() {
        return false;
    }

    public static String wrapCDATA(String data) {
        return "<![CDATA[" + data + "]]>";
    }

    public static String unwrapCData(String result) {
        int pt = result.indexOf("<![CDATA[");
        int pt1 = result.indexOf("]]>");
        return pt >= 0 && pt1 > pt ? result.substring(pt + 9, pt1) : result;
    }
}

