/*
 * Decompiled with CFR 0.152.
 */
package jme.io;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import jme.JMEmol;
import jme.JMEmolList;
import jme.core.Atom;
import jme.core.Bond;
import jme.core.JMECore;
import jme.util.Isotopes;
import jme.util.JMEUtil;

public class JMEWriter
extends JMECore {
    public static String createJMEString(JMECore mol, boolean addHydrogens, Rectangle2D.Double box) {
        return new JMEWriter(mol).createJME(addHydrogens, box);
    }

    public static String createMolFile(JMECore mol, String header, boolean stampDate, Rectangle2D.Double box) {
        return new JMEWriter(mol).createMolFile(header, stampDate, box);
    }

    public static String createExtendedMolFile(JMECore mol, String header, boolean stampDate, Rectangle2D.Double box) {
        return new JMEWriter(mol).createExtendedMolFile(header, stampDate, box);
    }

    public JMEWriter(JMECore mol) {
        super(mol);
    }

    public void transformAtomCoordinatesForOutput(Rectangle2D.Double boundingBox) {
        double scale = 0.055999999999999994;
        if (boundingBox == null) {
            boundingBox = this.computeCoordinate2DboundingBox();
        }
        if (boundingBox == null) {
            return;
        }
        double ymax = boundingBox.y + boundingBox.height;
        double xmin = boundingBox.x;
        if (this.parameters.keepSameCoordinatesForOutput) {
            xmin = 0.0;
            ymax = 0.0;
            scale = 1.0;
        }
        for (int i = 1; i <= this.natoms; ++i) {
            Atom atom = this.atoms[i];
            atom.x = (atom.x - xmin) * scale;
            atom.y = (ymax - atom.y) * scale;
        }
    }

    public String createJME(boolean addHydrogens, Rectangle2D.Double box) {
        String s = "" + this.natoms + " " + this.nbonds;
        this.transformAtomCoordinatesForOutput(box);
        for (int i = 1; i <= this.natoms; ++i) {
            int map;
            Atom atom = this.atoms[i];
            int iso = atom.iso;
            String sa = "";
            if (iso != 0) {
                sa = sa + iso;
            }
            sa = sa + atom.getLabel();
            if ((addHydrogens || this.getValenceForMolOutput(i) > 0) && atom.nh > 0) {
                sa = sa + "H";
                if (atom.nh > 1) {
                    sa = sa + atom.nh;
                }
            }
            if (atom.q != 0) {
                sa = atom.q > 0 ? sa + "+" : sa + "-";
                if (Math.abs(atom.q) > 1) {
                    sa = sa + Math.abs(atom.q);
                }
            }
            if ((map = this.findAtomMapForOutput(i)) != 0) {
                sa = sa + ":" + map;
            }
            s = s + " " + sa + " " + JMEUtil.fformat(atom.x, 0, 2) + " " + JMEUtil.fformat(atom.y, 0, 2);
        }
        for (int i = 1; i <= this.nbonds; ++i) {
            int a1 = this.bonds[i].va;
            int a2 = this.bonds[i].vb;
            int nas = this.bonds[i].bondType;
            int stereo = this.bonds[i].stereo;
            if (this.bonds[i].bondType == 9) {
                nas = stereo;
            } else {
                switch (stereo) {
                    case 1: {
                        nas = -1;
                        break;
                    }
                    case 2: {
                        nas = -2;
                        break;
                    }
                    case 3: 
                    case 4: {
                        nas = stereo == 3 ? -1 : -2;
                        int d = a1;
                        a1 = a2;
                        a2 = d;
                        break;
                    }
                    case 10: {
                        nas = -5;
                    }
                }
            }
            s = s + " " + a1 + " " + a2 + " " + nas;
        }
        return s;
    }

    public String createMolFile(String header, boolean stampDate, Rectangle2D.Double box) {
        int i;
        String s = this.mdlHeaderLines(header, stampDate, false);
        this.transformAtomCoordinatesForOutput(box);
        for (i = 1; i <= this.natoms; ++i) {
            int delta;
            Atom atom = this.atoms[i];
            s = s + JMEUtil.fformat(atom.x, 10, 4) + JMEUtil.fformat(atom.y, 10, 4) + JMEUtil.fformat(0.0, 10, 4);
            String z = this.getAtomLabel(i);
            if (z.length() == 1) {
                z = z + "  ";
            } else if (z.length() == 2) {
                z = z + " ";
            } else if (z.length() > 3) {
                z = "Q  ";
            }
            s = s + " " + z;
            int charge = 0;
            if (this.q(i) > 0 && this.q(i) < 4) {
                charge = 4 - this.q(i);
            } else if (this.q(i) < 0 && this.q(i) > -4) {
                charge = 4 - this.q(i);
            }
            int deltaIsotop = 0;
            if (atom.iso != 0 && (delta = Isotopes.getDeltaIsotopicMassOfElement(this.getAtomLabel(i), this.atoms[i].iso)) >= -3 && delta <= 4) {
                deltaIsotop = delta;
            }
            int vv = 0;
            vv = this.getValenceForMolOutput(i);
            z = JMEUtil.iformat(deltaIsotop, 2) + JMEUtil.iformat(charge, 3) + "  0" + JMEUtil.iformat(vv, 3) + "  0  0  0  0  0";
            int map = this.findAtomMapForOutput(i);
            z = z + JMEUtil.iformat(map, 3);
            s = s + z + "  0  0\n";
        }
        for (i = 1; i <= this.nbonds; ++i) {
            s = s + JMEWriter.getMOLStereoBond(this.bonds[i], false) + "\n";
        }
        for (i = 1; i <= this.natoms; ++i) {
            if (this.q(i) != 0) {
                s = s + "M  CHG  1" + JMEUtil.iformat(i, 4) + JMEUtil.iformat(this.q(i), 4) + "\n";
            }
            if (this.atoms[i].iso == 0) continue;
            s = s + "M  ISO  1" + JMEUtil.iformat(i, 4) + JMEUtil.iformat(this.atoms[i].iso, 4) + "\n";
        }
        s = s + "M  END\n";
        return s;
    }

    int getValenceForMolOutput(int at) {
        int val = 0;
        Atom atom = this.atoms[at];
        if (atom.nh > 0 && Atom.chargedMetalType(atom.an) != 0) {
            val = atom.nh + atom.nv;
        }
        return val;
    }

    String createExtendedMolFile2(String smiles) {
        return this.createExtendedMolFile(smiles, true, null);
    }

    public String createExtendedMolFile(String header, boolean stampDate, Rectangle2D.Double box) {
        int i;
        int i2;
        String s = this.mdlHeaderLines(header, stampDate, true);
        String mv30 = "M  V30 ";
        s = s + mv30 + "BEGIN CTAB\n";
        s = s + mv30 + "COUNTS " + this.natoms + " " + this.nbonds + " 0 0 " + this.mdlChiralFlag() + "\n";
        s = s + mv30 + "BEGIN ATOM\n";
        this.transformAtomCoordinatesForOutput(box);
        for (i2 = 1; i2 <= this.natoms; ++i2) {
            int val;
            Atom atom = this.atoms[i2];
            s = s + mv30;
            s = s + i2 + " " + this.getAtomLabel(i2);
            int m = this.findAtomMapForOutput(i2);
            s = s + " " + JMEUtil.fformat(atom.x, 0, 4) + " " + JMEUtil.fformat(atom.y, 0, 4) + " " + JMEUtil.fformat(0.0, 0, 4) + " " + m;
            if (atom.q != 0) {
                s = s + " CHG=" + atom.q;
            }
            if (atom.iso > 0) {
                s = s + " MASS=" + atom.iso;
            }
            if ((val = this.getValenceForMolOutput(i2)) != 0) {
                s = s + " VAL=" + val;
            }
            s = s + "\n";
        }
        s = s + mv30 + "END ATOM\n";
        s = s + mv30 + "BEGIN BOND\n";
        for (i2 = 1; i2 <= this.nbonds; ++i2) {
            s = s + mv30 + i2 + " " + JMEWriter.getMOLStereoBond(this.bonds[i2], true) + "\n";
        }
        s = s + mv30 + "END BOND\n";
        ArrayList<Integer> abs = new ArrayList<Integer>();
        ArrayList<ArrayList> orlists = new ArrayList<ArrayList>();
        ArrayList<ArrayList> mixlists = new ArrayList<ArrayList>();
        for (i = 0; i < 10; ++i) {
            orlists.add(null);
            mixlists.add(null);
        }
        for (i = 1; i <= this.natoms; ++i) {
            ArrayList l;
            ArrayList o;
            int n;
            String atag = this.atoms[i].atag;
            if (atag == null || atag.length() == 0) continue;
            if (atag.equals("abs")) {
                abs.add(new Integer(i));
                continue;
            }
            if (atag.startsWith("mix")) {
                n = Integer.parseInt(atag.substring(3));
                o = mixlists.size() > n ? (ArrayList)mixlists.get(n) : null;
                l = o == null ? new ArrayList() : o;
                l.add(new Integer(i));
                mixlists.set(n, l);
                continue;
            }
            if (!atag.startsWith("or")) continue;
            n = Integer.parseInt(atag.substring(2));
            o = orlists.size() > n ? (ArrayList)orlists.get(n) : null;
            l = o == null ? new ArrayList() : o;
            l.add(new Integer(i));
            orlists.set(n, l);
        }
        s = s + JMEWriter.appendMOLCollection("MDLV30/STEABS", abs, mv30);
        if (orlists.size() > 0) {
            for (i = 1; i < orlists.size(); ++i) {
                s = s + JMEWriter.appendMOLCollection("MDLV30/STEREL" + i, (ArrayList)orlists.get(i), mv30);
            }
        }
        if (mixlists.size() > 0) {
            for (i = 1; i < mixlists.size(); ++i) {
                s = s + JMEWriter.appendMOLCollection("MDLV30/STERAC" + i, (ArrayList)mixlists.get(i), mv30);
            }
        }
        s = s + mv30 + "END CTAB\n";
        s = s + "M  END\n";
        return s;
    }

    static String appendMOLCollection(String name, ArrayList<Integer> list, String mv30) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String s = "";
        s = s + mv30 + "BEGIN COLLECTION\n";
        s = s + mv30 + name + " [ATOMS=(" + list.size();
        Iterator<Integer> i = list.iterator();
        while (i.hasNext()) {
            s = s + " " + i.next();
        }
        s = s + ")]\n";
        s = s + mv30 + "END COLLECTION\n";
        return s;
    }

    protected String mdlHeaderLines(String header, boolean stampDate, boolean isV3000) {
        String s;
        int writeChiralFlag = isV3000 ? 0 : this.mdlChiralFlag();
        String string = s = header != null && (header = header.trim()).length() > 0 ? header : "_";
        if (s.length() > 79) {
            s = s.substring(0, 76) + "...";
        }
        s = s + "\n";
        String versiondate = "JME2024-12-13 " + new Date();
        s = s + JMEWriter.getSDFDateLine("JME2024-12-13") + "\n";
        s = s + versiondate + "\n";
        s = s + JMEUtil.iformat(isV3000 ? 0 : this.natoms, 3) + JMEUtil.iformat(isV3000 ? 0 : this.nbonds, 3);
        s = s + "  0  0" + JMEUtil.iformat(writeChiralFlag, 3) + "  0  0  0  0  0999 " + (isV3000 ? "V3000" : "V2000") + "\n";
        return s;
    }

    protected static String getMOLStereoBond(Bond bond, boolean isV3000) {
        String bonds;
        int bondType = bond.bondType;
        int a1 = bond.va;
        int a2 = bond.vb;
        int stereo = 0;
        if (bondType == 1 || bondType == 0) {
            switch (bond.stereo) {
                case 1: 
                case 3: {
                    stereo = 1;
                    break;
                }
                case 2: 
                case 4: {
                    stereo = 6;
                    break;
                }
                case 5: 
                case 6: {
                    stereo = 4;
                }
            }
            switch (bond.stereo) {
                case 3: 
                case 4: 
                case 6: {
                    int t = a1;
                    a1 = a2;
                    a2 = t;
                }
            }
        }
        if (bondType == 2 && bond.stereo == 10) {
            stereo = 3;
        }
        if (isV3000) {
            switch (stereo) {
                case 6: {
                    stereo = 3;
                    break;
                }
                case 3: 
                case 4: {
                    stereo = 2;
                }
            }
        }
        if (bondType == 0) {
            bondType = 8;
        } else if (bondType == 9 || bondType == 5) {
            bondType = 4;
        }
        if (isV3000) {
            bonds = bondType + " " + a1 + " " + a2;
            if (stereo != 0) {
                bonds = bonds + " CFG=" + stereo;
            }
        } else {
            bonds = JMEUtil.iformat(a1, 3) + JMEUtil.iformat(a2, 3) + JMEUtil.iformat(bondType, 3) + JMEUtil.iformat(stereo, 3) + "  0  0  0";
        }
        return bonds;
    }

    protected int mdlChiralFlag() {
        return this.getChiralFlag() != false && this.canBeChiral() ? 1 : 0;
    }

    public static String createMolfile(JMEmol mol, MolFileOrRxnParameters arg) {
        return arg.isV3000 ? JMEWriter.createExtendedMolFile(mol, arg.header, arg.stampDate, null) : JMEWriter.createMolFile(mol, arg.header, arg.stampDate, null);
    }

    public static String generateMolFileOrRxn(MolFileOrRxnParameters pars, JMEmolList molList) {
        if (!molList.isReaction) {
            return JMEWriter.createMolfile(molList.size() > 1 ? JMEmol.mergeMols(molList) : (JMEmol)molList.get(0), pars);
        }
        String s = "";
        int[] roles = molList.reactionParts(2).size() > 0 ? new int[]{1, 3, 2} : new int[]{1, 3};
        s = s + "$RXN\n\n\nJME Molecular Editor\n";
        for (int r : roles) {
            int n = pars.mergeReationComponents ? 1 : molList.reactionParts(r).size();
            s = s + JMEUtil.iformat(n, 3);
        }
        s = s + "\n";
        for (int r : roles) {
            JMEmolList mols = molList.reactionParts(r, pars.mergeReationComponents);
            for (JMEmol mol : mols) {
                s = s + "$MOL\n";
                s = s + JMEWriter.createMolfile(mol, pars);
            }
        }
        return s;
    }

    public static String generateSmilesOrSmirks(JMECore.Parameters pars, JMEmolList molList) {
        if (molList.isReaction) {
            return JMEWriter.generateSmilesOrSmirks(pars, molList.reactionParts(1)) + ">" + JMEWriter.generateSmilesOrSmirks(pars, molList.reactionParts(2)) + ">" + JMEWriter.generateSmilesOrSmirks(pars, molList.reactionParts(3));
        }
        String result = "";
        for (JMEmol mol : molList) {
            String smiles = mol.createSmiles(pars);
            if (smiles.length() <= 0) continue;
            if (result.length() > 0) {
                result = result + ".";
            }
            result = result + smiles;
        }
        return result;
    }

    public static String generateJMEstring(boolean showImplicitHydrogens, Rectangle2D.Double boundingBox, JMEmolList molList) {
        if (molList.isReaction) {
            return JMEWriter.generateJMEstring(showImplicitHydrogens, boundingBox, molList) + ">" + JMEWriter.generateJMEstring(showImplicitHydrogens, boundingBox, molList) + ">" + JMEWriter.generateJMEstring(showImplicitHydrogens, boundingBox, molList);
        }
        String result = "";
        for (JMEmol mol : molList) {
            String jme = JMEWriter.createJMEString(mol, showImplicitHydrogens, boundingBox);
            if (jme.length() <= 0) continue;
            if (result.length() > 0) {
                result = result + "|";
            }
            result = result + jme;
        }
        return result;
    }

    public static String getSDFDateLine(String version) {
        String mol = (version + "         ").substring(0, 10);
        Calendar c = Calendar.getInstance();
        int cMM = c.get(2);
        int cDD = c.get(5);
        int cYYYY = c.get(1);
        int cHH = c.get(11);
        int cmm = c.get(12);
        mol = mol + JMEUtil.rightJustify("00", "" + (1 + cMM));
        mol = mol + JMEUtil.rightJustify("00", "" + cDD);
        mol = mol + ("" + cYYYY).substring(2, 4);
        mol = mol + JMEUtil.rightJustify("00", "" + cHH);
        mol = mol + JMEUtil.rightJustify("00", "" + cmm);
        mol = mol + "2D 1   1.00000     0.00000     0";
        return mol;
    }

    public static enum SupportedOutputFileFormat {
        JME,
        SMILES,
        MOL,
        MOL_V3000,
        INCHI,
        INCHI_KEY,
        INCHI_AUXINFO,
        INCHI_JSON,
        OCLCODE,
        SVG,
        RAW_STRING_GRAPHIC;

    }

    public static class MolFileOrRxnParameters {
        public String header = "";
        public boolean stampDate = false;
        public boolean isV3000 = false;
        public boolean mergeReationComponents = false;
        public boolean debugDoNotUpdateReactionRole = false;
    }
}

