/*
 * Decompiled with CFR 0.152.
 */
package jme.io;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import jme.JME;
import jme.JMEmol;
import jme.JMEmolList;
import jme.core.Atom;
import jme.core.Bond;
import jme.core.JMECore;
import jme.io.ChemicalMimeType;
import jme.js.AsyncCallback;
import jme.util.Isotopes;
import jme.util.JMEUtil;

public class JMEReader {
    private MajorChemicalFormat majorChemicalFormat;
    private MinorChemicalFormat minorChemicalFormat;
    private Author author;
    private JMEReader embeddedChemicalFormat;
    protected boolean isReaction;
    private String chemicalString;
    private String error;
    private SupportedInputFileFormat fileTypeRead;
    static final Pattern InchiKeyPattern = Pattern.compile("^[A-Z]{14}\\-[A-Z]{10}\\-[A-Z]$");
    static final Pattern Smiles6Pattern = Pattern.compile("^[^J][a-z0-9@+\\-\\[\\]\\(\\)\\\\\\/%=#$:>]{6,}$", 2);
    static final Pattern SmilesOrSmirksPattern = Pattern.compile("^[a-z0-9@+\\-\\[\\]\\(\\)\\\\\\/%=#$:>\\\\.]+$", 2);
    static final Pattern NonSmilesPattern = Pattern.compile("j");
    static final Pattern SpacePattern = Pattern.compile("\\s+");
    static final Pattern Smartspattern = Pattern.compile("^[a-z0-9@+\\-\\[\\]\\(\\)\\\\\\/%=#$:\\\\.,;!&]+$", 2);
    static final Pattern ExtendedSmartsExtraPattern = Pattern.compile("[\\^]");
    static final Pattern SmartsExtraPattern = Pattern.compile("[,;!&]", 2);
    static final Pattern CSRMlpattern = Pattern.compile("\\s*^(<\\?xml\\s+[^>]+>)?\\s*<\\s*csrml\\b", 2);
    static final Pattern URLpattern = Pattern.compile("$\\w+:\\/\\/");
    private byte[] chemicalBytes;
    private boolean formatDetected;
    private static byte[] cdxMagic = new byte[]{86, 106, 67, 68};

    public String getError() {
        return this.error;
    }

    public SupportedInputFileFormat getFileTypeRead() {
        return this.fileTypeRead;
    }

    public boolean wasFormatDetected() {
        return this.formatDetected;
    }

    public JMEReader(Object chemicalStringOrBytes) {
        this.formatDetected = this.detectFormat(chemicalStringOrBytes);
    }

    private void reset() {
        this.init(null);
    }

    private static boolean isCDXML(String s) {
        return s.indexOf("<CDXML") >= 0;
    }

    private static boolean isCDX(byte[] b) {
        return JMEReader.bytesMatch(b, 0, cdxMagic);
    }

    private static boolean bytesMatch(byte[] a, int pt, byte[] b) {
        if (b.length > a.length - pt) {
            return false;
        }
        int i = b.length;
        while (--i >= 0) {
            if (a[pt + i] == b[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean detectFormat(Object chemicalStringOrBytes) {
        boolean success;
        block35: {
            int numberOfLines;
            block36: {
                block37: {
                    String mol;
                    block34: {
                        this.reset();
                        success = false;
                        if (chemicalStringOrBytes instanceof byte[]) {
                            this.chemicalBytes = (byte[])chemicalStringOrBytes;
                            if (JMEReader.isCDX(this.chemicalBytes)) {
                                this.majorChemicalFormat = MajorChemicalFormat.CDX;
                                return true;
                            }
                            chemicalStringOrBytes = new String(this.chemicalBytes);
                            this.chemicalBytes = null;
                        }
                        this.chemicalString = (String)chemicalStringOrBytes;
                        if (this.chemicalString == null || URLpattern.matcher(this.chemicalString).find()) {
                            return false;
                        }
                        if (JMEReader.isCDXML(this.chemicalString)) {
                            this.majorChemicalFormat = MajorChemicalFormat.CDXML;
                            return true;
                        }
                        numberOfLines = JMEReader.countLines(this.chemicalString, 5);
                        if (numberOfLines == 1) {
                            this.chemicalString = this.chemicalString.trim();
                        }
                        if (this.chemicalString.length() == 0) {
                            return false;
                        }
                        if (!CSRMlpattern.matcher(this.chemicalString).find()) break block34;
                        this.majorChemicalFormat = MajorChemicalFormat.CSRML;
                        break block35;
                    }
                    if (numberOfLines <= 4) break block36;
                    if (!this.chemicalString.startsWith("<")) break block37;
                    if (this.chemicalString.toLowerCase().startsWith("<svg") && (mol = ChemicalMimeType.extractEmbeddedChemicalString(this.chemicalString)) != null) {
                        this.embeddedChemicalFormat = new JMEReader(mol);
                        if (this.embeddedChemicalFormat.majorChemicalFormat != null) {
                            this.majorChemicalFormat = MajorChemicalFormat.SVG;
                        }
                    }
                    break block35;
                }
                if (!this.chemicalString.contains("M  END") && (!this.chemicalString.contains("M END") || !this.chemicalString.contains("V2000") && !this.chemicalString.contains("V3000"))) break block36;
                this.majorChemicalFormat = MajorChemicalFormat.MOL;
                if (this.chemicalString.contains("V2000")) {
                    this.minorChemicalFormat = MinorChemicalFormat.V2000;
                }
                if (this.chemicalString.contains("V3000")) {
                    this.minorChemicalFormat = MinorChemicalFormat.V3000;
                }
                if (this.chemicalString.startsWith("$RXN")) {
                    this.majorChemicalFormat = MajorChemicalFormat.RXN;
                    break block35;
                } else if (this.chemicalString.contains("$$$$")) {
                    this.majorChemicalFormat = MajorChemicalFormat.SDF;
                }
                break block35;
            }
            if (numberOfLines == 1) {
                Matcher m;
                if (this.chemicalString.startsWith("InChI=") || this.chemicalString.startsWith("AuxInfo=")) {
                    this.majorChemicalFormat = MajorChemicalFormat.InChI;
                } else if (this.chemicalString.length() == 27 && (m = InchiKeyPattern.matcher(this.chemicalString)).find()) {
                    this.majorChemicalFormat = MajorChemicalFormat.InChIkey;
                } else if (this.chemicalString.length() >= 1) {
                    boolean hasSpace = SpacePattern.matcher(this.chemicalString).find();
                    if (hasSpace) {
                        StringTokenizer st = new StringTokenizer(this.chemicalString, " |");
                        try {
                            String next = st.nextToken();
                            while (next.equals("|")) {
                                next = st.nextToken();
                            }
                            int natomsx = Integer.valueOf(next);
                            int nbondsx = Integer.valueOf(st.nextToken());
                            for (int i = 0; i < 3 * (natomsx + nbondsx); ++i) {
                                st.nextToken();
                            }
                            this.isReaction = this.chemicalString.indexOf(">") > 0;
                            this.majorChemicalFormat = MajorChemicalFormat.JME;
                        }
                        catch (Exception next) {}
                    } else if (OclCheck.isOclIdCode(this.chemicalString)) {
                        this.majorChemicalFormat = MajorChemicalFormat.OCLCODE;
                    } else if (!NonSmilesPattern.matcher(this.chemicalString).find()) {
                        boolean isSmiles;
                        boolean isReaction = this.chemicalString.indexOf(">") > 0;
                        boolean isSmarts = Smartspattern.matcher(this.chemicalString).find();
                        boolean canBeExtendedSmarts = ExtendedSmartsExtraPattern.matcher(this.chemicalString).find();
                        boolean bl = isSmiles = SmilesOrSmirksPattern.matcher(this.chemicalString).find() && !SmartsExtraPattern.matcher(this.chemicalString).find() && !canBeExtendedSmarts;
                        if (isSmiles) {
                            this.majorChemicalFormat = MajorChemicalFormat.SMILES;
                            if (isReaction) {
                                this.majorChemicalFormat = MajorChemicalFormat.SMIRKS;
                                this.isReaction = isReaction;
                            }
                        } else if (isSmarts || canBeExtendedSmarts) {
                            this.majorChemicalFormat = MajorChemicalFormat.SMARTS;
                            if (canBeExtendedSmarts) {
                                this.minorChemicalFormat = MinorChemicalFormat.extended;
                            }
                        }
                    }
                }
            }
        }
        if (this.majorChemicalFormat != null) {
            success = true;
            this.setAuthor();
        }
        return success;
    }

    private void setAuthor() {
        switch (this.majorChemicalFormat) {
            case InChIkey: 
            case InChI: {
                this.author = Author.IUPAC;
                break;
            }
            case SMILES: 
            case SMARTS: 
            case SMIRKS: {
                this.author = Author.DAYLIGHT;
                break;
            }
            case CSRML: {
                this.author = Author.MolecularNetworks;
                break;
            }
            case CDX: 
            case CDXML: {
                this.author = Author.RevitySignals;
                break;
            }
            case JME: {
                this.author = Author.P_ERTL;
                break;
            }
            case MOL: 
            case RXN: 
            case SDF: {
                this.author = Author.MDL;
                break;
            }
            case OCLCODE: {
                this.author = Author.OPENCHEMLIB;
                break;
            }
        }
    }

    private boolean isReaction() {
        return this.isReaction || this.majorChemicalFormat == MajorChemicalFormat.RXN || this.majorChemicalFormat == MajorChemicalFormat.SMIRKS;
    }

    private static int countLines(String str, int stop) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            if (stop > 0 && lines > stop) {
                return lines;
            }
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 >= len || str.charAt(pos + 1) != '\n') continue;
                ++pos;
                continue;
            }
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private void init(JMEReader other) {
        if (other == null) {
            this.author = null;
            this.majorChemicalFormat = null;
            this.minorChemicalFormat = null;
            this.isReaction = false;
            return;
        }
        this.author = other.author;
        this.majorChemicalFormat = other.majorChemicalFormat;
        this.minorChemicalFormat = other.minorChemicalFormat;
        this.isReaction = other.isReaction;
        this.embeddedChemicalFormat = other.embeddedChemicalFormat;
        this.chemicalString = other.chemicalString;
        this.chemicalBytes = other.chemicalBytes;
    }

    public static JMEmolList readMDLstringInput(String s, JMECore.Parameters pars) {
        JMEmolList molList = new JMEmolList();
        try {
            molList.isReaction = s.startsWith("$RXN");
            if (molList.isReaction) {
                molList.addAll(JMEReader.readReactionMols(s, pars));
            } else {
                molList.add(JMEReader.readSingleMOL(s, pars));
            }
        }
        catch (Exception e) {
            molList.error = e;
            return null;
        }
        return molList;
    }

    public static JMEmolList readJMEstringInput(String molecule, JMECore.Parameters pars) {
        JMEmolList molList = new JMEmolList();
        StringTokenizer st = new StringTokenizer(molecule, "|>", true);
        molList.isReaction = molecule.indexOf(">") > -1;
        int nt = st.countTokens();
        int roleIndex = 0;
        for (int i = 1; i <= nt; ++i) {
            String s = st.nextToken();
            s.trim();
            if (s.equals("|")) continue;
            if (s.equals(">")) {
                ++roleIndex;
                continue;
            }
            if (roleIndex > 3) {
                return molList.setErrorMsg("too many \">\"");
            }
            JMEmol mol = null;
            try {
                mol = new JMEmol(null, s, SupportedInputFileFormat.JME, pars);
                if (mol.natoms == 0) {
                    return molList.setErrorMsg("0 atoms found in \"" + s + "\"");
                }
            }
            catch (Exception e) {
                return molList.setErrorMsg(JME.makeErrorMessage(e) + ": " + s);
            }
            molList.add(mol);
            if (!molList.isReaction) continue;
            mol.setReactionRole(JMEmol.ReactionRole.all[roleIndex]);
        }
        return molList;
    }

    private static List<JMEmol> readReactionMols(String s, JMECore.Parameters pars) throws Exception {
        ArrayList<JMEmol> mols = new ArrayList<JMEmol>();
        String separator = JMEUtil.findLineSeparator(s);
        StringTokenizer st = new StringTokenizer(s, separator, true);
        String line = "";
        for (int i = 1; i <= 5; ++i) {
            line = JMEUtil.nextData(st, separator);
        }
        int nr = Integer.valueOf(line.substring(0, 3).trim());
        int np = Integer.valueOf(line.substring(3, 6).trim());
        int na = 0;
        if (line.length() >= 9) {
            na = Integer.valueOf(line.substring(6, 9).trim());
        }
        JMEUtil.nextData(st, separator);
        for (int p = 1; p <= nr + np + na; ++p) {
            String ns;
            String m = "";
            while ((ns = JMEUtil.nextData(st, separator)) != null && !ns.equals("$MOL")) {
                m = m + ns + separator;
            }
            JMEmol mol = JMEReader.readSingleMOL(m, pars);
            mols.add(mol);
            if (p <= nr) {
                mol.setReactionRole(1);
                continue;
            }
            if (p > nr && p <= nr + np) {
                mol.setReactionRole(3);
                continue;
            }
            mol.setReactionRole(2);
        }
        return mols;
    }

    private static JMEmol readSingleMOL(String s, JMECore.Parameters pars) throws Exception {
        return new JMEmol(null, s, SupportedInputFileFormat.MOL, pars);
    }

    public static void createMolFromString(JMECore mol, String jmeString) {
        if (jmeString.startsWith("\"")) {
            jmeString = jmeString.substring(1, jmeString.length());
        }
        if (jmeString.endsWith("\"")) {
            jmeString = jmeString.substring(0, jmeString.length() - 1);
        }
        if (jmeString.length() < 1) {
            mol.natoms = 0;
            return;
        }
        try {
            int i;
            StringTokenizer st = new StringTokenizer(jmeString);
            int natomsx = Integer.valueOf(st.nextToken());
            int nbondsx = Integer.valueOf(st.nextToken());
            for (i = 1; i <= natomsx; ++i) {
                String symbol = st.nextToken();
                Atom atom = mol.createAtom(symbol);
                atom.x = Double.valueOf(st.nextToken());
                atom.y = -Double.valueOf(st.nextToken()).doubleValue();
            }
            for (i = 1; i <= nbondsx; ++i) {
                Bond bond = mol.createAndAddBondFromOther(null);
                bond.va = Integer.valueOf(st.nextToken());
                bond.vb = Integer.valueOf(st.nextToken());
                int bondType = Integer.valueOf(st.nextToken());
                int stereob = 0;
                if (bondType == -1) {
                    bondType = 1;
                    stereob = 1;
                } else if (bondType == -2) {
                    bondType = 1;
                    stereob = 2;
                } else if (bondType == -5) {
                    bondType = 2;
                    stereob = 10;
                } else if (bondType == 11 || bondType == 12 || bondType == 13 || bondType == 14) {
                    stereob = bondType;
                    bondType = 9;
                }
                bond.bondType = bondType;
                bond.stereo = stereob;
            }
            mol.finalizeMolecule();
        }
        catch (Exception e) {
            System.err.println("read JSME string exception - " + e.getMessage());
            mol.natoms = 0;
            throw e;
        }
    }

    public static void createMolFromMolData(JMECore mol, String molData) {
        int i;
        String line = "";
        String separator = JMEUtil.findLineSeparator(molData);
        if (separator == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(molData, separator, true);
        for (int i2 = 1; i2 <= 4; ++i2) {
            line = JMEUtil.nextData(st, separator);
        }
        int natomsx = Integer.valueOf(line.substring(0, 3).trim());
        int nbondsx = Integer.valueOf(line.substring(3, 6).trim());
        int chiral = 0;
        try {
            chiral = Integer.valueOf(line.substring(14, 15).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        mol.setChiralFlag(chiral == 1);
        int[] valences = new int[natomsx + 1];
        for (i = 1; i <= natomsx; ++i) {
            int delta;
            int mark;
            String s;
            Atom atom = mol.createAtom();
            line = JMEUtil.nextData(st, separator);
            atom.x = Double.valueOf(line.substring(0, 10).trim());
            atom.y = -Double.valueOf(line.substring(10, 20).trim()).doubleValue();
            atom.z = Double.valueOf(line.substring(20, 30).trim());
            int endsymbol = 34;
            if (line.length() < 34) {
                endsymbol = line.length();
            }
            String symbol = line.substring(31, endsymbol).trim();
            mol.setAtom(i, symbol);
            if (line.length() >= 62 && (s = line.substring(60, 63).trim()).length() > 0 && (mark = Integer.valueOf(s).intValue()) > 0) {
                mol.setAtomMapFromInput(i, mark);
            }
            if (line.length() >= 36 && (s = line.substring(34, 36).trim()).length() > 0 && (delta = Integer.valueOf(s).intValue()) != 0 && delta >= -3 && delta <= 4) {
                int iso = Isotopes.getIsotopicMassOfElementDelta(symbol, delta);
                if (iso < 0) {
                    iso = 0;
                }
                mol.atoms[i].iso = iso;
            }
            if (line.length() >= 39 && (s = line.substring(37, 39).trim()).length() > 0 && (delta = Integer.valueOf(s).intValue()) > 0 && delta <= 7) {
                int charge = 0;
                switch (delta) {
                    case 1: {
                        charge = 3;
                        break;
                    }
                    case 2: {
                        charge = 2;
                        break;
                    }
                    case 3: {
                        charge = 1;
                        break;
                    }
                    case 4: {
                        charge = 0;
                        break;
                    }
                    case 5: {
                        charge = -1;
                        break;
                    }
                    case 6: {
                        charge = -2;
                        break;
                    }
                    case 7: {
                        charge = -3;
                    }
                }
                mol.Q(i, charge);
            }
            if (line.length() < 45 || (s = line.substring(43, 45).trim()).length() <= 0) continue;
            valences[i] = Integer.valueOf(s);
        }
        for (i = 1; i <= nbondsx; ++i) {
            Bond bond = mol.createAndAddBondFromOther(null);
            line = JMEUtil.nextData(st, separator);
            bond.va = Integer.valueOf(line.substring(0, 3).trim());
            bond.vb = Integer.valueOf(line.substring(3, 6).trim());
            int nasvx = Integer.valueOf(line.substring(6, 9).trim());
            int bondType = nasvx == 1 ? 1 : (nasvx == 2 ? 2 : (nasvx == 3 ? 3 : (nasvx == 8 ? 0 : 9)));
            int stereoVal = 0;
            if (line.length() > 11) {
                stereoVal = Integer.valueOf(line.substring(9, 12).trim());
            }
            if (bondType == 1 || bondType == 0) {
                if (stereoVal == 1) {
                    bond.stereo = 1;
                } else if (stereoVal == 6) {
                    bond.stereo = 2;
                } else if (stereoVal == 4) {
                    bond.stereo = 5;
                }
            }
            if (nasvx == 2 && stereoVal == 3) {
                bondType = 2;
                bond.stereo = 10;
            }
            bond.bondType = bondType;
        }
        while (st.hasMoreTokens() && (line = st.nextToken()) != null && !line.startsWith("M  END")) {
            int a;
            int i3;
            int ndata;
            if (line.startsWith("M  CHG")) {
                StringTokenizer stq = new StringTokenizer(line);
                stq.nextToken();
                stq.nextToken();
                ndata = Integer.valueOf(stq.nextToken());
                for (i3 = 1; i3 <= ndata; ++i3) {
                    int a2 = Integer.valueOf(stq.nextToken());
                    mol.atoms[a2].q = Integer.valueOf(stq.nextToken());
                }
            }
            if (line.startsWith("M  ISO")) {
                StringTokenizer stq = new StringTokenizer(line);
                stq.nextToken();
                stq.nextToken();
                ndata = Integer.valueOf(stq.nextToken());
                for (i3 = 1; i3 <= ndata; ++i3) {
                    a = Integer.valueOf(stq.nextToken());
                    mol.atoms[a].iso = Integer.valueOf(stq.nextToken());
                }
            }
            if (!line.startsWith("M  APO")) continue;
            StringTokenizer stq = new StringTokenizer(line);
            stq.nextToken();
            stq.nextToken();
            ndata = Integer.valueOf(stq.nextToken());
            for (i3 = 1; i3 <= ndata; ++i3) {
                a = Integer.valueOf(stq.nextToken());
                int nr = Integer.valueOf(stq.nextToken());
                mol.addBondToAtom(1, a, 0, false, 0.0);
                mol.setAtom(mol.natoms, "R" + nr);
            }
        }
        for (i = 1; i <= natomsx; ++i) {
            if (valences[i] <= 0) continue;
            int nv = mol.atoms[i].nv;
            if (valences[i] != 15) {
                int nh = valences[i] - nv;
                if (nh <= 0) continue;
                mol.atoms[i].nh = nh;
                continue;
            }
            mol.atoms[i].nh = 0;
        }
        mol.finalizeMolecule();
    }

    public void readMoleculeData(JME jme, boolean runAsync, AsyncCallback callback, boolean recordEvent, boolean repaint) {
        if (this.majorChemicalFormat == MajorChemicalFormat.SVG && this.embeddedChemicalFormat != null) {
            this.init(this.embeddedChemicalFormat);
        }
        if (this.author == Author.MDL && this.minorChemicalFormat != MinorChemicalFormat.V3000) {
            if (jme.handleReadMolFileRXN(this.chemicalString, false)) {
                this.fileTypeRead = this.isReaction() ? SupportedInputFileFormat.RXN : SupportedInputFileFormat.MOL;
            } else {
                this.error = "Invalid V2000 molfile";
            }
            return;
        }
        if (this.author == Author.P_ERTL) {
            if (jme.readMolecule(this.chemicalString, false)) {
                this.fileTypeRead = SupportedInputFileFormat.JME;
            } else {
                this.error = "Invalid JME string";
            }
            return;
        }
        if (this.majorChemicalFormat == MajorChemicalFormat.CSRML) {
            this.error = "Reading " + (Object)((Object)this.majorChemicalFormat) + " is not supported";
            return;
        }
        Runnable r = () -> this.oclSuccess(jme, callback, recordEvent, repaint);
        if (runAsync) {
            SwingUtilities.invokeLater(r);
        } else {
            r.run();
        }
    }

    private void oclSuccess(JME jme, AsyncCallback callback, boolean recordEvent, boolean repaint) {
        String error = null;
        String convertedmolFile = null;
        SupportedInputFileFormat fileTypeRead = null;
        switch (this.majorChemicalFormat) {
            case MOL: {
                if (this.minorChemicalFormat != MinorChemicalFormat.V3000) break;
                try {
                    convertedmolFile = JMEReader.v3000toV2000MOL(this.chemicalString);
                    if (convertedmolFile == null) {
                        throw new Exception("V3000 read failed.");
                    }
                    fileTypeRead = SupportedInputFileFormat.MOL_V3000;
                    jme.sdfPastedMessage.innerString = "V3000 conversion provided by OpenChemLib";
                }
                catch (Exception e) {
                    error = e.getMessage();
                }
                break;
            }
            case SMILES: 
            case SMARTS: 
            case SMIRKS: {
                try {
                    convertedmolFile = jme.SMILESorSMIRKStoMolOrRXN(this.chemicalString);
                    switch (this.majorChemicalFormat) {
                        case SMIRKS: {
                            fileTypeRead = SupportedInputFileFormat.SMIRKS;
                            break;
                        }
                        case SMILES: {
                            fileTypeRead = SupportedInputFileFormat.SMILES;
                            break;
                        }
                        case SMARTS: {
                            fileTypeRead = SupportedInputFileFormat.SMARTS;
                        }
                    }
                    jme.sdfPastedMessage.innerString = "SMILES conversion provided by OpenChemLib";
                }
                catch (Exception e) {
                    error = "SMILES parsing error:" + e.getMessage();
                }
                break;
            }
            case OCLCODE: {
                try {
                    convertedmolFile = jme.oclCodeToMOL(this.chemicalString);
                    fileTypeRead = SupportedInputFileFormat.OCLCODE;
                    error = null;
                }
                catch (Exception e) {
                    error = "OCL parsing failed";
                }
                break;
            }
            case CDX: {
                try {
                    convertedmolFile = jme.cdxToMOL(this.chemicalBytes);
                    fileTypeRead = SupportedInputFileFormat.CDX;
                    error = null;
                }
                catch (Exception e) {
                    error = "CDX parsing failed";
                }
                break;
            }
            case CDXML: {
                try {
                    convertedmolFile = jme.cdxmlToMOL(this.chemicalString);
                    fileTypeRead = SupportedInputFileFormat.CDXML;
                    error = null;
                }
                catch (Exception e) {
                    error = "CDXML parsing failed";
                    e.printStackTrace();
                }
                break;
            }
            case InChI: 
            case CSRML: {
                try {
                    convertedmolFile = jme.inchiToMOL(this.chemicalString);
                    fileTypeRead = SupportedInputFileFormat.INCHI;
                    error = null;
                }
                catch (Exception e) {
                    error = "InChI parsing failed";
                }
                break;
            }
            case InChIkey: {
                try {
                    convertedmolFile = jme.inchikeyToMOL(this.chemicalString);
                    fileTypeRead = SupportedInputFileFormat.INCHIKEY;
                    error = null;
                }
                catch (Exception e) {
                    error = "InChIKey parsing failed";
                }
                break;
            }
        }
        if (convertedmolFile != null && error == null) {
            boolean success = false;
            try {
                success = jme.handleReadMolFileRXN(convertedmolFile, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!success) {
                error = "Invalid molfile data";
            }
        }
        jme.processFileRead(callback, fileTypeRead, error, repaint);
    }

    private static String v3000toV2000MOL(String v3000Mol) throws Exception {
        return JME.getOclAdapter().v3000toV2000MOL(v3000Mol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JMEReader r = (JMEReader)o;
        return JMEReader.equals((Object)this.author, (Object)r.author) && JMEReader.equals((Object)this.majorChemicalFormat, (Object)r.majorChemicalFormat) && JMEReader.equals((Object)this.minorChemicalFormat, (Object)r.minorChemicalFormat) && JMEReader.equals(this.isReaction, r.isReaction) && JMEReader.equals(this.embeddedChemicalFormat, r.embeddedChemicalFormat);
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static enum SupportedInputFileFormat {
        CDX,
        CDXML,
        INCHI,
        INCHIKEY,
        JME,
        SMARTS,
        SMILES,
        MOL,
        MOL_V3000,
        OCLCODE,
        RXN,
        SMIRKS;

    }

    private static enum Author {
        MDL,
        DAYLIGHT,
        IUPAC,
        OPENCHEMLIB,
        P_ERTL,
        MolecularNetworks,
        RevitySignals;

    }

    private static enum MinorChemicalFormat {
        V2000,
        V3000,
        extended;

    }

    private static enum MajorChemicalFormat {
        CDX,
        CDXML,
        MOL,
        RXN,
        SDF,
        SMILES,
        SMARTS,
        SMIRKS,
        InChI,
        InChIkey,
        OCLCODE,
        JME,
        SVG,
        CSRML;

    }

    private static class OclCheck {
        private int nAvail = 6;
        private int pt;
        private byte[] idcode;
        private int mData;
        private int abits;
        private int bbits;
        private int nBytes;

        private OclCheck() {
        }

        protected static boolean isOclIdCode(String s) {
            return new OclCheck().isIDCode(s);
        }

        private boolean isIDCode(String s) {
            this.nBytes = s.indexOf(33);
            if (this.nBytes < 0) {
                this.nBytes = s.indexOf(35);
            }
            if (this.nBytes < 0) {
                this.nBytes = s.length();
            }
            if (this.nBytes < 10 || this.nBytes > 1000) {
                return false;
            }
            this.idcode = s.substring(0, this.nBytes).getBytes();
            this.mData = (this.idcode[0] & 0x3F) << 11;
            try {
                if (this.idcode == null || this.idcode.length == 0) {
                    return false;
                }
                this.abits = this.decodeBits(4);
                this.bbits = this.decodeBits(4);
                int version = 8;
                if (this.abits > 8) {
                    version = this.abits;
                    this.abits = this.bbits;
                }
                if (version != 8 && version != 9) {
                    return false;
                }
                int allAtoms = this.decodeBits(this.abits);
                int allBonds = this.decodeBits(this.bbits);
                int closureBonds = 1 + allBonds - allAtoms;
                if (allAtoms == 0 || closureBonds < 0 || closureBonds > allAtoms - 2) {
                    return false;
                }
                int nitrogens = this.decodeBits(this.abits);
                int oxygens = this.decodeBits(this.abits);
                int otherAtoms = this.decodeBits(this.abits);
                int chargedAtoms = this.decodeBits(this.abits);
                this.checkBits(nitrogens);
                this.checkBits(oxygens);
                this.checkBits(otherAtoms);
                this.checkBits(chargedAtoms);
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }

        private void checkBits(int n) {
            if (n != 0) {
                for (int i = 0; i < n; ++i) {
                    this.decodeBits(this.abits);
                }
            }
        }

        private int decodeBits(int bits) {
            int allBits = bits;
            int data = 0;
            while (bits != 0) {
                if (this.nAvail == 0) {
                    if (++this.pt >= this.idcode.length) {
                        throw new NullPointerException();
                    }
                    this.mData = (this.idcode[this.pt] & 0x3F) << 11;
                    this.nAvail = 6;
                }
                data |= (0x10000 & this.mData) >> 16 - allBits + bits;
                this.mData <<= 1;
                --bits;
                --this.nAvail;
            }
            return data;
        }
    }
}

