/*
 * Decompiled with CFR 0.152.
 */
package jme.gui;

import jme.JME;
import jme.JMEmol;
import jme.core.Atom;
import jme.core.Bond;
import jme.core.JMECore;
import jme.io.JMEReader;

public class JMEBuilder {
    public static final int TOUCH_LIMIT = 50;
    public static final int LA_FAILED = 9;
    public boolean spiroAdding = false;
    private JME jme;
    private JMEmol mol;
    private Atom[] atoms;
    private Bond[] bonds;
    private int touchedAtom;
    private int touchedBond;
    private int action;
    private boolean spiroMode;
    private JMEmol templateMolecule;
    private String templateString;
    private boolean linearAdding;
    private static final int LINEAR_ON = Integer.MAX_VALUE;
    private static final int LINEAR_OFF = Integer.MIN_VALUE;

    public JMEBuilder(JME jme) {
        this.jme = jme;
    }

    public JMEBuilder set(JMEmol mol, int action, boolean spiroMode) {
        if (mol != null) {
            this.mol = mol;
            this.atoms = mol.atoms;
            this.bonds = mol.bonds;
            this.touchedAtom = mol.touchedAtom;
            this.touchedBond = mol.touchedBond;
            this.action = action;
            this.spiroMode = spiroMode;
        }
        return this;
    }

    public void addBond() {
        this.mol.addBondToAtom(this.action, this.touchedAtom, 0, false);
        this.bonds = this.mol.bonds;
    }

    public void addRing() {
        int returnTouch = -1;
        int nmembered = 6;
        switch (this.action) {
            case 206: {
                nmembered = 3;
                break;
            }
            case 207: {
                nmembered = 4;
                break;
            }
            case 208: 
            case 221: 
            case 223: {
                nmembered = 5;
                break;
            }
            case 209: 
            case 210: {
                nmembered = 6;
                break;
            }
            case 211: {
                nmembered = 7;
                break;
            }
            case 212: {
                nmembered = 8;
                break;
            }
            case 229: {
                nmembered = 9;
            }
        }
        double diel = Math.PI * 2 / (double)nmembered;
        double rc = Math.sqrt(312.5 / (1.0 - Math.cos(diel)));
        Atom a = this.atoms[this.touchedAtom];
        Bond b = this.bonds[this.touchedBond];
        if (this.touchedAtom > 0) {
            if (a.nv < 2) {
                this.addRingToBond(nmembered, diel, rc);
            } else if (this.spiroMode || this.spiroAdding) {
                this.spiroAdding = false;
                if (this.action == 209 || this.action == 221 || this.action == 223) {
                    this.mol.failed("ERROR - cannot add aromatic spiro ring !");
                    return;
                }
                for (int i = 1; i <= a.nv; ++i) {
                    int bo = this.mol.getBond((int)this.touchedAtom, (int)a.v[i]).bondType;
                    if (i <= 2 && bo == 1) continue;
                    this.mol.failed("ERROR - spiro ring not possible here !");
                    return;
                }
                double[] newPoint = new double[2];
                this.mol.getNewPoint(this.touchedAtom, rc, newPoint);
                double dx = a.x - newPoint[0];
                double dy = a.y - newPoint[1];
                double rx = Math.sqrt(dx * dx + dy * dy);
                if (rx < 0.001) {
                    rx = 0.001;
                }
                double sina = dy / rx;
                double cosa = dx / rx;
                for (int i = 1; i <= nmembered; ++i) {
                    Atom newAtom = this.createAtom();
                    double uhol = diel * (double)i + 1.5707963267948966;
                    JMECore.XY(newAtom, newPoint[0] + rc * (Math.sin(uhol) * cosa - Math.cos(uhol) * sina), newPoint[1] + rc * (Math.cos(uhol) * cosa + Math.sin(uhol) * sina));
                }
            } else {
                returnTouch = this.touchedAtom;
                this.jme.setLastAction(2);
                this.addBond();
                this.touchedAtom = this.mol.natoms;
                this.addRingToBond(nmembered, diel, rc);
            }
        } else if (this.touchedBond > 0) {
            double dy;
            double dx;
            double rx;
            int revert;
            int atom1 = b.va;
            int atom2 = b.vb;
            Atom a1 = this.atoms[atom1];
            Atom a2 = this.atoms[atom2];
            int atom3 = 0;
            if (a1.nv == 2) {
                atom3 = a1.v[1] != atom2 ? a1.v[1] : a1.v[2];
            } else if (a2.nv == 2) {
                atom3 = a2.v[1] != atom1 ? a2.v[1] : a2.v[2];
                revert = atom1;
                atom1 = atom2;
                atom2 = revert;
            }
            if (atom3 == 0) {
                atom3 = a1.v[1] != atom2 ? a1.v[1] : a1.v[2];
            }
            if ((rx = Math.sqrt((dx = a2.x - a1.x) * dx + (dy = a2.y - a1.y) * dy)) < 0.001) {
                rx = 0.001;
            }
            double sina = dy / rx;
            double cosa = dx / rx;
            double xx = rx / 2.0;
            double yy = rc * Math.sin((Math.PI - diel) * 0.5);
            revert = 1;
            Atom a3 = this.atoms[atom3];
            if ((a3.y - a1.y) * cosa - (a3.x - a1.x) * sina > 0.0) {
                yy = -yy;
                revert = 0;
            }
            double xstart = a1.x + xx * cosa - yy * sina;
            double ystart = a1.y + yy * cosa + xx * sina;
            for (int i = 1; i <= nmembered; ++i) {
                Atom newAtom = this.createAtom();
                double uhol = diel * ((double)i + 0.5) + Math.PI * (double)revert;
                JMECore.XY(newAtom, xstart + rc * (Math.sin(uhol) * cosa - Math.cos(uhol) * sina), ystart + rc * (Math.cos(uhol) * cosa + Math.sin(uhol) * sina));
                if (revert == 1) {
                    if (i == nmembered) {
                        JMECore.XY(newAtom, a1.x, a1.y);
                    }
                    if (i != nmembered - 1) continue;
                    JMECore.XY(newAtom, a2.x, a2.y);
                    continue;
                }
                if (i == nmembered - 1) {
                    JMECore.XY(newAtom, a1.x, a1.y);
                }
                if (i != nmembered) continue;
                JMECore.XY(newAtom, a2.x, a2.y);
            }
        } else {
            double helpv = 0.5;
            if (nmembered == 6) {
                helpv = 0.0;
            }
            for (int i = 1; i <= nmembered; ++i) {
                Atom newAtom = this.createAtom();
                double uhol = diel * ((double)i - helpv);
                JMECore.XY(newAtom, this.mol.xorg + rc * Math.sin(uhol), this.mol.yorg + rc * Math.cos(uhol));
            }
        }
        this.completeRing(nmembered);
        this.checkRing(nmembered);
        this.mol.setBondCenters();
        if (returnTouch > -1) {
            this.touchedAtom = returnTouch;
        }
    }

    void addRingToBond(int nmembered, double diel, double rc) {
        double cosa;
        double sina;
        int atom1 = 0;
        Atom a = this.atoms[this.touchedAtom];
        if (a.nv == 0) {
            sina = 0.0;
            cosa = 1.0;
        } else {
            double dy;
            atom1 = a.v[1];
            double dx = a.x - this.mol.x(atom1);
            double rx = Math.sqrt(dx * dx + (dy = a.y - this.mol.y(atom1)) * dy);
            if (rx < 0.001) {
                rx = 0.001;
            }
            sina = dy / rx;
            cosa = dx / rx;
        }
        double xstart = a.x + rc * cosa;
        double ystart = a.y + rc * sina;
        for (int i = 1; i <= nmembered; ++i) {
            Atom newAtom = this.createAtom();
            double uhol = diel * (double)i - 1.5707963267948966;
            newAtom.XY(xstart + rc * (Math.sin(uhol) * cosa - Math.cos(uhol) * sina), ystart + rc * (Math.cos(uhol) * cosa + Math.sin(uhol) * sina));
        }
    }

    void completeRing(int nmembered) {
        int i;
        int atom = 0;
        Bond b = null;
        for (i = 1; i <= nmembered; ++i) {
            b = this.createAndAddNewBond();
            atom = this.mol.natoms - nmembered + i;
            this.mol.NV(atom, 2);
            b.va = atom;
            b.vb = atom + 1;
        }
        b.vb = this.mol.natoms - nmembered + 1;
        b = this.bonds[this.touchedBond];
        if (this.action == 209) {
            if (this.touchedBond > 0) {
                this.setBonds(2, 1, 2, 1, 2);
                if (b.isSingle()) {
                    int atom3 = 0;
                    if (this.mol.nv(b.va) > 1) {
                        atom3 = this.mol.v(b.va)[1];
                        atom = b.va;
                        if (atom3 == b.vb) {
                            atom3 = this.mol.v(b.va)[2];
                        }
                    }
                    if (atom3 == 0 && this.mol.nv(b.vb) > 1) {
                        atom3 = this.mol.v(b.vb)[1];
                        atom = b.vb;
                        if (atom3 == b.vb) {
                            atom3 = this.mol.v(b.vb)[2];
                        }
                    }
                    if (atom3 > 0) {
                        for (i = 1; i <= this.mol.nbonds; ++i) {
                            if (!this.bonds[i].isAB(atom, atom3)) continue;
                            if (!this.bonds[i].isSingle()) {
                                this.setBonds(2, 1, 2, 1, 3, 1);
                            }
                            break;
                        }
                    }
                } else {
                    this.setBonds(2, 1, 2, 1, 2, 1);
                }
            } else {
                this.setBonds(2, 1, 2, 1, 2);
            }
        } else if (this.action == 221 || this.action == 223) {
            if (this.touchedBond > 0) {
                if (b.bondType == 1) {
                    int i2;
                    Atom va = this.atoms[b.va];
                    Atom vb = this.atoms[b.vb];
                    boolean isConjugated = false;
                    for (i2 = 1; i2 <= va.nv; ++i2) {
                        if (this.mol.getBond((int)b.va, (int)va.v[i2]).bondType <= 1) continue;
                        isConjugated = true;
                        break;
                    }
                    for (i2 = 1; i2 <= this.mol.nv(b.vb); ++i2) {
                        int ax = vb.v[i2];
                        if (this.mol.getBond((int)b.vb, (int)ax).bondType <= 1) continue;
                        isConjugated = true;
                        break;
                    }
                    if (!isConjugated) {
                        b.bondType = 2;
                    }
                }
                this.bonds[this.mol.nbonds - 4].bondType = 2;
                this.mol.AN(this.mol.natoms - 2, 5);
            } else if (this.touchedAtom > 0) {
                if (this.action == 221) {
                    this.setBonds(1, 2, 1, 1, 2);
                    this.mol.AN(this.mol.natoms - 1, 5);
                } else {
                    this.setBonds(2, 1, 1, 2, 1);
                    this.mol.AN(this.mol.natoms - 2, 5);
                }
            } else {
                this.setBonds(2, 1, 1, 2, 1);
                this.mol.AN(this.mol.natoms - 2, 5);
            }
        }
    }

    private Bond createAndAddNewBond(int a, int b, int bondType) {
        Bond bond = this.mol.createAndAddNewBond(a, b, bondType);
        this.bonds = this.mol.bonds;
        return bond;
    }

    private Bond createAndAddNewBond() {
        Bond b = this.mol.createAndAddBondFromOther(null);
        this.bonds = this.mol.bonds;
        return b;
    }

    private Atom createAtom() {
        Atom a = this.mol.createAtom();
        this.atoms = this.mol.atoms;
        return a;
    }

    private void createAtom(double x, double y) {
        this.createAtom();
        this.mol.nbonds = 0;
        this.mol.XY(1, x, y);
        this.mol.touchedAtom = 1;
        this.touchedAtom = 1;
        this.mol.touched_org = 1;
    }

    private void checkRing(int nmembered) {
        int j;
        int n;
        int[] parent = new int[this.mol.natoms + 1];
        for (int i = 1; i <= nmembered; ++i) {
            int ratom = this.mol.natoms - nmembered + i;
            int rbond = this.mol.nbonds - nmembered + i;
            this.atoms[ratom].v[1] = ratom - 1;
            this.atoms[ratom].v[2] = ratom + 1;
            this.mol.setBondCenter(this.bonds[rbond]);
        }
        this.mol.v((int)(n - nmembered + 1))[1] = n = this.mol.natoms;
        this.mol.v((int)n)[2] = n - nmembered + 1;
        for (int i = this.mol.natoms - nmembered + 1; i <= this.mol.natoms; ++i) {
            parent[i] = 0;
            Atom a = this.atoms[i];
            double min = 51.0;
            int tooCloseAtom = 0;
            for (j = 1; j <= this.mol.natoms - nmembered; ++j) {
                Atom b = this.atoms[j];
                double dx = a.x - b.x;
                double dy = a.y - b.y;
                double rx = dx * dx + dy * dy;
                if (!(rx < 50.0) || !(rx < min)) continue;
                min = rx;
                tooCloseAtom = j;
            }
            if (tooCloseAtom <= 0 || this.touchedAtom != 0 && tooCloseAtom != this.touchedAtom) continue;
            parent[i] = tooCloseAtom;
        }
        int noldbonds = this.mol.nbonds - nmembered;
        block3: for (int i = noldbonds + 1; i <= noldbonds + nmembered; ++i) {
            int atom1 = this.bonds[i].va;
            int atom2 = this.bonds[i].vb;
            int p1 = parent[atom1];
            int p2 = parent[atom2];
            if (p1 > 0 && p2 > 0) {
                for (int k = 1; k <= noldbonds; ++k) {
                    if (this.bonds[k].isAB(p1, p2)) continue block3;
                }
                this.createAndAddNewBond(p1, p2, this.bonds[i].bondType);
                continue;
            }
            if (p1 > 0) {
                this.createAndAddNewBond(p1, atom2, this.bonds[i].bondType);
                continue;
            }
            if (p2 <= 0) continue;
            this.createAndAddNewBond(p2, atom1, this.bonds[i].bondType);
        }
        int noldatoms = this.mol.natoms - nmembered;
        for (int i = this.mol.natoms; i > noldatoms; --i) {
            int pi = parent[i];
            if (pi <= 0) continue;
            this.mol.deleteAtom(i);
            if (this.atoms[pi].an != 3) continue;
            int sum = 0;
            for (j = 1; j <= this.atoms[pi].nv; ++j) {
                int aj = this.atoms[pi].v[j];
                for (int k = 1; k <= this.mol.nbonds; ++k) {
                    Bond b = this.bonds[k];
                    if (!b.isAB(pi, aj)) continue;
                    sum += b.bondType;
                }
            }
            if (sum <= 4) continue;
            for (int k = noldbonds + 1; k <= noldbonds + nmembered; ++k) {
                this.bonds[k].bondType = 1;
            }
        }
        if (this.touchedAtom > 0) {
            this.mol.avoidTouch(nmembered);
        }
    }

    int addGroupTemplate(boolean emptyCanvas) {
        JMEmol tmol = this.templateMolecule;
        if (tmol == null || tmol.natoms == 0) {
            return 0;
        }
        int mark1 = 0;
        mark1 = tmol.findFirstMappdedOrMarkedAtom();
        if (mark1 == 0) {
            mark1 = 1;
        }
        int nn = this.mol.natoms;
        int source = this.touchedAtom;
        GroupTemplateBondDirection bd = new GroupTemplateBondDirection();
        boolean hasTwoPossibleAddAngle = bd.initBondCreate(this.mol, source, 1);
        GroupTemplateBondDirection alternativeBD = null;
        if (hasTwoPossibleAddAngle) {
            alternativeBD = new GroupTemplateBondDirection();
            alternativeBD.initBondCreate(this.mol, source, -1);
        }
        GroupTemplateBondDirection templateBD = new GroupTemplateBondDirection();
        templateBD.initBondCreate(tmol, mark1, 0);
        this.mol.addOtherMolToMe(tmol);
        this.mol.complete(this.mol.parameters.computeValenceState);
        this.atoms[nn + mark1].resetMap();
        if (!emptyCanvas) {
            templateBD.moveAndRotateFragment(this.mol, nn + 1, this.mol.natoms, source, bd);
            if (hasTwoPossibleAddAngle) {
                double closeContactFactor = bd.sumAtomTooCloseContactsOfAddedFragment(nn + 1, this.mol.natoms);
                for (int ta = 1; ta <= tmol.natoms; ++ta) {
                    this.mol.XY(nn + ta, tmol.x(ta), tmol.y(ta));
                }
                templateBD.moveAndRotateFragment(this.mol, nn + 1, this.mol.natoms, source, alternativeBD);
                double alternativecloseContactFactor = bd.sumAtomTooCloseContactsOfAddedFragment(nn + 1, this.mol.natoms);
                if (!(alternativecloseContactFactor <= closeContactFactor)) {
                    for (int ta = 1; ta <= tmol.natoms; ++ta) {
                        this.mol.XY(nn + ta, tmol.x(ta), tmol.y(ta));
                    }
                    templateBD.moveAndRotateFragment(this.mol, nn + 1, this.mol.natoms, source, bd);
                }
            }
        }
        this.createAndAddNewBond();
        this.bonds[this.mol.nbonds].va = source;
        this.bonds[this.mol.nbonds].vb = mark1 + nn;
        if (emptyCanvas) {
            this.mol.deleteAtom(source);
            this.mol.center();
        }
        this.mol.complete(this.mol.parameters.computeValenceState);
        return tmol.natoms;
    }

    public void addGroup(boolean emptyCanvas) {
        this.mol.touched_org = this.touchedAtom;
        int nadded = 0;
        switch (this.action) {
            case 2033: 
            case 2036: 
            case 2037: 
            case 2039: 
            case 2051: 
            case 2052: {
                this.addBonds(this.touchedAtom, Integer.MAX_VALUE, 0, Integer.MIN_VALUE, -1, -2);
                switch (this.action) {
                    case 2037: {
                        this.setAtoms(10, 10, 10);
                        break;
                    }
                    case 2036: {
                        this.setAtoms(9, 9, 9);
                        break;
                    }
                    case 2039: {
                        this.setAtoms(8, 5, 5, 5);
                        this.setBonds(1, 1, 2, 2);
                        break;
                    }
                    case 2052: {
                        this.setAtoms(8, 4, 5, 5);
                        this.setBonds(1, 1, 2, 2);
                        break;
                    }
                    case 2051: {
                        this.setAtoms(7, 5, 5, 5);
                        this.setBonds(1, 1, 1, 2);
                    }
                }
                nadded = 4;
                break;
            }
            case 2044: {
                this.addBonds(this.touchedAtom, 0, Integer.MAX_VALUE, 0, Integer.MIN_VALUE, -1, -2);
                nadded = this.setAtoms(4, 8, 3, 5, 5);
                this.setBonds(1, 1, 1, 2, 2);
                break;
            }
            case 2034: {
                this.addBonds(this.touchedAtom, 0, -1);
                nadded = this.setAtoms(4, 5, 5);
                this.setBonds(1, 2, this.jme.options.polarnitro ? 1 : 2);
                if (!this.jme.options.polarnitro) break;
                this.setCharges(-1);
                break;
            }
            case 2035: {
                this.addBonds(this.touchedAtom, 0, -1);
                nadded = this.setAtoms(3, 5, 5);
                this.setBonds(1, 1, 2);
                break;
            }
            case 2040: {
                this.addBonds(this.touchedAtom, 0, 0, -2);
                nadded = this.setAtoms(3, 5, 3, 5);
                this.setBonds(2);
                break;
            }
            case 2060: {
                this.addBonds(this.touchedAtom, 0, -1);
                nadded = this.setAtoms(3, 4, 5);
                this.setBonds(2);
                break;
            }
            case 2061: {
                this.addBonds(this.touchedAtom, 0, 0);
                nadded = this.setAtoms(4, 3, 5);
                this.setBonds(2);
                break;
            }
            case 2041: {
                this.addBonds(this.touchedAtom, 0, 0, -1);
                nadded = this.setAtoms(5, 3, 3, 5);
                this.setBonds(2);
                break;
            }
            case 2043: {
                this.addBonds(this.touchedAtom, 0, -1);
                nadded = this.setAtoms(4, 3, 3);
                break;
            }
            case 2038: {
                this.addBonds(this.touchedAtom, Integer.MAX_VALUE, 0, Integer.MIN_VALUE);
                this.setBonds(3);
                nadded = 2;
                break;
            }
            case 2049: {
                this.addBonds(this.touchedAtom, 0);
                nadded = this.setAtoms(3, 5);
                this.setBonds(2);
                break;
            }
            case 2050: {
                this.addBonds(this.touchedAtom);
                nadded = this.setAtoms(5);
                this.setBonds(2);
                break;
            }
            case 2045: {
                this.addBonds(this.touchedAtom, Integer.MAX_VALUE, 0, 0, Integer.MIN_VALUE);
                nadded = this.setAtoms(3, 3, 3);
                this.setBonds(3, 1);
                break;
            }
            case 2042: {
                this.addBonds(this.touchedAtom, Integer.MAX_VALUE, 0, Integer.MIN_VALUE);
                nadded = this.setAtoms(3, 4);
                this.setBonds(3);
                break;
            }
            case 2054: {
                this.addBonds(this.touchedAtom);
                nadded = this.setAtoms(9);
                break;
            }
            case 2055: {
                this.addBonds(this.touchedAtom);
                nadded = this.setAtoms(10);
                break;
            }
            case 2056: {
                this.addBonds(this.touchedAtom);
                nadded = this.setAtoms(11);
                break;
            }
            case 2057: {
                this.addBonds(this.touchedAtom);
                nadded = this.setAtoms(12);
                break;
            }
            case 2058: {
                this.addBonds(this.touchedAtom);
                nadded = this.setAtoms(4);
                break;
            }
            case 2059: {
                this.addBonds(this.touchedAtom);
                nadded = this.setAtoms(5);
                break;
            }
            case 2046: {
                this.addBonds(this.touchedAtom, 0);
                break;
            }
            case 2047: {
                this.addBonds(this.touchedAtom, 0, 0);
                break;
            }
            case 2048: {
                this.addBonds(this.touchedAtom, 0, 0, 0);
                break;
            }
            case 2053: {
                nadded = this.addGroupTemplate(emptyCanvas);
            }
        }
        this.mol.avoidTouch(nadded);
        if (emptyCanvas) {
            this.mol.touchedAtom = 0;
        }
    }

    private void addBonds(int ... b) {
        block4: for (int i = 0; i < b.length; ++i) {
            int mode = b[i];
            switch (mode) {
                case 0x7FFFFFFF: {
                    this.linearAdding = true;
                    continue block4;
                }
                case -2147483648: {
                    this.linearAdding = false;
                    continue block4;
                }
                default: {
                    this.mol.addBondToAtom(0, mode > 0 ? mode : this.mol.natoms + mode, 0, this.linearAdding);
                    this.bonds = this.mol.bonds;
                }
            }
        }
    }

    private void setBonds(int ... bo) {
        int pt = this.mol.nbonds - bo.length + 1;
        for (int i = 0; i < bo.length; ++i) {
            this.mol.bonds[pt++].bondType = bo[i];
        }
    }

    private int setAtoms(int ... an) {
        int n = an.length;
        int pt = this.mol.natoms - n + 1;
        for (int i = 0; i < n; ++i) {
            this.mol.atoms[pt++].an = an[i];
        }
        return n;
    }

    private void setCharges(int ... ch) {
        int pt = this.mol.natoms - ch.length + 1;
        for (int i = 0; i < ch.length; ++i) {
            this.mol.atoms[pt++].q = ch[i];
        }
    }

    public String setTemplate(String t) throws Exception {
        this.templateString = t;
        JMECore.Parameters pars = new JMECore.Parameters();
        pars.mark = true;
        this.templateMolecule = new JMEmol(this.jme, t, JMEReader.SupportedInputFileFormat.JME, pars);
        this.templateMolecule.internalBondLengthScaling();
        if (!this.templateMolecule.hasMappedOrMarkedAtom()) {
            return "template molecule has no mapped atom";
        }
        return null;
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public void checkBondAction() {
        String event = null;
        boolean cleanPolar = false;
        Bond b = this.mol.bonds[this.mol.touchedBond];
        switch (this.action) {
            case 104: {
                this.deleteAtomOrBond();
                this.jme.updatePartsList();
                break;
            }
            case 106: {
                this.mol.deleteAtomGroup();
                cleanPolar = true;
                this.mol.touchedBond = 0;
                event = "delBondGroup";
                break;
            }
            case 201: {
                this.mol.toggleBondStereo(this.mol.touchedBond);
                event = "setBondStereo";
                break;
            }
            case 202: 
            case 205: {
                if (b.bondType == 1 && b.stereo == 0) {
                    b.bondType = 2;
                    event = "setBondDouble";
                } else {
                    b.bondType = 1;
                    b.stereo = 0;
                    event = "setBondSingle";
                }
                b.stereo = 0;
                break;
            }
            case 203: {
                boolean differentBondOrder = b.bondType != 2;
                b.bondType = 2;
                if (!differentBondOrder) {
                    this.mol.toggleDoubleBondStereo(b);
                } else {
                    b.stereo = 0;
                }
                cleanPolar = true;
                event = "setBondDouble";
                break;
            }
            case 204: {
                if (b.smallRing) break;
                b.bondType = 3;
                b.stereo = 0;
                cleanPolar = true;
                event = "setBondTriple";
                break;
            }
            default: {
                if (this.action < 206 || this.action > 229) break;
                this.jme.setLastAction(2);
                this.addRing();
                cleanPolar = true;
                event = "addRingBond";
            }
        }
        if (cleanPolar) {
            this.mol.cleanAfterChanged(this.jme.options.polarnitro);
        }
        if (event != null) {
            this.jme.recordBondEvent(event, this.mol.touchedBond);
        }
    }

    public void checkAtomOrBondAction() {
        if (this.touchedAtom > 0) {
            this.checkAtomAction();
        } else if (this.touchedBond > 0) {
            this.checkBondAction();
        }
    }

    public void checkAtomAction() {
        String event = null;
        if (this.action == 104) {
            this.deleteAtomOrBond();
            this.jme.updatePartsList();
        } else {
            if (this.action == 106) {
                return;
            }
            if (this.action == 108) {
                if (this.mol.changeCharge(this.mol.touchedAtom, 0)) {
                    event = "chargeAtom0";
                }
            } else if (this.action == 202 || this.action == 203 || this.action == 204 || this.action == 201 || this.action == 205) {
                this.jme.setLastAction(1);
                this.addBond();
                this.mol.touched_org = this.mol.touchedAtom;
                if (this.action == 205) {
                    this.mol.nchain = 1;
                    this.mol.chain[1] = this.mol.natoms;
                    this.mol.chain[0] = this.mol.touchedAtom;
                    this.mol.touchedBond = 0;
                    this.jme.willPostSave(false);
                } else {
                    this.jme.recordBondEvent("addBond");
                    event = null;
                }
            } else if (this.action >= 206 && this.action <= 229) {
                this.jme.setLastAction(2);
                this.addRing();
                event = "addRing";
            } else if (this.action == 2030) {
                this.jme.setLastAction(3);
                event = "addTemplate";
            } else if (this.action >= 2033 && this.action < 2062) {
                this.addGroup(false);
                event = "addGroup";
                this.jme.setLastAction(3);
            } else if (this.action > 300 && (this.jme.active_an != this.mol.an(this.mol.touchedAtom) || this.jme.active_an == 32)) {
                this.mol.AN(this.mol.touchedAtom, this.jme.active_an);
                this.mol.Q(this.mol.touchedAtom, 0);
                this.mol.atoms[this.mol.touchedAtom].iso = 0;
                this.mol.atoms[this.mol.touchedAtom].nh = 0;
                if (this.jme.active_an == 32) {
                    this.mol.setAtom(this.mol.touchedAtom, this.jme.getAtomSymbolForX());
                }
                event = "setAtom";
            }
        }
        if (event != null) {
            this.jme.recordAtomEvent(event, this.mol.touchedAtom);
        }
    }

    public void deleteAtomOrBond() {
        if (this.mol.touchedAtom > 0) {
            this.mol.deleteAtom(this.mol.touchedAtom);
            this.jme.recordAtomEvent("delAtom");
            this.mol.touchedAtom = 0;
        } else if (this.mol.touchedBond > 0) {
            Bond b = this.mol.bonds[this.mol.touchedBond];
            int deletableAtoms = this.mol.deleteBond(this.mol.touchedBond, false);
            this.jme.recordBondEvent("delBond");
            switch (deletableAtoms) {
                case 0: {
                    break;
                }
                case 1: 
                case 3: {
                    this.mol.deleteAtom(b.va);
                    this.jme.recordAtomEvent("delAtom");
                    if (deletableAtoms == 1) break;
                }
                case 2: {
                    this.mol.deleteAtom(b.vb);
                    this.jme.recordAtomEvent("delAtom");
                }
            }
            this.mol.touchedBond = 0;
        }
        this.mol.cleanAfterChanged(this.jme.options.polarnitro);
    }

    public void newMolecule(double x, double y) {
        if (this.action >= 202 && this.action <= 204 || this.action == 205) {
            this.createAtom(x, y);
            this.jme.setLastAction(1);
            this.addBond();
            if (this.action == 205) {
                this.mol.XY(2, x + 21.65, y - 12.5);
                this.mol.chain[0] = 1;
                this.mol.chain[1] = 2;
                this.mol.nchain = 1;
                this.jme.recordBondEvent("addChain");
            } else {
                this.jme.recordBondEvent("addBond");
            }
            return;
        }
        if (this.action >= 206 && this.action <= 229) {
            this.mol.xorg = x;
            this.mol.yorg = y;
            this.jme.setLastAction(2);
            this.addRing();
            this.jme.recordAfterStructureChangedEvent("addRing");
            return;
        }
        if (this.action == 2030) {
            this.jme.recordAfterStructureChangedEvent("addTemplate");
            return;
        }
        if (this.action >= 2033 && this.action < 2062) {
            this.createAtom(x, y);
            this.addGroup(true);
            this.jme.recordAfterStructureChangedEvent("addGroup");
            return;
        }
        if (this.action >= 301) {
            this.createAtom(x, y);
            if (this.jme.active_an == 32) {
                this.mol.setAtom(1, this.jme.getAtomSymbolForX());
            } else {
                this.mol.AN(1, this.jme.active_an);
            }
            this.jme.recordAtomEvent("addAtom");
            return;
        }
        System.err.println("error -report fall through bug Builder.newMolecule! " + this.action);
    }

    public boolean setAtom(int active_an) {
        if (active_an != this.mol.an(this.mol.touchedAtom) && active_an != 32) {
            this.mol.AN(this.mol.touchedAtom, active_an);
            this.mol.Q(this.mol.touchedAtom, 0);
            this.mol.atoms[this.mol.touchedAtom].iso = 0;
            this.mol.atoms[this.mol.touchedAtom].nh = 0;
        } else if (active_an == 32) {
            String xx = this.jme.atomicSymbol.getText();
            this.mol.setAtom(this.mol.touchedAtom, xx);
        } else {
            return false;
        }
        this.jme.recordAtomEvent("setAtom");
        return true;
    }

    public static class GroupTemplateBondDirection {
        public double sin;
        public double cos;
        public double x;
        public double y;
        private JMEmol mol;

        public void init(JMEmol mol, int sourceAtom, int destAtom) {
            this.x = mol.x(destAtom);
            this.y = mol.y(destAtom);
            double dx = mol.x(sourceAtom) - this.x;
            double dy = mol.y(sourceAtom) - this.y;
            double r = Math.sqrt(dx * dx + dy * dy);
            this.sin = dy / r;
            this.cos = dx / r;
        }

        public boolean initBondCreate(JMEmol mol, int sourceAtom, int addBondArgument) {
            this.mol = mol;
            int nh = mol.atoms[sourceAtom].nh;
            int nv = mol.atoms[sourceAtom].nv;
            int q = mol.atoms[sourceAtom].q;
            Boolean b = mol.addBondToAtom(0, sourceAtom, addBondArgument, false);
            boolean hasTwoPossibleAddAngle = b == Boolean.TRUE;
            int destAtom = mol.natoms;
            this.init(mol, sourceAtom, destAtom);
            mol.deleteAtom(destAtom);
            mol.atoms[sourceAtom].nh = nh;
            mol.atoms[sourceAtom].nv = nv;
            mol.atoms[sourceAtom].q = q;
            return hasTwoPossibleAddAngle;
        }

        public void moveAndRotateFragment(JMEmol mol, int ffirst, int flast, int sourceAt, GroupTemplateBondDirection sourceBD) {
            for (int i = ffirst; i <= flast; ++i) {
                Atom atom = mol.atoms[i];
                atom.moveXY(-this.x, -this.y);
                double xx = atom.x * this.cos + atom.y * this.sin;
                double yy = atom.y * this.cos - atom.x * this.sin;
                atom.XY(xx, yy);
                xx = -atom.x * sourceBD.cos + atom.y * sourceBD.sin;
                yy = -atom.y * sourceBD.cos - atom.x * sourceBD.sin;
                atom.XY(xx, yy);
                atom.moveXY(mol.atoms[sourceAt].x, mol.atoms[sourceAt].y);
            }
        }

        public double sumAtomTooCloseContactsOfAddedFragment(int fragmentFirstAtom, int fragmentLastAtom) {
            double result = 0.0;
            for (int at = 1; at <= this.mol.natoms; ++at) {
                if (at >= fragmentFirstAtom && at <= fragmentLastAtom) continue;
                result += this.sumAtomTooCloseContacts(at, fragmentFirstAtom, fragmentLastAtom);
            }
            return result;
        }

        private double sumAtomTooCloseContacts(int atom, int firstAtom, int lastAtom) {
            double min = 100.0;
            double sum = 0.0;
            double x = this.mol.atoms[atom].x;
            double y = this.mol.atoms[atom].y;
            for (int i = firstAtom; i <= lastAtom; ++i) {
                double dy;
                double dx;
                double rx;
                if (atom == i || !((rx = (dx = x - this.mol.atoms[i].x) * dx + (dy = y - this.mol.atoms[i].y) * dy) < min)) continue;
                if (rx == 0.0) {
                    rx = 1.0E-4;
                }
                sum += 1.0 / rx;
            }
            return sum;
        }
    }
}

