/*
 * Decompiled with CFR 0.152.
 */
package jme.gui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;

class FrameWithLocation
extends JFrame {
    protected Point lastLocation;
    protected JButton closeJButton;

    public FrameWithLocation(String title) {
        super(title);
        this.initialize();
    }

    public FrameWithLocation() {
        this.initialize();
    }

    public String closeJButtonJLabel() {
        return "Close";
    }

    public void initialize() {
        this.closeJButton = new JButton(this.closeJButtonJLabel());
        this.closeJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameWithLocation.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrameWithLocation.this.setVisible(false);
            }
        });
    }

    @Override
    public void setVisible(boolean tf) {
        if (tf) {
            this.setLocation(this.lastLocation);
        } else if (this.isShowing()) {
            Point currentLocation = this.getLocationOnScreen();
            this.lastLocation.setLocation(currentLocation);
        }
        super.setVisible(tf);
    }

    public void disposeIfShowing() {
        if (this.isShowing()) {
            this.dispose();
        }
    }

    public static void safeTranslate(Point location, int deltaX, int deltaY) {
        location.translate(deltaX, deltaY);
        location.x = location.x < 0 ? 0 : location.x;
        location.y = location.y < 0 ? 0 : location.y;
    }
}

