/*
 * Decompiled with CFR 0.152.
 */
package jme.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jme.event.ChangeAtomPropertyCallback;
import jme.event.InspectorEvent;

public class AtomInspector {
    JDialog modalDialog;
    JFrame window;
    ActionListener actionListener;
    JTextField atomicMapField;
    ChangeAtomPropertyCallback change;

    public AtomInspector(final ChangeAtomPropertyCallback change) {
        final JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        this.atomicMapField = new JTextField("0", 4);
        this.change = change;
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomInspector.this.modalDialog.setVisible(false);
                if (e.getSource() == ok) {
                    String newInputValue = AtomInspector.this.atomicMapField.getText().trim();
                    try {
                        int newValue = Integer.parseInt(newInputValue);
                        change.setAtomValue(newValue);
                    }
                    catch (NumberFormatException exception) {
                        change.reportError("invalid atom " + AtomInspector.this.change.actionType() + ": " + newInputValue);
                    }
                }
            }
        };
        this.modalDialog = new JDialog();
        this.modalDialog.setModal(true);
        this.modalDialog.setLayout(new FlowLayout());
        ok.addActionListener(this.actionListener);
        cancel.addActionListener(this.actionListener);
        String label = "New atom " + change.actionType();
        this.modalDialog.add(new JLabel(label));
        this.modalDialog.add(ok);
        this.modalDialog.add(cancel);
        this.modalDialog.setLayout(new BorderLayout(2, 0));
        JPanel p = new JPanel();
        p.add(new JLabel("new atom " + change.actionType(), 0));
        p.add(this.atomicMapField);
        this.modalDialog.add("North", p);
        p = new JPanel();
        p.add(ok);
        p.add(cancel);
        this.modalDialog.add("South", p);
        this.modalDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AtomInspector.this.modalDialog.setVisible(false);
            }
        });
    }

    public void action(InspectorEvent event) {
        if (event.atomIndex > 0) {
            String title = "Change " + this.change.actionType() + " of atom  " + this.change.atomSymbol + " #" + event.atomIndex;
            this.modalDialog.setTitle(title);
            this.atomicMapField.setText("" + this.change.getAtomValue());
            this.modalDialog.setMinimumSize(new Dimension(250, 100));
            this.modalDialog.pack();
            Point loc = event.jme.getLocationOnScreen();
            this.modalDialog.setLocation(loc.x + event.x + 30, loc.y + event.y);
            this.modalDialog.setVisible(true);
            this.atomicMapField.requestFocusInWindow();
            this.atomicMapField.select(0, 1000);
        }
    }
}

