/*
 * Decompiled with CFR 0.152.
 */
package jme.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.BitSet;
import jme.JMEmol;
import jme.canvas.PreciseGraphicsAWT;
import jme.core.Atom;
import jme.core.Bond;
import jme.gui.GUI;

public class AtomDisplayLabel {
    public double smallAtomWidthLabel = 0.0;
    public double fullAtomWidthLabel;
    public int alignment;
    public boolean noLabelAtom;
    public Rectangle2D.Double drawBox;
    public Rectangle2D.Double fillSupBox;
    public Rectangle2D.Double fillBox;
    public double labelX;
    public double labelY;
    public String str;
    int boundingBoxpadding = 2;
    public double atomMapY;
    public double atomMapX;
    public String mapString;
    private BitSet subscripts;
    private BitSet superscripts;
    private BitSet bsSS;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_LEFT = 0;

    public static AtomDisplayLabel create(Atom atom, int alignment, FontMetrics fm, double h, boolean showHs, boolean showMap) {
        return new AtomDisplayLabel(atom, alignment, fm, h, showHs, showMap);
    }

    public AtomDisplayLabel(Atom a, int alignment, FontMetrics fm, double h, boolean showHs, boolean showMap) {
        int pos;
        String isoSymbol;
        int map = showMap && a.hasBeenMapped() ? a.getMap() : -1;
        String z = a.getLabel();
        if (z == null || z.length() < 1) {
            z = "*";
            System.err.println("Z error!");
        }
        this.alignment = alignment;
        int padding = 2;
        this.noLabelAtom = a.an == 3 && a.q == 0 && a.iso == 0 && a.nv > 0 && (a.nv != 2 || a.sbo != 4);
        String hydrogenSymbols = "";
        if (showHs && !this.noLabelAtom && a.nh > 0) {
            hydrogenSymbols = hydrogenSymbols + "H";
            if (a.nh > 1) {
                hydrogenSymbols = hydrogenSymbols + a.nh;
            }
        }
        String string = isoSymbol = a.iso == 0 ? "" : "[" + a.iso + "]";
        String chargeSymbols = a.q == 0 ? "" : (Math.abs(a.q) > 1 ? "" + Math.abs(a.q) : "") + (a.q > 0 ? "+" : "-");
        String stringForWidth = z;
        z = alignment == 2 ? chargeSymbols + hydrogenSymbols + isoSymbol + z : isoSymbol + z + hydrogenSymbols + chargeSymbols;
        this.str = z;
        if (alignment == 1) {
            stringForWidth = z;
        }
        if (hydrogenSymbols.length() > 1) {
            pos = z.indexOf(hydrogenSymbols);
            if (this.subscripts == null) {
                this.subscripts = new BitSet();
            }
            this.subscripts.set(pos + 1, pos + hydrogenSymbols.length());
        }
        if (chargeSymbols.length() > 0) {
            pos = z.indexOf(chargeSymbols);
            if (this.superscripts == null) {
                this.superscripts = new BitSet();
            }
            this.superscripts.set(pos, pos + chargeSymbols.length());
        }
        if (isoSymbol.length() > 0) {
            pos = z.indexOf(isoSymbol);
            if (this.superscripts == null) {
                this.superscripts = new BitSet();
            }
            this.superscripts.set(pos, pos + isoSymbol.length());
        }
        int nsub = this.subscripts == null ? 0 : this.subscripts.cardinality();
        int nsup = this.superscripts == null ? 0 : this.superscripts.cardinality();
        double xAdj1 = 0.0;
        double xAdj2 = 0.0;
        double yAdj1 = 0.0;
        double yAdj2 = 0.0;
        double ssCharWidth = fm.charWidth('2');
        if (nsub != 0 || nsup != 0) {
            this.bsSS = new BitSet();
            if (nsub > 0) {
                this.bsSS.or(this.subscripts);
                yAdj1 = 1.0;
            }
            if (nsup > 0) {
                this.bsSS.or(this.superscripts);
                yAdj2 = 1.0;
            }
            xAdj2 = (double)nsup * ssCharWidth * 0.4;
            xAdj1 = (double)nsub * ssCharWidth * 0.4;
        }
        double smallWidth = fm.stringWidth(stringForWidth);
        double fullWidth = (double)fm.stringWidth(z) - xAdj1 - xAdj2;
        this.smallAtomWidthLabel = smallWidth;
        this.fullAtomWidthLabel = fullWidth;
        boolean lineThickness = true;
        double x = a.x;
        double y = a.y;
        double xstart = x - smallWidth / 2.0;
        switch (alignment) {
            case 2: {
                xstart -= fullWidth - smallWidth;
                xstart += (double)nsup * ssCharWidth * 0.6;
                break;
            }
            case 1: {
                xstart += (double)nsup * ssCharWidth * 0.6;
                break;
            }
        }
        double ystart = y - h / 2.0;
        this.fillBox = new Rectangle2D.Double((xstart -= (double)lineThickness) - (double)padding, ystart - (double)padding, (fullWidth += (double)lineThickness) + (double)(2 * padding) - (double)nsup * ssCharWidth * 0.6, h + (double)(2 * padding));
        this.fillSupBox = nsup == 0 ? null : new Rectangle2D.Double(xstart - (double)padding + fullWidth - (double)nsup * ssCharWidth * 0.6, ystart - (double)padding, (double)nsup * ssCharWidth, h / 2.0);
        Rectangle2D.Double box = this.drawBox = new Rectangle2D.Double(xstart - (double)padding, ystart - (double)padding - yAdj2 * h / 3.0, fullWidth + (double)(2 * padding), h + (double)(2 * padding) + (yAdj1 + yAdj2) * h / 3.0);
        this.mapString = null;
        this.labelX = xstart + 1.0;
        this.labelY = ystart + h;
        if (map < 0) {
            return;
        }
        this.mapString = " " + map;
        double superscriptMove = h * 0.3;
        if (this.noLabelAtom) {
            this.atomMapX = x + smallWidth / 4.0;
            this.atomMapY = y - (h + yAdj2 * 0.6) * 0.1;
        } else {
            double atomMapStringWidth = fm.stringWidth(this.mapString);
            if (alignment == 0) {
                this.atomMapX = x - smallWidth / 2.0 + fullWidth;
            } else {
                box.x -= atomMapStringWidth;
                this.atomMapX = x + smallWidth / 2.0 - fullWidth - atomMapStringWidth;
            }
            this.atomMapY = y - superscriptMove;
            box.y -= superscriptMove;
            box.height += superscriptMove;
            box.width += atomMapStringWidth;
        }
    }

    public void draw(PreciseGraphicsAWT og, Color strokeColor, double h, FontMetrics fm) {
        double strokeWidth = h / 20.0;
        if (this.bsSS == null) {
            og.drawStringWithStroke(this.str, this.labelX, this.labelY, strokeColor, strokeWidth);
            return;
        }
        Font normalFont = og.baseGraphics.getFont();
        Font subFont = normalFont.deriveFont((float)(h * 0.8));
        double x = this.labelX;
        double y = this.labelY;
        double subOffset = h / 3.0;
        double superOffset = -2.0 * subOffset;
        int i = 0;
        while (i < this.str.length()) {
            double yoff;
            int pt0 = i;
            int pt1 = this.bsSS.nextSetBit(i);
            if (pt1 == pt0) {
                if (this.subscripts != null && this.subscripts.get(i)) {
                    pt1 = this.subscripts.nextClearBit(i + 1);
                    yoff = subOffset;
                } else {
                    pt1 = this.superscripts.nextClearBit(i + 1);
                    yoff = superOffset;
                }
            } else {
                if (pt1 < 0) {
                    pt1 = this.str.length();
                }
                yoff = 0.0;
            }
            String s = this.str.substring(pt0, pt1);
            if (yoff != 0.0) {
                og.setFont(subFont);
            }
            og.drawStringWithStroke(s, x, y + yoff, strokeColor, strokeWidth);
            if (yoff != 0.0) {
                og.setFont(normalFont);
            }
            x += (double)fm.stringWidth(s) * (yoff == 0.0 ? 1.0 : 0.6);
            i = pt1;
        }
    }

    public static AtomDisplayLabel[] createLabels(JMEmol mol, double rb, FontMetrics fm, boolean showHs, boolean showMap, AtomDisplayLabel[] labels) {
        int natoms = mol.natoms;
        Bond[] bonds = mol.bonds;
        Atom[] atoms = mol.atoms;
        if (labels == null || labels.length < natoms + 1) {
            labels = new AtomDisplayLabel[natoms + 1];
        }
        double[] neighborXSum = new double[natoms + 1];
        int[] neighborCount = new int[natoms + 1];
        int n = mol.nbonds;
        for (int i = 1; i <= n; ++i) {
            int atom1 = bonds[i].va;
            int atom2 = bonds[i].vb;
            int n2 = atom1;
            neighborXSum[n2] = neighborXSum[n2] + atoms[atom2].x;
            int n3 = atom2;
            neighborXSum[n3] = neighborXSum[n3] + atoms[atom1].x;
            int n4 = atom1;
            neighborCount[n4] = neighborCount[n4] + 1;
            int n5 = atom2;
            neighborCount[n5] = neighborCount[n5] + 1;
        }
        double h = GUI.stringHeight(fm);
        for (int i = 1; i <= natoms; ++i) {
            int n6 = neighborCount[i];
            double diff = neighborXSum[i] / (double)n6 - atoms[i].x;
            int alignment = n6 > 2 || n6 == 0 || n6 == 2 && Math.abs(diff) < rb / 3.0 ? 1 : (n6 == 1 && Math.abs(diff) < rb / 10.0 ? 0 : (diff < 0.0 ? 0 : 2));
            labels[i] = AtomDisplayLabel.create(atoms[i], alignment, fm, h, showHs, showMap);
        }
        return labels;
    }

    public void fill(PreciseGraphicsAWT og) {
        AtomDisplayLabel.fillBox(og, this.fillBox);
        if (this.fillSupBox != null) {
            AtomDisplayLabel.fillBox(og, this.fillSupBox);
        }
    }

    private static void fillBox(PreciseGraphicsAWT og, Rectangle2D.Double r) {
        double h = r.height;
        og.fillRoundRect(r.x, r.y, r.width, h, h / 2.0, h / 2.0);
    }
}

