/*
 * Decompiled with CFR 0.152.
 */
package jme.gui;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import jme.JME;

public class Actions {
    public static final int ACTION_UNCHANGED = -1;
    public static final int ACTION_SMI = 101;
    public static final int ACTION_CLEAR = 102;
    public static final int ACTION_NEW = 103;
    public static final int ACTION_DELETE = 104;
    public static final int ACTION_MARK = 105;
    public static final int ACTION_DELGROUP = 106;
    public static final int ACTION_QRY = 107;
    public static final int ACTION_CHARGE = 108;
    public static final int ACTION_REACP = 109;
    public static final int ACTION_UNDO = 110;
    public static final int ACTION_REDO = 111;
    public static final int ACTION_SPIRO = 112;
    public static final int ACTION_MOVE_AT = 113;
    public static final int ACTION_JME = 114;
    public static final int ACTION_PGUP = 151;
    public static final int ACTION_PGDN = 152;
    public static final int ACTION_HOME = 153;
    public static final int ACTION_END = 154;
    public static final int ACTION_STEREO = 201;
    public static final int ACTION_BOND_SINGLE = 202;
    public static final int ACTION_BOND_DOUBLE = 203;
    public static final int ACTION_BOND_TRIPLE = 204;
    public static final int ACTION_CHAIN = 205;
    public static final int ACTION_RING_3 = 206;
    public static final int ACTION_RING_4 = 207;
    public static final int ACTION_RING_5 = 208;
    public static final int ACTION_RING_PH = 209;
    public static final int ACTION_RING_6 = 210;
    public static final int ACTION_RING_7 = 211;
    public static final int ACTION_RING_8 = 212;
    public static final int ACTION_FG = 213;
    public static final int ACTION_IO = 214;
    public static final int ACTION_RING_FURANE = 221;
    public static final int ACTION_RING_3FURYL = 223;
    public static final int ACTION_RING_9 = 229;
    public static final int ACTION_AN_C = 301;
    public static final int ACTION_AN_N = 401;
    public static final int ACTION_AN_O = 501;
    public static final int ACTION_AN_S = 601;
    public static final int ACTION_AN_F = 701;
    public static final int ACTION_AN_CL = 801;
    public static final int ACTION_AN_BR = 901;
    public static final int ACTION_AN_I = 1001;
    public static final int ACTION_AN_P = 1101;
    public static final int ACTION_AN_X = 1201;
    public static final int ACTION_AN_H = 1300;
    public static final int ACTION_AN_R = 1301;
    public static final int ACTION_AN_R1 = 1302;
    public static final int ACTION_AN_R2 = 1303;
    public static final int ACTION_AN_R3 = 1304;
    public static final int ACTION_AN_R4 = 1305;
    public static final int ACTION_AN_R5 = 1306;
    public static final int ACTION_AN_R6 = 1307;
    public static final int ACTION_AN_R7 = 1308;
    public static final int ACTION_AN_R8 = 1309;
    public static final int ACTION_AN_R9 = 1310;
    public static final int ACTION_AN_R_LAST = 1310;
    public static final int ACTION_TEMPLATE = 2030;
    public static final int ACTION_GROUP_MIN = 2033;
    public static final int ACTION_GROUP_TBU = 2033;
    public static final int ACTION_GROUP_NITRO = 2034;
    public static final int ACTION_GROUP_COO = 2035;
    public static final int ACTION_GROUP_CF3 = 2036;
    public static final int ACTION_GROUP_CCL3 = 2037;
    public static final int ACTION_GROUP_CC = 2038;
    public static final int ACTION_GROUP_SULFO = 2039;
    public static final int ACTION_GROUP_COOME = 2040;
    public static final int ACTION_GROUP_OCOME = 2041;
    public static final int ACTION_GROUP_CYANO = 2042;
    public static final int ACTION_GROUP_NME2 = 2043;
    public static final int ACTION_GROUP_NHSO2ME = 2044;
    public static final int ACTION_GROUP_CCC = 2045;
    public static final int ACTION_GROUP_C2 = 2046;
    public static final int ACTION_GROUP_C3 = 2047;
    public static final int ACTION_GROUP_C4 = 2048;
    public static final int ACTION_GROUP_COH = 2049;
    public static final int ACTION_GROUP_dO = 2050;
    public static final int ACTION_GROUP_PO3H2 = 2051;
    public static final int ACTION_GROUP_SO2NH2 = 2052;
    public static final int ACTION_GROUP_TEMPLATE = 2053;
    public static final int ACTION_GROUP_CF = 2054;
    public static final int ACTION_GROUP_CL = 2055;
    public static final int ACTION_GROUP_CB = 2056;
    public static final int ACTION_GROUP_CI = 2057;
    public static final int ACTION_GROUP_CN = 2058;
    public static final int ACTION_GROUP_CO = 2059;
    public static final int ACTION_GROUP_CON = 2060;
    public static final int ACTION_GROUP_NCO = 2061;
    public static final int ACTION_GROUP_MAX = 2062;
    public static final int[] actionToAtomNumberArray = new int[]{301, 3, 401, 4, 501, 5, 701, 9, 801, 10, 901, 11, 1001, 12, 601, 8, 1101, 7, 1300, 1, 1201, 32, 1301, 33};
    public static final int LEFT_MENU_ELEMENT_COUNT = 9;
    private JME jme;
    private Map<Object, AbstractAction> actions = new HashMap<Object, AbstractAction>();
    private AbstractAction actionAtomBond;
    private int actions0_9 = 0;
    private int actionsBond = 0;

    public Actions(JME jme) {
        this.jme = jme;
        this.setActions();
    }

    public static int mapActionToAtomNumberX(int action) {
        if (action >= 1301 && action <= 1310) {
            int delta = action - 1301;
            return 33 + delta;
        }
        for (int i = 0; i < actionToAtomNumberArray.length; i += 2) {
            if (actionToAtomNumberArray[i] != action) continue;
            return actionToAtomNumberArray[i + 1];
        }
        return -1;
    }

    public KeyStroke getKeyStroke(int key, int modifiers) {
        if (modifiers == 4) {
            modifiers = 2;
        }
        if (key < 127) {
            return KeyStroke.getKeyStroke(Character.valueOf((char)key), modifiers);
        }
        return KeyStroke.getKeyStroke(key, modifiers);
    }

    protected void addAction(String name, int id, int key, int modifiers, AbstractAction a) {
        a.putValue("Name", name);
        if (id == 0) {
            id = key;
        }
        if (id != 0) {
            a = new WrappedAction(name, id, a);
        }
        this.actions.put(name, a);
        if (key != 0) {
            KeyStroke shortcut = this.getKeyStroke(key, modifiers);
            a.putValue("AcceleratorKey", shortcut);
            this.actions.put(shortcut, a);
        }
    }

    public boolean doAction(Object key, int id) {
        AbstractAction a = this.actions.get(key);
        if (a == null) {
            return false;
        }
        String actionCommand = key.toString();
        if (a instanceof WrappedAction) {
            if (id == 0) {
                id = ((WrappedAction)a).id;
            }
            a = ((WrappedAction)a).a;
        }
        this.jme.startKeyboardAction();
        a.actionPerformed(new ActionEvent(a, id, actionCommand));
        this.jme.endKeyboardAction();
        return true;
    }

    public void setActions() {
        this.addAction("copy", 0, 67, 2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.copyFileToClipboard();
            }
        });
        this.addAction("cut", 0, 88, 2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.cutSelectedMoleculeForSystemClipBoard();
            }
        });
        this.addAction("paste", 0, 86, 2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Actions)Actions.this).jme.options.paste) {
                    Actions.this.jme.pasteMolFileFromClipboard();
                }
            }
        });
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.doUndoRedo(e.getID());
            }
        };
        this.addAction("redo", 1, 89, 2, a);
        this.addAction("undo", -1, 85, 0, a);
        this.addAction("undo", -1, 90, 2, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.doNavigate(e.getID());
            }
        };
        this.addAction("navigate", 0, 38, 0, a);
        this.addAction("navigate", 0, 40, 0, a);
        this.addAction("navigate", 0, 37, 0, a);
        this.addAction("navigate", 0, 39, 0, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.doAtomG();
            }
        };
        this.addAction("atomG", 0, 106, 0, a);
        this.addAction("atomG", 0, 151, 0, a);
        this.addAction("atomG", 0, 71, 0, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.doAtomX();
            }
        };
        this.addAction("atomX", 0, 88, 0, a);
        a = this.actionAtomBond = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.doAtomBond(e.getID());
            }
        };
        this.addAction("atombond", 104, 68, 0, a);
        this.addAction("atombond", 104, 8, 0, a);
        this.addAction("atombond", 104, 127, 0, a);
        this.addAction("atombond", 202, 27, 0, a);
        this.addAction("atombond", 209, 80, 1, a);
        this.addAction("atombond", 2034, 89, 0, a);
        this.addAction("atombond", 2039, 90, 0, a);
        this.addAction("atombond", 2035, 65, 0, a);
        this.addAction("atombond", 2038, 69, 0, a);
        this.addAction("atombond", 2058, 81, 0, a);
        this.addAction("atombond", 223, 48, 8, a);
        this.addAction("atombond", 223, 48, 1, a);
        this.addAction("atombond", 205, 32, 0, a);
        this.addAction("atombond", 204, 35, 0, a);
        a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.jme.doPage(e.getID());
            }
        };
        this.addAction("page", 151, 77, 0, a);
        this.addAction("page", 151, 33, 0, a);
        this.addAction("page", 152, 87, 0, a);
        this.addAction("page", 152, 34, 0, a);
        this.addAction("page", 153, 36, 0, a);
        this.addAction("page", 154, 35, 0, a);
    }

    public void setBondVariableAction(boolean isBond) {
        int newActions = isBond ? 202 : 301;
        AbstractAction a = this.actionAtomBond;
        if (this.actionsBond != newActions) {
            this.actionsBond = newActions;
            if (newActions == 202) {
                this.addAction("atombond", 202, 45, 0, a);
                this.addAction("atombond", 201, 43, 0, a);
                this.addAction("atombond", 201, 107, 0, a);
            } else {
                this.addAction("atombond", 108, 43, 0, a);
                this.addAction("atombond", 108, 107, 0, a);
                this.addAction("atombond", -1, 45, 0, a);
            }
        }
    }

    public void setAtomVariableAction(boolean isR, int action) {
        int newActions;
        this.setBondVariableAction(false);
        AbstractAction a = this.actionAtomBond;
        switch (action) {
            case 701: {
                this.addAction("atombond", 2036, 84, 0, a);
                break;
            }
            case 801: {
                this.addAction("atombond", 2037, 84, 0, a);
                break;
            }
            default: {
                this.addAction("atombond", 2033, 84, 0, a);
            }
        }
        int n = newActions = isR ? 1301 : 2053;
        if (action == 105 && this.actions0_9 != 105) {
            this.actions0_9 = 105;
            int i = 0;
            while (i <= 9) {
                this.addAction("atombond", 105, 48, 0, a);
            }
            return;
        }
        if (this.actions0_9 == newActions) {
            return;
        }
        this.actions0_9 = newActions;
        if (isR) {
            for (int i = 0; i <= 9; ++i) {
                this.addAction("atombond", 1301 + i, (char)(48 + i), 0, a);
            }
        } else {
            this.addAction("atombond", 221, 48, 0, a);
            this.addAction("atombond", 202, 49, 0, a);
            int id = action == 501 ? 2050 : 203;
            this.addAction("atombond", id, 50, 0, a);
            this.addAction("atombond", id, 61, 0, a);
            this.addAction("atombond", 206, 51, 1, a);
            this.addAction("atombond", 204, 51, 0, a);
            this.addAction("atombond", 207, 52, 0, a);
            this.addAction("atombond", 208, 53, 0, a);
            this.addAction("atombond", 210, 54, 0, a);
            this.addAction("atombond", 211, 55, 0, a);
            this.addAction("atombond", 212, 56, 0, a);
            this.addAction("atombond", 229, 57, 0, a);
        }
    }

    public void dispose() {
        this.jme = null;
        this.actions = null;
    }

    private static class WrappedAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        int id;
        AbstractAction a;
        private String name;

        WrappedAction(String name, int id, AbstractAction a) {
            super(name);
            this.id = id;
            this.name = name;
            this.a = a;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int id = e.getID();
            if (this.id != 0) {
                id = this.id;
                e = new ActionEvent(e.getSource(), id, this.name);
            }
            this.a.actionPerformed(e);
        }
    }
}

