/*
 * Decompiled with CFR 0.152.
 */
package jme.event;

import jme.JMEmol;
import jme.JMEmolList;

public class JMEevent {
    public int atom;
    public int bond;
    public int[] bondAtoms;
    public int atomBackgroundColorIndex;
    public int atomE;
    public int bondE;
    public int[] bondAtomsE;
    public int molecule;
    public String action;
    public String argument;
    public Object argumentJSO;
    public String origin;
    public int stackLevel = 0;

    public JMEevent() {
        this.reset();
    }

    public JMEevent reset() {
        this.atom = 0;
        this.bond = 0;
        this.molecule = 0;
        this.atomBackgroundColorIndex = -1;
        this.bondAtoms = new int[]{0, 0};
        this.atomE = 0;
        this.bondE = 0;
        this.bondAtomsE = new int[]{0, 0};
        this.action = null;
        this.argument = null;
        this.origin = null;
        this.stackLevel = 0;
        return this;
    }

    public int getAtom() {
        return this.atom;
    }

    public void log(String string) {
        this.consoleLog(string);
    }

    private native void consoleLog(String var1);

    public JMEevent setAtomAndMol(JMEmolList moleculeParts, int atom, int mol) {
        this.atom = atom;
        this.molecule = mol + 1;
        this.atomE = moleculeParts.computeAtomEnsembleIndex(mol, atom);
        JMEmolList.EnsembleAtom eAtom = moleculeParts.getEnsembleAtom(mol, atom);
        if (eAtom != null && eAtom.atom != null) {
            this.atomBackgroundColorIndex = eAtom.atom.getMark();
        }
        return this;
    }

    public int getBond() {
        return this.bond;
    }

    public JMEevent setBondAndMol(JMEmolList moleculeParts, int bond, int mol) {
        this.bond = bond;
        if (bond > 0 && mol >= 0) {
            this.molecule = mol;
            JMEmol jmeMol = (JMEmol)moleculeParts.get(mol);
            this.bondAtoms[0] = jmeMol.bonds[bond].va;
            this.bondAtoms[1] = jmeMol.bonds[bond].vb;
            this.bondE = moleculeParts.computeBondEnsembleIndex(mol, bond);
            this.bondAtomsE[0] = moleculeParts.computeAtomEnsembleIndex(mol, this.bondAtoms[0]);
            this.bondAtomsE[1] = moleculeParts.computeAtomEnsembleIndex(mol, this.bondAtoms[1]);
        }
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public JMEevent setAction(String action) {
        this.action = action;
        return this;
    }

    public JMEevent setAtomAndBondAndMol(JMEmolList moleculeParts, int atom, int bond, int mol) {
        this.setBondAndMol(moleculeParts, bond, mol);
        return this.setAtomAndMol(moleculeParts, atom, mol);
    }

    public JMEevent setArgument(String arg) {
        this.argument = arg;
        return this;
    }

    public void setOrigin_API() {
        this.setOriginIfNotAlreadySet(Origin.API);
    }

    public void setOrigin_GUI() {
        this.setOriginIfNotAlreadySet(Origin.GUI);
    }

    public void setOrigin_DROP() {
        this.setOriginIfNotAlreadySet(Origin.DROP);
    }

    public void setOrigin_INIT() {
        this.setOriginIfNotAlreadySet(Origin.INIT);
    }

    public void setOrigin_PASTE() {
        this.setOriginIfNotAlreadySet(Origin.PASTE);
    }

    private void setOriginIfNotAlreadySet(String newOrigin) {
        if (this.origin == null) {
            this.origin = newOrigin;
        }
    }

    public boolean isOrigin_API() {
        return this.origin == Origin.API;
    }

    public String toString() {
        return "[JMEEvent " + this.action + (this.origin == null ? "" : " origin=" + this.origin) + (this.atom > 0 ? " atom=" + this.atom : "") + (this.bond > 0 ? " bond=" + this.bond + "(" + this.bondAtoms[0] + "-" + this.bondAtoms[1] + ")" : "") + "]";
    }

    public static class Origin {
        static String API = "API";
        static String PASTE = "PASTE";
        static String DROP = "DROP";
        static String GUI = "GUI";
        static String INIT = "INIT";
    }
}

