/*
 * Decompiled with CFR 0.152.
 */
package jme.canvas;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jme.canvas.PreciseGraphicsAWT;
import jme.util.Box;

public interface Graphical2DObject {
    public boolean isEmpty();

    public void draw(PreciseGraphicsAWT var1);

    public void moveXY(double var1, double var3);

    public Rectangle2D.Double computeBoundingBoxWithAtomLabels(Rectangle2D.Double var1);

    public double centerX();

    public double centerY();

    public static void move(Graphical2DObject o, Box.Axis xOrY, double d) {
        if (xOrY == Box.Axis.X) {
            o.moveXY(d, 0.0);
        } else {
            o.moveXY(0.0, d);
        }
    }

    public static double center(Graphical2DObject o, Box.Axis xOrY) {
        return xOrY == Box.Axis.X ? o.centerX() : o.centerY();
    }

    public static void move(Graphical2DObject o, double movex, double movey, Rectangle2D.Double boundingBoxLimits) {
        if (o.isEmpty()) {
            return;
        }
        Rectangle2D.Double bbox = o.computeBoundingBoxWithAtomLabels(null);
        double centerx = bbox.getCenterX();
        double centery = bbox.getCenterY();
        if (movex < 0.0 && centerx < boundingBoxLimits.x || movex > 0.0 && centerx > boundingBoxLimits.width || movey < 0.0 && centery < boundingBoxLimits.y || movey > 0.0 && centery > boundingBoxLimits.height) {
            return;
        }
        o.moveXY(movex, movey);
    }

    public static void move(Graphical2DObject o, Point2D.Double shiftXY) {
        o.moveXY(shiftXY.x, shiftXY.y);
    }

    public static Rectangle2D.Double newBoundingBox(Graphical2DObject o) {
        Rectangle2D.Double box = o.computeBoundingBoxWithAtomLabels(null);
        return box == null ? new Rectangle2D.Double() : box;
    }

    public static double shortestDistance(double x1, double y1, double x2, double y2, double x3, double y3) {
        double dy;
        double dx;
        double px = x2 - x1;
        double py = y2 - y1;
        double temp = px * px + py * py;
        if (temp == 0.0) {
            dx = x2 - x3;
            dy = y2 - y3;
        } else {
            double u = ((x3 - x1) * px + (y3 - y1) * py) / temp;
            if (u > 1.0) {
                u = 1.0;
            } else if (u < 0.0) {
                u = 0.0;
            }
            double x = x1 + u * px;
            double y = y1 + u * py;
            dx = x - x3;
            dy = y - y3;
        }
        double dist = Math.sqrt(dx * dx + dy * dy);
        return dist;
    }

    public static double closestDistancePointToLine(double x0, double y0, Line2D.Double line) {
        return Graphical2DObject.shortestDistance(line.x1, line.y1, line.x2, line.y2, x0, y0);
    }

    public double closestDistance(double var1, double var3);
}

